/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.server.namenode.FsImageValidation;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeReferenceValidation;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestFsImageValidation {
    static final Logger LOG = LoggerFactory.getLogger(TestFsImageValidation.class);

    @Test
    public void testValidation() throws Exception {
        FsImageValidation.initLogLevels();
        try {
            int errorCount = FsImageValidation.newInstance((String[])new String[0]).run();
            Assert.assertEquals((String)("Error Count: " + errorCount), (long)0L, (long)errorCount);
        }
        catch (HadoopIllegalArgumentException e) {
            LOG.warn("The environment variable {} is not set: {}", (Object)"FS_IMAGE", (Object)e);
        }
    }

    @Test
    public void testHaConf() {
        Configuration conf = new Configuration();
        String nsId = "cluster0";
        FsImageValidation.setHaConf((String)"cluster0", (Configuration)conf);
        Assert.assertTrue((boolean)HAUtil.isHAEnabled((Configuration)conf, (String)"cluster0"));
    }

    @Test
    public void testToCommaSeparatedNumber() {
        long b = 1L;
        while (b < Integer.MAX_VALUE) {
            for (long n = b; n < Integer.MAX_VALUE; n *= 10L) {
                TestFsImageValidation.runTestToCommaSeparatedNumber(n);
            }
            b = b == 1L ? 11L : 10L * (b - 1L) + 1L;
        }
    }

    static void runTestToCommaSeparatedNumber(long n) {
        String s = FsImageValidation.Util.toCommaSeparatedNumber((long)n);
        LOG.info("{} ?= {}", (Object)n, (Object)s);
        int i = s.length();
        while (i > 0) {
            for (int j = 0; j < 3 && i > 0; ++j) {
                Assert.assertTrue((boolean)Character.isDigit(s.charAt(--i)));
            }
            if (i <= 0) continue;
            Assert.assertEquals((long)44L, (long)s.charAt(--i));
        }
        Assert.assertNotEquals((long)0L, (long)(s.length() % 4));
        Assert.assertEquals((long)n, (long)Long.parseLong(s.replaceAll(",", "")));
    }

    static {
        Level t = Level.TRACE;
        GenericTestUtils.setLogLevel((Logger)LoggerFactory.getLogger(FsImageValidation.class), (Level)t);
        GenericTestUtils.setLogLevel((Logger)LoggerFactory.getLogger(INodeReferenceValidation.class), (Level)t);
        GenericTestUtils.setLogLevel((Logger)LoggerFactory.getLogger(INode.class), (Level)t);
    }
}

