/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSConfigKeys;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.server.balancer.BalancerMetrics;
import org.apache.hadoop.hdfs.server.balancer.BalancerParameters;
import org.apache.hadoop.hdfs.server.balancer.BalancingPolicy;
import org.apache.hadoop.hdfs.server.balancer.Dispatcher;
import org.apache.hadoop.hdfs.server.balancer.ExitStatus;
import org.apache.hadoop.hdfs.server.balancer.Matcher;
import org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicies;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.namenode.UnsupportedActionException;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.HostsFileReader;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class Balancer {
    static final Logger LOG = LoggerFactory.getLogger(Balancer.class);
    static final Path BALANCER_ID_PATH = new Path("/system/balancer.id");
    private static final String USAGE = "Usage: hdfs balancer\n\t[-policy <policy>]\tthe balancing policy: " + BalancingPolicy.Node.INSTANCE.getName() + " or " + BalancingPolicy.Pool.INSTANCE.getName() + "\n\t[-threshold <threshold>]\tPercentage of disk capacity\n\t[-exclude [-f <hosts-file> | <comma-separated list of hosts>]]\tExcludes the specified datanodes.\n\t[-include [-f <hosts-file> | <comma-separated list of hosts>]]\tIncludes only the specified datanodes.\n\t[-source [-f <hosts-file> | <comma-separated list of hosts>]]\tPick only the specified datanodes as source nodes.\n\t[-blockpools <comma-separated list of blockpool ids>]\tThe balancer will only run on blockpools included in this list.\n\t[-idleiterations <idleiterations>]\tNumber of consecutive idle iterations (-1 for Infinite) before exit.\n\t[-runDuringUpgrade]\tWhether to run the balancer during an ongoing HDFS upgrade.This is usually not desired since it will not affect used space on over-utilized machines.\n\t[-asService]\tRun as a long running service.\n\t[-sortTopNodes]\n\t[-hotBlockTimeInterval]\tprefer to move cold blocks.\tSort datanodes based on the utilization so that highly utilized datanodes get scheduled first.";
    @VisibleForTesting
    private static volatile boolean serviceRunning = false;
    private static final AtomicInteger EXCEPTIONS_SINCE_LAST_BALANCE = new AtomicInteger(0);
    private static final AtomicInteger FAILED_TIMES_SINCE_LAST_SUCCESSFUL_BALANCE = new AtomicInteger(0);
    private final Dispatcher dispatcher;
    private final NameNodeConnector nnc;
    private final BalancingPolicy policy;
    private final Set<String> sourceNodes;
    private final boolean runDuringUpgrade;
    private final double threshold;
    private final long maxSizeToMove;
    private final long defaultBlockSize;
    private final boolean sortTopNodes;
    private final BalancerMetrics metrics;
    private final Collection<Dispatcher.Source> overUtilized = new LinkedList<Dispatcher.Source>();
    private final Collection<Dispatcher.Source> aboveAvgUtilized = new LinkedList<Dispatcher.Source>();
    private final Collection<Dispatcher.DDatanode.StorageGroup> belowAvgUtilized = new LinkedList<Dispatcher.DDatanode.StorageGroup>();
    private final Collection<Dispatcher.DDatanode.StorageGroup> underUtilized = new LinkedList<Dispatcher.DDatanode.StorageGroup>();

    private static void checkReplicationPolicyCompatibility(Configuration conf) throws UnsupportedActionException {
        BlockPlacementPolicies placementPolicies = new BlockPlacementPolicies(conf, null, null, null);
        if (!(placementPolicies.getPolicy(BlockType.CONTIGUOUS) instanceof BlockPlacementPolicyDefault)) {
            throw new UnsupportedActionException("Balancer without BlockPlacementPolicyDefault");
        }
    }

    static long getLong(Configuration conf, String key, long defaultValue) {
        long v = conf.getLong(key, defaultValue);
        LOG.info(key + " = " + v + " (default=" + defaultValue + ")");
        if (v <= 0L) {
            throw new HadoopIllegalArgumentException(key + " = " + v + " <= " + 0);
        }
        return v;
    }

    static long getLongBytes(Configuration conf, String key, long defaultValue) {
        long v = conf.getLongBytes(key, defaultValue);
        LOG.info(key + " = " + v + " (default=" + defaultValue + ")");
        if (v <= 0L) {
            throw new HadoopIllegalArgumentException(key + " = " + v + " <= " + 0);
        }
        return v;
    }

    static int getInt(Configuration conf, String key, int defaultValue) {
        int v = conf.getInt(key, defaultValue);
        LOG.info(key + " = " + v + " (default=" + defaultValue + ")");
        if (v <= 0) {
            throw new HadoopIllegalArgumentException(key + " = " + v + " <= " + 0);
        }
        return v;
    }

    static int getExceptionsSinceLastBalance() {
        return EXCEPTIONS_SINCE_LAST_BALANCE.get();
    }

    static int getFailedTimesSinceLastSuccessfulBalance() {
        return FAILED_TIMES_SINCE_LAST_SUCCESSFUL_BALANCE.get();
    }

    Balancer(NameNodeConnector theblockpool, BalancerParameters p, Configuration conf) {
        Balancer.getInt(conf, "dfs.namenode.get-blocks.max-qps", 20);
        long movedWinWidth = Balancer.getLong(conf, "dfs.balancer.movedWinWidth", 5400000L);
        int moverThreads = Balancer.getInt(conf, "dfs.balancer.moverThreads", 1000);
        int dispatcherThreads = Balancer.getInt(conf, "dfs.balancer.dispatcherThreads", 200);
        long getBlocksSize = Balancer.getLongBytes(conf, "dfs.balancer.getBlocks.size", 0x80000000L);
        long getBlocksMinBlockSize = Balancer.getLongBytes(conf, "dfs.balancer.getBlocks.min-block-size", 0xA00000L);
        int blockMoveTimeout = conf.getInt("dfs.balancer.block-move.timeout", 0);
        int maxNoMoveInterval = conf.getInt("dfs.balancer.max-no-move-interval", 60000);
        long maxIterationTime = conf.getLong("dfs.balancer.max-iteration-time", 1200000L);
        long hotBlockTimeInterval = p.getHotBlockTimeInterval() != 0L ? p.getHotBlockTimeInterval() : conf.getTimeDuration("dfs.balancer.getBlocks.hot-time-interval", 0L, TimeUnit.MILLISECONDS);
        int maxConcurrentMovesPerNode = Balancer.getInt(conf, "dfs.datanode.balance.max.concurrent.moves", 100);
        Balancer.getLongBytes(conf, "dfs.datanode.balance.bandwidthPerSec", 0x6400000L);
        this.nnc = theblockpool;
        this.dispatcher = new Dispatcher(theblockpool, p.getIncludedNodes(), p.getExcludedNodes(), movedWinWidth, moverThreads, dispatcherThreads, maxConcurrentMovesPerNode, getBlocksSize, getBlocksMinBlockSize, blockMoveTimeout, maxNoMoveInterval, maxIterationTime, hotBlockTimeInterval, conf);
        this.threshold = p.getThreshold();
        this.policy = p.getBalancingPolicy();
        this.sourceNodes = p.getSourceNodes();
        this.runDuringUpgrade = p.getRunDuringUpgrade();
        this.sortTopNodes = p.getSortTopNodes();
        this.maxSizeToMove = Balancer.getLongBytes(conf, "dfs.balancer.max-size-to-move", 0x280000000L);
        this.defaultBlockSize = Balancer.getLongBytes(conf, "dfs.blocksize", 0x8000000L);
        this.metrics = BalancerMetrics.create(this);
    }

    private static long getCapacity(DatanodeStorageReport report, StorageType t) {
        long capacity = 0L;
        for (StorageReport r : report.getStorageReports()) {
            if (r.getStorage().getStorageType() != t) continue;
            capacity += r.getCapacity();
        }
        return capacity;
    }

    private long getRemaining(DatanodeStorageReport report, StorageType t) {
        long remaining = 0L;
        for (StorageReport r : report.getStorageReports()) {
            if (r.getStorage().getStorageType() != t || r.getRemaining() < this.defaultBlockSize) continue;
            remaining += r.getRemaining();
        }
        return remaining;
    }

    private long init(List<DatanodeStorageReport> reports) {
        for (DatanodeStorageReport r : reports) {
            this.policy.accumulateSpaces(r);
        }
        this.policy.initAvgUtilization();
        HashMap<Dispatcher.Source, Double> overUtilizedPercentage = new HashMap<Dispatcher.Source, Double>();
        long overLoadedBytes = 0L;
        long underLoadedBytes = 0L;
        for (DatanodeStorageReport r : reports) {
            Dispatcher.DDatanode dn = this.dispatcher.newDatanode(r.getDatanodeInfo());
            boolean isSource = Dispatcher.Util.isIncluded(this.sourceNodes, dn.getDatanodeInfo());
            for (StorageType t : StorageType.getMovableTypes()) {
                Dispatcher.DDatanode.StorageGroup g;
                Double utilization = this.policy.getUtilization(r, t);
                if (utilization == null) continue;
                double average = this.policy.getAvgUtilization(t);
                if (utilization >= average && !isSource) {
                    LOG.info(dn + "[" + t + "] has utilization=" + utilization + " >= average=" + average + " but it is not specified as a source; skipping it.");
                    continue;
                }
                double utilizationDiff = utilization - average;
                long capacity = Balancer.getCapacity(r, t);
                double thresholdDiff = Math.abs(utilizationDiff) - this.threshold;
                long maxSize2Move = Balancer.computeMaxSize2Move(capacity, this.getRemaining(r, t), utilizationDiff, this.maxSizeToMove);
                if (utilizationDiff > 0.0) {
                    Dispatcher.Source s = dn.addSource(t, maxSize2Move, this.dispatcher);
                    if (thresholdDiff <= 0.0) {
                        this.aboveAvgUtilized.add(s);
                    } else {
                        overLoadedBytes += Balancer.percentage2bytes(thresholdDiff, capacity);
                        this.overUtilized.add(s);
                        overUtilizedPercentage.put(s, utilization);
                    }
                    g = s;
                } else {
                    g = dn.addTarget(t, maxSize2Move);
                    if (thresholdDiff <= 0.0) {
                        this.belowAvgUtilized.add(g);
                    } else {
                        underLoadedBytes += Balancer.percentage2bytes(thresholdDiff, capacity);
                        this.underUtilized.add(g);
                    }
                }
                this.dispatcher.getStorageGroupMap().put(g);
            }
        }
        if (this.sortTopNodes) {
            this.sortOverUtilized(overUtilizedPercentage);
        }
        this.logUtilizationCollections();
        this.metrics.setNumOfOverUtilizedNodes(this.overUtilized.size());
        this.metrics.setNumOfUnderUtilizedNodes(this.underUtilized.size());
        Preconditions.checkState((this.dispatcher.getStorageGroupMap().size() == this.overUtilized.size() + this.underUtilized.size() + this.aboveAvgUtilized.size() + this.belowAvgUtilized.size() ? 1 : 0) != 0, (Object)"Mismatched number of storage groups");
        return Math.max(overLoadedBytes, underLoadedBytes);
    }

    private void sortOverUtilized(Map<Dispatcher.Source, Double> overUtilizedPercentage) {
        Preconditions.checkState((boolean)(this.overUtilized instanceof List), (Object)"Collection overUtilized is not a List.");
        LOG.info("Sorting over-utilized nodes by capacity to bring down top used datanode capacity faster");
        List list = (List)this.overUtilized;
        list.sort((source1, source2) -> Double.compare((Double)overUtilizedPercentage.get(source2), (Double)overUtilizedPercentage.get(source1)));
    }

    private static long computeMaxSize2Move(long capacity, long remaining, double utilizationDiff, long max) {
        double diff = Math.abs(utilizationDiff);
        long maxSizeToMove = Balancer.percentage2bytes(diff, capacity);
        if (utilizationDiff < 0.0) {
            maxSizeToMove = Math.min(remaining, maxSizeToMove);
        }
        return Math.min(max, maxSizeToMove);
    }

    private static long percentage2bytes(double percentage, long capacity) {
        Preconditions.checkArgument((percentage >= 0.0 ? 1 : 0) != 0, (String)"percentage = %s < 0", (Object[])new Object[]{percentage});
        return (long)(percentage * (double)capacity / 100.0);
    }

    private void logUtilizationCollections() {
        Balancer.logUtilizationCollection("over-utilized", this.overUtilized);
        if (LOG.isTraceEnabled()) {
            Balancer.logUtilizationCollection("above-average", this.aboveAvgUtilized);
            Balancer.logUtilizationCollection("below-average", this.belowAvgUtilized);
        }
        Balancer.logUtilizationCollection("underutilized", this.underUtilized);
    }

    private static <T extends Dispatcher.DDatanode.StorageGroup> void logUtilizationCollection(String name, Collection<T> items) {
        LOG.info(items.size() + " " + name + ": " + items);
    }

    private long chooseStorageGroups() {
        if (this.dispatcher.getCluster().isNodeGroupAware()) {
            this.chooseStorageGroups(Matcher.SAME_NODE_GROUP);
        }
        this.chooseStorageGroups(Matcher.SAME_RACK);
        this.chooseStorageGroups(Matcher.ANY_OTHER);
        return this.dispatcher.bytesToMove();
    }

    private void chooseStorageGroups(Matcher matcher) {
        LOG.info("chooseStorageGroups for " + matcher + ": overUtilized => underUtilized");
        this.chooseStorageGroups(this.overUtilized, this.underUtilized, matcher);
        LOG.info("chooseStorageGroups for " + matcher + ": overUtilized => belowAvgUtilized");
        this.chooseStorageGroups(this.overUtilized, this.belowAvgUtilized, matcher);
        LOG.info("chooseStorageGroups for " + matcher + ": underUtilized => aboveAvgUtilized");
        this.chooseStorageGroups(this.underUtilized, this.aboveAvgUtilized, matcher);
    }

    private <G extends Dispatcher.DDatanode.StorageGroup, C extends Dispatcher.DDatanode.StorageGroup> void chooseStorageGroups(Collection<G> groups, Collection<C> candidates, Matcher matcher) {
        Iterator<G> i = groups.iterator();
        while (i.hasNext()) {
            Dispatcher.DDatanode.StorageGroup g = (Dispatcher.DDatanode.StorageGroup)i.next();
            while (this.choose4One(g, candidates, matcher)) {
            }
            if (g.hasSpaceForScheduling()) continue;
            i.remove();
        }
    }

    private <C extends Dispatcher.DDatanode.StorageGroup> boolean choose4One(Dispatcher.DDatanode.StorageGroup g, Collection<C> candidates, Matcher matcher) {
        Iterator<C> i = candidates.iterator();
        C chosen = this.chooseCandidate(g, i, matcher);
        if (chosen == null) {
            return false;
        }
        if (g instanceof Dispatcher.Source) {
            this.matchSourceWithTargetToMove((Dispatcher.Source)g, (Dispatcher.DDatanode.StorageGroup)chosen);
        } else {
            this.matchSourceWithTargetToMove((Dispatcher.Source)chosen, g);
        }
        if (!((Dispatcher.DDatanode.StorageGroup)chosen).hasSpaceForScheduling()) {
            i.remove();
        }
        return true;
    }

    private void matchSourceWithTargetToMove(Dispatcher.Source source, Dispatcher.DDatanode.StorageGroup target) {
        long size = Math.min(source.availableSizeToMove(), target.availableSizeToMove());
        Dispatcher.Task task = new Dispatcher.Task(target, size);
        source.addTask(task);
        target.incScheduledSize(task.getSize());
        this.dispatcher.add(source, target);
        LOG.info("Decided to move " + StringUtils.byteDesc((long)size) + " bytes from " + source.getDisplayName() + " to " + target.getDisplayName());
    }

    private <G extends Dispatcher.DDatanode.StorageGroup, C extends Dispatcher.DDatanode.StorageGroup> C chooseCandidate(G g, Iterator<C> candidates, Matcher matcher) {
        if (g.hasSpaceForScheduling()) {
            while (candidates.hasNext()) {
                Dispatcher.DDatanode.StorageGroup c = (Dispatcher.DDatanode.StorageGroup)candidates.next();
                if (!c.hasSpaceForScheduling()) {
                    candidates.remove();
                    continue;
                }
                if (!this.matchStorageGroups(c, g, matcher)) continue;
                return (C)c;
            }
        }
        return null;
    }

    private boolean matchStorageGroups(Dispatcher.DDatanode.StorageGroup left, Dispatcher.DDatanode.StorageGroup right, Matcher matcher) {
        return left.getStorageType() == right.getStorageType() && matcher.match(this.dispatcher.getCluster(), (Node)left.getDatanodeInfo(), (Node)right.getDatanodeInfo());
    }

    void resetData(Configuration conf) {
        this.overUtilized.clear();
        this.aboveAvgUtilized.clear();
        this.belowAvgUtilized.clear();
        this.underUtilized.clear();
        this.policy.reset();
        this.dispatcher.reset(conf);
    }

    NameNodeConnector getNnc() {
        return this.nnc;
    }

    Result newResult(ExitStatus exitStatus, long bytesLeftToMove, long bytesBeingMoved) {
        return new Result(exitStatus, bytesLeftToMove, bytesBeingMoved, this.dispatcher.getBytesMoved(), this.dispatcher.getBlocksMoved());
    }

    Result newResult(ExitStatus exitStatus) {
        return new Result(exitStatus, -1L, -1L, this.dispatcher.getBytesMoved(), this.dispatcher.getBlocksMoved());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result runOneIteration() {
        try {
            this.metrics.setIterateRunning(true);
            List<DatanodeStorageReport> reports = this.dispatcher.init();
            long bytesLeftToMove = this.init(reports);
            this.metrics.setBytesLeftToMove(bytesLeftToMove);
            if (bytesLeftToMove == 0L) {
                Result result = this.newResult(ExitStatus.SUCCESS, bytesLeftToMove, 0L);
                return result;
            }
            LOG.info("Need to move " + StringUtils.byteDesc((long)bytesLeftToMove) + " to make the cluster balanced.");
            if (!this.runDuringUpgrade && this.nnc.isUpgrading()) {
                System.err.println("Balancer exiting as upgrade is not finalized, please finalize the HDFS upgrade before running the balancer.");
                LOG.error("Balancer exiting as upgrade is not finalized, please finalize the HDFS upgrade before running the balancer.");
                Result result = this.newResult(ExitStatus.UNFINALIZED_UPGRADE, bytesLeftToMove, -1L);
                return result;
            }
            long bytesBeingMoved = this.chooseStorageGroups();
            if (bytesBeingMoved == 0L) {
                System.out.println("No block can be moved. Exiting...");
                Result result = this.newResult(ExitStatus.NO_MOVE_BLOCK, bytesLeftToMove, bytesBeingMoved);
                return result;
            }
            LOG.info("Will move {}  in this iteration for {}", (Object)StringUtils.byteDesc((long)bytesBeingMoved), (Object)this.nnc.toString());
            LOG.info("Total target DataNodes in this iteration: {}", (Object)this.dispatcher.moveTasksTotal());
            if (!this.dispatcher.dispatchAndCheckContinue()) {
                Result result = this.newResult(ExitStatus.NO_MOVE_PROGRESS, bytesLeftToMove, bytesBeingMoved);
                return result;
            }
            Result result = this.newResult(ExitStatus.IN_PROGRESS, bytesLeftToMove, bytesBeingMoved);
            return result;
        }
        catch (IllegalArgumentException e) {
            System.out.println(e + ".  Exiting ...");
            Result result = this.newResult(ExitStatus.ILLEGAL_ARGUMENTS);
            return result;
        }
        catch (IOException e) {
            System.out.println(e + ".  Exiting ...");
            Result result = this.newResult(ExitStatus.IO_EXCEPTION);
            return result;
        }
        catch (InterruptedException e) {
            System.out.println(e + ".  Exiting ...");
            Result result = this.newResult(ExitStatus.INTERRUPTED);
            return result;
        }
        finally {
            this.metrics.setIterateRunning(false);
            this.dispatcher.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int doBalance(Collection<URI> namenodes, Collection<String> nsIds, BalancerParameters p, Configuration conf) throws IOException, InterruptedException {
        block16: {
            block15: {
                sleeptime = conf.getTimeDuration("dfs.heartbeat.interval", 3L, TimeUnit.SECONDS, TimeUnit.MILLISECONDS) * 2L + conf.getTimeDuration("dfs.namenode.redundancy.interval.seconds", 3L, TimeUnit.SECONDS, TimeUnit.MILLISECONDS);
                Balancer.LOG.info("namenodes  = " + namenodes);
                Balancer.LOG.info("parameters = " + p);
                Balancer.LOG.info("included nodes = " + p.getIncludedNodes());
                Balancer.LOG.info("excluded nodes = " + p.getExcludedNodes());
                Balancer.LOG.info("source nodes = " + p.getSourceNodes());
                Balancer.checkKeytabAndInit(conf);
                System.out.println("Time Stamp               Iteration#  Bytes Already Moved  Bytes Left To Move  Bytes Being Moved  NameNode");
                connectors = Collections.emptyList();
                try {
                    connectors = NameNodeConnector.newNameNodeConnectors(namenodes, nsIds, Balancer.class.getSimpleName(), Balancer.BALANCER_ID_PATH, conf, p.getMaxIdleIteration());
                    done = false;
                    var8_8 = false;
lbl14:
                    // 2 sources

                    while (!done) {
                        done = true;
                        Collections.shuffle(connectors);
lbl17:
                        // 3 sources

                        for (NameNodeConnector var10_12 : connectors) {
                            if (p.getBlockPools().size() != 0 && !p.getBlockPools().contains(var10_12.getBlockpoolID())) ** GOTO lbl-1000
                            b = new Balancer(var10_12, p, conf);
                            r = b.runOneIteration();
                            r.print((int)var8_9, var10_12, System.out);
                            b.resetData(conf);
                            if (Result.access$000(r) == ExitStatus.IN_PROGRESS) {
                                done = false;
                            } else if (Result.access$000(r) != ExitStatus.SUCCESS) {
                                var13_15 = Result.access$000(r).getExitCode();
                                var14_16 = connectors.iterator();
                                break block15;
                            }
                            ** GOTO lbl49
                        }
                        ** GOTO lbl52
                    }
                    break block16;
                }
                catch (Throwable var16_18) {
                    var17_19 = connectors.iterator();
                    while (true) {
                        if (!var17_19.hasNext()) {
                            throw var16_18;
                        }
                        var18_20 = (NameNodeConnector)var17_19.next();
                        IOUtils.cleanupWithLogger((Logger)Balancer.LOG, (Closeable[])new Closeable[]{var18_20});
                    }
                }
            }
            while (true) {
                if (!var14_16.hasNext()) {
                    return var13_15;
                }
                var15_17 = (NameNodeConnector)var14_16.next();
                IOUtils.cleanupWithLogger((Logger)Balancer.LOG, (Closeable[])new Closeable[]{var15_17});
            }
lbl-1000:
            // 1 sources

            {
                Balancer.LOG.info("Skipping blockpool " + var10_12.getBlockpoolID());
lbl49:
                // 3 sources

                if (!done) ** GOTO lbl17
                System.out.println("The cluster is balanced. Exiting...");
                ** GOTO lbl17
lbl52:
                // 1 sources

                if (!done) {
                    Thread.sleep(sleeptime);
                }
                ++var8_9;
                ** GOTO lbl14
            }
        }
        var7_7 = connectors.iterator();
        while (true) {
            if (!var7_7.hasNext()) {
                return ExitStatus.SUCCESS.getExitCode();
            }
            var8_10 = (NameNodeConnector)var7_7.next();
            IOUtils.cleanupWithLogger((Logger)Balancer.LOG, (Closeable[])new Closeable[]{var8_10});
        }
    }

    static int run(Collection<URI> namenodes, BalancerParameters p, Configuration conf) throws IOException, InterruptedException {
        return Balancer.run(namenodes, null, p, conf);
    }

    static int run(Collection<URI> namenodes, Collection<String> nsIds, BalancerParameters p, Configuration conf) throws IOException, InterruptedException {
        DefaultMetricsSystem.initialize((String)"Balancer");
        JvmMetrics.create((String)"Balancer", (String)conf.get("dfs.metrics.session-id"), (MetricsSystem)DefaultMetricsSystem.instance());
        if (!p.getRunAsService()) {
            return Balancer.doBalance(namenodes, nsIds, p, conf);
        }
        if (serviceRunning) {
            LOG.warn("Balancer already running as a long-service!");
            return ExitStatus.ALREADY_RUNNING.getExitCode();
        }
        serviceRunning = true;
        long scheduleInterval = conf.getTimeDuration("dfs.balancer.service.interval", DFSConfigKeys.DFS_BALANCER_SERVICE_INTERVAL_DEFAULT, TimeUnit.MILLISECONDS);
        int retryOnException = conf.getInt("dfs.balancer.service.retries.on.exception", 5);
        while (serviceRunning) {
            try {
                int retCode = Balancer.doBalance(namenodes, nsIds, p, conf);
                if (retCode < 0) {
                    LOG.info("Balance failed, error code: " + retCode);
                    FAILED_TIMES_SINCE_LAST_SUCCESSFUL_BALANCE.incrementAndGet();
                } else {
                    LOG.info("Balance succeed!");
                    FAILED_TIMES_SINCE_LAST_SUCCESSFUL_BALANCE.set(0);
                }
                EXCEPTIONS_SINCE_LAST_BALANCE.set(0);
            }
            catch (Exception e) {
                if (EXCEPTIONS_SINCE_LAST_BALANCE.incrementAndGet() > retryOnException) {
                    throw e;
                }
                LOG.warn("Encounter exception while do balance work. Already tried {} times", (Object)EXCEPTIONS_SINCE_LAST_BALANCE, (Object)e);
            }
            LOG.info("Finished one round, will wait for {} for next round", (Object)Balancer.time2Str(scheduleInterval));
            Thread.sleep(scheduleInterval);
        }
        DefaultMetricsSystem.shutdown();
        return 0;
    }

    static void stop() {
        serviceRunning = false;
    }

    private static void checkKeytabAndInit(Configuration conf) throws IOException {
        if (conf.getBoolean("dfs.balancer.keytab.enabled", false)) {
            LOG.info("Keytab is configured, will login using keytab.");
            UserGroupInformation.setConfiguration((Configuration)conf);
            String addr = conf.get("dfs.balancer.address", "0.0.0.0:0");
            InetSocketAddress socAddr = NetUtils.createSocketAddr((String)addr, (int)0, (String)"dfs.balancer.address");
            SecurityUtil.login((Configuration)conf, (String)"dfs.balancer.keytab.file", (String)"dfs.balancer.kerberos.principal", (String)socAddr.getHostName());
        }
    }

    private static String time2Str(long elapsedTime) {
        String unit;
        double time = elapsedTime;
        if (elapsedTime < 1000L) {
            unit = "milliseconds";
        } else if (elapsedTime < 60000L) {
            unit = "seconds";
            time /= 1000.0;
        } else if (elapsedTime < 3600000L) {
            unit = "minutes";
            time /= 60000.0;
        } else {
            unit = "hours";
            time /= 3600000.0;
        }
        return time + " " + unit;
    }

    public static void main(String[] args) {
        if (DFSUtil.parseHelpArgument(args, USAGE, System.out, true)) {
            System.exit(0);
        }
        try {
            System.exit(ToolRunner.run((Configuration)new HdfsConfiguration(), (Tool)new Cli(), (String[])args));
        }
        catch (Throwable e) {
            LOG.error("Exiting balancer due an exception", e);
            System.exit(-1);
        }
    }

    static class Cli
    extends Configured
    implements Tool {
        Cli() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public int run(String[] args) {
            int n;
            long startTime = Time.monotonicNow();
            Configuration conf = this.getConf();
            try {
                Balancer.checkReplicationPolicyCompatibility(conf);
                Collection<URI> namenodes = DFSUtil.getInternalNsRpcUris(conf);
                Collection nsIds = DFSUtilClient.getNameServiceIds((Configuration)conf);
                n = Balancer.run(namenodes, nsIds, Cli.parse(args), conf);
            }
            catch (IOException e) {
                System.out.println(e + ".  Exiting ...");
                int n2 = ExitStatus.IO_EXCEPTION.getExitCode();
                System.out.format("%-24s ", DateFormat.getDateTimeInstance().format(new Date()));
                System.out.println("Balancing took " + Balancer.time2Str(Time.monotonicNow() - startTime));
                return n2;
            }
            catch (InterruptedException e2) {
                System.out.println(e2 + ".  Exiting ...");
                int n3 = ExitStatus.INTERRUPTED.getExitCode();
                {
                    catch (Throwable throwable) {
                        System.out.format("%-24s ", DateFormat.getDateTimeInstance().format(new Date()));
                        System.out.println("Balancing took " + Balancer.time2Str(Time.monotonicNow() - startTime));
                        throw throwable;
                    }
                }
                System.out.format("%-24s ", DateFormat.getDateTimeInstance().format(new Date()));
                System.out.println("Balancing took " + Balancer.time2Str(Time.monotonicNow() - startTime));
                return n3;
            }
            System.out.format("%-24s ", DateFormat.getDateTimeInstance().format(new Date()));
            System.out.println("Balancing took " + Balancer.time2Str(Time.monotonicNow() - startTime));
            return n;
        }

        static BalancerParameters parse(String[] args) {
            HashSet<String> excludedNodes = null;
            HashSet<String> includedNodes = null;
            BalancerParameters.Builder b = new BalancerParameters.Builder();
            if (args != null) {
                try {
                    for (int i = 0; i < args.length; ++i) {
                        if ("-threshold".equalsIgnoreCase(args[i])) {
                            Preconditions.checkArgument((++i < args.length ? 1 : 0) != 0, (Object)("Threshold value is missing: args = " + Arrays.toString(args)));
                            try {
                                double threshold = Double.parseDouble(args[i]);
                                if (threshold < 1.0 || threshold > 100.0) {
                                    throw new IllegalArgumentException("Number out of range: threshold = " + threshold);
                                }
                                LOG.info("Using a threshold of " + threshold);
                                b.setThreshold(threshold);
                                continue;
                            }
                            catch (IllegalArgumentException e) {
                                System.err.println("Expecting a number in the range of [1.0, 100.0]: " + args[i]);
                                throw e;
                            }
                        }
                        if ("-policy".equalsIgnoreCase(args[i])) {
                            Preconditions.checkArgument((++i < args.length ? 1 : 0) != 0, (Object)("Policy value is missing: args = " + Arrays.toString(args)));
                            try {
                                b.setBalancingPolicy(BalancingPolicy.parse(args[i]));
                                continue;
                            }
                            catch (IllegalArgumentException e) {
                                System.err.println("Illegal policy name: " + args[i]);
                                throw e;
                            }
                        }
                        if ("-exclude".equalsIgnoreCase(args[i])) {
                            excludedNodes = new HashSet<String>();
                            i = Cli.processHostList(args, i, "exclude", excludedNodes);
                            b.setExcludedNodes(excludedNodes);
                            continue;
                        }
                        if ("-include".equalsIgnoreCase(args[i])) {
                            includedNodes = new HashSet<String>();
                            i = Cli.processHostList(args, i, "include", includedNodes);
                            b.setIncludedNodes(includedNodes);
                            continue;
                        }
                        if ("-source".equalsIgnoreCase(args[i])) {
                            HashSet<String> sourceNodes = new HashSet<String>();
                            i = Cli.processHostList(args, i, "source", sourceNodes);
                            b.setSourceNodes(sourceNodes);
                            continue;
                        }
                        if ("-blockpools".equalsIgnoreCase(args[i])) {
                            Preconditions.checkArgument((++i < args.length ? 1 : 0) != 0, (Object)("blockpools value is missing: args = " + Arrays.toString(args)));
                            Set<String> blockpools = Cli.parseBlockPoolList(args[i]);
                            LOG.info("Balancer will run on the following blockpools: " + blockpools.toString());
                            b.setBlockpools(blockpools);
                            continue;
                        }
                        if ("-idleiterations".equalsIgnoreCase(args[i])) {
                            Preconditions.checkArgument((++i < args.length ? 1 : 0) != 0, (Object)("idleiterations value is missing: args = " + Arrays.toString(args)));
                            int maxIdleIteration = Integer.parseInt(args[i]);
                            LOG.info("Using a idleiterations of " + maxIdleIteration);
                            b.setMaxIdleIteration(maxIdleIteration);
                            continue;
                        }
                        if ("-runDuringUpgrade".equalsIgnoreCase(args[i])) {
                            b.setRunDuringUpgrade(true);
                            LOG.info("Will run the balancer even during an ongoing HDFS upgrade. Most users will not want to run the balancer during an upgrade since it will not affect used space on over-utilized machines.");
                            continue;
                        }
                        if ("-asService".equalsIgnoreCase(args[i])) {
                            b.setRunAsService(true);
                            LOG.info("Balancer will run as a long running service");
                            continue;
                        }
                        if ("-hotBlockTimeInterval".equalsIgnoreCase(args[i])) {
                            Preconditions.checkArgument((++i < args.length ? 1 : 0) != 0, (Object)("hotBlockTimeInterval value is missing: args = " + Arrays.toString(args)));
                            long hotBlockTimeInterval = Long.parseLong(args[i]);
                            LOG.info("Using a hotBlockTimeInterval of " + hotBlockTimeInterval);
                            b.setHotBlockTimeInterval(hotBlockTimeInterval);
                            continue;
                        }
                        if ("-sortTopNodes".equalsIgnoreCase(args[i])) {
                            b.setSortTopNodes(true);
                            LOG.info("Balancer will sort nodes by capacity usage percentage to prioritize top used nodes");
                            continue;
                        }
                        throw new IllegalArgumentException("args = " + Arrays.toString(args));
                    }
                    Preconditions.checkArgument((excludedNodes == null || includedNodes == null ? 1 : 0) != 0, (Object)"-exclude and -include options cannot be specified together.");
                }
                catch (RuntimeException e) {
                    Cli.printUsage(System.err);
                    throw e;
                }
            }
            return b.build();
        }

        private static int processHostList(String[] args, int i, String type, Set<String> nodes) {
            Preconditions.checkArgument((++i < args.length ? 1 : 0) != 0, (String)"List of %s nodes | -f <filename> is missing: args=%s", (Object[])new Object[]{type, Arrays.toString(args)});
            if ("-f".equalsIgnoreCase(args[i])) {
                Preconditions.checkArgument((++i < args.length ? 1 : 0) != 0, (String)"File containing %s nodes is not specified: args=%s", (Object[])new Object[]{type, Arrays.toString(args)});
                String filename = args[i];
                try {
                    HostsFileReader.readFileToSet((String)type, (String)filename, nodes);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to read " + type + " node list from file: " + filename);
                }
            } else {
                String[] addresses = StringUtils.getTrimmedStrings((String)args[i]);
                nodes.addAll(Arrays.asList(addresses));
            }
            return i;
        }

        private static Set<String> parseBlockPoolList(String string) {
            String[] addrs = StringUtils.getTrimmedStrings((String)string);
            return new HashSet<String>(Arrays.asList(addrs));
        }

        private static void printUsage(PrintStream out) {
            out.println(USAGE + "\n");
        }
    }

    static class Result {
        private final ExitStatus exitStatus;
        private final long bytesLeftToMove;
        private final long bytesBeingMoved;
        private final long bytesAlreadyMoved;
        private final long blocksMoved;

        Result(ExitStatus exitStatus, long bytesLeftToMove, long bytesBeingMoved, long bytesAlreadyMoved, long blocksMoved) {
            this.exitStatus = exitStatus;
            this.bytesLeftToMove = bytesLeftToMove;
            this.bytesBeingMoved = bytesBeingMoved;
            this.bytesAlreadyMoved = bytesAlreadyMoved;
            this.blocksMoved = blocksMoved;
        }

        public ExitStatus getExitStatus() {
            return this.exitStatus;
        }

        public long getBytesLeftToMove() {
            return this.bytesLeftToMove;
        }

        public long getBytesBeingMoved() {
            return this.bytesBeingMoved;
        }

        public long getBytesAlreadyMoved() {
            return this.bytesAlreadyMoved;
        }

        public long getBlocksMoved() {
            return this.blocksMoved;
        }

        void print(int iteration, NameNodeConnector nnc, PrintStream out) {
            out.printf("%-24s %10d  %19s  %18s  %17s  %17s  %s%n", DateFormat.getDateTimeInstance().format(new Date()), iteration, StringUtils.byteDesc((long)this.bytesAlreadyMoved), StringUtils.byteDesc((long)this.bytesLeftToMove), StringUtils.byteDesc((long)this.bytesBeingMoved), this.blocksMoved, nnc.getNameNodeUri());
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("exitStatus", (Object)this.exitStatus).append("bytesLeftToMove", this.bytesLeftToMove).append("bytesBeingMoved", this.bytesBeingMoved).append("bytesAlreadyMoved", this.bytesAlreadyMoved).append("blocksMoved", this.blocksMoved).toString();
        }

        static /* synthetic */ ExitStatus access$000(Result x0) {
            return x0.exitStatus;
        }
    }
}

