/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.kms.KMSClientProvider;
import org.apache.hadoop.crypto.key.kms.server.KMSACLs;
import org.apache.hadoop.crypto.key.kms.server.KMSAudit;
import org.apache.hadoop.crypto.key.kms.server.KMSMDCFilter;
import org.apache.hadoop.crypto.key.kms.server.KMSServerJSONUtils;
import org.apache.hadoop.crypto.key.kms.server.KMSWebApp;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.web.HttpUserGroupInformation;

@Path(value="/v1")
@InterfaceAudience.Private
public class KMS {
    private KeyProviderCryptoExtension provider = KMSWebApp.getKeyProvider();
    private KMSAudit kmsAudit = KMSWebApp.getKMSAudit();

    private void assertAccess(KMSACLs.Type aclType, UserGroupInformation ugi, KMSOp operation) throws AccessControlException {
        KMSWebApp.getACLs().assertAccess(aclType, ugi, operation, null);
    }

    private void assertAccess(KMSACLs.Type aclType, UserGroupInformation ugi, KMSOp operation, String key) throws AccessControlException {
        KMSWebApp.getACLs().assertAccess(aclType, ugi, operation, key);
    }

    private static KeyProvider.KeyVersion removeKeyMaterial(KeyProvider.KeyVersion keyVersion) {
        return new KMSClientProvider.KMSKeyVersion(keyVersion.getName(), keyVersion.getVersionName(), null);
    }

    private static URI getKeyURI(String name) throws URISyntaxException {
        return new URI("/v1/key/" + name);
    }

    @POST
    @Path(value="keys")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createKey(Map jsonKey) throws Exception {
        KMSWebApp.getAdminCallsMeter().mark();
        UserGroupInformation user = HttpUserGroupInformation.get();
        final String name = (String)jsonKey.get("name");
        KMSClientProvider.checkNotEmpty((String)name, (String)"name");
        this.assertAccess(KMSACLs.Type.CREATE, user, KMSOp.CREATE_KEY, name);
        String cipher = (String)jsonKey.get("cipher");
        final String material = (String)jsonKey.get("material");
        int length = jsonKey.containsKey("length") ? (Integer)jsonKey.get("length") : 0;
        String description = (String)jsonKey.get("description");
        Map attributes = (Map)jsonKey.get("attributes");
        if (material != null) {
            this.assertAccess(KMSACLs.Type.SET_KEY_MATERIAL, user, KMSOp.CREATE_KEY, name);
        }
        final KeyProvider.Options options = new KeyProvider.Options(KMSWebApp.getConfiguration());
        if (cipher != null) {
            options.setCipher(cipher);
        }
        if (length != 0) {
            options.setBitLength(length);
        }
        options.setDescription(description);
        options.setAttributes(attributes);
        KeyProvider.KeyVersion keyVersion = (KeyProvider.KeyVersion)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProvider.KeyVersion>(){

            @Override
            public KeyProvider.KeyVersion run() throws Exception {
                KeyProvider.KeyVersion keyVersion = material != null ? KMS.this.provider.createKey(name, Base64.decodeBase64((String)material), options) : KMS.this.provider.createKey(name, options);
                KMS.this.provider.flush();
                return keyVersion;
            }
        });
        this.kmsAudit.ok(user, KMSOp.CREATE_KEY, name, "UserProvidedMaterial:" + (material != null) + " Description:" + description);
        if (!KMSWebApp.getACLs().hasAccess(KMSACLs.Type.GET, user)) {
            keyVersion = KMS.removeKeyMaterial(keyVersion);
        }
        Map json = KMSServerJSONUtils.toJSON(keyVersion);
        String requestURL = KMSMDCFilter.getURL();
        int idx = requestURL.lastIndexOf("keys");
        requestURL = requestURL.substring(0, idx);
        String keyURL = requestURL + "key" + "/" + name;
        return Response.created((URI)KMS.getKeyURI(name)).type("application/json").header("Location", (Object)keyURL).entity((Object)json).build();
    }

    @DELETE
    @Path(value="key/{name:.*}")
    public Response deleteKey(final @PathParam(value="name") String name) throws Exception {
        KMSWebApp.getAdminCallsMeter().mark();
        UserGroupInformation user = HttpUserGroupInformation.get();
        this.assertAccess(KMSACLs.Type.DELETE, user, KMSOp.DELETE_KEY, name);
        KMSClientProvider.checkNotEmpty((String)name, (String)"name");
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                KMS.this.provider.deleteKey(name);
                KMS.this.provider.flush();
                return null;
            }
        });
        this.kmsAudit.ok(user, KMSOp.DELETE_KEY, name, "");
        return Response.ok().build();
    }

    @POST
    @Path(value="key/{name:.*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response rolloverKey(final @PathParam(value="name") String name, Map jsonMaterial) throws Exception {
        KMSWebApp.getAdminCallsMeter().mark();
        UserGroupInformation user = HttpUserGroupInformation.get();
        this.assertAccess(KMSACLs.Type.ROLLOVER, user, KMSOp.ROLL_NEW_VERSION, name);
        KMSClientProvider.checkNotEmpty((String)name, (String)"name");
        final String material = (String)jsonMaterial.get("material");
        if (material != null) {
            this.assertAccess(KMSACLs.Type.SET_KEY_MATERIAL, user, KMSOp.ROLL_NEW_VERSION, name);
        }
        KeyProvider.KeyVersion keyVersion = (KeyProvider.KeyVersion)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProvider.KeyVersion>(){

            @Override
            public KeyProvider.KeyVersion run() throws Exception {
                KeyProvider.KeyVersion keyVersion = material != null ? KMS.this.provider.rollNewVersion(name, Base64.decodeBase64((String)material)) : KMS.this.provider.rollNewVersion(name);
                KMS.this.provider.flush();
                return keyVersion;
            }
        });
        this.kmsAudit.ok(user, KMSOp.ROLL_NEW_VERSION, name, "UserProvidedMaterial:" + (material != null) + " NewVersion:" + keyVersion.getVersionName());
        if (!KMSWebApp.getACLs().hasAccess(KMSACLs.Type.GET, user)) {
            keyVersion = KMS.removeKeyMaterial(keyVersion);
        }
        Map json = KMSServerJSONUtils.toJSON(keyVersion);
        return Response.ok().type("application/json").entity((Object)json).build();
    }

    @GET
    @Path(value="keys/metadata")
    @Produces(value={"application/json"})
    public Response getKeysMetadata(@QueryParam(value="key") List<String> keyNamesList) throws Exception {
        KMSWebApp.getAdminCallsMeter().mark();
        UserGroupInformation user = HttpUserGroupInformation.get();
        final String[] keyNames = keyNamesList.toArray(new String[keyNamesList.size()]);
        this.assertAccess(KMSACLs.Type.GET_METADATA, user, KMSOp.GET_KEYS_METADATA);
        KeyProvider.Metadata[] keysMeta = (KeyProvider.Metadata[])user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProvider.Metadata[]>(){

            @Override
            public KeyProvider.Metadata[] run() throws Exception {
                return KMS.this.provider.getKeysMetadata(keyNames);
            }
        });
        List json = KMSServerJSONUtils.toJSON(keyNames, keysMeta);
        this.kmsAudit.ok(user, KMSOp.GET_KEYS_METADATA, "");
        return Response.ok().type("application/json").entity((Object)json).build();
    }

    @GET
    @Path(value="keys/names")
    @Produces(value={"application/json"})
    public Response getKeyNames() throws Exception {
        KMSWebApp.getAdminCallsMeter().mark();
        UserGroupInformation user = HttpUserGroupInformation.get();
        this.assertAccess(KMSACLs.Type.GET_KEYS, user, KMSOp.GET_KEYS);
        List json = (List)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<String>>(){

            @Override
            public List<String> run() throws Exception {
                return KMS.this.provider.getKeys();
            }
        });
        this.kmsAudit.ok(user, KMSOp.GET_KEYS, "");
        return Response.ok().type("application/json").entity((Object)json).build();
    }

    @GET
    @Path(value="key/{name:.*}")
    public Response getKey(@PathParam(value="name") String name) throws Exception {
        return this.getMetadata(name);
    }

    @GET
    @Path(value="key/{name:.*}/_metadata")
    @Produces(value={"application/json"})
    public Response getMetadata(final @PathParam(value="name") String name) throws Exception {
        UserGroupInformation user = HttpUserGroupInformation.get();
        KMSClientProvider.checkNotEmpty((String)name, (String)"name");
        KMSWebApp.getAdminCallsMeter().mark();
        this.assertAccess(KMSACLs.Type.GET_METADATA, user, KMSOp.GET_METADATA, name);
        KeyProvider.Metadata metadata = (KeyProvider.Metadata)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProvider.Metadata>(){

            @Override
            public KeyProvider.Metadata run() throws Exception {
                return KMS.this.provider.getMetadata(name);
            }
        });
        Map json = KMSServerJSONUtils.toJSON(name, metadata);
        this.kmsAudit.ok(user, KMSOp.GET_METADATA, name, "");
        return Response.ok().type("application/json").entity((Object)json).build();
    }

    @GET
    @Path(value="key/{name:.*}/_currentversion")
    @Produces(value={"application/json"})
    public Response getCurrentVersion(final @PathParam(value="name") String name) throws Exception {
        UserGroupInformation user = HttpUserGroupInformation.get();
        KMSClientProvider.checkNotEmpty((String)name, (String)"name");
        KMSWebApp.getKeyCallsMeter().mark();
        this.assertAccess(KMSACLs.Type.GET, user, KMSOp.GET_CURRENT_KEY, name);
        KeyProvider.KeyVersion keyVersion = (KeyProvider.KeyVersion)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProvider.KeyVersion>(){

            @Override
            public KeyProvider.KeyVersion run() throws Exception {
                return KMS.this.provider.getCurrentKey(name);
            }
        });
        Map json = KMSServerJSONUtils.toJSON(keyVersion);
        this.kmsAudit.ok(user, KMSOp.GET_CURRENT_KEY, name, "");
        return Response.ok().type("application/json").entity((Object)json).build();
    }

    @GET
    @Path(value="keyversion/{versionName:.*}")
    @Produces(value={"application/json"})
    public Response getKeyVersion(final @PathParam(value="versionName") String versionName) throws Exception {
        UserGroupInformation user = HttpUserGroupInformation.get();
        KMSClientProvider.checkNotEmpty((String)versionName, (String)"versionName");
        KMSWebApp.getKeyCallsMeter().mark();
        this.assertAccess(KMSACLs.Type.GET, user, KMSOp.GET_KEY_VERSION);
        KeyProvider.KeyVersion keyVersion = (KeyProvider.KeyVersion)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProvider.KeyVersion>(){

            @Override
            public KeyProvider.KeyVersion run() throws Exception {
                return KMS.this.provider.getKeyVersion(versionName);
            }
        });
        if (keyVersion != null) {
            this.kmsAudit.ok(user, KMSOp.GET_KEY_VERSION, keyVersion.getName(), "");
        }
        Map json = KMSServerJSONUtils.toJSON(keyVersion);
        return Response.ok().type("application/json").entity((Object)json).build();
    }

    @GET
    @Path(value="key/{name:.*}/_eek")
    @Produces(value={"application/json"})
    public Response generateEncryptedKeys(final @PathParam(value="name") String name, @QueryParam(value="eek_op") String edekOp, final @DefaultValue(value="1") @QueryParam(value="num_keys") int numKeys) throws Exception {
        ArrayList<Map> retJSON;
        UserGroupInformation user = HttpUserGroupInformation.get();
        KMSClientProvider.checkNotEmpty((String)name, (String)"name");
        KMSClientProvider.checkNotNull((Object)edekOp, (String)"eekOp");
        if (edekOp.equals("generate")) {
            this.assertAccess(KMSACLs.Type.GENERATE_EEK, user, KMSOp.GENERATE_EEK, name);
            final LinkedList retEdeks = new LinkedList();
            try {
                user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        for (int i = 0; i < numKeys; ++i) {
                            retEdeks.add(KMS.this.provider.generateEncryptedKey(name));
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            this.kmsAudit.ok(user, KMSOp.GENERATE_EEK, name, "");
            retJSON = new ArrayList<Map>();
            for (KeyProviderCryptoExtension.EncryptedKeyVersion edek : retEdeks) {
                retJSON.add(KMSServerJSONUtils.toJSON(edek));
            }
        } else {
            throw new IllegalArgumentException("Wrong eek_op value, it must be generate or decrypt");
        }
        KMSWebApp.getGenerateEEKCallsMeter().mark();
        return Response.ok().type("application/json").entity(retJSON).build();
    }

    @POST
    @Path(value="keyversion/{versionName:.*}/_eek")
    @Produces(value={"application/json"})
    public Response decryptEncryptedKey(final @PathParam(value="versionName") String versionName, @QueryParam(value="eek_op") String eekOp, Map jsonPayload) throws Exception {
        UserGroupInformation user = HttpUserGroupInformation.get();
        KMSClientProvider.checkNotEmpty((String)versionName, (String)"versionName");
        KMSClientProvider.checkNotNull((Object)eekOp, (String)"eekOp");
        final String keyName = (String)jsonPayload.get("name");
        String ivStr = (String)jsonPayload.get("iv");
        String encMaterialStr = (String)jsonPayload.get("material");
        if (!eekOp.equals("decrypt")) {
            throw new IllegalArgumentException("Wrong eek_op value, it must be generate or decrypt");
        }
        this.assertAccess(KMSACLs.Type.DECRYPT_EEK, user, KMSOp.DECRYPT_EEK, keyName);
        KMSClientProvider.checkNotNull((Object)ivStr, (String)"iv");
        final byte[] iv = Base64.decodeBase64((String)ivStr);
        KMSClientProvider.checkNotNull((Object)encMaterialStr, (String)"material");
        final byte[] encMaterial = Base64.decodeBase64((String)encMaterialStr);
        KeyProvider.KeyVersion retKeyVersion = (KeyProvider.KeyVersion)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProvider.KeyVersion>(){

            @Override
            public KeyProvider.KeyVersion run() throws Exception {
                return KMS.this.provider.decryptEncryptedKey((KeyProviderCryptoExtension.EncryptedKeyVersion)new KMSClientProvider.KMSEncryptedKeyVersion(keyName, versionName, iv, "EEK", encMaterial));
            }
        });
        Map retJSON = KMSServerJSONUtils.toJSON(retKeyVersion);
        this.kmsAudit.ok(user, KMSOp.DECRYPT_EEK, keyName, "");
        KMSWebApp.getDecryptEEKCallsMeter().mark();
        return Response.ok().type("application/json").entity((Object)retJSON).build();
    }

    @GET
    @Path(value="key/{name:.*}/_versions")
    @Produces(value={"application/json"})
    public Response getKeyVersions(final @PathParam(value="name") String name) throws Exception {
        UserGroupInformation user = HttpUserGroupInformation.get();
        KMSClientProvider.checkNotEmpty((String)name, (String)"name");
        KMSWebApp.getKeyCallsMeter().mark();
        this.assertAccess(KMSACLs.Type.GET, user, KMSOp.GET_KEY_VERSIONS, name);
        List ret = (List)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<KeyProvider.KeyVersion>>(){

            @Override
            public List<KeyProvider.KeyVersion> run() throws Exception {
                return KMS.this.provider.getKeyVersions(name);
            }
        });
        List json = KMSServerJSONUtils.toJSON(ret);
        this.kmsAudit.ok(user, KMSOp.GET_KEY_VERSIONS, name, "");
        return Response.ok().type("application/json").entity((Object)json).build();
    }

    public static enum KMSOp {
        CREATE_KEY,
        DELETE_KEY,
        ROLL_NEW_VERSION,
        GET_KEYS,
        GET_KEYS_METADATA,
        GET_KEY_VERSIONS,
        GET_METADATA,
        GET_KEY_VERSION,
        GET_CURRENT_KEY,
        GENERATE_EEK,
        DECRYPT_EEK;

    }
}

