/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.TokenArgumentParam;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestWebHdfsUrl {
    @Test
    public void testDelegationTokenInUrl() throws IOException {
        Configuration conf = new Configuration();
        String uri = "webhdfs://127.0.0.1:9071";
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(new Text(ugi.getUserName()), null, null);
        FSNamesystem namesystem = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        DelegationTokenSecretManager dtSecretManager = new DelegationTokenSecretManager(86400000L, 86400000L, 86400000L, 86400000L, namesystem);
        dtSecretManager.startThreads();
        Token token = new Token((TokenIdentifier)dtId, (SecretManager)dtSecretManager);
        token.setService(new Text("127.0.0.1:9071"));
        token.setKind(WebHdfsFileSystem.TOKEN_KIND);
        ugi.addToken(token);
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)FileSystem.get((URI)URI.create("webhdfs://127.0.0.1:9071"), (Configuration)conf);
        String tokenString = token.encodeToUrlString();
        Path fsPath = new Path("/");
        URL renewTokenUrl = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.RENEWDELEGATIONTOKEN, fsPath, new Param[]{new TokenArgumentParam(tokenString)});
        URL cancelTokenUrl = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.CANCELDELEGATIONTOKEN, fsPath, new Param[]{new TokenArgumentParam(tokenString)});
        Assert.assertEquals((Object)(this.generateUrlQueryPrefix((HttpOpParam.Op)PutOpParam.Op.RENEWDELEGATIONTOKEN, ugi.getUserName()) + "&token=" + tokenString), (Object)renewTokenUrl.getQuery());
        Token delegationToken = new Token(token);
        delegationToken.setKind(WebHdfsFileSystem.TOKEN_KIND);
        Assert.assertEquals((Object)(this.generateUrlQueryPrefix((HttpOpParam.Op)PutOpParam.Op.CANCELDELEGATIONTOKEN, ugi.getUserName()) + "&token=" + tokenString + "&" + "delegation" + "=" + delegationToken.encodeToUrlString()), (Object)cancelTokenUrl.getQuery());
    }

    private String generateUrlQueryPrefix(HttpOpParam.Op op, String username) {
        return "op=" + op.toString() + "&user.name=" + username;
    }
}

