/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class MapReduceTestUtil {
    public static final Log LOG = LogFactory.getLog((String)MapReduceTestUtil.class.getName());
    private static Random rand = new Random();
    private static NumberFormat idFormat = NumberFormat.getInstance();

    public static void cleanData(FileSystem fs, Path dirPath) throws IOException {
        fs.delete(dirPath, true);
    }

    public static String generateRandomWord() {
        return idFormat.format(rand.nextLong());
    }

    public static String generateRandomLine() {
        long r = rand.nextLong() % 7L;
        long n = r + 20L;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while ((long)i < n) {
            sb.append(MapReduceTestUtil.generateRandomWord()).append(" ");
            ++i;
        }
        sb.append("\n");
        return sb.toString();
    }

    public static void generateData(FileSystem fs, Path dirPath) throws IOException {
        FSDataOutputStream out = fs.create(new Path(dirPath, "data.txt"));
        for (int i = 0; i < 10000; ++i) {
            String line = MapReduceTestUtil.generateRandomLine();
            out.write(line.getBytes("UTF-8"));
        }
        out.close();
    }

    public static Job createCopyJob(Configuration conf, Path outdir, Path ... indirs) throws Exception {
        conf.setInt("mapred.map.tasks", 3);
        Job theJob = new Job(conf);
        theJob.setJobName("DataMoveJob");
        FileInputFormat.setInputPaths((Job)theJob, (Path[])indirs);
        theJob.setMapperClass(DataCopyMapper.class);
        FileOutputFormat.setOutputPath((Job)theJob, (Path)outdir);
        theJob.setOutputKeyClass(Text.class);
        theJob.setOutputValueClass(Text.class);
        theJob.setReducerClass(DataCopyReducer.class);
        theJob.setNumReduceTasks(1);
        return theJob;
    }

    public static Job createFailJob(Configuration conf, Path outdir, Path ... indirs) throws Exception {
        FileSystem fs = outdir.getFileSystem(conf);
        if (fs.exists(outdir)) {
            fs.delete(outdir, true);
        }
        conf.setInt("mapred.map.max.attempts", 2);
        Job theJob = new Job(conf);
        theJob.setJobName("Fail-Job");
        FileInputFormat.setInputPaths((Job)theJob, (Path[])indirs);
        theJob.setMapperClass(FailMapper.class);
        theJob.setReducerClass(Reducer.class);
        theJob.setNumReduceTasks(0);
        FileOutputFormat.setOutputPath((Job)theJob, (Path)outdir);
        theJob.setOutputKeyClass(Text.class);
        theJob.setOutputValueClass(Text.class);
        return theJob;
    }

    public static Job createKillJob(Configuration conf, Path outdir, Path ... indirs) throws Exception {
        Job theJob = new Job(conf);
        theJob.setJobName("Kill-Job");
        FileInputFormat.setInputPaths((Job)theJob, (Path[])indirs);
        theJob.setMapperClass(KillMapper.class);
        theJob.setReducerClass(Reducer.class);
        theJob.setNumReduceTasks(0);
        FileOutputFormat.setOutputPath((Job)theJob, (Path)outdir);
        theJob.setOutputKeyClass(Text.class);
        theJob.setOutputValueClass(Text.class);
        return theJob;
    }

    public static Job createJob(Configuration conf, Path inDir, Path outDir, int numInputFiles, int numReds) throws IOException {
        String input = "The quick brown fox\nhas many silly\nred fox sox\n";
        return MapReduceTestUtil.createJob(conf, inDir, outDir, numInputFiles, numReds, input);
    }

    public static Job createJob(Configuration conf, Path inDir, Path outDir, int numInputFiles, int numReds, String input) throws IOException {
        Job job = new Job(conf);
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(outDir)) {
            fs.delete(outDir, true);
        }
        if (fs.exists(inDir)) {
            fs.delete(inDir, true);
        }
        fs.mkdirs(inDir);
        for (int i = 0; i < numInputFiles; ++i) {
            FSDataOutputStream file = fs.create(new Path(inDir, "part-" + i));
            file.writeBytes(input);
            file.close();
        }
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        job.setNumReduceTasks(numReds);
        return job;
    }

    public static TaskAttemptContext createDummyMapTaskAttemptContext(Configuration conf) {
        TaskAttemptID tid = new TaskAttemptID("jt", 1, true, 0, 0);
        conf.set("mapred.task.id", tid.toString());
        return new TaskAttemptContext(conf, tid);
    }

    public static StatusReporter createDummyReporter() {
        return new StatusReporter(){

            public void setStatus(String s) {
            }

            public void progress() {
            }

            public Counter getCounter(Enum<?> name) {
                return new Counters().findCounter(name);
            }

            public Counter getCounter(String group, String name) {
                return new Counters().findCounter(group, name);
            }
        };
    }

    public static String readOutput(Path outDir, Configuration conf) throws IOException {
        Path[] fileList;
        FileSystem fs = outDir.getFileSystem(conf);
        StringBuffer result = new StringBuffer();
        for (Path outputFile : fileList = FileUtil.stat2Paths((FileStatus[])fs.listStatus(outDir, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()))) {
            LOG.info((Object)("Path: " + outputFile));
            BufferedReader file = new BufferedReader(new InputStreamReader((InputStream)fs.open(outputFile)));
            String line = file.readLine();
            while (line != null) {
                result.append(line);
                result.append("\n");
                line = file.readLine();
            }
            file.close();
        }
        return result.toString();
    }

    static {
        idFormat.setMinimumIntegerDigits(4);
        idFormat.setGroupingUsed(false);
    }

    public static class KillMapper
    extends Mapper<WritableComparable<?>, Writable, WritableComparable<?>, Writable> {
        public void map(WritableComparable<?> key, Writable value, Mapper.Context context) throws IOException {
            try {
                Thread.sleep(1000000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public static class FailMapper
    extends Mapper<WritableComparable<?>, Writable, WritableComparable<?>, Writable> {
        public void map(WritableComparable<?> key, Writable value, Mapper.Context context) throws IOException {
            throw new RuntimeException("failing map");
        }
    }

    public static class DataCopyReducer
    extends Reducer<Text, Text, Text, Text> {
        public void reduce(Text key, Iterator<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            Text dumbKey = new Text("");
            while (values.hasNext()) {
                Text data = values.next();
                context.write((Object)dumbKey, (Object)data);
            }
        }
    }

    public static class DataCopyMapper
    extends Mapper<LongWritable, Text, Text, Text> {
        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)new Text(key.toString()), (Object)value);
        }
    }
}

