/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import junit.framework.TestCase;
import org.apache.hadoop.security.authentication.util.Signer;
import org.apache.hadoop.security.authentication.util.SignerException;

public class TestSigner
extends TestCase {
    public void testNoSecret() throws Exception {
        try {
            new Signer(null);
            TestSigner.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNullAndEmptyString() throws Exception {
        Signer signer = new Signer("secret".getBytes());
        try {
            signer.sign(null);
            TestSigner.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            TestSigner.fail();
        }
        try {
            signer.sign("");
            TestSigner.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            TestSigner.fail();
        }
    }

    public void testSignature() throws Exception {
        Signer signer = new Signer("secret".getBytes());
        String s1 = signer.sign("ok");
        String s2 = signer.sign("ok");
        String s3 = signer.sign("wrong");
        TestSigner.assertEquals((String)s1, (String)s2);
        TestSigner.assertNotSame((Object)s1, (Object)s3);
    }

    public void testVerify() throws Exception {
        Signer signer = new Signer("secret".getBytes());
        String t = "test";
        String s = signer.sign(t);
        String e = signer.verifyAndExtract(s);
        TestSigner.assertEquals((String)t, (String)e);
    }

    public void testInvalidSignedText() throws Exception {
        Signer signer = new Signer("secret".getBytes());
        try {
            signer.verifyAndExtract("test");
            TestSigner.fail();
        }
        catch (SignerException ex) {
        }
        catch (Throwable ex) {
            TestSigner.fail();
        }
    }

    public void testTampering() throws Exception {
        Signer signer = new Signer("secret".getBytes());
        String t = "test";
        String s = signer.sign(t);
        s = s + "x";
        try {
            signer.verifyAndExtract(s);
            TestSigner.fail();
        }
        catch (SignerException ex) {
        }
        catch (Throwable ex) {
            TestSigner.fail();
        }
    }
}

