/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.ProtocolHATestBase;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.Records;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestApplicationClientProtocolOnHA
extends ProtocolHATestBase {
    private YarnClient client = null;

    @Before
    public void initiate() throws Exception {
        this.startHACluster(1, true, false, false);
        YarnConfiguration conf = new YarnConfiguration(this.conf);
        this.client = this.createAndStartYarnClient((Configuration)conf);
    }

    @After
    public void shutDown() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Test(timeout=15000L)
    public void testGetApplicationReportOnHA() throws Exception {
        ApplicationReport report = this.client.getApplicationReport(this.cluster.createFakeAppId());
        Assert.assertTrue((report != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.cluster.createFakeAppReport(), (Object)report);
    }

    @Test(timeout=15000L)
    public void testGetNewApplicationOnHA() throws Exception {
        ApplicationId appId = this.client.createApplication().getApplicationSubmissionContext().getApplicationId();
        Assert.assertTrue((appId != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.cluster.createFakeAppId(), (Object)appId);
    }

    @Test(timeout=15000L)
    public void testGetClusterMetricsOnHA() throws Exception {
        YarnClusterMetrics clusterMetrics = this.client.getYarnClusterMetrics();
        Assert.assertTrue((clusterMetrics != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.cluster.createFakeYarnClusterMetrics(), (Object)clusterMetrics);
    }

    @Test(timeout=15000L)
    public void testGetApplicationsOnHA() throws Exception {
        List reports = this.client.getApplications();
        Assert.assertTrue((reports != null && !reports.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.cluster.createFakeAppReports(), (Object)reports);
    }

    @Test(timeout=15000L)
    public void testGetClusterNodesOnHA() throws Exception {
        List reports = this.client.getNodeReports(new NodeState[]{NodeState.RUNNING});
        Assert.assertTrue((reports != null && !reports.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.cluster.createFakeNodeReports(), (Object)reports);
    }

    @Test(timeout=15000L)
    public void testGetQueueInfoOnHA() throws Exception {
        QueueInfo queueInfo = this.client.getQueueInfo("root");
        Assert.assertTrue((queueInfo != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.cluster.createFakeQueueInfo(), (Object)queueInfo);
    }

    @Test(timeout=15000L)
    public void testGetQueueUserAclsOnHA() throws Exception {
        List queueUserAclsList = this.client.getQueueAclsInfo();
        Assert.assertTrue((queueUserAclsList != null && !queueUserAclsList.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.cluster.createFakeQueueUserACLInfoList(), (Object)queueUserAclsList);
    }

    @Test(timeout=15000L)
    public void testGetApplicationAttemptReportOnHA() throws Exception {
        ApplicationAttemptReport report = this.client.getApplicationAttemptReport(this.cluster.createFakeApplicationAttemptId());
        Assert.assertTrue((report != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.cluster.createFakeApplicationAttemptReport(), (Object)report);
    }

    @Test(timeout=15000L)
    public void testGetApplicationAttemptsOnHA() throws Exception {
        List reports = this.client.getApplicationAttempts(this.cluster.createFakeAppId());
        Assert.assertTrue((reports != null && !reports.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.cluster.createFakeApplicationAttemptReports(), (Object)reports);
    }

    @Test(timeout=15000L)
    public void testGetContainerReportOnHA() throws Exception {
        ContainerReport report = this.client.getContainerReport(this.cluster.createFakeContainerId());
        Assert.assertTrue((report != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.cluster.createFakeContainerReport(), (Object)report);
    }

    @Test(timeout=15000L)
    public void testGetContainersOnHA() throws Exception {
        List reports = this.client.getContainers(this.cluster.createFakeApplicationAttemptId());
        Assert.assertTrue((reports != null && !reports.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.cluster.createFakeContainerReports(), (Object)reports);
    }

    @Test(timeout=15000L)
    public void testSubmitApplicationOnHA() throws Exception {
        ApplicationSubmissionContext appContext = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        appContext.setApplicationId(this.cluster.createFakeAppId());
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        appContext.setAMContainerSpec(amContainer);
        Resource capability = (Resource)Records.newRecord(Resource.class);
        capability.setMemory(10);
        capability.setVirtualCores(1);
        appContext.setResource(capability);
        ApplicationId appId = this.client.submitApplication(appContext);
        Assert.assertTrue((boolean)this.getActiveRM().getRMContext().getRMApps().containsKey(appId));
    }

    @Test(timeout=15000L)
    public void testMoveApplicationAcrossQueuesOnHA() throws Exception {
        this.client.moveApplicationAcrossQueues(this.cluster.createFakeAppId(), "root");
    }

    @Test(timeout=15000L)
    public void testForceKillApplicationOnHA() throws Exception {
        this.client.killApplication(this.cluster.createFakeAppId());
    }

    @Test(timeout=15000L)
    public void testGetDelegationTokenOnHA() throws Exception {
        Token token = this.client.getRMDelegationToken(new Text(" "));
        Assert.assertEquals((Object)token, (Object)this.cluster.createFakeToken());
    }

    @Test(timeout=15000L)
    public void testRenewDelegationTokenOnHA() throws Exception {
        RenewDelegationTokenRequest request = RenewDelegationTokenRequest.newInstance((Token)this.cluster.createFakeToken());
        long newExpirationTime = ((ApplicationClientProtocol)ClientRMProxy.createRMProxy((Configuration)this.conf, ApplicationClientProtocol.class)).renewDelegationToken(request).getNextExpirationTime();
        Assert.assertEquals((long)newExpirationTime, (long)this.cluster.createNextExpirationTime());
    }

    @Test(timeout=15000L)
    public void testCancelDelegationTokenOnHA() throws Exception {
        CancelDelegationTokenRequest request = CancelDelegationTokenRequest.newInstance((Token)this.cluster.createFakeToken());
        ((ApplicationClientProtocol)ClientRMProxy.createRMProxy((Configuration)this.conf, ApplicationClientProtocol.class)).cancelDelegationToken(request);
    }
}

