/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.apache.hadoop.yarn.server.api.impl.pb.client.ResourceManagerAdministrationProtocolPBClientImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceResponse;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestResourceManagerAdministrationProtocolPBClientImpl {
    private static ResourceManager resourceManager;
    private static final Log LOG;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private static ResourceManagerAdministrationProtocol client;

    @BeforeClass
    public static void setUpResourceManager() throws IOException, InterruptedException {
        Configuration.addDefaultResource((String)"config-with-security.xml");
        YarnConfiguration configuration = new YarnConfiguration();
        resourceManager = new /* Unavailable Anonymous Inner Class!! */;
        resourceManager.init((Configuration)configuration);
        new /* Unavailable Anonymous Inner Class!! */.start();
        int waitCount = 0;
        while (resourceManager.getServiceState() == Service.STATE.INITED && waitCount++ < 10) {
            LOG.info((Object)"Waiting for RM to start...");
            Thread.sleep(1000L);
        }
        if (resourceManager.getServiceState() != Service.STATE.STARTED) {
            throw new IOException("ResourceManager failed to start. Final state is " + resourceManager.getServiceState());
        }
        LOG.info((Object)("ResourceManager RMAdmin address: " + configuration.get("yarn.resourcemanager.admin.address")));
        client = new ResourceManagerAdministrationProtocolPBClientImpl(1L, TestResourceManagerAdministrationProtocolPBClientImpl.getProtocolAddress((Configuration)configuration), (Configuration)configuration);
    }

    @Test
    public void testRefreshQueues() throws Exception {
        RefreshQueuesRequest request = (RefreshQueuesRequest)this.recordFactory.newRecordInstance(RefreshQueuesRequest.class);
        RefreshQueuesResponse response = client.refreshQueues(request);
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testRefreshNodes() throws Exception {
        resourceManager.getClientRMService();
        RefreshNodesRequest request = (RefreshNodesRequest)this.recordFactory.newRecordInstance(RefreshNodesRequest.class);
        RefreshNodesResponse response = client.refreshNodes(request);
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testRefreshSuperUserGroupsConfiguration() throws Exception {
        RefreshSuperUserGroupsConfigurationRequest request = (RefreshSuperUserGroupsConfigurationRequest)this.recordFactory.newRecordInstance(RefreshSuperUserGroupsConfigurationRequest.class);
        RefreshSuperUserGroupsConfigurationResponse response = client.refreshSuperUserGroupsConfiguration(request);
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testRefreshUserToGroupsMappings() throws Exception {
        RefreshUserToGroupsMappingsRequest request = (RefreshUserToGroupsMappingsRequest)this.recordFactory.newRecordInstance(RefreshUserToGroupsMappingsRequest.class);
        RefreshUserToGroupsMappingsResponse response = client.refreshUserToGroupsMappings(request);
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testRefreshAdminAcls() throws Exception {
        RefreshAdminAclsRequest request = (RefreshAdminAclsRequest)this.recordFactory.newRecordInstance(RefreshAdminAclsRequest.class);
        RefreshAdminAclsResponse response = client.refreshAdminAcls(request);
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testUpdateNodeResource() throws Exception {
        UpdateNodeResourceRequest request = (UpdateNodeResourceRequest)this.recordFactory.newRecordInstance(UpdateNodeResourceRequest.class);
        UpdateNodeResourceResponse response = client.updateNodeResource(request);
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testRefreshServiceAcls() throws Exception {
        RefreshServiceAclsRequest request = (RefreshServiceAclsRequest)this.recordFactory.newRecordInstance(RefreshServiceAclsRequest.class);
        RefreshServiceAclsResponse response = client.refreshServiceAcls(request);
        Assert.assertNotNull((Object)response);
    }

    @AfterClass
    public static void tearDownResourceManager() throws InterruptedException {
        if (resourceManager != null) {
            LOG.info((Object)"Stopping ResourceManager...");
            resourceManager.stop();
        }
    }

    private static InetSocketAddress getProtocolAddress(Configuration conf) throws IOException {
        return conf.getSocketAddr("yarn.resourcemanager.admin.address", "0.0.0.0:8033", 8033);
    }

    static /* synthetic */ ResourceManager access$000() {
        return resourceManager;
    }

    static {
        LOG = LogFactory.getLog(TestResourceManagerAdministrationProtocolPBClientImpl.class);
    }
}

