/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.client.api.NMTokenCache;
import org.apache.hadoop.yarn.client.api.impl.ContainerManagementProtocolProxy;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.ipc.YarnRPC;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.LimitedPrivate(value={"MapReduce", "YARN"})
public class ContainerManagementProtocolProxy {
    static final Log LOG = LogFactory.getLog(ContainerManagementProtocolProxy.class);
    private final int maxConnectedNMs;
    private final LinkedHashMap<String, ContainerManagementProtocolProxyData> cmProxy;
    private final Configuration conf;
    private final YarnRPC rpc;
    private NMTokenCache nmTokenCache;

    public ContainerManagementProtocolProxy(Configuration conf) {
        this(conf, NMTokenCache.getSingleton());
    }

    public ContainerManagementProtocolProxy(Configuration conf, NMTokenCache nmTokenCache) {
        this.conf = conf;
        this.nmTokenCache = nmTokenCache;
        this.maxConnectedNMs = conf.getInt("yarn.client.max-nodemanagers-proxies", 500);
        if (this.maxConnectedNMs < 1) {
            throw new YarnRuntimeException("yarn.client.max-nodemanagers-proxies (" + this.maxConnectedNMs + ") can not be less than 1.");
        }
        LOG.info((Object)("yarn.client.max-nodemanagers-proxies : " + this.maxConnectedNMs));
        this.cmProxy = new LinkedHashMap();
        this.rpc = YarnRPC.create((Configuration)conf);
    }

    public synchronized ContainerManagementProtocolProxyData getProxy(String containerManagerBindAddr, ContainerId containerId) throws SecretManager.InvalidToken {
        ContainerManagementProtocolProxyData proxy = (ContainerManagementProtocolProxyData)this.cmProxy.get(containerManagerBindAddr);
        while (proxy != null && !ContainerManagementProtocolProxyData.access$000((ContainerManagementProtocolProxyData)proxy).getIdentifier().equals(this.nmTokenCache.getToken(containerManagerBindAddr).getIdentifier())) {
            LOG.info((Object)("Refreshing proxy as NMToken got updated for node : " + containerManagerBindAddr));
            if (!ContainerManagementProtocolProxyData.access$100((ContainerManagementProtocolProxyData)proxy)) {
                this.removeProxy(proxy);
            } else {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (ContainerManagementProtocolProxyData.access$200((ContainerManagementProtocolProxyData)proxy) >= 0) continue;
            proxy = (ContainerManagementProtocolProxyData)this.cmProxy.get(containerManagerBindAddr);
        }
        if (proxy == null) {
            proxy = new ContainerManagementProtocolProxyData(this, this.rpc, containerManagerBindAddr, containerId, this.nmTokenCache.getToken(containerManagerBindAddr));
            if (this.cmProxy.size() > this.maxConnectedNMs) {
                String cmAddr = (String)this.cmProxy.keySet().iterator().next();
                this.removeProxy((ContainerManagementProtocolProxyData)this.cmProxy.get(cmAddr));
            }
            this.cmProxy.put(containerManagerBindAddr, proxy);
        }
        ContainerManagementProtocolProxyData.access$208((ContainerManagementProtocolProxyData)proxy);
        this.updateLRUCache(containerManagerBindAddr);
        return proxy;
    }

    private void updateLRUCache(String containerManagerBindAddr) {
        ContainerManagementProtocolProxyData proxy = (ContainerManagementProtocolProxyData)this.cmProxy.remove(containerManagerBindAddr);
        this.cmProxy.put(containerManagerBindAddr, proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void mayBeCloseProxy(ContainerManagementProtocolProxyData proxy) {
        ContainerManagementProtocolProxyData.access$210((ContainerManagementProtocolProxyData)proxy);
        if (ContainerManagementProtocolProxyData.access$100((ContainerManagementProtocolProxyData)proxy) && ContainerManagementProtocolProxyData.access$200((ContainerManagementProtocolProxyData)proxy) < 0) {
            LOG.info((Object)("Closing proxy : " + ContainerManagementProtocolProxyData.access$300((ContainerManagementProtocolProxyData)proxy)));
            this.cmProxy.remove(ContainerManagementProtocolProxyData.access$300((ContainerManagementProtocolProxyData)proxy));
            try {
                this.rpc.stopProxy((Object)proxy.getContainerManagementProtocol(), this.conf);
            }
            finally {
                this.notifyAll();
            }
        }
    }

    private synchronized void removeProxy(ContainerManagementProtocolProxyData proxy) {
        if (!ContainerManagementProtocolProxyData.access$100((ContainerManagementProtocolProxyData)proxy)) {
            ContainerManagementProtocolProxyData.access$102((ContainerManagementProtocolProxyData)proxy, (boolean)true);
            this.mayBeCloseProxy(proxy);
        }
    }

    public synchronized void stopAllProxies() {
        ArrayList nodeIds = new ArrayList();
        nodeIds.addAll(this.cmProxy.keySet());
        for (String nodeId : nodeIds) {
            ContainerManagementProtocolProxyData proxy = (ContainerManagementProtocolProxyData)this.cmProxy.get(nodeId);
            ContainerManagementProtocolProxyData.access$202((ContainerManagementProtocolProxyData)proxy, (int)0);
            try {
                this.removeProxy(proxy);
            }
            catch (Throwable t) {
                LOG.error((Object)"Error closing connection", t);
            }
        }
        this.cmProxy.clear();
    }

    static /* synthetic */ Configuration access$400(ContainerManagementProtocolProxy x0) {
        return x0.conf;
    }
}

