/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import java.net.ConnectException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.client.api.impl.TimelineClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestTimelineClient {
    private TimelineClientImpl client;

    @Before
    public void setup() {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        this.client = TestTimelineClient.createTimelineClient((YarnConfiguration)conf);
    }

    @After
    public void tearDown() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Test
    public void testPostEntities() throws Exception {
        TestTimelineClient.mockClientResponse((TimelineClientImpl)this.client, (ClientResponse.Status)ClientResponse.Status.OK, (boolean)false, (boolean)false);
        try {
            TimelinePutResponse response = this.client.putEntities(new TimelineEntity[]{TestTimelineClient.generateEntity()});
            Assert.assertEquals((long)0L, (long)response.getErrors().size());
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected");
        }
    }

    @Test
    public void testPostEntitiesWithError() throws Exception {
        TestTimelineClient.mockClientResponse((TimelineClientImpl)this.client, (ClientResponse.Status)ClientResponse.Status.OK, (boolean)true, (boolean)false);
        try {
            TimelinePutResponse response = this.client.putEntities(new TimelineEntity[]{TestTimelineClient.generateEntity()});
            Assert.assertEquals((long)1L, (long)response.getErrors().size());
            Assert.assertEquals((Object)"test entity id", (Object)((TimelinePutResponse.TimelinePutError)response.getErrors().get(0)).getEntityId());
            Assert.assertEquals((Object)"test entity type", (Object)((TimelinePutResponse.TimelinePutError)response.getErrors().get(0)).getEntityType());
            Assert.assertEquals((long)2L, (long)((TimelinePutResponse.TimelinePutError)response.getErrors().get(0)).getErrorCode());
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected");
        }
    }

    @Test
    public void testPostEntitiesNoResponse() throws Exception {
        TestTimelineClient.mockClientResponse((TimelineClientImpl)this.client, (ClientResponse.Status)ClientResponse.Status.INTERNAL_SERVER_ERROR, (boolean)false, (boolean)false);
        try {
            this.client.putEntities(new TimelineEntity[]{TestTimelineClient.generateEntity()});
            Assert.fail((String)"Exception is expected");
        }
        catch (YarnException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Failed to get the response from the timeline server."));
        }
    }

    @Test
    public void testPostEntitiesConnectionRefused() throws Exception {
        TestTimelineClient.mockClientResponse((TimelineClientImpl)this.client, null, (boolean)false, (boolean)true);
        try {
            this.client.putEntities(new TimelineEntity[]{TestTimelineClient.generateEntity()});
            Assert.fail((String)"RuntimeException is expected");
        }
        catch (RuntimeException re) {
            Assert.assertTrue((boolean)(re instanceof ClientHandlerException));
        }
    }

    @Test
    public void testPostEntitiesTimelineServiceNotEnabled() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", false);
        TimelineClientImpl client = TestTimelineClient.createTimelineClient((YarnConfiguration)conf);
        TestTimelineClient.mockClientResponse((TimelineClientImpl)client, (ClientResponse.Status)ClientResponse.Status.INTERNAL_SERVER_ERROR, (boolean)false, (boolean)false);
        try {
            TimelinePutResponse response = client.putEntities(new TimelineEntity[]{TestTimelineClient.generateEntity()});
            Assert.assertEquals((long)0L, (long)response.getErrors().size());
        }
        catch (YarnException e) {
            Assert.fail((String)"putEntities should already return before throwing the exception");
        }
    }

    @Test
    public void testPostEntitiesTimelineServiceDefaultNotEnabled() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.unset("yarn.timeline-service.enabled");
        TimelineClientImpl client = TestTimelineClient.createTimelineClient((YarnConfiguration)conf);
        TestTimelineClient.mockClientResponse((TimelineClientImpl)client, (ClientResponse.Status)ClientResponse.Status.INTERNAL_SERVER_ERROR, (boolean)false, (boolean)false);
        try {
            TimelinePutResponse response = client.putEntities(new TimelineEntity[]{TestTimelineClient.generateEntity()});
            Assert.assertEquals((long)0L, (long)response.getErrors().size());
        }
        catch (YarnException e) {
            Assert.fail((String)"putEntities should already return before throwing the exception");
        }
    }

    private static ClientResponse mockClientResponse(TimelineClientImpl client, ClientResponse.Status status, boolean hasError, boolean hasRuntimeError) {
        ClientResponse response = (ClientResponse)Mockito.mock(ClientResponse.class);
        if (hasRuntimeError) {
            ((TimelineClientImpl)Mockito.doThrow((Throwable)new ClientHandlerException((Throwable)new ConnectException())).when((Object)client)).doPostingEntities((TimelineEntities)Matchers.any(TimelineEntities.class));
            return response;
        }
        ((TimelineClientImpl)Mockito.doReturn((Object)response).when((Object)client)).doPostingEntities((TimelineEntities)Matchers.any(TimelineEntities.class));
        Mockito.when((Object)response.getClientResponseStatus()).thenReturn((Object)status);
        TimelinePutResponse.TimelinePutError error = new TimelinePutResponse.TimelinePutError();
        error.setEntityId("test entity id");
        error.setEntityType("test entity type");
        error.setErrorCode(2);
        TimelinePutResponse putResponse = new TimelinePutResponse();
        if (hasError) {
            putResponse.addError(error);
        }
        Mockito.when((Object)response.getEntity(TimelinePutResponse.class)).thenReturn((Object)putResponse);
        return response;
    }

    private static TimelineEntity generateEntity() {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityId("entity id");
        entity.setEntityType("entity type");
        entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
        for (int i = 0; i < 2; ++i) {
            TimelineEvent event = new TimelineEvent();
            event.setTimestamp(System.currentTimeMillis());
            event.setEventType("test event type " + i);
            event.addEventInfo("key1", (Object)"val1");
            event.addEventInfo("key2", (Object)"val2");
            entity.addEvent(event);
        }
        entity.addRelatedEntity("test ref type 1", "test ref id 1");
        entity.addRelatedEntity("test ref type 2", "test ref id 2");
        entity.addPrimaryFilter("pkey1", (Object)"pval1");
        entity.addPrimaryFilter("pkey2", (Object)"pval2");
        entity.addOtherInfo("okey1", (Object)"oval1");
        entity.addOtherInfo("okey2", (Object)"oval2");
        return entity;
    }

    private static TimelineClientImpl createTimelineClient(YarnConfiguration conf) {
        TimelineClientImpl client = (TimelineClientImpl)Mockito.spy((Object)((TimelineClientImpl)TimelineClient.createTimelineClient()));
        client.init((Configuration)conf);
        client.start();
        return client;
    }
}

