/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAAdmin;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.RMHAServiceTarget;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsRequest;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMAdminCLI
extends HAAdmin {
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected static final Map<String, HAAdmin.UsageInfo> ADMIN_USAGE = ImmutableMap.builder().put((Object)"-refreshQueues", (Object)new HAAdmin.UsageInfo("", "Reload the queues' acls, states and scheduler specific properties. \n\t\tResourceManager will reload the mapred-queues configuration file.")).put((Object)"-refreshNodes", (Object)new HAAdmin.UsageInfo("", "Refresh the hosts information at the ResourceManager.")).put((Object)"-refreshSuperUserGroupsConfiguration", (Object)new HAAdmin.UsageInfo("", "Refresh superuser proxy groups mappings")).put((Object)"-refreshUserToGroupsMappings", (Object)new HAAdmin.UsageInfo("", "Refresh user-to-groups mappings")).put((Object)"-refreshAdminAcls", (Object)new HAAdmin.UsageInfo("", "Refresh acls for administration of ResourceManager")).put((Object)"-refreshServiceAcl", (Object)new HAAdmin.UsageInfo("", "Reload the service-level authorization policy file. \n\t\tResoureceManager will reload the authorization policy file.")).put((Object)"-getGroups", (Object)new HAAdmin.UsageInfo("[username]", "Get the groups which given user belongs to.")).put((Object)"-help", (Object)new HAAdmin.UsageInfo("[cmd]", "Displays help for the given command or all commands if none is specified.")).build();

    public RMAdminCLI() {
    }

    public RMAdminCLI(Configuration conf) {
        super(conf);
    }

    private static void appendHAUsage(StringBuilder usageBuilder) {
        for (String cmdKey : USAGE.keySet()) {
            if (cmdKey.equals("-help")) continue;
            HAAdmin.UsageInfo usageInfo = (HAAdmin.UsageInfo)USAGE.get(cmdKey);
            usageBuilder.append(" [" + cmdKey + " " + usageInfo.args + "]");
        }
    }

    private static void buildHelpMsg(String cmd, StringBuilder builder) {
        HAAdmin.UsageInfo usageInfo = (HAAdmin.UsageInfo)ADMIN_USAGE.get(cmd);
        if (usageInfo == null && (usageInfo = (HAAdmin.UsageInfo)USAGE.get(cmd)) == null) {
            return;
        }
        String space = usageInfo.args == "" ? "" : " ";
        builder.append("   " + cmd + space + usageInfo.args + ": " + usageInfo.help);
    }

    private static void buildIndividualUsageMsg(String cmd, StringBuilder builder) {
        boolean isHACommand = false;
        HAAdmin.UsageInfo usageInfo = (HAAdmin.UsageInfo)ADMIN_USAGE.get(cmd);
        if (usageInfo == null) {
            usageInfo = (HAAdmin.UsageInfo)USAGE.get(cmd);
            if (usageInfo == null) {
                return;
            }
            isHACommand = true;
        }
        String space = usageInfo.args == "" ? "" : " ";
        builder.append("Usage: yarn rmadmin [" + cmd + space + usageInfo.args + "]\n");
        if (isHACommand) {
            builder.append(cmd + " can only be used when RM HA is enabled");
        }
    }

    private static void buildUsageMsg(StringBuilder builder, boolean isHAEnabled) {
        HAAdmin.UsageInfo usageInfo;
        builder.append("Usage: yarn rmadmin\n");
        for (String cmdKey : ADMIN_USAGE.keySet()) {
            usageInfo = (HAAdmin.UsageInfo)ADMIN_USAGE.get(cmdKey);
            builder.append("   " + cmdKey + " " + usageInfo.args + "\n");
        }
        if (isHAEnabled) {
            for (String cmdKey : USAGE.keySet()) {
                if (cmdKey.equals("-help")) continue;
                usageInfo = (HAAdmin.UsageInfo)USAGE.get(cmdKey);
                builder.append("   " + cmdKey + " " + usageInfo.args + "\n");
            }
        }
    }

    private static void printHelp(String cmd, boolean isHAEnabled) {
        StringBuilder summary = new StringBuilder();
        summary.append("rmadmin is the command to execute YARN administrative commands.\n");
        summary.append("The full syntax is: \n\nyarn rmadmin [-refreshQueues] [-refreshNodes] [-refreshSuperUserGroupsConfiguration] [-refreshUserToGroupsMappings] [-refreshAdminAcls] [-refreshServiceAcl] [-getGroup [username]] [-help [cmd]]");
        if (isHAEnabled) {
            RMAdminCLI.appendHAUsage((StringBuilder)summary);
        }
        summary.append("\n");
        StringBuilder helpBuilder = new StringBuilder();
        System.out.println(summary);
        for (String cmdKey : ADMIN_USAGE.keySet()) {
            RMAdminCLI.buildHelpMsg((String)cmdKey, (StringBuilder)helpBuilder);
            helpBuilder.append("\n");
        }
        if (isHAEnabled) {
            for (String cmdKey : USAGE.keySet()) {
                if (cmdKey.equals("-help")) continue;
                RMAdminCLI.buildHelpMsg((String)cmdKey, (StringBuilder)helpBuilder);
                helpBuilder.append("\n");
            }
        }
        System.out.println(helpBuilder);
        System.out.println();
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
    }

    private static void printUsage(String cmd, boolean isHAEnabled) {
        StringBuilder usageBuilder = new StringBuilder();
        if (ADMIN_USAGE.containsKey(cmd) || USAGE.containsKey(cmd)) {
            RMAdminCLI.buildIndividualUsageMsg((String)cmd, (StringBuilder)usageBuilder);
        } else {
            RMAdminCLI.buildUsageMsg((StringBuilder)usageBuilder, (boolean)isHAEnabled);
        }
        System.err.println(usageBuilder);
        ToolRunner.printGenericCommandUsage((PrintStream)System.err);
    }

    protected ResourceManagerAdministrationProtocol createAdminProtocol() throws IOException {
        YarnConfiguration conf = new YarnConfiguration(this.getConf());
        return (ResourceManagerAdministrationProtocol)ClientRMProxy.createRMProxy((Configuration)conf, ResourceManagerAdministrationProtocol.class);
    }

    private int refreshQueues() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshQueuesRequest request = (RefreshQueuesRequest)this.recordFactory.newRecordInstance(RefreshQueuesRequest.class);
        adminProtocol.refreshQueues(request);
        return 0;
    }

    private int refreshNodes() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshNodesRequest request = (RefreshNodesRequest)this.recordFactory.newRecordInstance(RefreshNodesRequest.class);
        adminProtocol.refreshNodes(request);
        return 0;
    }

    private int refreshUserToGroupsMappings() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshUserToGroupsMappingsRequest request = (RefreshUserToGroupsMappingsRequest)this.recordFactory.newRecordInstance(RefreshUserToGroupsMappingsRequest.class);
        adminProtocol.refreshUserToGroupsMappings(request);
        return 0;
    }

    private int refreshSuperUserGroupsConfiguration() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshSuperUserGroupsConfigurationRequest request = (RefreshSuperUserGroupsConfigurationRequest)this.recordFactory.newRecordInstance(RefreshSuperUserGroupsConfigurationRequest.class);
        adminProtocol.refreshSuperUserGroupsConfiguration(request);
        return 0;
    }

    private int refreshAdminAcls() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshAdminAclsRequest request = (RefreshAdminAclsRequest)this.recordFactory.newRecordInstance(RefreshAdminAclsRequest.class);
        adminProtocol.refreshAdminAcls(request);
        return 0;
    }

    private int refreshServiceAcls() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshServiceAclsRequest request = (RefreshServiceAclsRequest)this.recordFactory.newRecordInstance(RefreshServiceAclsRequest.class);
        adminProtocol.refreshServiceAcls(request);
        return 0;
    }

    private int getGroups(String[] usernames) throws IOException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        if (usernames.length == 0) {
            usernames = new String[]{UserGroupInformation.getCurrentUser().getUserName()};
        }
        for (String username : usernames) {
            StringBuilder sb = new StringBuilder();
            sb.append(username + " :");
            for (String group : adminProtocol.getGroupsForUser(username)) {
                sb.append(" ");
                sb.append(group);
            }
            System.out.println(sb);
        }
        return 0;
    }

    public int run(String[] args) throws Exception {
        YarnConfiguration yarnConf = this.getConf() == null ? new YarnConfiguration() : new YarnConfiguration(this.getConf());
        boolean isHAEnabled = yarnConf.getBoolean("yarn.resourcemanager.ha.enabled", false);
        if (args.length < 1) {
            RMAdminCLI.printUsage((String)"", (boolean)isHAEnabled);
            return -1;
        }
        int exitCode = -1;
        int i = 0;
        String cmd = args[i++];
        exitCode = 0;
        if ("-help".equals(cmd)) {
            if (i < args.length) {
                RMAdminCLI.printUsage((String)args[i], (boolean)isHAEnabled);
            } else {
                RMAdminCLI.printHelp((String)"", (boolean)isHAEnabled);
            }
            return exitCode;
        }
        if (USAGE.containsKey(cmd)) {
            if (isHAEnabled) {
                return super.run(args);
            }
            System.out.println("Cannot run " + cmd + " when ResourceManager HA is not enabled");
            return -1;
        }
        if (("-refreshAdminAcls".equals(cmd) || "-refreshQueues".equals(cmd) || "-refreshNodes".equals(cmd) || "-refreshServiceAcl".equals(cmd) || "-refreshUserToGroupsMappings".equals(cmd) || "-refreshSuperUserGroupsConfiguration".equals(cmd)) && args.length != 1) {
            RMAdminCLI.printUsage((String)cmd, (boolean)isHAEnabled);
            return exitCode;
        }
        try {
            if ("-refreshQueues".equals(cmd)) {
                exitCode = this.refreshQueues();
            } else if ("-refreshNodes".equals(cmd)) {
                exitCode = this.refreshNodes();
            } else if ("-refreshUserToGroupsMappings".equals(cmd)) {
                exitCode = this.refreshUserToGroupsMappings();
            } else if ("-refreshSuperUserGroupsConfiguration".equals(cmd)) {
                exitCode = this.refreshSuperUserGroupsConfiguration();
            } else if ("-refreshAdminAcls".equals(cmd)) {
                exitCode = this.refreshAdminAcls();
            } else if ("-refreshServiceAcl".equals(cmd)) {
                exitCode = this.refreshServiceAcls();
            } else if ("-getGroups".equals(cmd)) {
                String[] usernames = Arrays.copyOfRange(args, i, args.length);
                exitCode = this.getGroups(usernames);
            } else {
                exitCode = -1;
                System.err.println(cmd.substring(1) + ": Unknown command");
                RMAdminCLI.printUsage((String)"", (boolean)isHAEnabled);
            }
        }
        catch (IllegalArgumentException arge) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + arge.getLocalizedMessage());
            RMAdminCLI.printUsage((String)cmd, (boolean)isHAEnabled);
        }
        catch (RemoteException e) {
            exitCode = -1;
            try {
                String[] content = e.getLocalizedMessage().split("\n");
                System.err.println(cmd.substring(1) + ": " + content[0]);
            }
            catch (Exception ex) {
                System.err.println(cmd.substring(1) + ": " + ex.getLocalizedMessage());
            }
        }
        catch (Exception e) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + e.getLocalizedMessage());
        }
        return exitCode;
    }

    public void setConf(Configuration conf) {
        if (conf != null) {
            conf = RMAdminCLI.addSecurityConfiguration((Configuration)conf);
        }
        super.setConf(conf);
    }

    private static Configuration addSecurityConfiguration(Configuration conf) {
        conf = new YarnConfiguration(conf);
        conf.set("hadoop.security.service.user.name.key", conf.get("yarn.resourcemanager.principal", ""));
        return conf;
    }

    protected HAServiceTarget resolveTarget(String rmId) {
        Collection rmIds = HAUtil.getRMHAIds((Configuration)this.getConf());
        if (!rmIds.contains(rmId)) {
            StringBuilder msg = new StringBuilder();
            msg.append(rmId + " is not a valid serviceId. It should be one of ");
            for (String id : rmIds) {
                msg.append(id + " ");
            }
            throw new IllegalArgumentException(msg.toString());
        }
        try {
            YarnConfiguration conf = new YarnConfiguration(this.getConf());
            conf.set("yarn.resourcemanager.ha.id", rmId);
            return new RMHAServiceTarget(conf);
        }
        catch (IllegalArgumentException iae) {
            throw new YarnRuntimeException("Could not connect to " + rmId + "; the configuration for it might be missing");
        }
        catch (IOException ioe) {
            throw new YarnRuntimeException("Could not connect to RM HA Admin for node " + rmId);
        }
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run((Tool)new RMAdminCLI(), (String[])args);
        System.exit(result);
    }
}

