/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationTimeout;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ShellContainerCommand;
import org.apache.hadoop.yarn.api.records.SignalContainerCommand;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.AppAdminClient;
import org.apache.hadoop.yarn.client.cli.YarnCLI;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.ContainerNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ApplicationCLI
extends YarnCLI {
    private static final String APPLICATIONS_PATTERN = "%30s\t%20s\t%20s\t%10s\t%10s\t%18s\t%18s\t%15s\t%35s" + System.getProperty("line.separator");
    private static final String APPLICATION_ATTEMPTS_PATTERN = "%30s\t%20s\t%35s\t%35s" + System.getProperty("line.separator");
    private static final String APP_TYPE_CMD = "appTypes";
    private static final String APP_STATE_CMD = "appStates";
    private static final String APP_TAG_CMD = "appTags";
    private static final String ALLSTATES_OPTION = "ALL";
    private static final String QUEUE_CMD = "queue";
    @VisibleForTesting
    protected static final String CONTAINER_PATTERN = "%30s\t%20s\t%20s\t%20s\t%20s\t%20s\t%35s" + System.getProperty("line.separator");
    public static final String APP = "app";
    public static final String APPLICATION = "application";
    public static final String APPLICATION_ATTEMPT = "applicationattempt";
    public static final String CONTAINER = "container";
    public static final String APP_ID = "appId";
    public static final String UPDATE_PRIORITY = "updatePriority";
    public static final String UPDATE_LIFETIME = "updateLifetime";
    public static final String CHANGE_APPLICATION_QUEUE = "changeQueue";
    public static final String LAUNCH_CMD = "launch";
    public static final String STOP_CMD = "stop";
    public static final String START_CMD = "start";
    public static final String SAVE_CMD = "save";
    public static final String DESTROY_CMD = "destroy";
    public static final String FLEX_CMD = "flex";
    public static final String COMPONENT = "component";
    public static final String DECOMMISSION = "decommission";
    public static final String ENABLE_FAST_LAUNCH = "enableFastLaunch";
    public static final String UPGRADE_CMD = "upgrade";
    public static final String UPGRADE_EXPRESS = "express";
    public static final String UPGRADE_CANCEL = "cancel";
    public static final String UPGRADE_INITIATE = "initiate";
    public static final String UPGRADE_AUTO_FINALIZE = "autoFinalize";
    public static final String UPGRADE_FINALIZE = "finalize";
    public static final String COMPONENT_INSTS = "instances";
    public static final String COMPONENTS = "components";
    public static final String VERSION = "version";
    public static final String STATES = "states";
    public static final String SHELL_CMD = "shell";
    public static final String CLUSTER_ID_OPTION = "clusterId";
    private static String firstArg = null;
    private boolean allAppStates;

    public static void main(String[] args) throws Exception {
        ApplicationCLI cli = new ApplicationCLI();
        cli.setSysOutPrintStream(System.out);
        cli.setSysErrPrintStream(System.err);
        int res = ToolRunner.run((Tool)cli, (String[])ApplicationCLI.preProcessArgs(args));
        cli.stop();
        System.exit(res);
    }

    @VisibleForTesting
    public static String[] preProcessArgs(String[] args) {
        if (args.length > 0) {
            firstArg = args[0];
            return Arrays.copyOfRange(args, 1, args.length);
        }
        return args;
    }

    public int run(String[] args) throws Exception {
        int exitCode = -1;
        Options opts = new Options();
        String title = null;
        if (firstArg != null) {
            title = firstArg;
        } else if (args.length > 0) {
            title = args[0];
        }
        if (APPLICATION.equalsIgnoreCase(title) || APP.equalsIgnoreCase(title)) {
            title = APPLICATION;
            this.addApplicationOptions(opts);
        } else if (APPLICATION_ATTEMPT.equalsIgnoreCase(title)) {
            this.addApplicationAttemptOptions(opts);
        } else if (CONTAINER.equalsIgnoreCase(title)) {
            this.addContainerOptions(opts);
        }
        CommandLine cliParser = this.createCLIParser(opts, args);
        if (cliParser == null) {
            this.printUsage(title, opts);
            return exitCode;
        }
        if (cliParser.hasOption(CLUSTER_ID_OPTION)) {
            String clusterIdStr = cliParser.getOptionValue(CLUSTER_ID_OPTION);
            this.getConf().set("yarn.resourcemanager.cluster-id", clusterIdStr);
        }
        this.createAndStartYarnClient();
        if (cliParser.hasOption("status")) {
            return this.executeStatusCommand(cliParser, title, opts);
        }
        if (cliParser.hasOption("list")) {
            return this.executeListCommand(cliParser, title, opts);
        }
        if (cliParser.hasOption("kill")) {
            return this.executeKillCommand(cliParser, title, opts);
        }
        if (cliParser.hasOption("movetoqueue")) {
            return this.executeMoveToQueueCommand(cliParser, title, opts);
        }
        if (cliParser.hasOption("fail")) {
            return this.executeFailCommand(cliParser, title, opts);
        }
        if (cliParser.hasOption(UPDATE_PRIORITY)) {
            return this.executeUpdatePriorityCommand(cliParser, title, opts);
        }
        if (cliParser.hasOption("signal")) {
            return this.executeSignalCommand(cliParser, title, opts);
        }
        if (cliParser.hasOption(SHELL_CMD)) {
            return this.executeShellCommand(cliParser, title, opts);
        }
        if (cliParser.hasOption(LAUNCH_CMD)) {
            return this.executeLaunchCommand(cliParser, title, opts);
        }
        if (cliParser.hasOption(STOP_CMD)) {
            return this.executeStopCommand(cliParser, title, opts);
        }
        if (cliParser.hasOption(START_CMD)) {
            return this.executeStartCommand(cliParser, title, opts);
        }
        if (cliParser.hasOption(SAVE_CMD)) {
            return this.executeSaveCommand(cliParser, title, opts);
        }
        if (cliParser.hasOption(DESTROY_CMD)) {
            return this.executeDestroyCommand(cliParser, title, opts);
        }
        if (cliParser.hasOption(FLEX_CMD)) {
            return this.executeFlexCommand(cliParser, title, opts);
        }
        if (cliParser.hasOption(ENABLE_FAST_LAUNCH)) {
            return this.executeEnableFastLaunchCommand(cliParser, title, opts);
        }
        if (cliParser.hasOption(UPDATE_LIFETIME)) {
            return this.executeUpdateLifeTimeCommand(cliParser, title, opts);
        }
        if (cliParser.hasOption(CHANGE_APPLICATION_QUEUE)) {
            return this.executeChangeApplicationQueueCommand(cliParser, title, opts);
        }
        if (cliParser.hasOption(UPGRADE_CMD)) {
            return this.executeUpgradeCommand(cliParser, title, opts);
        }
        if (cliParser.hasOption(DECOMMISSION)) {
            return this.executeDecommissionCommand(cliParser, title, opts);
        }
        if (cliParser.hasOption("help")) {
            this.printUsage(title, opts);
            return 0;
        }
        this.syserr.println("Invalid Command Usage : ");
        this.printUsage(title, opts);
        return 0;
    }

    private ApplicationReport getApplicationReport(ApplicationId applicationId) throws IOException, YarnException {
        ApplicationReport appReport = null;
        try {
            appReport = this.client.getApplicationReport(applicationId);
        }
        catch (ApplicationNotFoundException e) {
            throw new YarnException("Application with id '" + applicationId + "' doesn't exist in RM or Timeline Server.");
        }
        return appReport;
    }

    private String[] getAppNameAndType(CommandLine cliParser, String option) throws IOException, YarnException {
        String applicationIdOrName = cliParser.getOptionValue(option);
        try {
            ApplicationId id = ApplicationId.fromString((String)applicationIdOrName);
            ApplicationReport report = this.getApplicationReport(id);
            return new String[]{report.getName(), report.getApplicationType()};
        }
        catch (IllegalArgumentException e) {
            String appType = ApplicationCLI.getSingleAppTypeFromCLI(cliParser);
            return new String[]{applicationIdOrName, appType};
        }
    }

    private static String getSingleAppTypeFromCLI(CommandLine cliParser) {
        String[] types;
        if (cliParser.hasOption(APP_TYPE_CMD) && (types = cliParser.getOptionValues(APP_TYPE_CMD)) != null) {
            for (String type : types) {
                if (type.trim().isEmpty()) continue;
                return StringUtils.toLowerCase((String)type).trim();
            }
        }
        return "yarn-service";
    }

    private void updateApplicationTimeout(String applicationId, ApplicationTimeoutType timeoutType, long timeoutInSec) throws YarnException, IOException {
        ApplicationId appId = ApplicationId.fromString((String)applicationId);
        String newTimeout = Times.formatISO8601((long)(System.currentTimeMillis() + timeoutInSec * 1000L));
        this.sysout.println("Updating timeout for given timeoutType: " + timeoutType.toString() + " of an application " + applicationId);
        UpdateApplicationTimeoutsRequest request = UpdateApplicationTimeoutsRequest.newInstance((ApplicationId)appId, Collections.singletonMap(timeoutType, newTimeout));
        UpdateApplicationTimeoutsResponse updateApplicationTimeouts = this.client.updateApplicationTimeouts(request);
        String updatedTimeout = (String)updateApplicationTimeouts.getApplicationTimeouts().get(timeoutType);
        if (timeoutType.equals((Object)ApplicationTimeoutType.LIFETIME) && !newTimeout.equals(updatedTimeout)) {
            this.sysout.println("Updated lifetime of an application  " + applicationId + " to queue max/default lifetime. New expiry time is " + updatedTimeout);
            return;
        }
        this.sysout.println("Successfully updated " + timeoutType.toString() + " of an application " + applicationId + ". New expiry time is " + updatedTimeout);
    }

    private void signalToContainer(String containerIdStr, SignalContainerCommand command) throws YarnException, IOException {
        ContainerId containerId = ContainerId.fromString((String)containerIdStr);
        this.sysout.println("Signalling container " + containerIdStr);
        this.client.signalToContainer(containerId, command);
    }

    private void shellToContainer(String containerIdStr, ShellContainerCommand command) throws YarnException, IOException {
        ContainerId containerId = ContainerId.fromString((String)containerIdStr);
        this.sysout.println("Shelling to container " + containerIdStr);
        this.client.shellToContainer(containerId, command);
    }

    @VisibleForTesting
    void printUsage(String title, Options opts) {
        new HelpFormatter().printHelp(title, opts);
    }

    private int printApplicationAttemptReport(String applicationAttemptId) throws YarnException, IOException {
        ApplicationAttemptReport appAttemptReport = null;
        try {
            appAttemptReport = this.client.getApplicationAttemptReport(ApplicationAttemptId.fromString((String)applicationAttemptId));
        }
        catch (ApplicationNotFoundException e) {
            this.sysout.println("Application for AppAttempt with id '" + applicationAttemptId + "' doesn't exist in RM or Timeline Server.");
            return -1;
        }
        catch (ApplicationAttemptNotFoundException e) {
            this.sysout.println("Application Attempt with id '" + applicationAttemptId + "' doesn't exist in RM or Timeline Server.");
            return -1;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter appAttemptReportStr = new PrintWriter(new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF-8")));
        if (appAttemptReport == null) {
            appAttemptReportStr.print("Application Attempt with id '" + applicationAttemptId + "' doesn't exist in Timeline Server.");
            appAttemptReportStr.close();
            this.sysout.println(baos.toString("UTF-8"));
            return -1;
        }
        appAttemptReportStr.println("Application Attempt Report : ");
        appAttemptReportStr.print("\tApplicationAttempt-Id : ");
        appAttemptReportStr.println(appAttemptReport.getApplicationAttemptId());
        appAttemptReportStr.print("\tState : ");
        appAttemptReportStr.println(appAttemptReport.getYarnApplicationAttemptState());
        appAttemptReportStr.print("\tAMContainer : ");
        appAttemptReportStr.println(appAttemptReport.getAMContainerId() == null ? "N/A" : appAttemptReport.getAMContainerId().toString());
        appAttemptReportStr.print("\tTracking-URL : ");
        appAttemptReportStr.println(appAttemptReport.getTrackingUrl());
        appAttemptReportStr.print("\tRPC Port : ");
        appAttemptReportStr.println(appAttemptReport.getRpcPort());
        appAttemptReportStr.print("\tAM Host : ");
        appAttemptReportStr.println(appAttemptReport.getHost());
        appAttemptReportStr.print("\tDiagnostics : ");
        appAttemptReportStr.print(appAttemptReport.getDiagnostics());
        appAttemptReportStr.close();
        this.sysout.println(baos.toString("UTF-8"));
        return 0;
    }

    private int printContainerReport(String containerId) throws YarnException, IOException {
        ContainerReport containerReport = null;
        try {
            containerReport = this.client.getContainerReport(ContainerId.fromString((String)containerId));
        }
        catch (ApplicationNotFoundException e) {
            this.sysout.println("Application for Container with id '" + containerId + "' doesn't exist in RM or Timeline Server.");
            return -1;
        }
        catch (ApplicationAttemptNotFoundException e) {
            this.sysout.println("Application Attempt for Container with id '" + containerId + "' doesn't exist in RM or Timeline Server.");
            return -1;
        }
        catch (ContainerNotFoundException e) {
            this.sysout.println("Container with id '" + containerId + "' doesn't exist in RM or Timeline Server.");
            return -1;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter containerReportStr = new PrintWriter(new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF-8")));
        if (containerReport == null) {
            containerReportStr.print("Container with id '" + containerId + "' doesn't exist in Timeline Server.");
            containerReportStr.close();
            this.sysout.println(baos.toString("UTF-8"));
            return -1;
        }
        containerReportStr.println("Container Report : ");
        containerReportStr.print("\tContainer-Id : ");
        containerReportStr.println(containerReport.getContainerId());
        containerReportStr.print("\tStart-Time : ");
        containerReportStr.println(containerReport.getCreationTime());
        containerReportStr.print("\tFinish-Time : ");
        containerReportStr.println(containerReport.getFinishTime());
        containerReportStr.print("\tState : ");
        containerReportStr.println(containerReport.getContainerState());
        containerReportStr.print("\tExecution-Type : ");
        containerReportStr.println(containerReport.getExecutionType());
        containerReportStr.print("\tLOG-URL : ");
        containerReportStr.println(containerReport.getLogUrl());
        containerReportStr.print("\tHost : ");
        containerReportStr.println(containerReport.getAssignedNode());
        containerReportStr.print("\tNodeHttpAddress : ");
        containerReportStr.println(containerReport.getNodeHttpAddress() == null ? "N/A" : containerReport.getNodeHttpAddress());
        containerReportStr.print("\tExposedPorts : ");
        containerReportStr.println(containerReport.getExposedPorts() == null ? "N/A" : containerReport.getExposedPorts());
        containerReportStr.print("\tDiagnostics : ");
        containerReportStr.print(containerReport.getDiagnosticsInfo());
        containerReportStr.close();
        this.sysout.println(baos.toString("UTF-8"));
        return 0;
    }

    private void listApplications(Set<String> appTypes, EnumSet<YarnApplicationState> appStates, Set<String> appTags) throws YarnException, IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.sysout, Charset.forName("UTF-8")));
        if (this.allAppStates) {
            for (YarnApplicationState appState : YarnApplicationState.values()) {
                appStates.add(appState);
            }
        } else if (appStates.isEmpty()) {
            appStates.add(YarnApplicationState.RUNNING);
            appStates.add(YarnApplicationState.ACCEPTED);
            appStates.add(YarnApplicationState.SUBMITTED);
        }
        List<ApplicationReport> appsReport = this.client.getApplications(appTypes, appStates, appTags);
        writer.println("Total number of applications (application-types: " + appTypes + ", states: " + appStates + " and tags: " + appTags + "):" + appsReport.size());
        writer.printf(APPLICATIONS_PATTERN, "Application-Id", "Application-Name", "Application-Type", "User", "Queue", "State", "Final-State", "Progress", "Tracking-URL");
        for (ApplicationReport appReport : appsReport) {
            DecimalFormat formatter = new DecimalFormat("###.##%");
            String progress = formatter.format(appReport.getProgress());
            writer.printf(APPLICATIONS_PATTERN, appReport.getApplicationId(), appReport.getName(), appReport.getApplicationType(), appReport.getUser(), appReport.getQueue(), appReport.getYarnApplicationState(), appReport.getFinalApplicationStatus(), progress, appReport.getOriginalTrackingUrl());
        }
        writer.flush();
    }

    private int killApplication(String[] applicationIds) throws YarnException, IOException {
        int returnCode = -1;
        for (String applicationId : applicationIds) {
            try {
                this.killApplication(applicationId);
                returnCode = 0;
            }
            catch (ApplicationNotFoundException e) {
                // empty catch block
            }
        }
        return returnCode;
    }

    private void killApplication(String applicationId) throws YarnException, IOException {
        ApplicationId appId = ApplicationId.fromString((String)applicationId);
        ApplicationReport appReport = null;
        try {
            appReport = this.client.getApplicationReport(appId);
        }
        catch (ApplicationNotFoundException e) {
            this.sysout.println("Application with id '" + applicationId + "' doesn't exist in RM.");
            throw e;
        }
        if (Apps.isApplicationFinalState((YarnApplicationState)appReport.getYarnApplicationState())) {
            this.sysout.println("Application " + applicationId + " has already finished ");
        } else {
            this.sysout.println("Killing application " + applicationId);
            this.client.killApplication(appId);
        }
    }

    private void moveApplicationAcrossQueues(String applicationId, String queue) throws YarnException, IOException {
        ApplicationId appId = ApplicationId.fromString((String)applicationId);
        ApplicationReport appReport = this.client.getApplicationReport(appId);
        if (Apps.isApplicationFinalState((YarnApplicationState)appReport.getYarnApplicationState())) {
            this.sysout.println("Application " + applicationId + " has already finished ");
        } else {
            this.sysout.println("Moving application " + applicationId + " to queue " + queue);
            this.client.moveApplicationAcrossQueues(appId, queue);
            this.sysout.println("Successfully completed move.");
        }
    }

    private void failApplicationAttempt(String attemptId) throws YarnException, IOException {
        ApplicationAttemptId attId = ApplicationAttemptId.fromString((String)attemptId);
        ApplicationId appId = attId.getApplicationId();
        this.sysout.println("Failing attempt " + attId + " of application " + appId);
        this.client.failApplicationAttempt(attId);
    }

    private int printApplicationReport(String applicationId) throws YarnException, IOException {
        ApplicationReport appReport = null;
        try {
            appReport = this.client.getApplicationReport(ApplicationId.fromString((String)applicationId));
        }
        catch (ApplicationNotFoundException e) {
            this.sysout.println("Application with id '" + applicationId + "' doesn't exist in RM or Timeline Server.");
            return -1;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter appReportStr = new PrintWriter(new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF-8")));
        if (appReport != null) {
            appReportStr.println("Application Report : ");
            appReportStr.print("\tApplication-Id : ");
            appReportStr.println(appReport.getApplicationId());
            appReportStr.print("\tApplication-Name : ");
            appReportStr.println(appReport.getName());
            appReportStr.print("\tApplication-Type : ");
            appReportStr.println(appReport.getApplicationType());
            appReportStr.print("\tUser : ");
            appReportStr.println(appReport.getUser());
            appReportStr.print("\tQueue : ");
            appReportStr.println(appReport.getQueue());
            appReportStr.print("\tApplication Priority : ");
            appReportStr.println(appReport.getPriority());
            appReportStr.print("\tStart-Time : ");
            appReportStr.println(appReport.getStartTime());
            appReportStr.print("\tFinish-Time : ");
            appReportStr.println(appReport.getFinishTime());
            appReportStr.print("\tProgress : ");
            DecimalFormat formatter = new DecimalFormat("###.##%");
            String progress = formatter.format(appReport.getProgress());
            appReportStr.println(progress);
            appReportStr.print("\tState : ");
            appReportStr.println(appReport.getYarnApplicationState());
            appReportStr.print("\tFinal-State : ");
            appReportStr.println(appReport.getFinalApplicationStatus());
            appReportStr.print("\tTracking-URL : ");
            appReportStr.println(appReport.getOriginalTrackingUrl());
            appReportStr.print("\tRPC Port : ");
            appReportStr.println(appReport.getRpcPort());
            appReportStr.print("\tAM Host : ");
            appReportStr.println(appReport.getHost());
            ApplicationResourceUsageReport usageReport = appReport.getApplicationResourceUsageReport();
            this.printResourceUsage(appReportStr, usageReport);
            appReportStr.print("\tLog Aggregation Status : ");
            appReportStr.println((Object)(appReport.getLogAggregationStatus() == null ? "N/A" : appReport.getLogAggregationStatus()));
            appReportStr.print("\tDiagnostics : ");
            appReportStr.println(appReport.getDiagnostics());
            appReportStr.print("\tUnmanaged Application : ");
            appReportStr.println(appReport.isUnmanagedApp());
            appReportStr.print("\tApplication Node Label Expression : ");
            appReportStr.println(appReport.getAppNodeLabelExpression());
            appReportStr.print("\tAM container Node Label Expression : ");
            appReportStr.println(appReport.getAmNodeLabelExpression());
            for (ApplicationTimeout timeout : appReport.getApplicationTimeouts().values()) {
                appReportStr.print("\tTimeoutType : " + timeout.getTimeoutType());
                appReportStr.print("\tExpiryTime : " + timeout.getExpiryTime());
                appReportStr.println("\tRemainingTime : " + timeout.getRemainingTime() + "seconds");
            }
            String rmClusterId = appReport.getRMClusterId();
            if (rmClusterId != null) {
                appReportStr.print("\tRMClusterId : ");
                appReportStr.println(rmClusterId);
            }
        } else {
            appReportStr.print("Application with id '" + applicationId + "' doesn't exist in RM.");
            appReportStr.close();
            this.sysout.println(baos.toString("UTF-8"));
            return -1;
        }
        appReportStr.close();
        this.sysout.println(baos.toString("UTF-8"));
        return 0;
    }

    private void printResourceUsage(PrintWriter appReportStr, ApplicationResourceUsageReport usageReport) {
        appReportStr.print("\tAggregate Resource Allocation : ");
        if (usageReport != null) {
            appReportStr.println(StringHelper.getResourceSecondsString((Map)usageReport.getResourceSecondsMap()));
            appReportStr.print("\tAggregate Resource Preempted : ");
            appReportStr.println(StringHelper.getResourceSecondsString((Map)usageReport.getPreemptedResourceSecondsMap()));
        } else {
            appReportStr.println("N/A");
            appReportStr.print("\tAggregate Resource Preempted : ");
            appReportStr.println("N/A");
        }
    }

    private String getAllValidApplicationStates() {
        StringBuilder sb = new StringBuilder();
        sb.append("The valid application state can be one of the following: ").append("ALL,");
        for (YarnApplicationState appState : YarnApplicationState.values()) {
            sb.append(appState + ",");
        }
        String output = sb.toString();
        return output.substring(0, output.length() - 1);
    }

    private void listApplicationAttempts(String applicationId) throws YarnException, IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.sysout, Charset.forName("UTF-8")));
        List<ApplicationAttemptReport> appAttemptsReport = this.client.getApplicationAttempts(ApplicationId.fromString((String)applicationId));
        writer.println("Total number of application attempts :" + appAttemptsReport.size());
        writer.printf(APPLICATION_ATTEMPTS_PATTERN, "ApplicationAttempt-Id", "State", "AM-Container-Id", "Tracking-URL");
        for (ApplicationAttemptReport appAttemptReport : appAttemptsReport) {
            writer.printf(APPLICATION_ATTEMPTS_PATTERN, appAttemptReport.getApplicationAttemptId(), appAttemptReport.getYarnApplicationAttemptState(), appAttemptReport.getAMContainerId() == null ? "N/A" : appAttemptReport.getAMContainerId().toString(), appAttemptReport.getTrackingUrl());
        }
        writer.flush();
    }

    private void listContainers(String appAttemptId) throws YarnException, IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.sysout, Charset.forName("UTF-8")));
        List<ContainerReport> appsReport = this.client.getContainers(ApplicationAttemptId.fromString((String)appAttemptId));
        writer.println("Total number of containers :" + appsReport.size());
        writer.printf(CONTAINER_PATTERN, "Container-Id", "Start Time", "Finish Time", "State", "Host", "Node Http Address", "LOG-URL");
        for (ContainerReport containerReport : appsReport) {
            writer.printf(CONTAINER_PATTERN, containerReport.getContainerId(), Times.format((long)containerReport.getCreationTime()), Times.format((long)containerReport.getFinishTime()), containerReport.getContainerState(), containerReport.getAssignedNode(), containerReport.getNodeHttpAddress() == null ? "N/A" : containerReport.getNodeHttpAddress(), containerReport.getLogUrl());
        }
        writer.flush();
    }

    private void updateApplicationPriority(String applicationId, String priority) throws YarnException, IOException {
        ApplicationId appId = ApplicationId.fromString((String)applicationId);
        Priority newAppPriority = Priority.newInstance((int)Integer.parseInt(priority));
        this.sysout.println("Updating priority of an application " + applicationId);
        Priority updateApplicationPriority = this.client.updateApplicationPriority(appId, newAppPriority);
        if (newAppPriority.equals((Object)updateApplicationPriority)) {
            this.sysout.println("Successfully updated the application " + applicationId + " with priority '" + priority + "'");
        } else {
            this.sysout.println("Updated priority of an application  " + applicationId + " to cluster max priority OR keeping old priority as application is in final states");
        }
    }

    private void addApplicationOptions(Options opts) {
        opts.addOption("status", true, "Prints the status of the application. If app ID is provided, it prints the generic YARN application status. If name is provided, it prints the application specific status based on app's own implementation, and -appTypes option must be specified unless it is the default yarn-service type.");
        opts.addOption("list", false, "List applications. Supports optional use of -appTypes to filter applications based on application type, -appStates to filter applications based on application state and -appTags to filter applications based on application tag.");
        opts.addOption("movetoqueue", true, "Moves the application to a different queue. Deprecated command. Use 'changeQueue' instead.");
        opts.addOption(QUEUE_CMD, true, "Works with the movetoqueue command to specify which queue to move an application to.");
        opts.addOption("help", false, "Displays help for all commands.");
        Option appTypeOpt = new Option(APP_TYPE_CMD, true, "Works with -list to filter applications based on input comma-separated list of application types.");
        appTypeOpt.setValueSeparator(',');
        appTypeOpt.setArgs(-2);
        appTypeOpt.setArgName("Types");
        opts.addOption(appTypeOpt);
        Option appStateOpt = new Option(APP_STATE_CMD, true, "Works with -list to filter applications based on input comma-separated list of application states. " + this.getAllValidApplicationStates());
        appStateOpt.setValueSeparator(',');
        appStateOpt.setArgs(-2);
        appStateOpt.setArgName("States");
        opts.addOption(appStateOpt);
        Option appTagOpt = new Option(APP_TAG_CMD, true, "Works with -list to filter applications based on input comma-separated list of application tags.");
        appTagOpt.setValueSeparator(',');
        appTagOpt.setArgs(-2);
        appTagOpt.setArgName("Tags");
        opts.addOption(appTagOpt);
        opts.addOption(APP_ID, true, "Specify Application Id to be operated");
        opts.addOption(UPDATE_PRIORITY, true, "update priority of an application. ApplicationId can be passed using 'appId' option.");
        opts.addOption(UPDATE_LIFETIME, true, "update timeout of an application from NOW. ApplicationId can be passed using 'appId' option. Timeout value is in seconds.");
        opts.addOption(CHANGE_APPLICATION_QUEUE, true, "Moves application to a new queue. ApplicationId can be  passed using 'appId' option. 'movetoqueue' command is  deprecated, this new command 'changeQueue' performs same functionality.");
        Option killOpt = new Option("kill", true, "Kills the application. Set of applications can be provided separated with space");
        killOpt.setValueSeparator(' ');
        killOpt.setArgs(-2);
        killOpt.setArgName("Application ID");
        opts.addOption(killOpt);
        opts.getOption("movetoqueue").setArgName("Application ID");
        opts.getOption(QUEUE_CMD).setArgName("Queue Name");
        opts.getOption("status").setArgName("Application Name or ID");
        opts.getOption(APP_ID).setArgName("Application ID");
        opts.getOption(UPDATE_PRIORITY).setArgName("Priority");
        opts.getOption(UPDATE_LIFETIME).setArgName("Timeout");
        opts.getOption(CHANGE_APPLICATION_QUEUE).setArgName("Queue Name");
        opts.addOption(LAUNCH_CMD, true, "Launches application from specification file (saves specification and starts application). Options -updateLifetime and -changeQueue can be specified to alter the values provided in the file. Supports -appTypes option to specify which client implementation to use.");
        opts.addOption(STOP_CMD, true, "Stops application gracefully (may be started again later). If name is provided, appType must be provided unless it is the default yarn-service. If ID is provided, the appType will be looked up. Supports -appTypes option to specify which client implementation to use.");
        opts.addOption(START_CMD, true, "Starts a previously saved application. Supports -appTypes option to specify which client implementation to use.");
        opts.addOption(SAVE_CMD, true, "Saves specification file for an application. Options -updateLifetime and -changeQueue can be specified to alter the values provided in the file. Supports -appTypes option to specify which client implementation to use.");
        opts.addOption(DESTROY_CMD, true, "Destroys a saved application specification and removes all application data permanently. Supports -appTypes option to specify which client implementation to use.");
        opts.addOption(FLEX_CMD, true, "Changes number of running containers for a component of an application / long-running service. Requires -component option. If name is provided, appType must be provided unless it is the default yarn-service. If ID is provided, the appType will be looked up. Supports -appTypes option to specify which client implementation to use.");
        opts.addOption(DECOMMISSION, true, "Decommissions component instances for an application / long-running service. Requires -instances option. Supports -appTypes option to specify which client implementation to use.");
        opts.addOption(COMPONENT, true, "Works with -flex option to change the number of components/containers running for an application / long-running service. Supports absolute or relative changes, such as +1, 2, or -3.");
        opts.addOption(ENABLE_FAST_LAUNCH, true, "Uploads AM dependencies to HDFS to make future launches faster. Supports -appTypes option to specify which client implementation to use. Optionally a destination folder for the tarball can be specified.");
        opts.addOption(UPGRADE_CMD, true, "Upgrades an application/long-running service. It requires either -initiate, -instances, or -finalize options.");
        opts.addOption(UPGRADE_EXPRESS, true, "Works with -upgrade option to perform express upgrade.  It requires the upgraded application specification file.");
        opts.addOption(UPGRADE_INITIATE, true, "Works with -upgrade option to initiate the application upgrade. It requires the upgraded application specification file.");
        opts.addOption(COMPONENT_INSTS, true, "Works with -upgrade option to trigger the upgrade of specified component instances of the application. Also works with -decommission option to decommission specified component instances. Multiple instances should be separated by commas.");
        opts.addOption(COMPONENTS, true, "Works with -upgrade option to trigger the upgrade of specified components of the application. Multiple components should be separated by commas.");
        opts.addOption(UPGRADE_FINALIZE, false, "Works with -upgrade option to finalize the upgrade.");
        opts.addOption(UPGRADE_AUTO_FINALIZE, false, "Works with -upgrade and -initiate options to initiate the upgrade of the application with the ability to finalize the upgrade automatically.");
        opts.addOption(UPGRADE_CANCEL, false, "Works with -upgrade option to cancel current upgrade.");
        opts.addOption(CLUSTER_ID_OPTION, true, "ClusterId. By default, it will take default cluster id from the RM");
        opts.getOption(LAUNCH_CMD).setArgName("Application Name> <File Name");
        opts.getOption(LAUNCH_CMD).setArgs(2);
        opts.getOption(START_CMD).setArgName("Application Name");
        opts.getOption(STOP_CMD).setArgName("Application Name or ID");
        opts.getOption(SAVE_CMD).setArgName("Application Name> <File Name");
        opts.getOption(SAVE_CMD).setArgs(2);
        opts.getOption(DESTROY_CMD).setArgName("Application Name");
        opts.getOption(FLEX_CMD).setArgName("Application Name or ID");
        opts.getOption(COMPONENT).setArgName("Component Name> <Count");
        opts.getOption(COMPONENT).setArgs(2);
        opts.getOption(ENABLE_FAST_LAUNCH).setOptionalArg(true);
        opts.getOption(ENABLE_FAST_LAUNCH).setArgName("Destination Folder");
        opts.getOption(UPGRADE_CMD).setArgName("Application Name");
        opts.getOption(UPGRADE_CMD).setArgs(1);
        opts.getOption(UPGRADE_INITIATE).setArgName("File Name");
        opts.getOption(UPGRADE_INITIATE).setArgs(1);
        opts.getOption(COMPONENT_INSTS).setArgName("Component Instances");
        opts.getOption(COMPONENT_INSTS).setValueSeparator(',');
        opts.getOption(COMPONENT_INSTS).setArgs(-2);
        opts.getOption(COMPONENTS).setArgName("Components");
        opts.getOption(COMPONENTS).setValueSeparator(',');
        opts.getOption(COMPONENTS).setArgs(-2);
        opts.getOption(DECOMMISSION).setArgName("Application Name");
        opts.getOption(DECOMMISSION).setArgs(1);
        opts.getOption(CLUSTER_ID_OPTION).setArgName("Cluster ID");
    }

    private void addApplicationAttemptOptions(Options opts) {
        opts.addOption("status", true, "Prints the status of the application attempt.");
        opts.addOption("list", true, "List application attempts for application.");
        opts.addOption("fail", true, "Fails application attempt.");
        opts.addOption("help", false, "Displays help for all commands.");
        opts.addOption(CLUSTER_ID_OPTION, true, "ClusterId. By default, it will take default cluster id from the RM");
        opts.getOption("status").setArgName("Application Attempt ID");
        opts.getOption("list").setArgName("Application ID");
        opts.getOption("fail").setArgName("Application Attempt ID");
        opts.getOption(CLUSTER_ID_OPTION).setArgName("Cluster ID");
    }

    private void addContainerOptions(Options opts) {
        opts.addOption(SHELL_CMD, true, "Run a shell in the container.");
        opts.addOption("status", true, "Prints the status of the container.");
        opts.addOption("list", true, "List containers for application attempt when application attempt ID is provided. When application name is provided, then it finds the instances of the application based on app's own implementation, and -appTypes option must be specified unless it is the default yarn-service type. With app name, it supports optional use of -version to filter instances based on app version, -components to filter instances based on component names, -states to filter instances based on instance state.");
        opts.addOption("help", false, "Displays help for all commands.");
        opts.getOption(SHELL_CMD).setArgName("Container ID [bash|sh]");
        opts.getOption(SHELL_CMD).setArgs(3);
        opts.getOption("status").setArgName("Container ID");
        opts.getOption("list").setArgName("Application Name or Attempt ID");
        opts.addOption(APP_TYPE_CMD, true, "Works with -list to specify the app type when application name is provided.");
        opts.getOption(APP_TYPE_CMD).setValueSeparator(',');
        opts.getOption(APP_TYPE_CMD).setArgs(-2);
        opts.getOption(APP_TYPE_CMD).setArgName("Types");
        opts.addOption(VERSION, true, "Works with -list to filter instances based on input application version.");
        opts.getOption(VERSION).setArgs(1);
        opts.addOption(COMPONENTS, true, "Works with -list to filter instances based on input comma-separated list of component names.");
        opts.getOption(COMPONENTS).setValueSeparator(',');
        opts.getOption(COMPONENTS).setArgs(-2);
        opts.addOption(STATES, true, "Works with -list to filter instances based on input comma-separated list of instance states.");
        opts.getOption(STATES).setValueSeparator(',');
        opts.getOption(STATES).setArgs(-2);
        opts.addOption("signal", true, "Signal the container. The available signal commands are " + Arrays.asList(SignalContainerCommand.values()) + " Default command is OUTPUT_THREAD_DUMP.");
        opts.getOption("signal").setArgName("container ID [signal command]");
        opts.getOption("signal").setArgs(3);
        opts.addOption(CLUSTER_ID_OPTION, true, "ClusterId. By default, it will take default cluster id from the RM");
        opts.getOption(CLUSTER_ID_OPTION).setArgName("Cluster ID");
    }

    private CommandLine createCLIParser(Options opts, String[] args) throws Exception {
        CommandLine cliParser;
        try {
            cliParser = new GnuParser().parse(opts, args);
        }
        catch (MissingArgumentException ex) {
            this.sysout.println("Missing argument for options");
            cliParser = null;
        }
        if (cliParser != null) {
            String[] unparsedArgs = cliParser.getArgs();
            if (firstArg == null) {
                if (unparsedArgs.length != 1) {
                    cliParser = null;
                }
            } else if (unparsedArgs.length != 0) {
                cliParser = null;
            }
        }
        return cliParser;
    }

    private int executeStatusCommand(CommandLine cliParser, String title, Options opts) throws Exception {
        int exitCode = -1;
        if (this.hasAnyOtherCLIOptions(cliParser, opts, "status", APP_TYPE_CMD)) {
            this.printUsage(title, opts);
            return exitCode;
        }
        if (title.equalsIgnoreCase(APPLICATION) || title.equalsIgnoreCase(APP)) {
            String appIdOrName = cliParser.getOptionValue("status");
            try {
                ApplicationId.fromString((String)appIdOrName);
                exitCode = this.printApplicationReport(appIdOrName);
            }
            catch (IllegalArgumentException e) {
                AppAdminClient client = AppAdminClient.createAppAdminClient((String)ApplicationCLI.getSingleAppTypeFromCLI(cliParser), (Configuration)this.getConf());
                try {
                    this.sysout.println(client.getStatusString(appIdOrName));
                    exitCode = 0;
                }
                catch (ApplicationNotFoundException exception) {
                    System.err.println("Application with name '" + appIdOrName + "' doesn't exist in RM or Timeline Server.");
                    return -1;
                }
                catch (Exception ie) {
                    System.err.println(ie.getMessage());
                    return -1;
                }
            }
        } else if (title.equalsIgnoreCase(APPLICATION_ATTEMPT)) {
            exitCode = this.printApplicationAttemptReport(cliParser.getOptionValue("status"));
        } else if (title.equalsIgnoreCase(CONTAINER)) {
            exitCode = this.printContainerReport(cliParser.getOptionValue("status"));
        }
        return exitCode;
    }

    private int executeListCommand(CommandLine cliParser, String title, Options opts) throws Exception {
        int exitCode = -1;
        if (APPLICATION.equalsIgnoreCase(title) || APP.equalsIgnoreCase(title)) {
            String[] tags;
            String[] states;
            String[] types;
            this.allAppStates = false;
            HashSet<String> appTypes = new HashSet<String>();
            if (cliParser.hasOption(APP_TYPE_CMD) && (types = cliParser.getOptionValues(APP_TYPE_CMD)) != null) {
                for (String type : types) {
                    if (type.trim().isEmpty()) continue;
                    appTypes.add(StringUtils.toUpperCase((String)type).trim());
                }
            }
            EnumSet<YarnApplicationState> appStates = EnumSet.noneOf(YarnApplicationState.class);
            if (cliParser.hasOption(APP_STATE_CMD) && (states = cliParser.getOptionValues(APP_STATE_CMD)) != null) {
                for (String state : states) {
                    if (state.trim().isEmpty()) continue;
                    if (state.trim().equalsIgnoreCase(ALLSTATES_OPTION)) {
                        this.allAppStates = true;
                        break;
                    }
                    try {
                        appStates.add(YarnApplicationState.valueOf((String)StringUtils.toUpperCase((String)state).trim()));
                    }
                    catch (IllegalArgumentException ex) {
                        this.sysout.println("The application state " + state + " is invalid.");
                        this.sysout.println(this.getAllValidApplicationStates());
                        return exitCode;
                    }
                }
            }
            HashSet<String> appTags = new HashSet<String>();
            if (cliParser.hasOption(APP_TAG_CMD) && (tags = cliParser.getOptionValues(APP_TAG_CMD)) != null) {
                for (String tag : tags) {
                    if (tag.trim().isEmpty()) continue;
                    appTags.add(tag.trim());
                }
            }
            this.listApplications(appTypes, appStates, appTags);
        } else if (APPLICATION_ATTEMPT.equalsIgnoreCase(title)) {
            if (this.hasAnyOtherCLIOptions(cliParser, opts, "list")) {
                this.printUsage(title, opts);
                return exitCode;
            }
            this.listApplicationAttempts(cliParser.getOptionValue("list"));
        } else if (CONTAINER.equalsIgnoreCase(title)) {
            if (this.hasAnyOtherCLIOptions(cliParser, opts, "list", APP_TYPE_CMD, VERSION, COMPONENTS, STATES)) {
                this.printUsage(title, opts);
                return exitCode;
            }
            String appAttemptIdOrName = cliParser.getOptionValue("list");
            try {
                ApplicationAttemptId.fromString((String)appAttemptIdOrName);
                this.listContainers(appAttemptIdOrName);
            }
            catch (IllegalArgumentException e) {
                AppAdminClient client = AppAdminClient.createAppAdminClient((String)ApplicationCLI.getSingleAppTypeFromCLI(cliParser), (Configuration)this.getConf());
                String version = cliParser.getOptionValue(VERSION);
                String[] components = cliParser.getOptionValues(COMPONENTS);
                String[] instanceStates = cliParser.getOptionValues(STATES);
                try {
                    this.sysout.println(client.getInstances(appAttemptIdOrName, components == null ? null : Arrays.asList(components), version, instanceStates == null ? null : Arrays.asList(instanceStates)));
                    return 0;
                }
                catch (ApplicationNotFoundException exception) {
                    System.err.println("Application with name '" + appAttemptIdOrName + "' doesn't exist in RM or Timeline Server.");
                    return -1;
                }
                catch (Exception ex) {
                    System.err.println(ex.getMessage());
                    return -1;
                }
            }
        }
        return 0;
    }

    private int executeKillCommand(CommandLine cliParser, String title, Options opts) throws Exception {
        int exitCode = -1;
        if (this.hasAnyOtherCLIOptions(cliParser, opts, "kill")) {
            this.printUsage(title, opts);
            return exitCode;
        }
        return this.killApplication(cliParser.getOptionValues("kill"));
    }

    private int executeMoveToQueueCommand(CommandLine cliParser, String title, Options opts) throws Exception {
        int exitCode = -1;
        if (!cliParser.hasOption(QUEUE_CMD)) {
            this.printUsage(title, opts);
            return exitCode;
        }
        this.moveApplicationAcrossQueues(cliParser.getOptionValue("movetoqueue"), cliParser.getOptionValue(QUEUE_CMD));
        return 0;
    }

    private int executeFailCommand(CommandLine cliParser, String title, Options opts) throws Exception {
        int exitCode = -1;
        if (!title.equalsIgnoreCase(APPLICATION_ATTEMPT)) {
            this.printUsage(title, opts);
            return exitCode;
        }
        this.failApplicationAttempt(cliParser.getOptionValue("fail"));
        return 0;
    }

    private int executeUpdatePriorityCommand(CommandLine cliParser, String title, Options opts) throws Exception {
        int exitCode = -1;
        if (!cliParser.hasOption(APP_ID)) {
            this.printUsage(title, opts);
            return exitCode;
        }
        this.updateApplicationPriority(cliParser.getOptionValue(APP_ID), cliParser.getOptionValue(UPDATE_PRIORITY));
        return 0;
    }

    private int executeSignalCommand(CommandLine cliParser, String title, Options opts) throws Exception {
        int exitCode = -1;
        if (this.hasAnyOtherCLIOptions(cliParser, opts, "signal")) {
            this.printUsage(title, opts);
            return exitCode;
        }
        String[] signalArgs = cliParser.getOptionValues("signal");
        String containerId = signalArgs[0];
        SignalContainerCommand command = SignalContainerCommand.OUTPUT_THREAD_DUMP;
        if (signalArgs.length == 2) {
            command = SignalContainerCommand.valueOf((String)signalArgs[1]);
        }
        this.signalToContainer(containerId, command);
        return 0;
    }

    private int executeShellCommand(CommandLine cliParser, String title, Options opts) throws Exception {
        int exitCode = -1;
        if (this.hasAnyOtherCLIOptions(cliParser, opts, SHELL_CMD)) {
            this.printUsage(title, opts);
            return exitCode;
        }
        String[] shellArgs = cliParser.getOptionValues(SHELL_CMD);
        String containerId = shellArgs[0];
        ShellContainerCommand command = ShellContainerCommand.BASH;
        if (shellArgs.length == 2) {
            command = ShellContainerCommand.valueOf((String)shellArgs[1].toUpperCase());
        }
        this.shellToContainer(containerId, command);
        return 0;
    }

    private int executeLaunchCommand(CommandLine cliParser, String title, Options opts) throws Exception {
        int exitCode = -1;
        if (this.hasAnyOtherCLIOptions(cliParser, opts, LAUNCH_CMD, APP_TYPE_CMD, UPDATE_LIFETIME, CHANGE_APPLICATION_QUEUE)) {
            this.printUsage(title, opts);
            return exitCode;
        }
        String appType = ApplicationCLI.getSingleAppTypeFromCLI(cliParser);
        Long lifetime = null;
        if (cliParser.hasOption(UPDATE_LIFETIME)) {
            lifetime = Long.parseLong(cliParser.getOptionValue(UPDATE_LIFETIME));
        }
        String queue = null;
        if (cliParser.hasOption(CHANGE_APPLICATION_QUEUE)) {
            queue = cliParser.getOptionValue(CHANGE_APPLICATION_QUEUE);
        }
        String[] nameAndFile = cliParser.getOptionValues(LAUNCH_CMD);
        return AppAdminClient.createAppAdminClient((String)appType, (Configuration)this.getConf()).actionLaunch(nameAndFile[1], nameAndFile[0], lifetime, queue);
    }

    private int executeStopCommand(CommandLine cliParser, String title, Options opts) throws Exception {
        int exitCode = -1;
        if (this.hasAnyOtherCLIOptions(cliParser, opts, STOP_CMD, APP_TYPE_CMD)) {
            this.printUsage(title, opts);
            return exitCode;
        }
        String[] appNameAndType = this.getAppNameAndType(cliParser, STOP_CMD);
        return AppAdminClient.createAppAdminClient((String)appNameAndType[1], (Configuration)this.getConf()).actionStop(appNameAndType[0]);
    }

    private int executeStartCommand(CommandLine cliParser, String title, Options opts) throws Exception {
        int exitCode = -1;
        if (this.hasAnyOtherCLIOptions(cliParser, opts, START_CMD, APP_TYPE_CMD)) {
            this.printUsage(title, opts);
            return exitCode;
        }
        String appType = ApplicationCLI.getSingleAppTypeFromCLI(cliParser);
        return AppAdminClient.createAppAdminClient((String)appType, (Configuration)this.getConf()).actionStart(cliParser.getOptionValue(START_CMD));
    }

    private int executeSaveCommand(CommandLine cliParser, String title, Options opts) throws Exception {
        int exitCode = -1;
        if (this.hasAnyOtherCLIOptions(cliParser, opts, SAVE_CMD, APP_TYPE_CMD, UPDATE_LIFETIME, CHANGE_APPLICATION_QUEUE)) {
            this.printUsage(title, opts);
            return exitCode;
        }
        String appType = ApplicationCLI.getSingleAppTypeFromCLI(cliParser);
        Long lifetime = null;
        if (cliParser.hasOption(UPDATE_LIFETIME)) {
            lifetime = Long.parseLong(cliParser.getOptionValue(UPDATE_LIFETIME));
        }
        String queue = null;
        if (cliParser.hasOption(CHANGE_APPLICATION_QUEUE)) {
            queue = cliParser.getOptionValue(CHANGE_APPLICATION_QUEUE);
        }
        String[] nameAndFile = cliParser.getOptionValues(SAVE_CMD);
        return AppAdminClient.createAppAdminClient((String)appType, (Configuration)this.getConf()).actionSave(nameAndFile[1], nameAndFile[0], lifetime, queue);
    }

    private int executeDestroyCommand(CommandLine cliParser, String title, Options opts) throws Exception {
        int exitCode = -1;
        if (this.hasAnyOtherCLIOptions(cliParser, opts, DESTROY_CMD, APP_TYPE_CMD)) {
            this.printUsage(title, opts);
            return exitCode;
        }
        String appType = ApplicationCLI.getSingleAppTypeFromCLI(cliParser);
        return AppAdminClient.createAppAdminClient((String)appType, (Configuration)this.getConf()).actionDestroy(cliParser.getOptionValue(DESTROY_CMD));
    }

    private int executeFlexCommand(CommandLine cliParser, String title, Options opts) throws Exception {
        int exitCode = -1;
        if (!cliParser.hasOption(COMPONENT) || this.hasAnyOtherCLIOptions(cliParser, opts, FLEX_CMD, COMPONENT, APP_TYPE_CMD)) {
            this.printUsage(title, opts);
            return exitCode;
        }
        String[] rawCounts = cliParser.getOptionValues(COMPONENT);
        HashMap<String, String> counts = new HashMap<String, String>(rawCounts.length / 2);
        for (int i = 0; i < rawCounts.length - 1; i += 2) {
            counts.put(rawCounts[i], rawCounts[i + 1]);
        }
        String[] appNameAndType = this.getAppNameAndType(cliParser, FLEX_CMD);
        return AppAdminClient.createAppAdminClient((String)appNameAndType[1], (Configuration)this.getConf()).actionFlex(appNameAndType[0], counts);
    }

    private int executeEnableFastLaunchCommand(CommandLine cliParser, String title, Options opts) throws Exception {
        int exitCode = -1;
        String appType = ApplicationCLI.getSingleAppTypeFromCLI(cliParser);
        String uploadDestinationFolder = cliParser.getOptionValue(ENABLE_FAST_LAUNCH);
        if (this.hasAnyOtherCLIOptions(cliParser, opts, ENABLE_FAST_LAUNCH, APP_TYPE_CMD)) {
            this.printUsage(title, opts);
            return exitCode;
        }
        return AppAdminClient.createAppAdminClient((String)appType, (Configuration)this.getConf()).enableFastLaunch(uploadDestinationFolder);
    }

    private int executeUpdateLifeTimeCommand(CommandLine cliParser, String title, Options opts) throws Exception {
        int exitCode = -1;
        if (!cliParser.hasOption(APP_ID)) {
            this.printUsage(title, opts);
            return exitCode;
        }
        long timeoutInSec = Long.parseLong(cliParser.getOptionValue(UPDATE_LIFETIME));
        this.updateApplicationTimeout(cliParser.getOptionValue(APP_ID), ApplicationTimeoutType.LIFETIME, timeoutInSec);
        return 0;
    }

    private int executeChangeApplicationQueueCommand(CommandLine cliParser, String title, Options opts) throws Exception {
        int exitCode = -1;
        if (!cliParser.hasOption(APP_ID)) {
            this.printUsage(title, opts);
            return exitCode;
        }
        this.moveApplicationAcrossQueues(cliParser.getOptionValue(APP_ID), cliParser.getOptionValue(CHANGE_APPLICATION_QUEUE));
        return 0;
    }

    private int executeUpgradeCommand(CommandLine cliParser, String title, Options opts) throws Exception {
        int exitCode = -1;
        if (this.hasAnyOtherCLIOptions(cliParser, opts, UPGRADE_CMD, UPGRADE_EXPRESS, UPGRADE_INITIATE, UPGRADE_AUTO_FINALIZE, UPGRADE_FINALIZE, UPGRADE_CANCEL, COMPONENT_INSTS, COMPONENTS, APP_TYPE_CMD)) {
            this.printUsage(title, opts);
            return exitCode;
        }
        String appType = ApplicationCLI.getSingleAppTypeFromCLI(cliParser);
        AppAdminClient client = AppAdminClient.createAppAdminClient((String)appType, (Configuration)this.getConf());
        String appName = cliParser.getOptionValue(UPGRADE_CMD);
        if (cliParser.hasOption(UPGRADE_EXPRESS)) {
            File file = new File(cliParser.getOptionValue(UPGRADE_EXPRESS));
            if (!file.exists()) {
                System.err.println(file.getAbsolutePath() + " does not exist.");
                return exitCode;
            }
            return client.actionUpgradeExpress(appName, file);
        }
        if (cliParser.hasOption(UPGRADE_INITIATE)) {
            if (this.hasAnyOtherCLIOptions(cliParser, opts, UPGRADE_CMD, UPGRADE_INITIATE, UPGRADE_AUTO_FINALIZE, APP_TYPE_CMD)) {
                this.printUsage(title, opts);
                return exitCode;
            }
            String fileName = cliParser.getOptionValue(UPGRADE_INITIATE);
            if (cliParser.hasOption(UPGRADE_AUTO_FINALIZE)) {
                return client.initiateUpgrade(appName, fileName, true);
            }
            return client.initiateUpgrade(appName, fileName, false);
        }
        if (cliParser.hasOption(COMPONENT_INSTS)) {
            if (this.hasAnyOtherCLIOptions(cliParser, opts, UPGRADE_CMD, COMPONENT_INSTS, APP_TYPE_CMD)) {
                this.printUsage(title, opts);
                return exitCode;
            }
            String[] instances = cliParser.getOptionValues(COMPONENT_INSTS);
            return client.actionUpgradeInstances(appName, Arrays.asList(instances));
        }
        if (cliParser.hasOption(COMPONENTS)) {
            if (this.hasAnyOtherCLIOptions(cliParser, opts, UPGRADE_CMD, COMPONENTS, APP_TYPE_CMD)) {
                this.printUsage(title, opts);
                return exitCode;
            }
            String[] components = cliParser.getOptionValues(COMPONENTS);
            return client.actionUpgradeComponents(appName, Arrays.asList(components));
        }
        if (cliParser.hasOption(UPGRADE_FINALIZE)) {
            if (this.hasAnyOtherCLIOptions(cliParser, opts, UPGRADE_CMD, UPGRADE_FINALIZE, APP_TYPE_CMD)) {
                this.printUsage(title, opts);
                return exitCode;
            }
            return client.actionStart(appName);
        }
        if (cliParser.hasOption(UPGRADE_CANCEL)) {
            if (this.hasAnyOtherCLIOptions(cliParser, opts, UPGRADE_CMD, UPGRADE_CANCEL, APP_TYPE_CMD)) {
                this.printUsage(title, opts);
                return exitCode;
            }
            return client.actionCancelUpgrade(appName);
        }
        return 0;
    }

    private int executeDecommissionCommand(CommandLine cliParser, String title, Options opts) throws Exception {
        int exitCode = -1;
        if (!cliParser.hasOption(COMPONENT_INSTS) || this.hasAnyOtherCLIOptions(cliParser, opts, DECOMMISSION, COMPONENT_INSTS, APP_TYPE_CMD)) {
            this.printUsage(title, opts);
            return exitCode;
        }
        String[] instances = cliParser.getOptionValues(COMPONENT_INSTS);
        String[] appNameAndType = this.getAppNameAndType(cliParser, DECOMMISSION);
        return AppAdminClient.createAppAdminClient((String)appNameAndType[1], (Configuration)this.getConf()).actionDecommissionInstances(appNameAndType[0], Arrays.asList(instances));
    }

    private boolean hasAnyOtherCLIOptions(CommandLine cliParser, Options opts, String ... excludeOptions) {
        Collection ops = opts.getOptions();
        HashSet<String> excludeSet = new HashSet<String>(Arrays.asList(excludeOptions));
        for (Option op : ops) {
            if (excludeSet.contains(op.getOpt()) || !cliParser.hasOption(op.getOpt())) continue;
            return true;
        }
        return false;
    }
}

