/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.ha.HAAdmin;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.util.FormattingCLIUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeregisterSubClusterRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeregisterSubClusterResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.FederationQueueWeight;
import org.apache.hadoop.yarn.server.api.protocolrecords.SaveFederationQueuePolicyRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.SaveFederationQueuePolicyResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterCLI
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(RouterCLI.class);
    protected static final Map<String, HAAdmin.UsageInfo> ADMIN_USAGE = ImmutableMap.builder().put((Object)"-deregisterSubCluster", (Object)new HAAdmin.UsageInfo("[-sc|--subClusterId [subCluster Id]]", "Deregister SubCluster, If the interval between the heartbeat time of the subCluster and the current time exceeds the timeout period, set the state of the subCluster to SC_LOST.")).put((Object)"-policy", (Object)new HAAdmin.UsageInfo("[-s|--save [queue;router weight;amrm weight;headroomalpha]]", "We provide a set of commands for Policy: Include list policies, save policies, batch save policies.  (Note: The policy type will be directly read from the yarn.federation.policy-manager in the local yarn-site.xml.) eg. (routeradmin -policy [-s|--save] root.a;SC-1:0.7,SC-2:0.3;SC-1:0.7,SC-2:0.3;1.0)")).build();
    private static final String SEMICOLON = ";";
    private static final String CMD_EMPTY = "";
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_ERROR = -1;
    private static final String DEREGISTER_SUBCLUSTER_TITLE = "Yarn Federation Deregister SubCluster";
    private static final List<String> DEREGISTER_SUBCLUSTER_HEADER = Arrays.asList("SubCluster Id", "Deregister State", "Last HeartBeatTime", "Information", "SubCluster State");
    private static final String OPTION_SC = "sc";
    private static final String OPTION_SUBCLUSTERID = "subClusterId";
    private static final String CMD_DEREGISTERSUBCLUSTER = "-deregisterSubCluster";
    private static final String CMD_HELP = "-help";
    private static final String OPTION_S = "s";
    private static final String OPTION_SAVE = "save";
    private static final String CMD_POLICY = "-policy";

    public RouterCLI() {
    }

    public RouterCLI(Configuration conf) {
        super(conf);
    }

    private static void buildHelpMsg(String cmd, StringBuilder builder) {
        HAAdmin.UsageInfo usageInfo = ADMIN_USAGE.get(cmd);
        if (usageInfo == null) {
            return;
        }
        if (usageInfo.args != null) {
            String space = usageInfo.args == CMD_EMPTY ? CMD_EMPTY : " ";
            builder.append("   ").append(cmd).append(space).append(usageInfo.args).append(": ").append(usageInfo.help);
        } else {
            builder.append("   ").append(cmd).append(": ").append(usageInfo.help);
        }
    }

    private static void buildIndividualUsageMsg(String cmd, StringBuilder builder) {
        HAAdmin.UsageInfo usageInfo = ADMIN_USAGE.get(cmd);
        if (usageInfo == null) {
            return;
        }
        if (usageInfo.args == null) {
            builder.append("Usage: routeradmin [").append(cmd).append("]\n");
        } else {
            String space = usageInfo.args == CMD_EMPTY ? CMD_EMPTY : " ";
            builder.append("Usage: routeradmin [").append(cmd).append(space).append(usageInfo.args).append("]\n");
        }
    }

    private static void printHelp() {
        StringBuilder summary = new StringBuilder();
        summary.append("routeradmin is the command to execute ").append("YARN Federation administrative commands.\n").append("The full syntax is: \n\n").append("routeradmin\n").append("   [-deregisterSubCluster [-sc|--subClusterId [subCluster Id]]\n").append("   [-policy [-s|--save [queue;router weight;amrm weight;headroomalpha]]\n").append("   [-help [cmd]]").append("\n");
        StringBuilder helpBuilder = new StringBuilder();
        System.out.println(summary);
        for (String cmdKey : ADMIN_USAGE.keySet()) {
            RouterCLI.buildHelpMsg(cmdKey, helpBuilder);
            helpBuilder.append("\n");
        }
        helpBuilder.append("   -help [cmd]: Displays help for the given command or all commands").append(" if none is specified.");
        System.out.println(helpBuilder);
        System.out.println();
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
    }

    protected ResourceManagerAdministrationProtocol createAdminProtocol() throws IOException {
        YarnConfiguration conf = new YarnConfiguration(this.getConf());
        return (ResourceManagerAdministrationProtocol)ClientRMProxy.createRMProxy((Configuration)conf, ResourceManagerAdministrationProtocol.class);
    }

    private static void buildUsageMsg(StringBuilder builder) {
        builder.append("routeradmin is only used in Yarn Federation Mode.\n");
        builder.append("Usage: routeradmin\n");
        for (Map.Entry<String, HAAdmin.UsageInfo> cmdEntry : ADMIN_USAGE.entrySet()) {
            HAAdmin.UsageInfo usageInfo = cmdEntry.getValue();
            builder.append("   ").append(cmdEntry.getKey()).append(" ").append(usageInfo.args).append("\n");
        }
        builder.append("   -help [cmd]\n");
    }

    private static void printUsage(String cmd) {
        StringBuilder usageBuilder = new StringBuilder();
        if (ADMIN_USAGE.containsKey(cmd)) {
            RouterCLI.buildIndividualUsageMsg(cmd, usageBuilder);
        } else {
            RouterCLI.buildUsageMsg(usageBuilder);
        }
        System.err.println(usageBuilder);
        ToolRunner.printGenericCommandUsage((PrintStream)System.err);
    }

    private int handleDeregisterSubCluster(String[] args) throws IOException, YarnException, ParseException {
        CommandLine cliParser;
        Options opts = new Options();
        opts.addOption("deregisterSubCluster", false, "Deregister YARN subCluster, if subCluster Heartbeat Timeout.");
        Option subClusterOpt = new Option(OPTION_SC, OPTION_SUBCLUSTERID, true, "The subCluster can be specified using either the '-sc' or '--subCluster' option.  If the subCluster's Heartbeat Timeout, it will be marked as 'SC_LOST'.");
        subClusterOpt.setOptionalArg(true);
        opts.addOption(subClusterOpt);
        try {
            cliParser = new GnuParser().parse(opts, args);
        }
        catch (MissingArgumentException ex) {
            System.out.println("Missing argument for options");
            RouterCLI.printUsage(args[0]);
            return -1;
        }
        String subClusterId = null;
        if ((cliParser.hasOption(OPTION_SC) || cliParser.hasOption(OPTION_SUBCLUSTERID)) && (subClusterId = cliParser.getOptionValue(OPTION_SC)) == null) {
            subClusterId = cliParser.getOptionValue(OPTION_SUBCLUSTERID);
        }
        if (StringUtils.isNotBlank((CharSequence)subClusterId)) {
            return this.deregisterSubCluster(subClusterId);
        }
        return this.deregisterSubCluster();
    }

    private int deregisterSubCluster(String subClusterId) throws IOException, YarnException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, Charset.forName(StandardCharsets.UTF_8.name())));
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        DeregisterSubClusterRequest request = DeregisterSubClusterRequest.newInstance((String)subClusterId);
        DeregisterSubClusterResponse response = adminProtocol.deregisterSubCluster(request);
        FormattingCLIUtils formattingCLIUtils = new FormattingCLIUtils(DEREGISTER_SUBCLUSTER_TITLE).addHeaders(DEREGISTER_SUBCLUSTER_HEADER);
        List deregisterSubClusters = response.getDeregisterSubClusters();
        deregisterSubClusters.forEach(deregisterSubCluster -> {
            String responseSubClusterId = deregisterSubCluster.getSubClusterId();
            String deregisterState = deregisterSubCluster.getDeregisterState();
            String lastHeartBeatTime = deregisterSubCluster.getLastHeartBeatTime();
            String info = deregisterSubCluster.getInformation();
            String subClusterState = deregisterSubCluster.getSubClusterState();
            formattingCLIUtils.addLine(responseSubClusterId, deregisterState, lastHeartBeatTime, info, subClusterState);
        });
        writer.print(formattingCLIUtils.render());
        writer.flush();
        return 0;
    }

    private int deregisterSubCluster() throws IOException, YarnException {
        this.deregisterSubCluster(CMD_EMPTY);
        return 0;
    }

    private int handlePolicy(String[] args) throws IOException, YarnException, ParseException {
        CommandLine cliParser;
        Options opts = new Options();
        opts.addOption("policy", false, "We provide a set of commands for Policy Include list policies, save policies, batch save policies.");
        Option saveOpt = new Option(OPTION_S, OPTION_SAVE, true, "We will save the policy information of the queue, including queue and weight information");
        saveOpt.setOptionalArg(true);
        opts.addOption(saveOpt);
        try {
            cliParser = new GnuParser().parse(opts, args);
        }
        catch (MissingArgumentException ex) {
            System.out.println("Missing argument for options");
            RouterCLI.printUsage(args[0]);
            return -1;
        }
        if (cliParser.hasOption(OPTION_S) || cliParser.hasOption(OPTION_SAVE)) {
            String policy = cliParser.getOptionValue(OPTION_S);
            if (StringUtils.isBlank((CharSequence)policy)) {
                policy = cliParser.getOptionValue(OPTION_SAVE);
            }
            return this.handleSavePolicy(policy);
        }
        return -1;
    }

    private int handleSavePolicy(String policy) {
        LOG.info("Save Federation Policy = {}.", (Object)policy);
        try {
            SaveFederationQueuePolicyRequest request = this.parsePolicy(policy);
            ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
            SaveFederationQueuePolicyResponse response = adminProtocol.saveFederationQueuePolicy(request);
            System.out.println(response.getMessage());
            return 0;
        }
        catch (IOException | YarnException e) {
            LOG.error("handleSavePolicy error.", e);
            return -1;
        }
    }

    protected SaveFederationQueuePolicyRequest parsePolicy(String policy) throws YarnException {
        String[] policyItems = policy.split(SEMICOLON);
        if (policyItems == null || policyItems.length != 4) {
            throw new YarnException("The policy cannot be empty or the policy is incorrect. \n Required information to provide: queue,router weight,amrm weight,headroomalpha \n eg. root.a;SC-1:0.7,SC-2:0.3;SC-1:0.7,SC-2:0.3;1.0");
        }
        String queue = policyItems[0];
        String routerWeight = policyItems[1];
        String amrmWeight = policyItems[2];
        String headroomalpha = policyItems[3];
        LOG.info("Policy: [Queue = {}, RouterWeight = {}, AmRmWeight = {}, Headroomalpha = {}]", new Object[]{queue, routerWeight, amrmWeight, headroomalpha});
        FederationQueueWeight.checkSubClusterQueueWeightRatioValid((String)routerWeight);
        FederationQueueWeight.checkSubClusterQueueWeightRatioValid((String)amrmWeight);
        FederationQueueWeight.checkHeadRoomAlphaValid((String)headroomalpha);
        FederationQueueWeight federationQueueWeight = FederationQueueWeight.newInstance((String)routerWeight, (String)amrmWeight, (String)headroomalpha);
        String policyManager = this.getConf().get("yarn.federation.policy-manager", "org.apache.hadoop.yarn.server.federation.policies.manager.UniformBroadcastPolicyManager");
        SaveFederationQueuePolicyRequest request = SaveFederationQueuePolicyRequest.newInstance((String)queue, (FederationQueueWeight)federationQueueWeight, (String)policyManager);
        return request;
    }

    public int run(String[] args) throws Exception {
        YarnConfiguration yarnConf = this.getConf() == null ? new YarnConfiguration() : new YarnConfiguration(this.getConf());
        boolean isFederationEnabled = yarnConf.getBoolean("yarn.federation.enabled", false);
        if (args.length < 1 || !isFederationEnabled) {
            RouterCLI.printUsage(CMD_EMPTY);
            return -1;
        }
        String cmd = args[0];
        if (CMD_HELP.equals(cmd)) {
            if (args.length > 1) {
                RouterCLI.printUsage(args[1]);
            } else {
                RouterCLI.printHelp();
            }
            return 0;
        }
        if (CMD_DEREGISTERSUBCLUSTER.equals(cmd)) {
            return this.handleDeregisterSubCluster(args);
        }
        if (CMD_POLICY.equals(cmd)) {
            return this.handlePolicy(args);
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run((Tool)new RouterCLI(), (String[])args);
        System.exit(result);
    }
}

