/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.TestRPC;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.IncreaseContainersResourceRequest;
import org.apache.hadoop.yarn.api.protocolrecords.IncreaseContainersResourceResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.HadoopYarnProtoRPC;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.junit.Assert;
import org.junit.Test;

public class TestContainerResourceIncreaseRPC {
    static final Log LOG = LogFactory.getLog(TestContainerResourceIncreaseRPC.class);

    @Test
    public void testHadoopProtoRPCTimeout() throws Exception {
        this.testRPCTimeout(HadoopYarnProtoRPC.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRPCTimeout(String rpcClass) throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("yarn.rpc.nm-command-timeout", 3000);
        conf.set("yarn.ipc.rpc.class", rpcClass);
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        String bindAddr = "localhost:0";
        InetSocketAddress addr = NetUtils.createSocketAddr((String)bindAddr);
        Server server = rpc.getServer(ContainerManagementProtocol.class, (Object)new DummyContainerManager(), addr, conf, null, 1);
        server.start();
        try {
            ContainerManagementProtocol proxy = (ContainerManagementProtocol)rpc.getProxy(ContainerManagementProtocol.class, server.getListenerAddress(), conf);
            ApplicationId applicationId = ApplicationId.newInstance((long)0L, (int)0);
            ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)0);
            ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)applicationAttemptId, (long)100L);
            NodeId nodeId = NodeId.newInstance((String)"localhost", (int)1234);
            Resource resource = Resource.newInstance((int)1234, (int)2);
            ContainerTokenIdentifier containerTokenIdentifier = new ContainerTokenIdentifier(containerId, "localhost", "user", resource, System.currentTimeMillis() + 10000L, 42, 42L, Priority.newInstance((int)0), 0L);
            Token containerToken = TestRPC.newContainerToken(nodeId, "password".getBytes(), containerTokenIdentifier);
            ArrayList<Token> increaseTokens = new ArrayList<Token>();
            increaseTokens.add(containerToken);
            IncreaseContainersResourceRequest increaseRequest = IncreaseContainersResourceRequest.newInstance(increaseTokens);
            try {
                proxy.increaseContainersResource(increaseRequest);
            }
            catch (Exception e) {
                LOG.info((Object)StringUtils.stringifyException((Throwable)e));
                Assert.assertEquals((String)("Error, exception is not: " + SocketTimeoutException.class.getName()), (Object)SocketTimeoutException.class.getName(), (Object)e.getClass().getName());
                server.stop();
                return;
            }
        }
        finally {
            server.stop();
        }
        Assert.fail((String)"timeout exception should have occurred!");
    }

    public class DummyContainerManager
    implements ContainerManagementProtocol {
        public StartContainersResponse startContainers(StartContainersRequest requests) throws YarnException, IOException {
            Exception e = new Exception("Dummy function", new Exception("Dummy function cause"));
            throw new YarnException((Throwable)e);
        }

        public StopContainersResponse stopContainers(StopContainersRequest requests) throws YarnException, IOException {
            Exception e = new Exception("Dummy function", new Exception("Dummy function cause"));
            throw new YarnException((Throwable)e);
        }

        public GetContainerStatusesResponse getContainerStatuses(GetContainerStatusesRequest request) throws YarnException, IOException {
            Exception e = new Exception("Dummy function", new Exception("Dummy function cause"));
            throw new YarnException((Throwable)e);
        }

        public IncreaseContainersResourceResponse increaseContainersResource(IncreaseContainersResourceRequest request) throws YarnException, IOException {
            try {
                Thread.sleep(10000L);
            }
            catch (Exception e) {
                LOG.error((Object)e);
                throw new YarnException((Throwable)e);
            }
            throw new YarnException("Shouldn't happen!!");
        }
    }
}

