/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;

public class TestResources {
    public Resource createResource(int memory, int vCores) {
        return Resource.newInstance((int)memory, (int)vCores);
    }

    @Test(timeout=1000L)
    public void testCompareToWithUnboundedResource() {
        Assert.assertTrue((Resources.unbounded().compareTo((Object)this.createResource(Integer.MAX_VALUE, Integer.MAX_VALUE)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Resources.unbounded().compareTo((Object)this.createResource(Integer.MAX_VALUE, 0)) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((Resources.unbounded().compareTo((Object)this.createResource(0, Integer.MAX_VALUE)) > 0 ? 1 : 0) != 0);
    }

    @Test(timeout=1000L)
    public void testCompareToWithNoneResource() {
        Assert.assertTrue((Resources.none().compareTo((Object)this.createResource(0, 0)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Resources.none().compareTo((Object)this.createResource(1, 0)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((Resources.none().compareTo((Object)this.createResource(0, 1)) < 0 ? 1 : 0) != 0);
    }
}

