/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.operations;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.AbstractRegistryTest;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.binding.RegistryTypeUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.exceptions.NoRecordException;
import org.apache.hadoop.registry.client.types.RegistryPathStatus;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestRegistryOperations
extends AbstractRegistryTest {
    protected static final Logger LOG = LoggerFactory.getLogger(TestRegistryOperations.class);

    @Test
    public void testPutGetServiceEntry() throws Throwable {
        ServiceRecord written = this.putExampleServiceEntry("/users/devteam/org-apache-hadoop/hdfs", 0, "application");
        ServiceRecord resolved = this.operations.resolve("/users/devteam/org-apache-hadoop/hdfs");
        TestRegistryOperations.validateEntry((ServiceRecord)resolved);
        TestRegistryOperations.assertMatches((ServiceRecord)written, (ServiceRecord)resolved);
    }

    @Test
    public void testDeleteServiceEntry() throws Throwable {
        this.putExampleServiceEntry("/users/devteam/org-apache-hadoop/hdfs", 0);
        this.operations.delete("/users/devteam/org-apache-hadoop/hdfs", false);
    }

    @Test
    public void testDeleteNonexistentEntry() throws Throwable {
        this.operations.delete("/users/devteam/org-apache-hadoop/hdfs", false);
        this.operations.delete("/users/devteam/org-apache-hadoop/hdfs", true);
    }

    @Test
    public void testStat() throws Throwable {
        this.putExampleServiceEntry("/users/devteam/org-apache-hadoop/hdfs", 0);
        RegistryPathStatus stat = this.operations.stat("/users/devteam/org-apache-hadoop/hdfs");
        TestRegistryOperations.assertTrue((stat.size > 0L ? 1 : 0) != 0);
        TestRegistryOperations.assertTrue((stat.time > 0L ? 1 : 0) != 0);
        TestRegistryOperations.assertEquals((Object)"hdfs", (Object)stat.path);
    }

    @Test
    public void testLsParent() throws Throwable {
        ServiceRecord written = this.putExampleServiceEntry("/users/devteam/org-apache-hadoop/hdfs", 0);
        RegistryPathStatus stat = this.operations.stat("/users/devteam/org-apache-hadoop/hdfs");
        List children = this.operations.list("/users/devteam/org-apache-hadoop/");
        TestRegistryOperations.assertEquals((long)1L, (long)children.size());
        TestRegistryOperations.assertEquals((Object)"hdfs", children.get(0));
        Map childStats = RegistryUtils.statChildren((RegistryOperations)this.operations, (String)"/users/devteam/org-apache-hadoop/");
        TestRegistryOperations.assertEquals((long)1L, (long)childStats.size());
        TestRegistryOperations.assertEquals((Object)stat, childStats.get("hdfs"));
        Map records = RegistryUtils.extractServiceRecords((RegistryOperations)this.operations, (String)"/users/devteam/org-apache-hadoop/", childStats.values());
        TestRegistryOperations.assertEquals((long)1L, (long)records.size());
        ServiceRecord record = (ServiceRecord)records.get("/users/devteam/org-apache-hadoop/hdfs");
        RegistryTypeUtils.validateServiceRecord((String)"/users/devteam/org-apache-hadoop/hdfs", (ServiceRecord)record);
        TestRegistryOperations.assertMatches((ServiceRecord)written, (ServiceRecord)record);
    }

    @Test
    public void testDeleteNonEmpty() throws Throwable {
        this.putExampleServiceEntry("/users/devteam/org-apache-hadoop/hdfs", 0);
        try {
            this.operations.delete("/users/devteam/org-apache-hadoop/", false);
            TestRegistryOperations.fail((String)"Expected a failure");
        }
        catch (PathIsNotEmptyDirectoryException pathIsNotEmptyDirectoryException) {
            // empty catch block
        }
        this.operations.delete("/users/devteam/org-apache-hadoop/", true);
    }

    @Test(expected=PathNotFoundException.class)
    public void testStatEmptyPath() throws Throwable {
        this.operations.stat("/users/devteam/org-apache-hadoop/hdfs");
    }

    @Test(expected=PathNotFoundException.class)
    public void testLsEmptyPath() throws Throwable {
        this.operations.list("/users/devteam/org-apache-hadoop/");
    }

    @Test(expected=PathNotFoundException.class)
    public void testResolveEmptyPath() throws Throwable {
        this.operations.resolve("/users/devteam/org-apache-hadoop/hdfs");
    }

    @Test
    public void testMkdirNoParent() throws Throwable {
        String path = "/users/devteam/org-apache-hadoop/hdfs/missing";
        try {
            this.operations.mknode(path, false);
            RegistryPathStatus stat = this.operations.stat(path);
            TestRegistryOperations.fail((String)("Got a status " + stat));
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testDoubleMkdir() throws Throwable {
        this.operations.mknode("/users/devteam/", false);
        String path = "/users/devteam/newentry";
        TestRegistryOperations.assertTrue((boolean)this.operations.mknode(path, false));
        this.operations.stat(path);
        TestRegistryOperations.assertFalse((boolean)this.operations.mknode(path, false));
    }

    @Test
    public void testPutNoParent() throws Throwable {
        ServiceRecord record = new ServiceRecord();
        record.set("yarn:id", (Object)"testPutNoParent");
        String path = "/path/without/parent";
        try {
            this.operations.bind(path, record, 0);
            RegistryPathStatus stat = this.operations.stat(path);
            TestRegistryOperations.fail((String)("Got a status " + stat));
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testPutMinimalRecord() throws Throwable {
        String path = "/path/with/minimal";
        this.operations.mknode(path, true);
        ServiceRecord record = new ServiceRecord();
        this.operations.bind(path, record, 1);
        ServiceRecord resolve = this.operations.resolve(path);
        TestRegistryOperations.assertMatches((ServiceRecord)record, (ServiceRecord)resolve);
    }

    @Test(expected=PathNotFoundException.class)
    public void testPutNoParent2() throws Throwable {
        ServiceRecord record = new ServiceRecord();
        record.set("yarn:id", (Object)"testPutNoParent");
        String path = "/path/without/parent";
        this.operations.bind(path, record, 0);
    }

    @Test
    public void testStatDirectory() throws Throwable {
        String empty = "/empty";
        this.operations.mknode(empty, false);
        this.operations.stat(empty);
    }

    @Test
    public void testStatRootPath() throws Throwable {
        this.operations.mknode("/", false);
        this.operations.stat("/");
        this.operations.list("/");
        this.operations.list("/");
    }

    @Test
    public void testStatOneLevelDown() throws Throwable {
        this.operations.mknode("/subdir", true);
        this.operations.stat("/subdir");
    }

    @Test
    public void testLsRootPath() throws Throwable {
        String empty = "/";
        this.operations.mknode(empty, false);
        this.operations.stat(empty);
    }

    @Test
    public void testResolvePathThatHasNoEntry() throws Throwable {
        String empty = "/empty2";
        this.operations.mknode(empty, false);
        try {
            ServiceRecord record = this.operations.resolve(empty);
            TestRegistryOperations.fail((String)("expected an exception, got " + record));
        }
        catch (NoRecordException noRecordException) {
            // empty catch block
        }
    }

    @Test
    public void testOverwrite() throws Throwable {
        ServiceRecord written = this.putExampleServiceEntry("/users/devteam/org-apache-hadoop/hdfs", 0);
        ServiceRecord resolved1 = this.operations.resolve("/users/devteam/org-apache-hadoop/hdfs");
        resolved1.description = "resolved1";
        try {
            this.operations.bind("/users/devteam/org-apache-hadoop/hdfs", resolved1, 0);
            TestRegistryOperations.fail((String)"overwrite succeeded when it should have failed");
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        ServiceRecord resolved2 = this.operations.resolve("/users/devteam/org-apache-hadoop/hdfs");
        TestRegistryOperations.assertMatches((ServiceRecord)written, (ServiceRecord)resolved2);
        this.operations.bind("/users/devteam/org-apache-hadoop/hdfs", resolved1, 1);
        ServiceRecord resolved3 = this.operations.resolve("/users/devteam/org-apache-hadoop/hdfs");
        TestRegistryOperations.assertMatches((ServiceRecord)resolved1, (ServiceRecord)resolved3);
    }

    @Test
    public void testPutGetContainerPersistenceServiceEntry() throws Throwable {
        String path = "/users/devteam/org-apache-hadoop/hdfs";
        ServiceRecord written = TestRegistryOperations.buildExampleServiceEntry((String)"container");
        this.operations.mknode(RegistryPathUtils.parentOf((String)path), true);
        this.operations.bind(path, written, 0);
        ServiceRecord resolved = this.operations.resolve(path);
        TestRegistryOperations.validateEntry((ServiceRecord)resolved);
        TestRegistryOperations.assertMatches((ServiceRecord)written, (ServiceRecord)resolved);
    }

    @Test
    public void testAddingWriteAccessIsNoOpEntry() throws Throwable {
        TestRegistryOperations.assertFalse((boolean)this.operations.addWriteAccessor("id", "pass"));
        this.operations.clearWriteAccessors();
    }

    @Test
    public void testListListFully() throws Throwable {
        ServiceRecord r1 = new ServiceRecord();
        ServiceRecord r2 = TestRegistryOperations.createRecord((String)"i", (String)"permanent", (String)"r2");
        String path = "/users/devteam/org-apache-hadoop/listing";
        this.operations.mknode(path, true);
        String r1path = path + "/r1";
        this.operations.bind(r1path, r1, 0);
        String r2path = path + "/r2";
        this.operations.bind(r2path, r2, 0);
        RegistryPathStatus r1stat = this.operations.stat(r1path);
        TestRegistryOperations.assertEquals((Object)"r1", (Object)r1stat.path);
        RegistryPathStatus r2stat = this.operations.stat(r2path);
        TestRegistryOperations.assertEquals((Object)"r2", (Object)r2stat.path);
        TestRegistryOperations.assertNotEquals((Object)r1stat, (Object)r2stat);
        List list = this.operations.list(path);
        TestRegistryOperations.assertEquals((String)"Wrong no. of children", (long)2L, (long)list.size());
        HashMap<String, String> names = new HashMap<String, String>();
        String entries = "";
        for (String child : list) {
            names.put(child, child);
            entries = entries + child + " ";
        }
        TestRegistryOperations.assertTrue((String)("No 'r1' in " + entries), (boolean)names.containsKey("r1"));
        TestRegistryOperations.assertTrue((String)("No 'r2' in " + entries), (boolean)names.containsKey("r2"));
        Map stats = RegistryUtils.statChildren((RegistryOperations)this.operations, (String)path);
        TestRegistryOperations.assertEquals((String)"Wrong no. of children", (long)2L, (long)stats.size());
        TestRegistryOperations.assertEquals((Object)r1stat, stats.get("r1"));
        TestRegistryOperations.assertEquals((Object)r2stat, stats.get("r2"));
    }

    @Test
    public void testComplexUsernames() throws Throwable {
        this.operations.mknode("/users/user with spaces", true);
        this.operations.mknode("/users/user-with_underscores", true);
        this.operations.mknode("/users/000000", true);
        this.operations.mknode("/users/-storm", true);
        this.operations.mknode("/users/windows\\ user", true);
        String home = RegistryUtils.homePathForUser((String)"\u0413PA\u0414_3");
        this.operations.mknode(home, true);
        this.operations.mknode(RegistryUtils.servicePath((String)home, (String)"service.class", (String)"service 4_5"), true);
        this.operations.mknode(RegistryUtils.homePathForUser((String)"hbase@HADOOP.APACHE.ORG"), true);
        this.operations.mknode(RegistryUtils.homePathForUser((String)"hbase/localhost@HADOOP.APACHE.ORG"), true);
        home = RegistryUtils.homePathForUser((String)"ADMINISTRATOR/127.0.0.1");
        TestRegistryOperations.assertTrue((String)("No 'administrator' in " + home), (boolean)home.contains("administrator"));
        this.operations.mknode(home, true);
    }
}

