/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.server.services;

import com.google.common.annotations.VisibleForTesting;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.exceptions.InvalidRecordException;
import org.apache.hadoop.registry.client.exceptions.NoPathPermissionsException;
import org.apache.hadoop.registry.client.exceptions.NoRecordException;
import org.apache.hadoop.registry.client.impl.zk.RegistryBindingSource;
import org.apache.hadoop.registry.client.impl.zk.RegistryOperationsService;
import org.apache.hadoop.registry.client.impl.zk.RegistrySecurity;
import org.apache.hadoop.registry.client.types.RegistryPathStatus;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.registry.server.services.RegistryAdminService;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryAdminService
extends RegistryOperationsService {
    private static final Logger LOG = LoggerFactory.getLogger(RegistryAdminService.class);
    public static final int USER_HOMEDIR_ACL_PERMISSIONS = 15;
    protected final ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);

    public RegistryAdminService(String name) {
        this(name, null);
    }

    public RegistryAdminService(String name, RegistryBindingSource bindingSource) {
        super(name, bindingSource);
    }

    protected void serviceStop() throws Exception {
        this.stopExecutor();
        super.serviceStop();
    }

    protected synchronized void stopExecutor() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    protected ExecutorService getExecutor() {
        return this.executor;
    }

    public <V> Future<V> submit(Callable<V> callable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Submitting {}", callable);
        }
        return this.getExecutor().submit(callable);
    }

    public Future<Boolean> createDirAsync(String path, List<ACL> acls, boolean createParents) throws IOException {
        return this.submit((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        RegistrySecurity registrySecurity = this.getRegistrySecurity();
        if (registrySecurity.isSecureRegistry()) {
            ACL sasl = registrySecurity.createSaslACLFromCurrentUser(31);
            registrySecurity.addSystemACL(sasl);
            LOG.info("Registry System ACLs:", (Object)RegistrySecurity.aclsToString((List)registrySecurity.getSystemACLs()));
        }
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        try {
            this.createRootRegistryPaths();
        }
        catch (NoPathPermissionsException e) {
            String message = String.format(Locale.ENGLISH, "Failed to create root paths {%s};%ndiagnostics={%s}%ncurrent registry is:%n{%s}", new Object[]{e, this.bindingDiagnosticDetails(), this.dumpRegistryRobustly(true)});
            LOG.error(" Failure {}", (Object)e, (Object)e);
            LOG.error(message);
            throw new NoPathPermissionsException(e.getPath().toString(), message, (Throwable)e);
        }
    }

    @VisibleForTesting
    public void createRootRegistryPaths() throws IOException {
        List systemACLs = this.getRegistrySecurity().getSystemACLs();
        LOG.info("System ACLs {}", (Object)RegistrySecurity.aclsToString((List)systemACLs));
        this.maybeCreate("", CreateMode.PERSISTENT, systemACLs, false);
        this.maybeCreate("/users/", CreateMode.PERSISTENT, systemACLs, false);
        this.maybeCreate("/services/", CreateMode.PERSISTENT, systemACLs, false);
    }

    protected String homeDir(String username) {
        return RegistryUtils.homePathForUser((String)username);
    }

    public List<ACL> aclsForUser(String username, int perms) throws IOException {
        List clientACLs = this.getClientAcls();
        RegistrySecurity security = this.getRegistrySecurity();
        if (security.isSecureRegistry()) {
            clientACLs.add(security.createACLfromUsername(username, perms));
        }
        return clientACLs;
    }

    public Future<Boolean> initUserRegistryAsync(String shortname) throws IOException {
        String homeDir = this.homeDir(shortname);
        if (!this.exists(homeDir)) {
            return this.createDirAsync(homeDir, this.aclsForUser(shortname, 15), false);
        }
        return null;
    }

    public String initUserRegistry(String username) throws IOException {
        try {
            Future future = this.initUserRegistryAsync(username);
            future.get();
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException(e.toString()).initCause(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause.toString(), cause);
        }
        return this.homeDir(username);
    }

    protected void verifyRealmValidity() throws ServiceStateException {
        if (this.isSecure()) {
            String realm = this.getRegistrySecurity().getKerberosRealm();
            if (StringUtils.isEmpty((String)realm)) {
                throw new ServiceStateException("Cannot determine service realm");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Started Registry operations in realm {}", (Object)realm);
            }
        }
    }

    @VisibleForTesting
    public int purge(String path, NodeSelector selector, PurgePolicy purgePolicy, BackgroundCallback callback) throws IOException {
        Collection entries;
        boolean toDelete = false;
        try {
            Map childEntries = RegistryUtils.statChildren((RegistryOperations)this, (String)path);
            entries = childEntries.values();
        }
        catch (PathNotFoundException e) {
            return 0;
        }
        try {
            RegistryPathStatus registryPathStatus = this.stat(path);
            ServiceRecord serviceRecord = this.resolve(path);
            toDelete = selector.shouldSelect(path, registryPathStatus, serviceRecord);
        }
        catch (EOFException registryPathStatus) {
        }
        catch (InvalidRecordException registryPathStatus) {
        }
        catch (NoRecordException registryPathStatus) {
        }
        catch (PathNotFoundException e) {
            return 0;
        }
        if (toDelete && !entries.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Match on record @ {} with children ", (Object)path);
            }
            switch (3.$SwitchMap$org$apache$hadoop$registry$server$services$RegistryAdminService$PurgePolicy[purgePolicy.ordinal()]) {
                case 1: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Skipping deletion");
                    }
                    toDelete = false;
                    break;
                }
                case 2: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Scheduling for deletion with children");
                    }
                    toDelete = true;
                    entries = new ArrayList(0);
                    break;
                }
                case 3: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Failing deletion operation");
                    }
                    throw new PathIsNotEmptyDirectoryException(path);
                }
            }
        }
        int deleteOps = 0;
        if (toDelete) {
            try {
                this.zkDelete(path, true, callback);
            }
            catch (PathNotFoundException e) {
                return deleteOps;
            }
            ++deleteOps;
        }
        for (RegistryPathStatus status : entries) {
            String childname = status.path;
            String childpath = RegistryPathUtils.join((String)path, (String)childname);
            deleteOps += this.purge(childpath, selector, purgePolicy, callback);
        }
        return deleteOps;
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

