/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.ConfigurableFederationPolicy;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.policies.router.FederationRouterPolicy;
import org.apache.hadoop.yarn.server.federation.policies.router.LocalityRouterPolicy;
import org.apache.hadoop.yarn.server.federation.policies.router.TestWeightedRandomRouterPolicy;
import org.apache.hadoop.yarn.server.federation.resolver.SubClusterResolver;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.utils.FederationPoliciesTestUtil;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLocalityRouterPolicy
extends TestWeightedRandomRouterPolicy {
    @Override
    @Before
    public void setUp() throws Exception {
        this.setPolicy((ConfigurableFederationPolicy)new LocalityRouterPolicy());
        this.setPolicyInfo(new WeightedPolicyInfo());
        this.configureWeights(4.0f);
        this.initializePolicy((Configuration)new YarnConfiguration());
    }

    private void initializePolicy(Configuration conf) throws YarnException {
        this.setFederationPolicyContext(new FederationPolicyInitializationContext());
        SubClusterResolver resolver = FederationPoliciesTestUtil.initResolver();
        this.getFederationPolicyContext().setFederationSubclusterResolver(resolver);
        ByteBuffer buf = this.getPolicyInfo().toByteBuffer();
        this.getFederationPolicyContext().setSubClusterPolicyConfiguration(SubClusterPolicyConfiguration.newInstance((String)"queue1", (String)this.getPolicy().getClass().getCanonicalName(), (ByteBuffer)buf));
        this.getFederationPolicyContext().setHomeSubcluster(this.getHomeSubCluster());
        this.setupContext();
    }

    @Test
    public void testNodeInActiveSubCluster() throws YarnException {
        ArrayList<ResourceRequest> requests = new ArrayList<ResourceRequest>();
        requests.add(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"node1", (Resource)Resource.newInstance((int)10, (int)1), (int)1));
        requests.add(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"rack1", (Resource)Resource.newInstance((int)10, (int)1), (int)1));
        requests.add(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resource.newInstance((int)10, (int)1), (int)1));
        ApplicationSubmissionContext asc = ApplicationSubmissionContext.newInstance(null, null, null, null, null, (boolean)false, (boolean)false, (int)0, (Resource)Resources.none(), null, (boolean)false, null, null);
        asc.setAMContainerResourceRequests(requests);
        SubClusterId chosen = ((FederationRouterPolicy)this.getPolicy()).getHomeSubcluster(asc, null);
        if (this.getActiveSubclusters().containsKey(this.getFederationPolicyContext().getFederationSubclusterResolver().getSubClusterForNode("node1").getId())) {
            Assert.assertEquals((Object)this.getFederationPolicyContext().getFederationSubclusterResolver().getSubClusterForNode("node1"), (Object)chosen);
        }
        Assert.assertTrue((boolean)this.getActiveSubclusters().containsKey(chosen));
    }

    @Test
    public void testMultipleResourceRequests() throws YarnException {
        ArrayList<ResourceRequest> requests = new ArrayList<ResourceRequest>();
        requests.add(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"node1", (Resource)Resource.newInstance((int)10, (int)1), (int)1));
        requests.add(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"node2", (Resource)Resource.newInstance((int)10, (int)1), (int)1));
        ApplicationSubmissionContext asc = ApplicationSubmissionContext.newInstance(null, null, null, null, null, (boolean)false, (boolean)false, (int)0, (Resource)Resources.none(), null, (boolean)false, null, null);
        asc.setAMContainerResourceRequests(requests);
        try {
            ((FederationRouterPolicy)this.getPolicy()).getHomeSubcluster(asc, null);
            Assert.fail();
        }
        catch (FederationPolicyException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid number of resource requests: "));
        }
    }

    @Test
    public void testNodeNotExists() throws YarnException {
        ArrayList<ResourceRequest> requests = new ArrayList<ResourceRequest>();
        boolean relaxLocality = true;
        requests.add(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"node5", (Resource)Resource.newInstance((int)10, (int)1), (int)1, (boolean)relaxLocality));
        requests.add(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"rack1", (Resource)Resource.newInstance((int)10, (int)1), (int)1));
        requests.add(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resource.newInstance((int)10, (int)1), (int)1));
        ApplicationSubmissionContext asc = ApplicationSubmissionContext.newInstance(null, null, null, null, null, (boolean)false, (boolean)false, (int)0, (Resource)Resources.none(), null, (boolean)false, null, null);
        asc.setAMContainerResourceRequests(requests);
        try {
            ((FederationRouterPolicy)this.getPolicy()).getHomeSubcluster(asc, null);
        }
        catch (FederationPolicyException e) {
            Assert.fail();
        }
    }

    @Test
    public void testNodeInABlacklistSubCluster() throws YarnException {
        String subClusterToBlacklist = "subcluster3";
        Float value = (Float)this.getPolicyInfo().getRouterPolicyWeights().get(subClusterToBlacklist);
        this.getPolicyInfo().getRouterPolicyWeights().put(new SubClusterIdInfo(subClusterToBlacklist), Float.valueOf(0.0f));
        this.initializePolicy((Configuration)new YarnConfiguration());
        FederationPoliciesTestUtil.initializePolicyContext(this.getFederationPolicyContext(), this.getPolicy(), this.getPolicyInfo(), this.getActiveSubclusters(), new Configuration());
        ArrayList<ResourceRequest> requests = new ArrayList<ResourceRequest>();
        boolean relaxLocality = true;
        requests.add(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"node4", (Resource)Resource.newInstance((int)10, (int)1), (int)1, (boolean)relaxLocality));
        requests.add(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"rack1", (Resource)Resource.newInstance((int)10, (int)1), (int)1));
        requests.add(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resource.newInstance((int)10, (int)1), (int)1));
        ApplicationSubmissionContext asc = ApplicationSubmissionContext.newInstance(null, null, null, null, null, (boolean)false, (boolean)false, (int)0, (Resource)Resources.none(), null, (boolean)false, null, null);
        asc.setAMContainerResourceRequests(requests);
        try {
            SubClusterId targetId = ((FederationRouterPolicy)this.getPolicy()).getHomeSubcluster(asc, null);
            Assert.assertNotEquals((Object)targetId.getId(), (Object)subClusterToBlacklist);
        }
        catch (FederationPolicyException e) {
            Assert.fail();
        }
        this.getPolicyInfo().getRouterPolicyWeights().put(new SubClusterIdInfo(subClusterToBlacklist), value);
    }

    @Test
    public void testNodeNotInPolicy() throws YarnException {
        String subClusterToBlacklist = "subcluster3";
        Float value = (Float)this.getPolicyInfo().getRouterPolicyWeights().get(subClusterToBlacklist);
        this.getPolicyInfo().getRouterPolicyWeights().remove(subClusterToBlacklist);
        this.initializePolicy((Configuration)new YarnConfiguration());
        FederationPoliciesTestUtil.initializePolicyContext(this.getFederationPolicyContext(), this.getPolicy(), this.getPolicyInfo(), this.getActiveSubclusters(), new Configuration());
        ArrayList<ResourceRequest> requests = new ArrayList<ResourceRequest>();
        boolean relaxLocality = true;
        requests.add(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"node4", (Resource)Resource.newInstance((int)10, (int)1), (int)1, (boolean)relaxLocality));
        requests.add(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"rack1", (Resource)Resource.newInstance((int)10, (int)1), (int)1));
        requests.add(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resource.newInstance((int)10, (int)1), (int)1));
        ApplicationSubmissionContext asc = ApplicationSubmissionContext.newInstance(null, null, null, null, null, (boolean)false, (boolean)false, (int)0, (Resource)Resources.none(), null, (boolean)false, null, null);
        asc.setAMContainerResourceRequests(requests);
        try {
            SubClusterId targetId = ((FederationRouterPolicy)this.getPolicy()).getHomeSubcluster(asc, null);
            Assert.assertNotEquals((Object)targetId.getId(), (Object)subClusterToBlacklist);
        }
        catch (FederationPolicyException e) {
            Assert.fail();
        }
        this.getPolicyInfo().getRouterPolicyWeights().put(new SubClusterIdInfo(subClusterToBlacklist), value);
    }
}

