/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.ConfigurableFederationPolicy;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.router.BaseRouterPoliciesTest;
import org.apache.hadoop.yarn.server.federation.policies.router.FederationRouterPolicy;
import org.apache.hadoop.yarn.server.federation.policies.router.UniformRandomRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestUniformRandomRouterPolicy
extends BaseRouterPoliciesTest {
    @Before
    public void setUp() throws Exception {
        this.setPolicy((ConfigurableFederationPolicy)new UniformRandomRouterPolicy());
        this.setPolicyInfo((WeightedPolicyInfo)Mockito.mock(WeightedPolicyInfo.class));
        for (int i = 1; i <= 2; ++i) {
            SubClusterIdInfo sc = new SubClusterIdInfo("sc" + i);
            long now = Time.now();
            SubClusterInfo federationSubClusterInfo = SubClusterInfo.newInstance((SubClusterId)sc.toId(), (String)"dns1:80", (String)"dns1:81", (String)"dns1:82", (String)"dns1:83", (long)(now - 1000L), (SubClusterState)SubClusterState.SC_RUNNING, (long)(now - 2000L), (String)this.generateClusterMetricsInfo(i));
            this.getActiveSubclusters().put(sc.toId(), federationSubClusterInfo);
        }
        this.setupContext();
    }

    @Test
    public void testOneSubclusterIsChosen() throws YarnException {
        SubClusterId chosen = ((FederationRouterPolicy)this.getPolicy()).getHomeSubcluster(this.getApplicationSubmissionContext(), null);
        Assert.assertTrue((boolean)this.getActiveSubclusters().keySet().contains(chosen));
    }
}

