/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.impl;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.impl.FederationStateStoreBaseTest;
import org.apache.hadoop.yarn.server.federation.store.impl.HSQLDBFederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.metrics.FederationStateStoreClientMetrics;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterRequest;
import org.junit.Assert;
import org.junit.Test;

public class TestSQLFederationStateStore
extends FederationStateStoreBaseTest {
    private static final String HSQLDB_DRIVER = "org.hsqldb.jdbc.JDBCDataSource";
    private static final String DATABASE_URL = "jdbc:hsqldb:mem:state";
    private static final String DATABASE_USERNAME = "SA";
    private static final String DATABASE_PASSWORD = "";

    @Override
    protected FederationStateStore createStateStore() {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.federation.state-store.sql.jdbc-class", HSQLDB_DRIVER);
        conf.set("yarn.federation.state-store.sql.username", DATABASE_USERNAME);
        conf.set("yarn.federation.state-store.sql.password", DATABASE_PASSWORD);
        conf.set("yarn.federation.state-store.sql.url", DATABASE_URL + System.currentTimeMillis());
        super.setConf((Configuration)conf);
        return new HSQLDBFederationStateStore();
    }

    @Test
    public void testSqlConnectionsCreatedCount() throws YarnException {
        FederationStateStore stateStore = this.getStateStore();
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        SubClusterInfo subClusterInfo = this.createSubClusterInfo(subClusterId);
        stateStore.registerSubCluster(SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo));
        Assert.assertEquals((Object)subClusterInfo, (Object)this.querySubClusterInfo(subClusterId));
        this.addApplicationHomeSC(appId, subClusterId);
        Assert.assertEquals((Object)subClusterId, (Object)this.queryApplicationHomeSC(appId));
        Assert.assertEquals((long)1L, (long)FederationStateStoreClientMetrics.getNumConnections());
    }
}

