/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.impl;

import java.io.IOException;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.metrics2.impl.MetricsRecords;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.impl.FederationStateStoreBaseTest;
import org.apache.hadoop.yarn.server.federation.store.impl.ZKFederationStateStoreOpDurations;
import org.apache.hadoop.yarn.server.federation.store.impl.ZookeeperFederationStateStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestZookeeperFederationStateStore
extends FederationStateStoreBaseTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestZookeeperFederationStateStore.class);
    private static TestingServer curatorTestingServer;
    private static CuratorFramework curatorFramework;

    @Override
    @Before
    public void before() throws IOException, YarnException {
        try {
            curatorTestingServer = new TestingServer();
            curatorTestingServer.start();
            String connectString = curatorTestingServer.getConnectString();
            curatorFramework = CuratorFrameworkFactory.builder().connectString(connectString).retryPolicy((RetryPolicy)new RetryNTimes(100, 100)).build();
            curatorFramework.start();
            YarnConfiguration conf = new YarnConfiguration();
            conf.set("hadoop.zk.address", connectString);
            this.setConf((Configuration)conf);
        }
        catch (Exception e) {
            LOG.error("Cannot initialize ZooKeeper store", (Throwable)e);
            throw new IOException(e);
        }
        super.before();
    }

    @Override
    @After
    public void after() throws Exception {
        super.after();
        curatorFramework.close();
        try {
            curatorTestingServer.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected FederationStateStore createStateStore() {
        super.setConf(this.getConf());
        return new ZookeeperFederationStateStore();
    }

    @Test
    public void testMetricsInited() throws Exception {
        ZookeeperFederationStateStore zkStateStore = (ZookeeperFederationStateStore)this.createStateStore();
        ZKFederationStateStoreOpDurations zkStateStoreOpDurations = zkStateStore.getOpDurations();
        MetricsCollectorImpl collector = new MetricsCollectorImpl();
        long anyDuration = 10L;
        long start = Time.now();
        long end = start + anyDuration;
        zkStateStoreOpDurations.addAppHomeSubClusterDuration(start, end);
        zkStateStoreOpDurations.addUpdateAppHomeSubClusterDuration(start, end);
        zkStateStoreOpDurations.addGetAppHomeSubClusterDuration(start, end);
        zkStateStoreOpDurations.addGetAppsHomeSubClusterDuration(start, end);
        zkStateStoreOpDurations.addDeleteAppHomeSubClusterDuration(start, end);
        zkStateStoreOpDurations.addRegisterSubClusterDuration(start, end);
        zkStateStoreOpDurations.addDeregisterSubClusterDuration(start, end);
        zkStateStoreOpDurations.addSubClusterHeartbeatDuration(start, end);
        zkStateStoreOpDurations.addGetSubClusterDuration(start, end);
        zkStateStoreOpDurations.addGetSubClustersDuration(start, end);
        zkStateStoreOpDurations.addGetPolicyConfigurationDuration(start, end);
        zkStateStoreOpDurations.addSetPolicyConfigurationDuration(start, end);
        zkStateStoreOpDurations.addGetPoliciesConfigurationsDuration(start, end);
        zkStateStoreOpDurations.getMetrics((MetricsCollector)collector, true);
        Assert.assertEquals((String)"Incorrect number of perf metrics", (long)1L, (long)collector.getRecords().size());
        MetricsRecord record = (MetricsRecord)collector.getRecords().get(0);
        MetricsRecords.assertTag((MetricsRecord)record, (String)ZKFederationStateStoreOpDurations.RECORD_INFO.name(), (String)"ZKFederationStateStoreOpDurations");
        double expectAvgTime = anyDuration;
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"AddAppHomeSubClusterAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"UpdateAppHomeSubClusterAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetAppHomeSubClusterAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetAppsHomeSubClusterAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"DeleteAppHomeSubClusterAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"RegisterSubClusterAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"DeregisterSubClusterAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"SubClusterHeartbeatAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetSubClusterAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetSubClustersAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetPolicyConfigurationAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"SetPolicyConfigurationAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetPoliciesConfigurationsAvgTime", (Number)expectAvgTime);
        long expectOps = 1L;
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"AddAppHomeSubClusterNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"UpdateAppHomeSubClusterNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetAppHomeSubClusterNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetAppsHomeSubClusterNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"DeleteAppHomeSubClusterNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"RegisterSubClusterNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"DeregisterSubClusterNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"SubClusterHeartbeatNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetSubClusterNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetSubClustersNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetPolicyConfigurationNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"SetPolicyConfigurationNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetPoliciesConfigurationsNumOps", (Number)expectOps);
    }
}

