/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.utils;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.impl.FSRegistryOperationsService;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.federation.utils.FederationRegistryClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFederationRegistryClient {
    private Configuration conf;
    private UserGroupInformation user;
    private RegistryOperations registry;
    private FederationRegistryClient registryClient;

    @Before
    public void setup() throws Exception {
        this.conf = new YarnConfiguration();
        this.registry = new FSRegistryOperationsService();
        this.registry.init(this.conf);
        this.registry.start();
        this.user = UserGroupInformation.getCurrentUser();
        this.registryClient = new FederationRegistryClient(this.conf, this.registry, this.user);
        this.registryClient.cleanAllApplications();
        Assert.assertEquals((long)0L, (long)this.registryClient.getAllApplications().size());
    }

    @After
    public void breakDown() {
        this.registryClient.cleanAllApplications();
        Assert.assertEquals((long)0L, (long)this.registryClient.getAllApplications().size());
        this.registry.stop();
    }

    @Test
    public void testBasicCase() {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)0);
        String scId1 = "subcluster1";
        String scId2 = "subcluster2";
        this.registryClient.writeAMRMTokenForUAM(appId, scId1, new Token());
        this.registryClient.writeAMRMTokenForUAM(appId, scId2, new Token());
        this.registryClient.writeAMRMTokenForUAM(appId, scId1, new Token());
        Assert.assertEquals((long)1L, (long)this.registryClient.getAllApplications().size());
        Assert.assertEquals((long)2L, (long)this.registryClient.loadStateFromRegistry(appId).size());
        this.registryClient.removeAppFromRegistry(appId);
        Assert.assertEquals((long)0L, (long)this.registryClient.getAllApplications().size());
        Assert.assertEquals((long)0L, (long)this.registryClient.loadStateFromRegistry(appId).size());
    }
}

