/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.curator.framework.recipes.shared.SharedCount;
import org.apache.curator.framework.recipes.shared.VersionedValue;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.thirdparty.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.util.curator.ZKCuratorManager;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.federation.proto.YarnServerFederationProtos;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.impl.ZKFederationStateStoreOpDurations;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.AddReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.AddReservationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteReservationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationsHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationsHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetReservationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetReservationsHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetReservationsHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoResponse;
import org.apache.hadoop.yarn.server.federation.store.records.ReservationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKey;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKeyRequest;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKeyResponse;
import org.apache.hadoop.yarn.server.federation.store.records.RouterRMTokenRequest;
import org.apache.hadoop.yarn.server.federation.store.records.RouterRMTokenResponse;
import org.apache.hadoop.yarn.server.federation.store.records.RouterStoreToken;
import org.apache.hadoop.yarn.server.federation.store.records.SetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SetSubClusterPolicyConfigurationResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterDeregisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterDeregisterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterHeartbeatRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterHeartbeatResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateReservationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.SubClusterIdPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.SubClusterInfoPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.SubClusterPolicyConfigurationPBImpl;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationApplicationHomeSubClusterStoreInputValidator;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationMembershipStateStoreInputValidator;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationPolicyStoreInputValidator;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationReservationHomeSubClusterStoreInputValidator;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationRouterRMTokenInputValidator;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationStateStoreUtils;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperFederationStateStore
implements FederationStateStore {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperFederationStateStore.class);
    private static final String ROOT_ZNODE_NAME_MEMBERSHIP = "memberships";
    private static final String ROOT_ZNODE_NAME_APPLICATION = "applications";
    private static final String ROOT_ZNODE_NAME_POLICY = "policies";
    private static final String ROOT_ZNODE_NAME_RESERVATION = "reservation";
    private static final String ROUTER_RM_DT_SECRET_MANAGER_ROOT = "router_rm_dt_secret_manager_root";
    private static final String ROUTER_RM_DT_MASTER_KEYS_ROOT_ZNODE_NAME = "router_rm_dt_master_keys_root";
    private static final String ROUTER_RM_DELEGATION_TOKENS_ROOT_ZNODE_NAME = "router_rm_delegation_tokens_root";
    private static final String ROUTER_RM_DT_SEQUENTIAL_NUMBER_ZNODE_NAME = "router_rm_dt_sequential_number";
    private static final String ROUTER_RM_DT_MASTER_KEY_ID_ZNODE_NAME = "router_rm_dt_master_key_id";
    private static final String ROUTER_RM_DELEGATION_KEY_PREFIX = "delegation_key_";
    private static final String ROUTER_RM_DELEGATION_TOKEN_PREFIX = "rm_delegation_token_";
    private ZKCuratorManager zkManager;
    private int seqNumBatchSize;
    private int currentSeqNum;
    private int currentMaxSeqNum;
    private SharedCount delTokSeqCounter;
    private SharedCount keyIdSeqCounter;
    private String baseZNode;
    private String appsZNode;
    private String membershipZNode;
    private String policiesZNode;
    private String reservationsZNode;
    private int maxAppsInStateStore;
    private String routerRMDTSecretManagerRoot;
    private String routerRMDTMasterKeysRootPath;
    private String routerRMDelegationTokensRootPath;
    private String routerRMSequenceNumberPath;
    private String routerRMMasterKeyIdPath;
    private volatile Clock clock = SystemClock.getInstance();
    @VisibleForTesting
    private ZKFederationStateStoreOpDurations opDurations = ZKFederationStateStoreOpDurations.getInstance();

    @Override
    public void init(Configuration conf) throws YarnException {
        LOG.info("Initializing ZooKeeper connection");
        this.maxAppsInStateStore = conf.getInt("yarn.federation.state-store.max-applications", 1000);
        this.baseZNode = conf.get("yarn.federation.zk-state-store.parent-path", "/federationstore");
        try {
            this.zkManager = new ZKCuratorManager(conf);
            this.zkManager.start();
        }
        catch (IOException e) {
            LOG.error("Cannot initialize the ZK connection", (Throwable)e);
        }
        this.membershipZNode = ZKCuratorManager.getNodePath((String)this.baseZNode, (String)ROOT_ZNODE_NAME_MEMBERSHIP);
        this.appsZNode = ZKCuratorManager.getNodePath((String)this.baseZNode, (String)ROOT_ZNODE_NAME_APPLICATION);
        this.policiesZNode = ZKCuratorManager.getNodePath((String)this.baseZNode, (String)ROOT_ZNODE_NAME_POLICY);
        this.reservationsZNode = ZKCuratorManager.getNodePath((String)this.baseZNode, (String)ROOT_ZNODE_NAME_RESERVATION);
        this.routerRMDTSecretManagerRoot = ZKCuratorManager.getNodePath((String)this.baseZNode, (String)ROUTER_RM_DT_SECRET_MANAGER_ROOT);
        this.routerRMDTMasterKeysRootPath = ZKCuratorManager.getNodePath((String)this.routerRMDTSecretManagerRoot, (String)ROUTER_RM_DT_MASTER_KEYS_ROOT_ZNODE_NAME);
        this.routerRMDelegationTokensRootPath = ZKCuratorManager.getNodePath((String)this.routerRMDTSecretManagerRoot, (String)ROUTER_RM_DELEGATION_TOKENS_ROOT_ZNODE_NAME);
        this.routerRMSequenceNumberPath = ZKCuratorManager.getNodePath((String)this.routerRMDTSecretManagerRoot, (String)ROUTER_RM_DT_SEQUENTIAL_NUMBER_ZNODE_NAME);
        this.routerRMMasterKeyIdPath = ZKCuratorManager.getNodePath((String)this.routerRMDTSecretManagerRoot, (String)ROUTER_RM_DT_MASTER_KEY_ID_ZNODE_NAME);
        try {
            List zkAcl = ZKCuratorManager.getZKAcls((Configuration)conf);
            this.zkManager.createRootDirRecursively(this.membershipZNode, zkAcl);
            this.zkManager.createRootDirRecursively(this.appsZNode, zkAcl);
            this.zkManager.createRootDirRecursively(this.policiesZNode, zkAcl);
            this.zkManager.createRootDirRecursively(this.reservationsZNode, zkAcl);
            this.zkManager.createRootDirRecursively(this.routerRMDTSecretManagerRoot, zkAcl);
            this.zkManager.createRootDirRecursively(this.routerRMDTMasterKeysRootPath, zkAcl);
            this.zkManager.createRootDirRecursively(this.routerRMDelegationTokensRootPath, zkAcl);
        }
        catch (Exception e) {
            String errMsg = "Cannot create base directories: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        try {
            this.seqNumBatchSize = conf.getInt("zk-dt-secret-manager.token.seqnum.batch.size", 1);
            this.delTokSeqCounter = new SharedCount(this.zkManager.getCurator(), this.routerRMSequenceNumberPath, 0);
            if (this.delTokSeqCounter != null) {
                this.delTokSeqCounter.start();
            }
            this.currentSeqNum = this.incrSharedCount(this.delTokSeqCounter, this.seqNumBatchSize);
            this.currentMaxSeqNum = this.currentSeqNum + this.seqNumBatchSize;
            LOG.info("Fetched initial range of seq num, from {} to {} ", (Object)(this.currentSeqNum + 1), (Object)this.currentMaxSeqNum);
        }
        catch (Exception e) {
            throw new YarnException("Could not start Sequence Counter.", (Throwable)e);
        }
        try {
            this.keyIdSeqCounter = new SharedCount(this.zkManager.getCurator(), this.routerRMMasterKeyIdPath, 0);
            if (this.keyIdSeqCounter != null) {
                this.keyIdSeqCounter.start();
            }
        }
        catch (Exception e) {
            throw new YarnException("Could not start Master KeyId Counter", (Throwable)e);
        }
    }

    @Override
    public void close() throws Exception {
        try {
            if (this.delTokSeqCounter != null) {
                this.delTokSeqCounter.close();
                this.delTokSeqCounter = null;
            }
        }
        catch (Exception e) {
            LOG.error("Could not Stop Delegation Token Counter.", (Throwable)e);
        }
        try {
            if (this.keyIdSeqCounter != null) {
                this.keyIdSeqCounter.close();
                this.keyIdSeqCounter = null;
            }
        }
        catch (Exception e) {
            LOG.error("Could not stop Master KeyId Counter.", (Throwable)e);
        }
        if (this.zkManager != null) {
            this.zkManager.close();
        }
    }

    @Override
    public AddApplicationHomeSubClusterResponse addApplicationHomeSubCluster(AddApplicationHomeSubClusterRequest request) throws YarnException {
        String errMsg;
        long start = this.clock.getTime();
        FederationApplicationHomeSubClusterStoreInputValidator.validate(request);
        ApplicationHomeSubCluster app = request.getApplicationHomeSubCluster();
        ApplicationId appId = app.getApplicationId();
        SubClusterId homeSubCluster = app.getHomeSubCluster();
        try {
            this.putApp(appId, homeSubCluster, false);
        }
        catch (Exception e) {
            errMsg = "Cannot add application home subcluster for " + appId;
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        try {
            homeSubCluster = this.getApp(appId);
        }
        catch (Exception e) {
            errMsg = "Cannot check app home subcluster for " + appId;
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        long end = this.clock.getTime();
        this.opDurations.addAppHomeSubClusterDuration(start, end);
        return AddApplicationHomeSubClusterResponse.newInstance(homeSubCluster);
    }

    @Override
    public UpdateApplicationHomeSubClusterResponse updateApplicationHomeSubCluster(UpdateApplicationHomeSubClusterRequest request) throws YarnException {
        long start = this.clock.getTime();
        FederationApplicationHomeSubClusterStoreInputValidator.validate(request);
        ApplicationHomeSubCluster app = request.getApplicationHomeSubCluster();
        ApplicationId appId = app.getApplicationId();
        SubClusterId homeSubCluster = this.getApp(appId);
        if (homeSubCluster == null) {
            String errMsg = "Application " + appId + " does not exist";
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        SubClusterId newSubClusterId = request.getApplicationHomeSubCluster().getHomeSubCluster();
        this.putApp(appId, newSubClusterId, true);
        long end = this.clock.getTime();
        this.opDurations.addUpdateAppHomeSubClusterDuration(start, end);
        return UpdateApplicationHomeSubClusterResponse.newInstance();
    }

    @Override
    public GetApplicationHomeSubClusterResponse getApplicationHomeSubCluster(GetApplicationHomeSubClusterRequest request) throws YarnException {
        long start = this.clock.getTime();
        FederationApplicationHomeSubClusterStoreInputValidator.validate(request);
        ApplicationId appId = request.getApplicationId();
        SubClusterId homeSubCluster = this.getApp(appId);
        if (homeSubCluster == null) {
            String errMsg = "Application " + appId + " does not exist";
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        long end = this.clock.getTime();
        this.opDurations.addGetAppHomeSubClusterDuration(start, end);
        return GetApplicationHomeSubClusterResponse.newInstance(appId, homeSubCluster);
    }

    @Override
    public GetApplicationsHomeSubClusterResponse getApplicationsHomeSubCluster(GetApplicationsHomeSubClusterRequest request) throws YarnException {
        if (request == null) {
            throw new YarnException("Missing getApplicationsHomeSubCluster request");
        }
        try {
            long start = this.clock.getTime();
            SubClusterId requestSC = request.getSubClusterId();
            List children = this.zkManager.getChildren(this.appsZNode);
            List<ApplicationHomeSubCluster> result = children.stream().map(child -> this.generateAppHomeSC((String)child)).sorted(Comparator.comparing(ApplicationHomeSubCluster::getCreateTime).reversed()).filter(appHomeSC -> FederationStateStoreUtils.filterHomeSubCluster(requestSC, appHomeSC.getHomeSubCluster())).limit(this.maxAppsInStateStore).collect(Collectors.toList());
            long end = this.clock.getTime();
            this.opDurations.addGetAppsHomeSubClusterDuration(start, end);
            LOG.info("filterSubClusterId = {}, appCount = {}.", (Object)requestSC, (Object)result.size());
            return GetApplicationsHomeSubClusterResponse.newInstance(result);
        }
        catch (Exception e) {
            String errMsg = "Cannot get apps: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            throw new YarnException("Cannot get app by request");
        }
    }

    private ApplicationHomeSubCluster generateAppHomeSC(String appId) {
        try {
            ApplicationId applicationId = ApplicationId.fromString((String)appId);
            SubClusterId homeSubCluster = this.getApp(applicationId);
            ApplicationHomeSubCluster app = ApplicationHomeSubCluster.newInstance(applicationId, homeSubCluster);
            return app;
        }
        catch (Exception ex) {
            LOG.error("get homeSubCluster by appId = {}.", (Object)appId);
            return null;
        }
    }

    @Override
    public DeleteApplicationHomeSubClusterResponse deleteApplicationHomeSubCluster(DeleteApplicationHomeSubClusterRequest request) throws YarnException {
        String errMsg;
        long start = this.clock.getTime();
        FederationApplicationHomeSubClusterStoreInputValidator.validate(request);
        ApplicationId appId = request.getApplicationId();
        String appZNode = ZKCuratorManager.getNodePath((String)this.appsZNode, (String)appId.toString());
        boolean exists = false;
        try {
            exists = this.zkManager.exists(appZNode);
        }
        catch (Exception e) {
            errMsg = "Cannot check app: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        if (!exists) {
            String errMsg2 = "Application " + appId + " does not exist";
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg2);
        }
        try {
            this.zkManager.delete(appZNode);
        }
        catch (Exception e) {
            errMsg = "Cannot delete app: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        long end = this.clock.getTime();
        this.opDurations.addDeleteAppHomeSubClusterDuration(start, end);
        return DeleteApplicationHomeSubClusterResponse.newInstance();
    }

    @Override
    public SubClusterRegisterResponse registerSubCluster(SubClusterRegisterRequest request) throws YarnException {
        long start = this.clock.getTime();
        FederationMembershipStateStoreInputValidator.validate(request);
        SubClusterInfo subClusterInfo = request.getSubClusterInfo();
        SubClusterId subclusterId = subClusterInfo.getSubClusterId();
        long currentTime = ZookeeperFederationStateStore.getCurrentTime();
        subClusterInfo.setLastHeartBeat(currentTime);
        try {
            this.putSubclusterInfo(subclusterId, subClusterInfo, true);
        }
        catch (Exception e) {
            String errMsg = "Cannot register subcluster: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        long end = this.clock.getTime();
        this.opDurations.addRegisterSubClusterDuration(start, end);
        return SubClusterRegisterResponse.newInstance();
    }

    @Override
    public SubClusterDeregisterResponse deregisterSubCluster(SubClusterDeregisterRequest request) throws YarnException {
        long start = this.clock.getTime();
        FederationMembershipStateStoreInputValidator.validate(request);
        SubClusterId subClusterId = request.getSubClusterId();
        SubClusterState state = request.getState();
        SubClusterInfo subClusterInfo = this.getSubclusterInfo(subClusterId);
        if (subClusterInfo == null) {
            String errMsg = "SubCluster " + subClusterId + " not found";
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        } else {
            subClusterInfo.setState(state);
            this.putSubclusterInfo(subClusterId, subClusterInfo, true);
        }
        long end = this.clock.getTime();
        this.opDurations.addDeregisterSubClusterDuration(start, end);
        return SubClusterDeregisterResponse.newInstance();
    }

    @Override
    public SubClusterHeartbeatResponse subClusterHeartbeat(SubClusterHeartbeatRequest request) throws YarnException {
        long start = this.clock.getTime();
        FederationMembershipStateStoreInputValidator.validate(request);
        SubClusterId subClusterId = request.getSubClusterId();
        SubClusterInfo subClusterInfo = this.getSubclusterInfo(subClusterId);
        if (subClusterInfo == null) {
            String errMsg = "SubCluster " + subClusterId + " does not exist; cannot heartbeat";
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        long currentTime = ZookeeperFederationStateStore.getCurrentTime();
        subClusterInfo.setLastHeartBeat(currentTime);
        subClusterInfo.setState(request.getState());
        subClusterInfo.setCapability(request.getCapability());
        this.putSubclusterInfo(subClusterId, subClusterInfo, true);
        long end = this.clock.getTime();
        this.opDurations.addSubClusterHeartbeatDuration(start, end);
        return SubClusterHeartbeatResponse.newInstance();
    }

    @Override
    public GetSubClusterInfoResponse getSubCluster(GetSubClusterInfoRequest request) throws YarnException {
        long start = this.clock.getTime();
        FederationMembershipStateStoreInputValidator.validate(request);
        SubClusterId subClusterId = request.getSubClusterId();
        SubClusterInfo subClusterInfo = null;
        try {
            subClusterInfo = this.getSubclusterInfo(subClusterId);
            if (subClusterInfo == null) {
                LOG.warn("The queried SubCluster: {} does not exist.", (Object)subClusterId);
                return null;
            }
        }
        catch (Exception e) {
            String errMsg = "Cannot get subcluster: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        long end = this.clock.getTime();
        this.opDurations.addGetSubClusterDuration(start, end);
        return GetSubClusterInfoResponse.newInstance(subClusterInfo);
    }

    @Override
    public GetSubClustersInfoResponse getSubClusters(GetSubClustersInfoRequest request) throws YarnException {
        long start = this.clock.getTime();
        ArrayList<SubClusterInfo> result = new ArrayList<SubClusterInfo>();
        try {
            for (String child : this.zkManager.getChildren(this.membershipZNode)) {
                SubClusterId subClusterId = SubClusterId.newInstance(child);
                SubClusterInfo info = this.getSubclusterInfo(subClusterId);
                if (request.getFilterInactiveSubClusters() && !info.getState().isActive()) continue;
                result.add(info);
            }
        }
        catch (Exception e) {
            String errMsg = "Cannot get subclusters: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        long end = this.clock.getTime();
        this.opDurations.addGetSubClustersDuration(start, end);
        return GetSubClustersInfoResponse.newInstance(result);
    }

    @Override
    public GetSubClusterPolicyConfigurationResponse getPolicyConfiguration(GetSubClusterPolicyConfigurationRequest request) throws YarnException {
        long start = this.clock.getTime();
        FederationPolicyStoreInputValidator.validate(request);
        String queue = request.getQueue();
        SubClusterPolicyConfiguration policy = null;
        try {
            policy = this.getPolicy(queue);
        }
        catch (Exception e) {
            String errMsg = "Cannot get policy: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        if (policy == null) {
            LOG.warn("Policy for queue: {} does not exist.", (Object)queue);
            return null;
        }
        long end = this.clock.getTime();
        this.opDurations.addGetPolicyConfigurationDuration(start, end);
        return GetSubClusterPolicyConfigurationResponse.newInstance(policy);
    }

    @Override
    public SetSubClusterPolicyConfigurationResponse setPolicyConfiguration(SetSubClusterPolicyConfigurationRequest request) throws YarnException {
        long start = this.clock.getTime();
        FederationPolicyStoreInputValidator.validate(request);
        SubClusterPolicyConfiguration policy = request.getPolicyConfiguration();
        try {
            String queue = policy.getQueue();
            this.putPolicy(queue, policy, true);
        }
        catch (Exception e) {
            String errMsg = "Cannot set policy: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        long end = this.clock.getTime();
        this.opDurations.addSetPolicyConfigurationDuration(start, end);
        return SetSubClusterPolicyConfigurationResponse.newInstance();
    }

    @Override
    public GetSubClusterPoliciesConfigurationsResponse getPoliciesConfigurations(GetSubClusterPoliciesConfigurationsRequest request) throws YarnException {
        long start = this.clock.getTime();
        ArrayList<SubClusterPolicyConfiguration> result = new ArrayList<SubClusterPolicyConfiguration>();
        try {
            for (String child : this.zkManager.getChildren(this.policiesZNode)) {
                SubClusterPolicyConfiguration policy = this.getPolicy(child);
                if (policy == null) {
                    LOG.warn("Policy for queue: {} does not exist.", (Object)child);
                    continue;
                }
                result.add(policy);
            }
        }
        catch (Exception e) {
            String errMsg = "Cannot get policies: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        long end = this.clock.getTime();
        this.opDurations.addGetPoliciesConfigurationsDuration(start, end);
        return GetSubClusterPoliciesConfigurationsResponse.newInstance(result);
    }

    @Override
    public Version getCurrentVersion() {
        throw new NotImplementedException("Code is not implemented");
    }

    @Override
    public Version loadVersion() throws Exception {
        throw new NotImplementedException("Code is not implemented");
    }

    @Override
    public void storeVersion() throws Exception {
        throw new NotImplementedException("Code is not implemented");
    }

    @Override
    public void checkVersion() throws Exception {
        throw new NotImplementedException("Code is not implemented");
    }

    private SubClusterId getApp(ApplicationId appId) throws YarnException {
        String appZNode = ZKCuratorManager.getNodePath((String)this.appsZNode, (String)appId.toString());
        SubClusterIdPBImpl subClusterId = null;
        byte[] data = this.get(appZNode);
        if (data != null) {
            try {
                subClusterId = new SubClusterIdPBImpl(YarnServerFederationProtos.SubClusterIdProto.parseFrom(data));
            }
            catch (InvalidProtocolBufferException e) {
                String errMsg = "Cannot parse application at " + appZNode;
                FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            }
        }
        return subClusterId;
    }

    private void putApp(ApplicationId appId, SubClusterId subClusterId, boolean update) throws YarnException {
        String appZNode = ZKCuratorManager.getNodePath((String)this.appsZNode, (String)appId.toString());
        YarnServerFederationProtos.SubClusterIdProto proto = ((SubClusterIdPBImpl)subClusterId).getProto();
        byte[] data = proto.toByteArray();
        this.put(appZNode, data, update);
    }

    private SubClusterInfo getSubclusterInfo(SubClusterId subclusterId) throws YarnException {
        String memberZNode = ZKCuratorManager.getNodePath((String)this.membershipZNode, (String)subclusterId.toString());
        SubClusterInfoPBImpl policy = null;
        byte[] data = this.get(memberZNode);
        if (data != null) {
            try {
                policy = new SubClusterInfoPBImpl(YarnServerFederationProtos.SubClusterInfoProto.parseFrom(data));
            }
            catch (InvalidProtocolBufferException e) {
                String errMsg = "Cannot parse subcluster info at " + memberZNode;
                FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            }
        }
        return policy;
    }

    private void putSubclusterInfo(SubClusterId subclusterId, SubClusterInfo subClusterInfo, boolean update) throws YarnException {
        String memberZNode = ZKCuratorManager.getNodePath((String)this.membershipZNode, (String)subclusterId.toString());
        YarnServerFederationProtos.SubClusterInfoProto proto = ((SubClusterInfoPBImpl)subClusterInfo).getProto();
        byte[] data = proto.toByteArray();
        this.put(memberZNode, data, update);
    }

    private SubClusterPolicyConfiguration getPolicy(String queue) throws YarnException {
        String policyZNode = ZKCuratorManager.getNodePath((String)this.policiesZNode, (String)queue);
        SubClusterPolicyConfigurationPBImpl policy = null;
        byte[] data = this.get(policyZNode);
        if (data != null) {
            try {
                policy = new SubClusterPolicyConfigurationPBImpl(YarnServerFederationProtos.SubClusterPolicyConfigurationProto.parseFrom(data));
            }
            catch (InvalidProtocolBufferException e) {
                String errMsg = "Cannot parse policy at " + policyZNode;
                FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            }
        }
        return policy;
    }

    private void putPolicy(String queue, SubClusterPolicyConfiguration policy, boolean update) throws YarnException {
        String policyZNode = ZKCuratorManager.getNodePath((String)this.policiesZNode, (String)queue);
        YarnServerFederationProtos.SubClusterPolicyConfigurationProto proto = ((SubClusterPolicyConfigurationPBImpl)policy).getProto();
        byte[] data = proto.toByteArray();
        this.put(policyZNode, data, update);
    }

    private byte[] get(String znode) throws YarnException {
        boolean exists = false;
        try {
            exists = this.zkManager.exists(znode);
        }
        catch (Exception e) {
            String errMsg = "Cannot find znode " + znode;
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        if (!exists) {
            LOG.error("{} does not exist", (Object)znode);
            return null;
        }
        byte[] data = null;
        try {
            data = this.zkManager.getData(znode);
        }
        catch (Exception e) {
            String errMsg = "Cannot get data from znode " + znode + ": " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        return data;
    }

    private void put(String znode, byte[] data, boolean update) throws YarnException {
        String errMsg;
        boolean created = false;
        try {
            created = this.zkManager.create(znode);
        }
        catch (Exception e) {
            errMsg = "Cannot create znode " + znode + ": " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        if (!created) {
            LOG.debug("{} not created", (Object)znode);
            if (!update) {
                LOG.info("{} already existed and we are not updating", (Object)znode);
                return;
            }
        }
        try {
            this.zkManager.setData(znode, data, -1);
        }
        catch (Exception e) {
            errMsg = "Cannot write data into znode " + znode + ": " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
    }

    private static long getCurrentTime() {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        return cal.getTimeInMillis();
    }

    private void putReservation(ReservationId reservationId, SubClusterId subClusterId, boolean update) throws YarnException {
        String reservationZNode = ZKCuratorManager.getNodePath((String)this.reservationsZNode, (String)reservationId.toString());
        YarnServerFederationProtos.SubClusterIdProto proto = ((SubClusterIdPBImpl)subClusterId).getProto();
        byte[] data = proto.toByteArray();
        this.put(reservationZNode, data, update);
    }

    private SubClusterId getReservation(ReservationId reservationId) throws YarnException {
        String reservationIdZNode = ZKCuratorManager.getNodePath((String)this.reservationsZNode, (String)reservationId.toString());
        SubClusterIdPBImpl subClusterId = null;
        byte[] data = this.get(reservationIdZNode);
        if (data != null) {
            try {
                subClusterId = new SubClusterIdPBImpl(YarnServerFederationProtos.SubClusterIdProto.parseFrom(data));
            }
            catch (InvalidProtocolBufferException e) {
                String errMsg = "Cannot parse reservation at " + reservationId;
                FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            }
        }
        return subClusterId;
    }

    @VisibleForTesting
    public ZKFederationStateStoreOpDurations getOpDurations() {
        return this.opDurations;
    }

    @Override
    public AddReservationHomeSubClusterResponse addReservationHomeSubCluster(AddReservationHomeSubClusterRequest request) throws YarnException {
        String errMsg;
        long start = this.clock.getTime();
        FederationReservationHomeSubClusterStoreInputValidator.validate(request);
        ReservationHomeSubCluster reservationHomeSubCluster = request.getReservationHomeSubCluster();
        ReservationId reservationId = reservationHomeSubCluster.getReservationId();
        SubClusterId homeSubCluster = reservationHomeSubCluster.getHomeSubCluster();
        try {
            this.putReservation(reservationId, homeSubCluster, false);
        }
        catch (Exception e) {
            errMsg = "Cannot add reservation home subcluster for " + reservationId;
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        try {
            homeSubCluster = this.getReservation(reservationId);
        }
        catch (Exception e) {
            errMsg = "Cannot check app home subcluster for " + reservationId;
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        long end = this.clock.getTime();
        this.opDurations.addReservationHomeSubClusterDuration(start, end);
        return AddReservationHomeSubClusterResponse.newInstance(homeSubCluster);
    }

    @Override
    public GetReservationHomeSubClusterResponse getReservationHomeSubCluster(GetReservationHomeSubClusterRequest request) throws YarnException {
        long start = this.clock.getTime();
        FederationReservationHomeSubClusterStoreInputValidator.validate(request);
        ReservationId reservationId = request.getReservationId();
        SubClusterId homeSubCluster = this.getReservation(reservationId);
        if (homeSubCluster == null) {
            String errMsg = "Reservation " + reservationId + " does not exist";
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        ReservationHomeSubCluster reservationHomeSubCluster = ReservationHomeSubCluster.newInstance(reservationId, homeSubCluster);
        long end = this.clock.getTime();
        this.opDurations.addGetReservationHomeSubClusterDuration(start, end);
        return GetReservationHomeSubClusterResponse.newInstance(reservationHomeSubCluster);
    }

    @Override
    public GetReservationsHomeSubClusterResponse getReservationsHomeSubCluster(GetReservationsHomeSubClusterRequest request) throws YarnException {
        long start = this.clock.getTime();
        ArrayList<ReservationHomeSubCluster> result = new ArrayList<ReservationHomeSubCluster>();
        try {
            for (String child : this.zkManager.getChildren(this.reservationsZNode)) {
                ReservationId reservationId = ReservationId.parseReservationId((String)child);
                SubClusterId homeSubCluster = this.getReservation(reservationId);
                ReservationHomeSubCluster app = ReservationHomeSubCluster.newInstance(reservationId, homeSubCluster);
                result.add(app);
            }
        }
        catch (Exception e) {
            String errMsg = "Cannot get apps: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        long end = this.clock.getTime();
        this.opDurations.addGetReservationsHomeSubClusterDuration(start, end);
        return GetReservationsHomeSubClusterResponse.newInstance(result);
    }

    @Override
    public DeleteReservationHomeSubClusterResponse deleteReservationHomeSubCluster(DeleteReservationHomeSubClusterRequest request) throws YarnException {
        String errMsg;
        long start = this.clock.getTime();
        FederationReservationHomeSubClusterStoreInputValidator.validate(request);
        ReservationId reservationId = request.getReservationId();
        String reservationZNode = ZKCuratorManager.getNodePath((String)this.reservationsZNode, (String)reservationId.toString());
        boolean exists = false;
        try {
            exists = this.zkManager.exists(reservationZNode);
        }
        catch (Exception e) {
            errMsg = "Cannot check reservation: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        if (!exists) {
            String errMsg2 = "Reservation " + reservationId + " does not exist";
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg2);
        }
        try {
            this.zkManager.delete(reservationZNode);
        }
        catch (Exception e) {
            errMsg = "Cannot delete reservation: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        long end = this.clock.getTime();
        this.opDurations.addDeleteReservationHomeSubClusterDuration(start, end);
        return DeleteReservationHomeSubClusterResponse.newInstance();
    }

    @Override
    public UpdateReservationHomeSubClusterResponse updateReservationHomeSubCluster(UpdateReservationHomeSubClusterRequest request) throws YarnException {
        long start = this.clock.getTime();
        FederationReservationHomeSubClusterStoreInputValidator.validate(request);
        ReservationHomeSubCluster reservationHomeSubCluster = request.getReservationHomeSubCluster();
        ReservationId reservationId = reservationHomeSubCluster.getReservationId();
        SubClusterId homeSubCluster = this.getReservation(reservationId);
        if (homeSubCluster == null) {
            String errMsg = "Reservation " + reservationId + " does not exist";
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        SubClusterId newSubClusterId = reservationHomeSubCluster.getHomeSubCluster();
        this.putReservation(reservationId, newSubClusterId, true);
        long end = this.clock.getTime();
        this.opDurations.addUpdateReservationHomeSubClusterDuration(start, end);
        return UpdateReservationHomeSubClusterResponse.newInstance();
    }

    @Override
    public RouterMasterKeyResponse storeNewMasterKey(RouterMasterKeyRequest request) throws YarnException, IOException {
        long start = this.clock.getTime();
        FederationRouterRMTokenInputValidator.validate(request);
        DelegationKey delegationKey = this.convertMasterKeyToDelegationKey(request);
        String nodeCreatePath = this.getMasterKeyZNodePathByDelegationKey(delegationKey);
        LOG.debug("Storing RMDelegationKey_{}, ZkNodePath = {}.", (Object)delegationKey.getKeyId(), (Object)nodeCreatePath);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();
             DataOutputStream fsOut = new DataOutputStream(os);){
            delegationKey.write((DataOutput)fsOut);
            this.put(nodeCreatePath, os.toByteArray(), false);
        }
        RouterMasterKey masterKeyFromZK = this.getRouterMasterKeyFromZK(nodeCreatePath);
        long end = this.clock.getTime();
        this.opDurations.addStoreNewMasterKeyDuration(start, end);
        return RouterMasterKeyResponse.newInstance(masterKeyFromZK);
    }

    @Override
    public RouterMasterKeyResponse removeStoredMasterKey(RouterMasterKeyRequest request) throws YarnException, IOException {
        long start = this.clock.getTime();
        FederationRouterRMTokenInputValidator.validate(request);
        try {
            RouterMasterKey masterKey = request.getRouterMasterKey();
            DelegationKey delegationKey = this.convertMasterKeyToDelegationKey(request);
            String nodeRemovePath = this.getMasterKeyZNodePathByDelegationKey(delegationKey);
            LOG.debug("Removing RMDelegationKey_{}, ZkNodePath = {}.", (Object)delegationKey.getKeyId(), (Object)nodeRemovePath);
            if (!this.exists(nodeRemovePath)) {
                throw new YarnException("ZkNodePath = " + nodeRemovePath + " not exists!");
            }
            this.zkManager.delete(nodeRemovePath);
            long end = this.clock.getTime();
            this.opDurations.removeStoredMasterKeyDuration(start, end);
            return RouterMasterKeyResponse.newInstance(masterKey);
        }
        catch (Exception e) {
            throw new YarnException((Throwable)e);
        }
    }

    @Override
    public RouterMasterKeyResponse getMasterKeyByDelegationKey(RouterMasterKeyRequest request) throws YarnException, IOException {
        long start = this.clock.getTime();
        FederationRouterRMTokenInputValidator.validate(request);
        try {
            DelegationKey delegationKey = this.convertMasterKeyToDelegationKey(request);
            String nodePath = this.getMasterKeyZNodePathByDelegationKey(delegationKey);
            if (!this.exists(nodePath)) {
                throw new YarnException("ZkNodePath = " + nodePath + " not exists!");
            }
            RouterMasterKey routerMasterKey = this.getRouterMasterKeyFromZK(nodePath);
            long end = this.clock.getTime();
            this.opDurations.getMasterKeyByDelegationKeyDuration(start, end);
            return RouterMasterKeyResponse.newInstance(routerMasterKey);
        }
        catch (Exception e) {
            throw new YarnException((Throwable)e);
        }
    }

    private String getMasterKeyZNodePathByDelegationKey(DelegationKey delegationKey) {
        return this.getMasterKeyZNodePathByKeyId(delegationKey.getKeyId());
    }

    private String getMasterKeyZNodePathByKeyId(int keyId) {
        String nodeName = ROUTER_RM_DELEGATION_KEY_PREFIX + keyId;
        return ZKCuratorManager.getNodePath((String)this.routerRMDTMasterKeysRootPath, (String)nodeName);
    }

    private RouterMasterKey getRouterMasterKeyFromZK(String nodePath) throws IOException {
        try {
            byte[] data = this.get(nodePath);
            if (data == null || data.length == 0) {
                return null;
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            DataInputStream din = new DataInputStream(bin);
            DelegationKey key = new DelegationKey();
            key.readFields((DataInput)din);
            return RouterMasterKey.newInstance(key.getKeyId(), ByteBuffer.wrap(key.getEncodedKey()), key.getExpiryDate());
        }
        catch (Exception ex) {
            LOG.error("No node in path {}.", (Object)nodePath);
            throw new IOException(ex);
        }
    }

    @Override
    public RouterRMTokenResponse storeNewToken(RouterRMTokenRequest request) throws YarnException, IOException {
        long start = this.clock.getTime();
        FederationRouterRMTokenInputValidator.validate(request);
        try {
            this.storeOrUpdateRouterRMDT(request, false);
            RouterStoreToken resultStoreToken = this.getStoreTokenFromZK(request);
            long end = this.clock.getTime();
            this.opDurations.getStoreNewTokenDuration(start, end);
            return RouterRMTokenResponse.newInstance(resultStoreToken);
        }
        catch (IOException | YarnException e) {
            throw e;
        }
        catch (Exception e) {
            throw new YarnException((Throwable)e);
        }
    }

    @Override
    public RouterRMTokenResponse updateStoredToken(RouterRMTokenRequest request) throws YarnException, IOException {
        long start = this.clock.getTime();
        FederationRouterRMTokenInputValidator.validate(request);
        try {
            String nodePath = this.getStoreTokenZNodePathByTokenRequest(request);
            boolean pathExists = true;
            if (!this.exists(nodePath)) {
                pathExists = false;
            }
            if (pathExists) {
                this.storeOrUpdateRouterRMDT(request, true);
            } else {
                this.storeNewToken(request);
            }
            RouterStoreToken resultStoreToken = this.getStoreTokenFromZK(request);
            long end = this.clock.getTime();
            this.opDurations.updateStoredTokenDuration(start, end);
            return RouterRMTokenResponse.newInstance(resultStoreToken);
        }
        catch (IOException | YarnException e) {
            throw e;
        }
        catch (Exception e) {
            throw new YarnException((Throwable)e);
        }
    }

    @Override
    public RouterRMTokenResponse removeStoredToken(RouterRMTokenRequest request) throws YarnException, IOException {
        long start = this.clock.getTime();
        FederationRouterRMTokenInputValidator.validate(request);
        try {
            String nodePath = this.getStoreTokenZNodePathByTokenRequest(request);
            if (!this.exists(nodePath)) {
                throw new YarnException("ZkNodePath = " + nodePath + " not exists!");
            }
            RouterStoreToken storeToken = this.getStoreTokenFromZK(request);
            if (storeToken != null) {
                this.zkManager.delete(nodePath);
            }
            long end = this.clock.getTime();
            this.opDurations.removeStoredTokenDuration(start, end);
            return RouterRMTokenResponse.newInstance(storeToken);
        }
        catch (IOException | YarnException e) {
            throw e;
        }
        catch (Exception e) {
            throw new YarnException((Throwable)e);
        }
    }

    @Override
    public RouterRMTokenResponse getTokenByRouterStoreToken(RouterRMTokenRequest request) throws YarnException, IOException {
        long start = this.clock.getTime();
        FederationRouterRMTokenInputValidator.validate(request);
        try {
            String nodePath = this.getStoreTokenZNodePathByTokenRequest(request);
            if (!this.exists(nodePath)) {
                throw new YarnException("ZkNodePath = " + nodePath + " not exists!");
            }
            RouterStoreToken resultStoreToken = this.getStoreTokenFromZK(request);
            long end = this.clock.getTime();
            this.opDurations.getTokenByRouterStoreTokenDuration(start, end);
            return RouterRMTokenResponse.newInstance(resultStoreToken);
        }
        catch (IOException | YarnException e) {
            throw e;
        }
        catch (Exception e) {
            throw new YarnException((Throwable)e);
        }
    }

    private DelegationKey convertMasterKeyToDelegationKey(RouterMasterKeyRequest request) {
        RouterMasterKey masterKey = request.getRouterMasterKey();
        return this.convertMasterKeyToDelegationKey(masterKey);
    }

    private DelegationKey convertMasterKeyToDelegationKey(RouterMasterKey masterKey) {
        ByteBuffer keyByteBuf = masterKey.getKeyBytes();
        byte[] keyBytes = new byte[keyByteBuf.remaining()];
        keyByteBuf.get(keyBytes);
        return new DelegationKey(masterKey.getKeyId().intValue(), masterKey.getExpiryDate().longValue(), keyBytes);
    }

    @VisibleForTesting
    boolean exists(String path) throws Exception {
        return this.zkManager.exists(path);
    }

    private void storeOrUpdateRouterRMDT(RouterRMTokenRequest request, boolean isUpdate) throws Exception {
        RouterStoreToken routerStoreToken = request.getRouterStoreToken();
        String nodeCreatePath = this.getStoreTokenZNodePathByTokenRequest(request);
        LOG.debug("nodeCreatePath = {}, isUpdate = {}", (Object)nodeCreatePath, (Object)isUpdate);
        this.put(nodeCreatePath, routerStoreToken.toByteArray(), isUpdate);
    }

    private String getStoreTokenZNodePathByTokenRequest(RouterRMTokenRequest request) throws IOException {
        RouterStoreToken routerStoreToken = request.getRouterStoreToken();
        YARNDelegationTokenIdentifier identifier = routerStoreToken.getTokenIdentifier();
        return this.getStoreTokenZNodePathByIdentifier(identifier);
    }

    private String getStoreTokenZNodePathByIdentifier(YARNDelegationTokenIdentifier identifier) {
        String nodePath = ZKCuratorManager.getNodePath((String)this.routerRMDelegationTokensRootPath, (String)(ROUTER_RM_DELEGATION_TOKEN_PREFIX + identifier.getSequenceNumber()));
        return nodePath;
    }

    private RouterStoreToken getStoreTokenFromZK(RouterRMTokenRequest request) throws IOException {
        RouterStoreToken routerStoreToken = request.getRouterStoreToken();
        YARNDelegationTokenIdentifier identifier = routerStoreToken.getTokenIdentifier();
        return this.getStoreTokenFromZK(identifier);
    }

    private RouterStoreToken getStoreTokenFromZK(YARNDelegationTokenIdentifier identifier) throws IOException {
        String nodePath = this.getStoreTokenZNodePathByIdentifier(identifier);
        return this.getStoreTokenFromZK(nodePath);
    }

    private RouterStoreToken getStoreTokenFromZK(String nodePath) throws IOException {
        try {
            byte[] data = this.get(nodePath);
            if (data == null || data.length == 0) {
                return null;
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            DataInputStream din = new DataInputStream(bin);
            RouterStoreToken storeToken = (RouterStoreToken)Records.newRecord(RouterStoreToken.class);
            storeToken.readFields(din);
            return storeToken;
        }
        catch (Exception ex) {
            LOG.error("No node in path [{}]", (Object)nodePath, (Object)ex);
            throw new IOException(ex);
        }
    }

    @Override
    public int incrementDelegationTokenSeqNum() {
        if (this.currentSeqNum >= this.currentMaxSeqNum) {
            try {
                this.currentSeqNum = this.incrSharedCount(this.delTokSeqCounter, this.seqNumBatchSize);
                this.currentMaxSeqNum = this.currentSeqNum + this.seqNumBatchSize;
                LOG.info("Fetched new range of seq num, from {} to {} ", (Object)(this.currentSeqNum + 1), (Object)this.currentMaxSeqNum);
            }
            catch (InterruptedException e) {
                LOG.debug("Thread interrupted while performing token counter increment", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not increment shared counter !!", e);
            }
        }
        return ++this.currentSeqNum;
    }

    private int incrSharedCount(SharedCount sharedCount, int batchSize) throws Exception {
        VersionedValue versionedValue;
        while (!sharedCount.trySetCount(versionedValue = sharedCount.getVersionedValue(), (Integer)versionedValue.getValue() + batchSize)) {
        }
        return (Integer)versionedValue.getValue();
    }

    @Override
    public int getDelegationTokenSeqNum() {
        return this.delTokSeqCounter.getCount();
    }

    @Override
    public void setDelegationTokenSeqNum(int seqNum) {
        try {
            this.delTokSeqCounter.setCount(seqNum);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set shared counter !!", e);
        }
    }

    @Override
    public int getCurrentKeyId() {
        return this.keyIdSeqCounter.getCount();
    }

    @Override
    public int incrementCurrentKeyId() {
        try {
            this.incrSharedCount(this.keyIdSeqCounter, 1);
        }
        catch (InterruptedException e) {
            LOG.debug("Thread interrupted while performing Master keyId increment", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not increment shared Master keyId counter !!", e);
        }
        return this.keyIdSeqCounter.getCount();
    }
}

