/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.records;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class ApplicationHomeSubCluster {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ApplicationHomeSubCluster newInstance(ApplicationId appId, SubClusterId homeSubCluster) {
        ApplicationHomeSubCluster appMapping = (ApplicationHomeSubCluster)Records.newRecord(ApplicationHomeSubCluster.class);
        appMapping.setApplicationId(appId);
        appMapping.setHomeSubCluster(homeSubCluster);
        return appMapping;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ApplicationHomeSubCluster newInstance(ApplicationId appId, long createTime, SubClusterId homeSubCluster) {
        ApplicationHomeSubCluster appMapping = (ApplicationHomeSubCluster)Records.newRecord(ApplicationHomeSubCluster.class);
        appMapping.setApplicationId(appId);
        appMapping.setHomeSubCluster(homeSubCluster);
        appMapping.setCreateTime(createTime);
        return appMapping;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ApplicationId getApplicationId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setApplicationId(ApplicationId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract SubClusterId getHomeSubCluster();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setHomeSubCluster(SubClusterId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract long getCreateTime();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setCreateTime(long var1);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ApplicationHomeSubCluster) {
            ApplicationHomeSubCluster other = (ApplicationHomeSubCluster)obj;
            return new EqualsBuilder().append((Object)this.getApplicationId(), (Object)other.getApplicationId()).append((Object)this.getHomeSubCluster(), (Object)other.getHomeSubCluster()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getApplicationId()).append((Object)this.getHomeSubCluster()).append(this.getCreateTime()).toHashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ApplicationHomeSubCluster: [").append("ApplicationId: ").append(this.getApplicationId()).append(", ").append("HomeSubCluster: ").append(this.getHomeSubCluster()).append(", ").append("CreateTime: ").append(this.getCreateTime()).append(", ").append("]");
        return sb.toString();
    }
}

