/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;

public class ComputeFairShares {
    private static final int COMPUTE_FAIR_SHARES_ITERATIONS = 25;

    public static void computeShares(Collection<? extends Schedulable> schedulables, Resource totalResources, ResourceType type) {
        ComputeFairShares.computeSharesInternal(schedulables, totalResources, type, false);
    }

    public static void computeSteadyShares(Collection<? extends FSQueue> queues, Resource totalResources, ResourceType type) {
        ComputeFairShares.computeSharesInternal(queues, totalResources, type, true);
    }

    private static void computeSharesInternal(Collection<? extends Schedulable> allSchedulables, Resource totalResources, ResourceType type, boolean isSteadyShare) {
        Schedulable sched;
        long maxShare;
        ArrayList<Schedulable> schedulables = new ArrayList<Schedulable>();
        int takenResources = ComputeFairShares.handleFixedFairShares(allSchedulables, schedulables, isSteadyShare, type);
        if (schedulables.isEmpty()) {
            return;
        }
        int totalMaxShare = 0;
        Iterator i$ = schedulables.iterator();
        while (i$.hasNext() && (totalMaxShare = (int)Math.min((maxShare = ComputeFairShares.getResourceValue((sched = (Schedulable)i$.next()).getMaxShare(), type)) + (long)totalMaxShare, Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
        }
        long totalResource = Math.max(ComputeFairShares.getResourceValue(totalResources, type) - (long)takenResources, 0L);
        totalResource = Math.min((long)totalMaxShare, totalResource);
        double rMax = 1.0;
        while ((long)ComputeFairShares.resourceUsedWithWeightToResourceRatio(rMax, schedulables, type) < totalResource) {
            rMax *= 2.0;
        }
        double left = 0.0;
        double right = rMax;
        for (int i = 0; i < 25; ++i) {
            double mid = (left + right) / 2.0;
            int plannedResourceUsed = ComputeFairShares.resourceUsedWithWeightToResourceRatio(mid, schedulables, type);
            if ((long)plannedResourceUsed == totalResource) {
                right = mid;
                break;
            }
            if ((long)plannedResourceUsed < totalResource) {
                left = mid;
                continue;
            }
            right = mid;
        }
        for (Schedulable sched2 : schedulables) {
            if (isSteadyShare) {
                ComputeFairShares.setResourceValue(ComputeFairShares.computeShare(sched2, right, type), ((FSQueue)sched2).getSteadyFairShare(), type);
                continue;
            }
            ComputeFairShares.setResourceValue(ComputeFairShares.computeShare(sched2, right, type), sched2.getFairShare(), type);
        }
    }

    private static int resourceUsedWithWeightToResourceRatio(double w2rRatio, Collection<? extends Schedulable> schedulables, ResourceType type) {
        int resourcesTaken = 0;
        for (Schedulable schedulable : schedulables) {
            int share = ComputeFairShares.computeShare(schedulable, w2rRatio, type);
            resourcesTaken += share;
        }
        return resourcesTaken;
    }

    private static int computeShare(Schedulable sched, double w2rRatio, ResourceType type) {
        double share = (double)sched.getWeights().getWeight(type) * w2rRatio;
        share = Math.max(share, (double)ComputeFairShares.getResourceValue(sched.getMinShare(), type));
        share = Math.min(share, (double)ComputeFairShares.getResourceValue(sched.getMaxShare(), type));
        return (int)share;
    }

    private static int handleFixedFairShares(Collection<? extends Schedulable> schedulables, Collection<Schedulable> nonFixedSchedulables, boolean isSteadyShare, ResourceType type) {
        int totalResource = 0;
        for (Schedulable schedulable : schedulables) {
            long fixedShare = ComputeFairShares.getFairShareIfFixed(schedulable, isSteadyShare, type);
            if (fixedShare < 0L) {
                nonFixedSchedulables.add(schedulable);
                continue;
            }
            ComputeFairShares.setResourceValue(fixedShare, isSteadyShare ? ((FSQueue)schedulable).getSteadyFairShare() : schedulable.getFairShare(), type);
            totalResource = (int)Math.min((long)totalResource + fixedShare, Integer.MAX_VALUE);
        }
        return totalResource;
    }

    private static long getFairShareIfFixed(Schedulable sched, boolean isSteadyShare, ResourceType type) {
        if (ComputeFairShares.getResourceValue(sched.getMaxShare(), type) <= 0L) {
            return 0L;
        }
        if (!isSteadyShare && sched instanceof FSQueue && !((FSQueue)sched).isActive()) {
            return 0L;
        }
        if (sched.getWeights().getWeight(type) <= 0.0f) {
            long minShare = ComputeFairShares.getResourceValue(sched.getMinShare(), type);
            return minShare <= 0L ? 0L : minShare;
        }
        return -1L;
    }

    private static long getResourceValue(Resource resource, ResourceType type) {
        switch (type) {
            case MEMORY: {
                return resource.getMemorySize();
            }
            case CPU: {
                return resource.getVirtualCores();
            }
        }
        throw new IllegalArgumentException("Invalid resource");
    }

    private static void setResourceValue(long val, Resource resource, ResourceType type) {
        switch (type) {
            case MEMORY: {
                resource.setMemorySize(val);
                break;
            }
            case CPU: {
                resource.setVirtualCores((int)val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid resource");
            }
        }
    }
}

