/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;

public final class MappingRuleValidationHelper {
    private MappingRuleValidationHelper() {
    }

    public static String normalizeQueuePathRoot(CapacitySchedulerQueueManager queueManager, String fullPath) throws YarnException {
        ArrayList<String> parts = new ArrayList<String>();
        Collections.addAll(parts, fullPath.split("\\."));
        String pathRoot = (String)parts.get(0);
        CSQueue pathRootQueue = queueManager.getQueue(pathRoot);
        if (pathRootQueue == null) {
            if (queueManager.isAmbiguous(pathRoot)) {
                throw new YarnException("Path root '" + pathRoot + "' is ambiguous. Path '" + fullPath + "' is invalid");
            }
            throw new YarnException("Path root '" + pathRoot + "' does not exist. Path '" + fullPath + "' is invalid");
        }
        parts.set(0, pathRootQueue.getQueuePath());
        return String.join((CharSequence)".", parts);
    }

    public static ValidationResult validateQueuePathAutoCreation(CapacitySchedulerQueueManager queueManager, String path) {
        String grandParentPath;
        if (path == null || path.isEmpty()) {
            return ValidationResult.EMPTY_PATH;
        }
        if (queueManager.getQueue(path) != null) {
            return ValidationResult.QUEUE_EXISTS;
        }
        if (queueManager.isAmbiguous(path)) {
            return ValidationResult.AMBIGUOUS_QUEUE;
        }
        ArrayList parts = new ArrayList();
        Collections.addAll(parts, path.split("\\."));
        parts.remove(parts.size() - 1);
        String parentPath = parts.size() >= 1 ? String.join((CharSequence)".", parts) : "";
        parts.remove(parts.size() - 1);
        String string = grandParentPath = parts.size() >= 1 ? String.join((CharSequence)".", parts) : "";
        if (parentPath.isEmpty()) {
            return ValidationResult.NO_PARENT_PROVIDED;
        }
        if (queueManager.isAmbiguous(parentPath)) {
            return ValidationResult.AMBIGUOUS_PARENT;
        }
        CSQueue parentQueue = queueManager.getQueue(parentPath);
        if (parentQueue == null) {
            if (grandParentPath.isEmpty()) {
                return ValidationResult.NO_PARENT_PROVIDED;
            }
            if (queueManager.isAmbiguous(grandParentPath)) {
                return ValidationResult.AMBIGUOUS_PARENT;
            }
            CSQueue grandParentQueue = queueManager.getQueue(grandParentPath);
            if (grandParentQueue != null && grandParentQueue instanceof ParentQueue && ((ParentQueue)grandParentQueue).isEligibleForAutoQueueCreation()) {
                return ValidationResult.CREATABLE;
            }
            return ValidationResult.NO_DYNAMIC_PARENT;
        }
        if (parentQueue instanceof ManagedParentQueue) {
            return ValidationResult.CREATABLE;
        }
        if (parentQueue instanceof ParentQueue && ((ParentQueue)parentQueue).isEligibleForAutoQueueCreation()) {
            return ValidationResult.CREATABLE;
        }
        return ValidationResult.NO_DYNAMIC_PARENT;
    }

    public static enum ValidationResult {
        CREATABLE,
        QUEUE_EXISTS,
        NO_PARENT_PROVIDED,
        NO_DYNAMIC_PARENT,
        AMBIGUOUS_PARENT,
        AMBIGUOUS_QUEUE,
        EMPTY_PATH;

    }
}

