/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.SecretKey;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEvent;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.blacklist.BlacklistManager;
import org.apache.hadoop.yarn.server.resourcemanager.blacklist.DisabledBlacklistManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFailedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AggregateAppResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppStartAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptRegistrationEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptStatusupdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptUnregistrationEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeFinishedContainersPulledByAMEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerUpdates;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.webproxy.ProxyUriUtils;
import org.apache.hadoop.yarn.state.InvalidStateTransitionException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.BoundedAppender;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMAppAttemptImpl
implements RMAppAttempt,
Recoverable {
    private static final String STATE_CHANGE_MESSAGE = "%s State change from %s to %s on event = %s";
    private static final String RECOVERY_MESSAGE = "Recovering attempt: %s with final state = %s";
    private static final String DIAGNOSTIC_LIMIT_CONFIG_ERROR_MESSAGE = "The value of %s should be a positive integer: %s";
    private static final Logger LOG = LoggerFactory.getLogger(RMAppAttemptImpl.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    public static final Priority AM_CONTAINER_PRIORITY = (Priority)recordFactory.newRecordInstance(Priority.class);
    private final StateMachine<RMAppAttemptState, RMAppAttemptEventType, RMAppAttemptEvent> stateMachine;
    private final RMContext rmContext;
    private final EventHandler eventHandler;
    private final YarnScheduler scheduler;
    private final ApplicationMasterService masterService;
    private final RMApp rmApp;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ApplicationAttemptId applicationAttemptId;
    private final ApplicationSubmissionContext submissionContext;
    private Token<AMRMTokenIdentifier> amrmToken = null;
    private volatile Integer amrmTokenKeyId = null;
    private SecretKey clientTokenMasterKey = null;
    private ConcurrentMap<NodeId, List<ContainerStatus>> justFinishedContainers = new ConcurrentHashMap<NodeId, List<ContainerStatus>>();
    private ConcurrentMap<NodeId, List<ContainerStatus>> finishedContainersSentToAM = new ConcurrentHashMap<NodeId, List<ContainerStatus>>();
    private volatile Container masterContainer;
    private float progress = 0.0f;
    private String host = "N/A";
    private int rpcPort = -1;
    private String originalTrackingUrl = "N/A";
    private String proxiedTrackingUrl = "N/A";
    private long startTime = 0L;
    private long finishTime = 0L;
    private long launchAMStartTime = 0L;
    private long launchAMEndTime = 0L;
    private long scheduledTime = 0L;
    private long containerAllocatedTime = 0L;
    private boolean nonWorkPreservingAMContainerFinished = false;
    private FinalApplicationStatus finalStatus = null;
    private final BoundedAppender diagnostics;
    private int amContainerExitStatus = -1000;
    private Configuration conf;
    private static final ExpiredTransition EXPIRED_TRANSITION;
    private static final AttemptFailedTransition FAILED_TRANSITION;
    private static final AMRegisteredTransition REGISTERED_TRANSITION;
    private static final AMLaunchedTransition LAUNCHED_TRANSITION;
    private RMAppAttemptEvent eventCausingFinalSaving;
    private RMAppAttemptState targetedFinalState;
    private RMAppAttemptState recoveredFinalState;
    private RMAppAttemptState stateBeforeFinalSaving;
    private Object transitionTodo;
    private RMAppAttemptMetrics attemptMetrics = null;
    private List<ResourceRequest> amReqs = null;
    private BlacklistManager blacklistedNodesForAM = null;
    private String amLaunchDiagnostics;
    private static final StateMachineFactory<RMAppAttemptImpl, RMAppAttemptState, RMAppAttemptEventType, RMAppAttemptEvent> stateMachineFactory;
    private static final List<ContainerId> EMPTY_CONTAINER_RELEASE_LIST;
    private static final List<ResourceRequest> EMPTY_CONTAINER_REQUEST_LIST;

    public RMAppAttemptImpl(ApplicationAttemptId appAttemptId, RMContext rmContext, YarnScheduler scheduler, ApplicationMasterService masterService, ApplicationSubmissionContext submissionContext, Configuration conf, List<ResourceRequest> amReqs, RMApp rmApp) {
        this(appAttemptId, rmContext, scheduler, masterService, submissionContext, conf, amReqs, rmApp, new DisabledBlacklistManager());
    }

    public RMAppAttemptImpl(ApplicationAttemptId appAttemptId, RMContext rmContext, YarnScheduler scheduler, ApplicationMasterService masterService, ApplicationSubmissionContext submissionContext, Configuration conf, List<ResourceRequest> amReqs, RMApp rmApp, BlacklistManager amBlacklistManager) {
        this.conf = conf;
        this.applicationAttemptId = appAttemptId;
        this.rmContext = rmContext;
        this.eventHandler = rmContext.getDispatcher().getEventHandler();
        this.submissionContext = submissionContext;
        this.scheduler = scheduler;
        this.masterService = masterService;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.proxiedTrackingUrl = rmContext.getAppProxyUrl(conf, appAttemptId.getApplicationId());
        this.stateMachine = stateMachineFactory.make((Object)this);
        this.attemptMetrics = new RMAppAttemptMetrics(this.applicationAttemptId, rmContext);
        this.amReqs = amReqs;
        this.blacklistedNodesForAM = amBlacklistManager;
        int diagnosticsLimitKC = this.getDiagnosticsLimitKCOrThrow(conf);
        LOG.debug("{} : {}", (Object)"yarn.app.attempt.diagnostics.limit.kc", (Object)diagnosticsLimitKC);
        this.diagnostics = new BoundedAppender(diagnosticsLimitKC * 1024);
        this.rmApp = rmApp;
    }

    private int getDiagnosticsLimitKCOrThrow(Configuration configuration) {
        try {
            int diagnosticsLimitKC = configuration.getInt("yarn.app.attempt.diagnostics.limit.kc", 64);
            if (diagnosticsLimitKC <= 0) {
                String message = String.format(DIAGNOSTIC_LIMIT_CONFIG_ERROR_MESSAGE, "yarn.app.attempt.diagnostics.limit.kc", diagnosticsLimitKC);
                LOG.error(message);
                throw new YarnRuntimeException(message);
            }
            return diagnosticsLimitKC;
        }
        catch (NumberFormatException ignored) {
            String diagnosticsLimitKCString = configuration.get("yarn.app.attempt.diagnostics.limit.kc");
            String message = String.format(DIAGNOSTIC_LIMIT_CONFIG_ERROR_MESSAGE, "yarn.app.attempt.diagnostics.limit.kc", diagnosticsLimitKCString);
            LOG.error(message);
            throw new YarnRuntimeException(message);
        }
    }

    @Override
    public ApplicationAttemptId getAppAttemptId() {
        return this.applicationAttemptId;
    }

    @Override
    public ApplicationSubmissionContext getSubmissionContext() {
        return this.submissionContext;
    }

    @Override
    public FinalApplicationStatus getFinalApplicationStatus() {
        this.readLock.lock();
        try {
            FinalApplicationStatus finalApplicationStatus = this.finalStatus;
            return finalApplicationStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public RMAppAttemptState getAppAttemptState() {
        this.readLock.lock();
        try {
            RMAppAttemptState rMAppAttemptState = (RMAppAttemptState)this.stateMachine.getCurrentState();
            return rMAppAttemptState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getHost() {
        this.readLock.lock();
        try {
            String string = this.host;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getRpcPort() {
        this.readLock.lock();
        try {
            int n = this.rpcPort;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getTrackingUrl() {
        this.readLock.lock();
        try {
            String string = this.getSubmissionContext().getUnmanagedAM() ? this.originalTrackingUrl : this.proxiedTrackingUrl;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getOriginalTrackingUrl() {
        this.readLock.lock();
        try {
            String string = this.originalTrackingUrl;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getWebProxyBase() {
        this.readLock.lock();
        try {
            String string = ProxyUriUtils.getPath((ApplicationId)this.applicationAttemptId.getApplicationId());
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void setTrackingUrlToRMAppPage(RMAppAttemptState stateToBeStored) {
        this.originalTrackingUrl = StringHelper.pjoin((Object[])new Object[]{WebAppUtils.getResolvedRMWebAppURLWithScheme((Configuration)this.conf), "cluster", "app", this.getAppAttemptId().getApplicationId()});
        switch (stateToBeStored) {
            case KILLED: 
            case FAILED: {
                this.proxiedTrackingUrl = this.originalTrackingUrl;
                break;
            }
        }
    }

    private void setTrackingUrlToAHSPage(RMAppAttemptState stateToBeStored) {
        this.originalTrackingUrl = StringHelper.pjoin((Object[])new Object[]{WebAppUtils.getHttpSchemePrefix((Configuration)this.conf) + WebAppUtils.getAHSWebAppURLWithoutScheme((Configuration)this.conf), "applicationhistory", "app", this.getAppAttemptId().getApplicationId()});
        switch (stateToBeStored) {
            case KILLED: 
            case FAILED: {
                this.proxiedTrackingUrl = this.originalTrackingUrl;
                break;
            }
        }
    }

    private void invalidateAMHostAndPort() {
        this.host = "N/A";
        this.rpcPort = -1;
    }

    @Override
    public SecretKey getClientTokenMasterKey() {
        return this.clientTokenMasterKey;
    }

    @Override
    public Token<AMRMTokenIdentifier> getAMRMToken() {
        this.readLock.lock();
        try {
            Token<AMRMTokenIdentifier> token = this.amrmToken;
            return token;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @InterfaceAudience.Private
    public void setAMRMToken(Token<AMRMTokenIdentifier> lastToken) {
        this.writeLock.lock();
        try {
            this.amrmToken = lastToken;
            this.amrmTokenKeyId = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @InterfaceAudience.Private
    public int getAMRMTokenKeyId() {
        Integer keyId = this.amrmTokenKeyId;
        if (keyId == null) {
            this.readLock.lock();
            try {
                if (this.amrmToken == null) {
                    throw new YarnRuntimeException("Missing AMRM token for " + this.applicationAttemptId);
                }
                this.amrmTokenKeyId = keyId = Integer.valueOf(((AMRMTokenIdentifier)this.amrmToken.decodeIdentifier()).getKeyId());
            }
            catch (IOException e) {
                throw new YarnRuntimeException("AMRM token decode error for " + this.applicationAttemptId, (Throwable)e);
            }
            finally {
                this.readLock.unlock();
            }
        }
        return keyId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token<ClientToAMTokenIdentifier> createClientToken(String client) {
        this.readLock.lock();
        try {
            Token token = null;
            ClientToAMTokenSecretManagerInRM secretMgr = this.rmContext.getClientToAMTokenSecretManager();
            if (client != null && secretMgr.getMasterKey(this.applicationAttemptId) != null) {
                token = new Token((TokenIdentifier)new ClientToAMTokenIdentifier(this.applicationAttemptId, client), (SecretManager)secretMgr);
            }
            Token token2 = token;
            return token2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getDiagnostics() {
        this.readLock.lock();
        try {
            if (this.diagnostics.length() == 0 && this.amLaunchDiagnostics != null) {
                String string = this.amLaunchDiagnostics;
                return string;
            }
            String string = this.diagnostics.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @VisibleForTesting
    void appendDiagnostics(CharSequence message) {
        this.diagnostics.append(message);
    }

    public int getAMContainerExitStatus() {
        this.readLock.lock();
        try {
            int n = this.amContainerExitStatus;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            float f = this.progress;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public List<ContainerStatus> getJustFinishedContainers() {
        this.readLock.lock();
        try {
            ArrayList returnList = new ArrayList();
            for (Collection containerStatusList : this.justFinishedContainers.values()) {
                returnList.addAll(containerStatusList);
            }
            ArrayList arrayList = returnList;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ConcurrentMap<NodeId, List<ContainerStatus>> getJustFinishedContainersReference() {
        this.readLock.lock();
        try {
            ConcurrentMap<NodeId, List<ContainerStatus>> concurrentMap = this.justFinishedContainers;
            return concurrentMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ConcurrentMap<NodeId, List<ContainerStatus>> getFinishedContainersSentToAMReference() {
        this.readLock.lock();
        try {
            ConcurrentMap<NodeId, List<ContainerStatus>> concurrentMap = this.finishedContainersSentToAM;
            return concurrentMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContainerStatus> pullJustFinishedContainers() {
        this.writeLock.lock();
        try {
            ArrayList<ContainerStatus> returnList = new ArrayList<ContainerStatus>();
            this.sendFinishedContainersToNM(this.finishedContainersSentToAM);
            boolean keepContainersAcrossAppAttempts = this.submissionContext.getKeepContainersAcrossApplicationAttempts();
            for (Map.Entry entry : this.justFinishedContainers.entrySet()) {
                NodeId nodeId = (NodeId)entry.getKey();
                List finishedContainers = (List)entry.getValue();
                if (finishedContainers.isEmpty()) continue;
                if (keepContainersAcrossAppAttempts) {
                    returnList.addAll(finishedContainers);
                } else {
                    for (ContainerStatus containerStatus : finishedContainers) {
                        if (!containerStatus.getContainerId().getApplicationAttemptId().equals((Object)this.getAppAttemptId())) continue;
                        returnList.add(containerStatus);
                    }
                }
                this.finishedContainersSentToAM.putIfAbsent(nodeId, new ArrayList());
                ((List)this.finishedContainersSentToAM.get(nodeId)).addAll(finishedContainers);
            }
            this.justFinishedContainers.clear();
            ArrayList<ContainerStatus> arrayList = returnList;
            return arrayList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Container getMasterContainer() {
        return this.masterContainer;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setMasterContainer(Container container) {
        this.masterContainer = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMAppAttemptEvent event) {
        this.writeLock.lock();
        try {
            ApplicationAttemptId appAttemptID = event.getApplicationAttemptId();
            LOG.debug("Processing event for {} of type {}", (Object)appAttemptID, (Object)event.getType());
            RMAppAttemptState oldState = this.getAppAttemptState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitionException e) {
                LOG.error("App attempt: " + appAttemptID + " can't handle this event at current state", (Throwable)e);
                this.onInvalidTranstion((RMAppAttemptEventType)event.getType(), oldState);
            }
            if (oldState != this.getAppAttemptState() && (this.recoveredFinalState == null || event.getType() != RMAppAttemptEventType.RECOVER)) {
                LOG.info(String.format(STATE_CHANGE_MESSAGE, new Object[]{appAttemptID, oldState, this.getAppAttemptState(), event.getType()}));
            } else if (oldState != this.getAppAttemptState() && LOG.isDebugEnabled()) {
                LOG.debug(String.format(STATE_CHANGE_MESSAGE, new Object[]{appAttemptID, oldState, this.getAppAttemptState(), event.getType()}));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationResourceUsageReport getApplicationResourceUsageReport() {
        this.readLock.lock();
        try {
            ApplicationResourceUsageReport report = this.scheduler.getAppResourceUsageReport(this.getAppAttemptId());
            if (report == null) {
                report = RMServerUtils.DUMMY_APPLICATION_RESOURCE_USAGE_REPORT;
            }
            AggregateAppResourceUsage resUsage = this.attemptMetrics.getAggregateAppResourceUsage();
            report.setResourceSecondsMap(resUsage.getResourceUsageSecondsMap());
            report.setPreemptedResourceSecondsMap(this.attemptMetrics.getPreemptedResourceSecondsMap());
            ApplicationResourceUsageReport applicationResourceUsageReport = report;
            return applicationResourceUsageReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void recover(RMStateStore.RMState state) {
        ApplicationStateData appState = state.getApplicationState().get(this.getAppAttemptId().getApplicationId());
        ApplicationAttemptStateData attemptState = appState.getAttempt(this.getAppAttemptId());
        assert (attemptState != null);
        if (attemptState.getState() == null) {
            LOG.info(String.format(RECOVERY_MESSAGE, this.getAppAttemptId(), "NONE"));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(String.format(RECOVERY_MESSAGE, new Object[]{this.getAppAttemptId(), attemptState.getState()}));
        }
        this.diagnostics.append((CharSequence)"Attempt recovered after RM restart");
        this.diagnostics.append((CharSequence)attemptState.getDiagnostics());
        this.amContainerExitStatus = attemptState.getAMContainerExitStatus();
        if (this.amContainerExitStatus == -102) {
            this.attemptMetrics.setIsPreempted();
        }
        Credentials credentials = attemptState.getAppAttemptTokens();
        this.setMasterContainer(attemptState.getMasterContainer());
        this.recoverAppAttemptCredentials(credentials, attemptState.getState());
        this.recoveredFinalState = attemptState.getState();
        this.originalTrackingUrl = attemptState.getFinalTrackingUrl();
        this.finalStatus = attemptState.getFinalApplicationStatus();
        this.startTime = attemptState.getStartTime();
        this.finishTime = attemptState.getFinishTime();
        this.attemptMetrics.updateAggregateAppResourceUsage(attemptState.getResourceSecondsMap());
        this.attemptMetrics.updateAggregatePreemptedAppResourceUsage(attemptState.getPreemptedResourceSecondsMap());
        this.attemptMetrics.setTotalAllocatedContainers(attemptState.getTotalAllocatedContainers());
    }

    public void transferStateFromAttempt(RMAppAttempt attempt) {
        this.justFinishedContainers = attempt.getJustFinishedContainersReference();
        this.finishedContainersSentToAM = attempt.getFinishedContainersSentToAMReference();
        if (!this.finishedContainersSentToAM.isEmpty()) {
            for (Map.Entry finishedContainer : this.finishedContainersSentToAM.entrySet()) {
                List containerStatuses = (List)finishedContainer.getValue();
                NodeId nodeId = (NodeId)finishedContainer.getKey();
                this.justFinishedContainers.putIfAbsent(nodeId, new ArrayList());
                ((List)this.justFinishedContainers.get(nodeId)).addAll(containerStatuses);
            }
            this.finishedContainersSentToAM.clear();
        }
    }

    private void recoverAppAttemptCredentials(Credentials appAttemptTokens, RMAppAttemptState state) {
        byte[] clientTokenMasterKeyBytes;
        if (appAttemptTokens == null || state == RMAppAttemptState.FAILED || state == RMAppAttemptState.FINISHED || state == RMAppAttemptState.KILLED) {
            return;
        }
        if (UserGroupInformation.isSecurityEnabled() && (clientTokenMasterKeyBytes = appAttemptTokens.getSecretKey(RMStateStore.AM_CLIENT_TOKEN_MASTER_KEY_NAME)) != null) {
            this.clientTokenMasterKey = this.rmContext.getClientToAMTokenSecretManager().registerMasterKey(this.applicationAttemptId, clientTokenMasterKeyBytes);
        }
        this.setAMRMToken(this.rmContext.getAMRMTokenSecretManager().createAndGetAMRMToken(this.applicationAttemptId));
    }

    private void retryFetchingAMContainer(final RMAppAttemptImpl appAttempt) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted while waiting to resend the ContainerAllocated Event.");
                }
                appAttempt.eventHandler.handle((Event)new RMAppAttemptEvent(appAttempt.applicationAttemptId, RMAppAttemptEventType.CONTAINER_ALLOCATED));
            }
        }.start();
    }

    private void rememberTargetTransitions(RMAppAttemptEvent event, Object transitionToDo, RMAppAttemptState targetFinalState) {
        this.transitionTodo = transitionToDo;
        this.targetedFinalState = targetFinalState;
        this.eventCausingFinalSaving = event;
    }

    private void rememberTargetTransitionsAndStoreState(RMAppAttemptEvent event, Object transitionToDo, RMAppAttemptState targetFinalState, RMAppAttemptState stateToBeStored) {
        this.rememberTargetTransitions(event, transitionToDo, targetFinalState);
        this.stateBeforeFinalSaving = this.getState();
        BoundedAppender diags = new BoundedAppender(this.diagnostics.getLimit());
        if (this.conf.getBoolean("yarn.timeline-service.generic-application-history.enabled", false)) {
            this.setTrackingUrlToAHSPage(stateToBeStored);
        } else {
            this.setTrackingUrlToRMAppPage(stateToBeStored);
        }
        String finalTrackingUrl = this.getOriginalTrackingUrl();
        FinalApplicationStatus finalStatus = null;
        int exitStatus = -1000;
        switch ((RMAppAttemptEventType)event.getType()) {
            case LAUNCH_FAILED: {
                diags.append((CharSequence)event.getDiagnosticMsg());
                break;
            }
            case REGISTERED: {
                diags.append((CharSequence)RMAppAttemptImpl.getUnexpectedAMRegisteredDiagnostics());
                break;
            }
            case UNREGISTERED: {
                RMAppAttemptUnregistrationEvent unregisterEvent = (RMAppAttemptUnregistrationEvent)event;
                diags.append((CharSequence)unregisterEvent.getDiagnosticMsg());
                finalTrackingUrl = RMAppAttemptImpl.sanitizeTrackingUrl(unregisterEvent.getFinalTrackingUrl());
                finalStatus = unregisterEvent.getFinalApplicationStatus();
                break;
            }
            case CONTAINER_FINISHED: {
                RMAppAttemptContainerFinishedEvent finishEvent = (RMAppAttemptContainerFinishedEvent)event;
                diags.append((CharSequence)this.getAMContainerCrashedDiagnostics(finishEvent));
                exitStatus = finishEvent.getContainerStatus().getExitStatus();
                break;
            }
            case KILL: {
                break;
            }
            case FAIL: {
                diags.append((CharSequence)event.getDiagnosticMsg());
                break;
            }
            case EXPIRE: {
                diags.append((CharSequence)RMAppAttemptImpl.getAMExpiredDiagnostics(event));
                break;
            }
        }
        AggregateAppResourceUsage resUsage = this.attemptMetrics.getAggregateAppResourceUsage();
        RMStateStore rmStore = this.rmContext.getStateStore();
        this.setFinishTime(System.currentTimeMillis());
        ApplicationAttemptStateData attemptState = ApplicationAttemptStateData.newInstance(this.applicationAttemptId, this.getMasterContainer(), rmStore.getCredentialsFromAppAttempt(this), this.startTime, stateToBeStored, finalTrackingUrl, diags.toString(), finalStatus, exitStatus, this.getFinishTime(), resUsage.getResourceUsageSecondsMap(), this.attemptMetrics.getPreemptedResourceSecondsMap(), this.attemptMetrics.getTotalAllocatedContainers());
        LOG.info("Updating application attempt " + this.applicationAttemptId + " with final state: " + (Object)((Object)this.targetedFinalState) + ", and exit status: " + exitStatus);
        rmStore.updateApplicationAttemptState(attemptState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldCountTowardsMaxAttemptRetry() {
        long attemptFailuresValidityInterval = this.submissionContext.getAttemptFailuresValidityInterval();
        long end = System.currentTimeMillis();
        if (attemptFailuresValidityInterval > 0L && this.getFinishTime() > 0L && this.getFinishTime() < end - attemptFailuresValidityInterval) {
            return false;
        }
        this.readLock.lock();
        try {
            int exitStatus = this.getAMContainerExitStatus();
            boolean bl = exitStatus != -102 && exitStatus != -100 && exitStatus != -101 && exitStatus != -106;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void registerClientToken() {
        if (UserGroupInformation.isSecurityEnabled()) {
            this.rmContext.getClientToAMTokenSecretManager().registerApplication(this.getAppAttemptId(), this.getClientTokenMasterKey());
        }
    }

    private void setAMContainerCrashedDiagnosticsAndExitStatus(RMAppAttemptContainerFinishedEvent finishEvent) {
        ContainerStatus status = finishEvent.getContainerStatus();
        this.diagnostics.append((CharSequence)this.getAMContainerCrashedDiagnostics(finishEvent));
        this.amContainerExitStatus = status.getExitStatus();
    }

    private String getAMContainerCrashedDiagnostics(RMAppAttemptContainerFinishedEvent finishEvent) {
        ContainerStatus status = finishEvent.getContainerStatus();
        StringBuilder diagnosticsBuilder = new StringBuilder();
        diagnosticsBuilder.append("AM Container for ").append(finishEvent.getApplicationAttemptId()).append(" exited with ").append(" exitCode: ").append(status.getExitStatus()).append("\n");
        diagnosticsBuilder.append("Failing this attempt.").append("Diagnostics: ").append(status.getDiagnostics());
        if (this.getTrackingUrl() != null) {
            diagnosticsBuilder.append("For more detailed output,").append(" check the application tracking page: ").append(this.getTrackingUrl()).append(" Then click on links to logs of each attempt.\n");
        }
        return diagnosticsBuilder.toString();
    }

    private static String getAMExpiredDiagnostics(RMAppAttemptEvent event) {
        String diag = "ApplicationMaster for attempt " + event.getApplicationAttemptId() + " timed out";
        return diag;
    }

    private static String getUnexpectedAMRegisteredDiagnostics() {
        return "Unmanaged AM must register after AM attempt reaches LAUNCHED state.";
    }

    private void updateInfoOnAMUnregister(RMAppAttemptEvent event) {
        this.progress = 1.0f;
        RMAppAttemptUnregistrationEvent unregisterEvent = (RMAppAttemptUnregistrationEvent)event;
        this.diagnostics.append((CharSequence)unregisterEvent.getDiagnosticMsg());
        this.originalTrackingUrl = RMAppAttemptImpl.sanitizeTrackingUrl(unregisterEvent.getFinalTrackingUrl());
        this.finalStatus = unregisterEvent.getFinalApplicationStatus();
    }

    private void sendFinishedAMContainerToNM(NodeId nodeId, ContainerId containerId) {
        ArrayList<ContainerId> containerIdList = new ArrayList<ContainerId>();
        containerIdList.add(containerId);
        this.eventHandler.handle((Event)new RMNodeFinishedContainersPulledByAMEvent(nodeId, containerIdList));
    }

    private void sendFinishedContainersToNM(Map<NodeId, List<ContainerStatus>> finishedContainers) {
        for (NodeId nodeId : finishedContainers.keySet()) {
            List currentSentContainers = finishedContainers.put(nodeId, new ArrayList());
            ArrayList<ContainerId> containerIdList = new ArrayList<ContainerId>(currentSentContainers.size());
            for (ContainerStatus containerStatus : currentSentContainers) {
                containerIdList.add(containerStatus.getContainerId());
            }
            this.eventHandler.handle((Event)new RMNodeFinishedContainersPulledByAMEvent(nodeId, containerIdList));
        }
        finishedContainers.clear();
    }

    private static void amContainerFinished(RMAppAttemptImpl appAttempt, RMAppAttemptContainerFinishedEvent containerFinishedEvent) {
        NodeId nodeId = containerFinishedEvent.getNodeId();
        ContainerStatus containerStatus = containerFinishedEvent.getContainerStatus();
        if (containerStatus != null) {
            int exitStatus = containerStatus.getExitStatus();
            if (Apps.shouldCountTowardsNodeBlacklisting((int)exitStatus)) {
                appAttempt.addAMNodeToBlackList(nodeId);
            }
        } else {
            LOG.warn("No ContainerStatus in containerFinishedEvent");
        }
        if (!appAttempt.getSubmissionContext().getKeepContainersAcrossApplicationAttempts()) {
            appAttempt.finishedContainersSentToAM.putIfAbsent(nodeId, new ArrayList());
            ((List)appAttempt.finishedContainersSentToAM.get(nodeId)).add(containerStatus);
            appAttempt.sendFinishedContainersToNM(appAttempt.finishedContainersSentToAM);
            appAttempt.sendFinishedContainersToNM(appAttempt.justFinishedContainers);
            appAttempt.nonWorkPreservingAMContainerFinished = true;
        } else {
            appAttempt.sendFinishedAMContainerToNM(nodeId, containerStatus.getContainerId());
        }
    }

    private void addAMNodeToBlackList(NodeId nodeId) {
        SchedulerNode schedulerNode = this.scheduler.getSchedulerNode(nodeId);
        if (schedulerNode != null) {
            this.blacklistedNodesForAM.addNode(schedulerNode.getNodeName());
        } else {
            LOG.info(nodeId + " is not added to AM blacklist for " + this.applicationAttemptId + ", because it has been removed");
        }
    }

    @Override
    public BlacklistManager getAMBlacklistManager() {
        return this.blacklistedNodesForAM;
    }

    private static void addJustFinishedContainer(RMAppAttemptImpl appAttempt, RMAppAttemptContainerFinishedEvent containerFinishedEvent) {
        appAttempt.justFinishedContainers.putIfAbsent(containerFinishedEvent.getNodeId(), new ArrayList());
        ((List)appAttempt.justFinishedContainers.get(containerFinishedEvent.getNodeId())).add(containerFinishedEvent.getContainerStatus());
        if (appAttempt.nonWorkPreservingAMContainerFinished) {
            appAttempt.sendFinishedContainersToNM(appAttempt.justFinishedContainers);
        }
    }

    @Override
    public long getStartTime() {
        this.readLock.lock();
        try {
            long l = this.startTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public RMAppAttemptState getState() {
        this.readLock.lock();
        try {
            RMAppAttemptState rMAppAttemptState = (RMAppAttemptState)this.stateMachine.getCurrentState();
            return rMAppAttemptState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public YarnApplicationAttemptState createApplicationAttemptState() {
        RMAppAttemptState state = this.getState();
        if (state.equals((Object)RMAppAttemptState.FINAL_SAVING)) {
            state = this.stateBeforeFinalSaving;
        }
        return RMServerUtils.createApplicationAttemptState(state);
    }

    private void launchAttempt() {
        this.launchAMStartTime = System.currentTimeMillis();
        this.eventHandler.handle((Event)new AMLauncherEvent(AMLauncherEventType.LAUNCH, this));
    }

    private void attemptLaunched() {
        this.rmContext.getAMLivelinessMonitor().register(this.getAppAttemptId());
    }

    private void storeAttempt() {
        LOG.info("Storing attempt: AppId: " + this.getAppAttemptId().getApplicationId() + " AttemptId: " + this.getAppAttemptId() + " MasterContainer: " + this.masterContainer);
        this.rmContext.getStateStore().storeNewApplicationAttempt(this);
    }

    private void removeCredentials(RMAppAttemptImpl appAttempt) {
        if (UserGroupInformation.isSecurityEnabled()) {
            appAttempt.rmContext.getClientToAMTokenSecretManager().unRegisterApplication(appAttempt.getAppAttemptId());
        }
        appAttempt.rmContext.getAMRMTokenSecretManager().applicationMasterFinished(appAttempt.getAppAttemptId());
    }

    private static String sanitizeTrackingUrl(String url) {
        return url == null || url.trim().isEmpty() ? "N/A" : url;
    }

    @Override
    public ApplicationAttemptReport createApplicationAttemptReport() {
        this.readLock.lock();
        ApplicationAttemptReport attemptReport = null;
        try {
            ContainerId amId = this.masterContainer == null ? null : this.masterContainer.getId();
            attemptReport = ApplicationAttemptReport.newInstance((ApplicationAttemptId)this.getAppAttemptId(), (String)this.getHost(), (int)this.getRpcPort(), (String)this.getTrackingUrl(), (String)this.getOriginalTrackingUrl(), (String)this.getDiagnostics(), (YarnApplicationAttemptState)this.createApplicationAttemptState(), (ContainerId)amId, (long)this.startTime, (long)this.finishTime);
        }
        finally {
            this.readLock.unlock();
        }
        return attemptReport;
    }

    @Override
    public RMAppAttemptMetrics getRMAppAttemptMetrics() {
        return this.attemptMetrics;
    }

    @Override
    public long getFinishTime() {
        this.readLock.lock();
        try {
            long l = this.finishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void setFinishTime(long finishTime) {
        this.writeLock.lock();
        try {
            this.finishTime = finishTime;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void updateAMLaunchDiagnostics(String amLaunchDiagnostics) {
        this.amLaunchDiagnostics = amLaunchDiagnostics;
    }

    public RMAppAttemptState getRecoveredFinalState() {
        return this.recoveredFinalState;
    }

    public void setRecoveredFinalState(RMAppAttemptState finalState) {
        this.recoveredFinalState = finalState;
    }

    @Override
    public Set<String> getBlacklistedNodes() {
        AbstractYarnScheduler ayScheduler;
        Object attempt;
        if (this.scheduler instanceof AbstractYarnScheduler && (attempt = (ayScheduler = (AbstractYarnScheduler)this.scheduler).getApplicationAttempt(this.applicationAttemptId)) != null) {
            return ((SchedulerApplicationAttempt)attempt).getBlacklistedNodes();
        }
        return Collections.emptySet();
    }

    protected void onInvalidTranstion(RMAppAttemptEventType rmAppAttemptEventType, RMAppAttemptState state) {
    }

    static {
        AM_CONTAINER_PRIORITY.setPriority(0);
        EXPIRED_TRANSITION = new ExpiredTransition();
        FAILED_TRANSITION = new AttemptFailedTransition();
        REGISTERED_TRANSITION = new AMRegisteredTransition();
        LAUNCHED_TRANSITION = new AMLaunchedTransition();
        stateMachineFactory = new StateMachineFactory((Enum)RMAppAttemptState.NEW).addTransition((Enum)RMAppAttemptState.NEW, (Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptEventType.START, (SingleArcTransition)new AttemptStartedTransition()).addTransition((Enum)RMAppAttemptState.NEW, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition(new BaseFinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.NEW, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.FAIL, (SingleArcTransition)new FinalSavingTransition(FAILED_TRANSITION, RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.NEW, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)new FinalSavingTransition(new UnexpectedAMRegisteredTransition(), RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.NEW, EnumSet.of(RMAppAttemptState.FINISHED, RMAppAttemptState.KILLED, RMAppAttemptState.FAILED, RMAppAttemptState.LAUNCHED), (Enum)RMAppAttemptEventType.RECOVER, (MultipleArcTransition)new AttemptRecoveredTransition()).addTransition((Enum)RMAppAttemptState.SUBMITTED, EnumSet.of(RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, RMAppAttemptState.SCHEDULED), (Enum)RMAppAttemptEventType.ATTEMPT_ADDED, (MultipleArcTransition)new ScheduleTransition()).addTransition((Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition(new BaseFinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.FAIL, (SingleArcTransition)new FinalSavingTransition(FAILED_TRANSITION, RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)new FinalSavingTransition(new UnexpectedAMRegisteredTransition(), RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.SCHEDULED, EnumSet.of(RMAppAttemptState.ALLOCATED_SAVING, RMAppAttemptState.SCHEDULED), (Enum)RMAppAttemptEventType.CONTAINER_ALLOCATED, (MultipleArcTransition)new AMContainerAllocatedTransition()).addTransition((Enum)RMAppAttemptState.SCHEDULED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition(new BaseFinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.SCHEDULED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.FAIL, (SingleArcTransition)new FinalSavingTransition(FAILED_TRANSITION, RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.SCHEDULED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (SingleArcTransition)new FinalSavingTransition(new AMContainerCrashedBeforeRunningTransition(), RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptEventType.ATTEMPT_NEW_SAVED, (SingleArcTransition)new AttemptStoredTransition()).addTransition((Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition(new BaseFinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (SingleArcTransition)new FinalSavingTransition(new AMContainerCrashedBeforeRunningTransition(), RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.FAIL, (SingleArcTransition)new FinalSavingTransition(FAILED_TRANSITION, RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, (Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptEventType.ATTEMPT_NEW_SAVED, (SingleArcTransition)new UnmanagedAMAttemptSavedTransition()).addTransition((Enum)RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)new FinalSavingTransition(new UnexpectedAMRegisteredTransition(), RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition(new BaseFinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.FAIL, (SingleArcTransition)new FinalSavingTransition(FAILED_TRANSITION, RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptEventType.LAUNCHED, (SingleArcTransition)LAUNCHED_TRANSITION).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.LAUNCH_FAILED, (SingleArcTransition)new FinalSavingTransition(new LaunchFailedTransition(), RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition(new KillAllocatedAMTransition(), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.FAIL, (SingleArcTransition)new FinalSavingTransition(FAILED_TRANSITION, RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)REGISTERED_TRANSITION).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (SingleArcTransition)new FinalSavingTransition(new AMContainerCrashedBeforeRunningTransition(), RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)REGISTERED_TRANSITION).addTransition((Enum)RMAppAttemptState.LAUNCHED, EnumSet.of(RMAppAttemptState.LAUNCHED, RMAppAttemptState.FINAL_SAVING), (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (MultipleArcTransition)new ContainerFinishedTransition(new AMContainerCrashedBeforeRunningTransition(), RMAppAttemptState.LAUNCHED)).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.EXPIRE, (SingleArcTransition)new FinalSavingTransition(EXPIRED_TRANSITION, RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition(new FinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.FAIL, (SingleArcTransition)new FinalSavingTransition(FAILED_TRANSITION, RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.RUNNING, EnumSet.of(RMAppAttemptEventType.LAUNCHED, RMAppAttemptEventType.REGISTERED)).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.UNREGISTERED, (SingleArcTransition)new AMUnregisteredTransition()).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.STATUS_UPDATE, (SingleArcTransition)new StatusUpdateTransition()).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.CONTAINER_ALLOCATED).addTransition((Enum)RMAppAttemptState.RUNNING, EnumSet.of(RMAppAttemptState.RUNNING, RMAppAttemptState.FINAL_SAVING), (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (MultipleArcTransition)new ContainerFinishedTransition(new AMContainerCrashedAtRunningTransition(), RMAppAttemptState.RUNNING)).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.EXPIRE, (SingleArcTransition)new FinalSavingTransition(EXPIRED_TRANSITION, RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition(new FinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.FAIL, (SingleArcTransition)new FinalSavingTransition(FAILED_TRANSITION, RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.FINAL_SAVING, EnumSet.of(RMAppAttemptState.FINISHING, RMAppAttemptState.FAILED, RMAppAttemptState.KILLED, RMAppAttemptState.FINISHED), (Enum)RMAppAttemptEventType.ATTEMPT_UPDATE_SAVED, (MultipleArcTransition)new FinalStateSavedTransition()).addTransition((Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (SingleArcTransition)new ContainerFinishedAtFinalSavingTransition()).addTransition((Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.EXPIRE, (SingleArcTransition)new AMExpiredAtFinalSavingTransition()).addTransition((Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, EnumSet.of(RMAppAttemptEventType.UNREGISTERED, new RMAppAttemptEventType[]{RMAppAttemptEventType.STATUS_UPDATE, RMAppAttemptEventType.LAUNCHED, RMAppAttemptEventType.LAUNCH_FAILED, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.ATTEMPT_NEW_SAVED, RMAppAttemptEventType.KILL, RMAppAttemptEventType.FAIL, RMAppAttemptEventType.ATTEMPT_ADDED})).addTransition((Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (SingleArcTransition)new ContainerFinishedAtFinalStateTransition()).addTransition((Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptState.FAILED, EnumSet.of(RMAppAttemptEventType.LAUNCHED, new RMAppAttemptEventType[]{RMAppAttemptEventType.LAUNCH_FAILED, RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.KILL, RMAppAttemptEventType.FAIL, RMAppAttemptEventType.REGISTERED, RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.STATUS_UPDATE, RMAppAttemptEventType.CONTAINER_ALLOCATED})).addTransition((Enum)RMAppAttemptState.FINISHING, EnumSet.of(RMAppAttemptState.FINISHING, RMAppAttemptState.FINISHED), (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (MultipleArcTransition)new AMFinishingContainerFinishedTransition()).addTransition((Enum)RMAppAttemptState.FINISHING, (Enum)RMAppAttemptState.FINISHED, (Enum)RMAppAttemptEventType.EXPIRE, (SingleArcTransition)new FinalTransition(RMAppAttemptState.FINISHED)).addTransition((Enum)RMAppAttemptState.FINISHING, (Enum)RMAppAttemptState.FINISHING, EnumSet.of(RMAppAttemptEventType.LAUNCHED, new RMAppAttemptEventType[]{RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.STATUS_UPDATE, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.KILL, RMAppAttemptEventType.FAIL})).addTransition((Enum)RMAppAttemptState.FINISHED, (Enum)RMAppAttemptState.FINISHED, EnumSet.of(RMAppAttemptEventType.LAUNCHED, new RMAppAttemptEventType[]{RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.KILL, RMAppAttemptEventType.FAIL})).addTransition((Enum)RMAppAttemptState.FINISHED, (Enum)RMAppAttemptState.FINISHED, (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (SingleArcTransition)new ContainerFinishedAtFinalStateTransition()).addTransition((Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptState.KILLED, EnumSet.of(RMAppAttemptEventType.ATTEMPT_ADDED, new RMAppAttemptEventType[]{RMAppAttemptEventType.LAUNCHED, RMAppAttemptEventType.LAUNCH_FAILED, RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.REGISTERED, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.KILL, RMAppAttemptEventType.FAIL, RMAppAttemptEventType.STATUS_UPDATE})).addTransition((Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (SingleArcTransition)new ContainerFinishedAtFinalStateTransition()).installTopology();
        EMPTY_CONTAINER_RELEASE_LIST = new ArrayList<ContainerId>();
        EMPTY_CONTAINER_REQUEST_LIST = new ArrayList<ResourceRequest>();
    }

    private static class AMExpiredAtFinalSavingTransition
    extends BaseTransition {
        private AMExpiredAtFinalSavingTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            if (appAttempt.targetedFinalState.equals((Object)RMAppAttemptState.FAILED) || appAttempt.targetedFinalState.equals((Object)RMAppAttemptState.KILLED)) {
                return;
            }
            appAttempt.rememberTargetTransitions(event, new AMFinishedAfterFinalSavingTransition(appAttempt.eventCausingFinalSaving), RMAppAttemptState.FINISHED);
        }
    }

    private static class AMFinishedAfterFinalSavingTransition
    extends BaseTransition {
        RMAppAttemptEvent amUnregisteredEvent;

        public AMFinishedAfterFinalSavingTransition(RMAppAttemptEvent amUnregisteredEvent) {
            this.amUnregisteredEvent = amUnregisteredEvent;
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.updateInfoOnAMUnregister(this.amUnregisteredEvent);
            new FinalTransition(RMAppAttemptState.FINISHED).transition(appAttempt, event);
        }
    }

    private static class ContainerFinishedAtFinalSavingTransition
    extends BaseTransition {
        private ContainerFinishedAtFinalSavingTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptContainerFinishedEvent containerFinishedEvent = (RMAppAttemptContainerFinishedEvent)event;
            ContainerStatus containerStatus = containerFinishedEvent.getContainerStatus();
            if (appAttempt.masterContainer.getId().equals((Object)containerStatus.getContainerId())) {
                RMAppAttemptImpl.amContainerFinished(appAttempt, containerFinishedEvent);
                if (appAttempt.targetedFinalState.equals((Object)RMAppAttemptState.FAILED) || appAttempt.targetedFinalState.equals((Object)RMAppAttemptState.KILLED)) {
                    return;
                }
                appAttempt.rememberTargetTransitions(event, new AMFinishedAfterFinalSavingTransition(appAttempt.eventCausingFinalSaving), RMAppAttemptState.FINISHED);
                return;
            }
            RMAppAttemptImpl.addJustFinishedContainer(appAttempt, containerFinishedEvent);
        }
    }

    private static final class AMFinishingContainerFinishedTransition
    implements MultipleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent, RMAppAttemptState> {
        private AMFinishingContainerFinishedTransition() {
        }

        public RMAppAttemptState transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptContainerFinishedEvent containerFinishedEvent = (RMAppAttemptContainerFinishedEvent)event;
            ContainerStatus containerStatus = containerFinishedEvent.getContainerStatus();
            if (appAttempt.masterContainer.getId().equals((Object)containerStatus.getContainerId())) {
                new FinalTransition(RMAppAttemptState.FINISHED).transition(appAttempt, containerFinishedEvent);
                RMAppAttemptImpl.amContainerFinished(appAttempt, containerFinishedEvent);
                return RMAppAttemptState.FINISHED;
            }
            RMAppAttemptImpl.addJustFinishedContainer(appAttempt, containerFinishedEvent);
            return RMAppAttemptState.FINISHING;
        }
    }

    private static class AMContainerCrashedAtRunningTransition
    extends BaseTransition {
        private AMContainerCrashedAtRunningTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptContainerFinishedEvent finishEvent = (RMAppAttemptContainerFinishedEvent)event;
            assert (!appAttempt.submissionContext.getUnmanagedAM());
            appAttempt.setAMContainerCrashedDiagnosticsAndExitStatus(finishEvent);
            new FinalTransition(RMAppAttemptState.FAILED).transition(appAttempt, event);
        }
    }

    private static final class ContainerFinishedAtFinalStateTransition
    extends BaseTransition {
        private ContainerFinishedAtFinalStateTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptContainerFinishedEvent containerFinishedEvent = (RMAppAttemptContainerFinishedEvent)event;
            RMAppAttemptImpl.addJustFinishedContainer(appAttempt, containerFinishedEvent);
        }
    }

    private static final class ContainerFinishedTransition
    implements MultipleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent, RMAppAttemptState> {
        private BaseTransition transitionToDo;
        private RMAppAttemptState currentState;

        public ContainerFinishedTransition(BaseTransition transitionToDo, RMAppAttemptState currentState) {
            this.transitionToDo = transitionToDo;
            this.currentState = currentState;
        }

        public RMAppAttemptState transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptContainerFinishedEvent containerFinishedEvent = (RMAppAttemptContainerFinishedEvent)event;
            ContainerStatus containerStatus = containerFinishedEvent.getContainerStatus();
            if (appAttempt.masterContainer != null && appAttempt.masterContainer.getId().equals((Object)containerStatus.getContainerId())) {
                RMAppAttemptImpl.amContainerFinished(appAttempt, containerFinishedEvent);
                appAttempt.rememberTargetTransitionsAndStoreState(event, this.transitionToDo, RMAppAttemptState.FAILED, RMAppAttemptState.FAILED);
                return RMAppAttemptState.FINAL_SAVING;
            }
            RMAppAttemptImpl.addJustFinishedContainer(appAttempt, containerFinishedEvent);
            return this.currentState;
        }
    }

    private static class FinalStateSavedAfterAMUnregisterTransition
    extends BaseTransition {
        private FinalStateSavedAfterAMUnregisterTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.rmContext.getAMLivelinessMonitor().unregister(appAttempt.applicationAttemptId);
            appAttempt.rmContext.getAMFinishingMonitor().register(appAttempt.applicationAttemptId);
            appAttempt.updateInfoOnAMUnregister(event);
        }
    }

    private static final class AMUnregisteredTransition
    extends BaseTransition {
        private AMUnregisteredTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            if (appAttempt.getSubmissionContext().getUnmanagedAM()) {
                appAttempt.rememberTargetTransitionsAndStoreState(event, new AMFinishedAfterFinalSavingTransition(event), RMAppAttemptState.FINISHED, RMAppAttemptState.FINISHED);
            } else {
                appAttempt.rememberTargetTransitionsAndStoreState(event, new FinalStateSavedAfterAMUnregisterTransition(), RMAppAttemptState.FINISHING, RMAppAttemptState.FINISHED);
            }
            ApplicationId applicationId = appAttempt.getAppAttemptId().getApplicationId();
            appAttempt.eventHandler.handle((Event)new RMAppEvent(applicationId, RMAppEventType.ATTEMPT_UNREGISTERED));
        }
    }

    private static final class StatusUpdateTransition
    extends BaseTransition {
        private StatusUpdateTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptStatusupdateEvent statusUpdateEvent = (RMAppAttemptStatusupdateEvent)event;
            appAttempt.progress = statusUpdateEvent.getProgress();
            String newTrackingUrl = statusUpdateEvent.getTrackingUrl();
            if (newTrackingUrl != null && !newTrackingUrl.equals(appAttempt.originalTrackingUrl)) {
                appAttempt.originalTrackingUrl = newTrackingUrl;
                ApplicationAttemptStateData attemptState = ApplicationAttemptStateData.newInstance(appAttempt.applicationAttemptId, appAttempt.getMasterContainer(), appAttempt.rmContext.getStateStore().getCredentialsFromAppAttempt(appAttempt), appAttempt.startTime, appAttempt.recoveredFinalState, newTrackingUrl, appAttempt.getDiagnostics(), null, -1000, appAttempt.getFinishTime(), appAttempt.attemptMetrics.getAggregateAppResourceUsage().getResourceUsageSecondsMap(), appAttempt.attemptMetrics.getPreemptedResourceSecondsMap(), appAttempt.attemptMetrics.getTotalAllocatedContainers());
                appAttempt.rmContext.getStateStore().updateApplicationAttemptState(attemptState);
            }
            appAttempt.rmContext.getAMLivelinessMonitor().receivedPing(statusUpdateEvent.getApplicationAttemptId());
        }
    }

    private static class UnexpectedAMRegisteredTransition
    extends BaseFinalTransition {
        public UnexpectedAMRegisteredTransition() {
            super(RMAppAttemptState.FAILED);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            assert (appAttempt.submissionContext.getUnmanagedAM());
            appAttempt.diagnostics.append((CharSequence)RMAppAttemptImpl.getUnexpectedAMRegisteredDiagnostics());
            super.transition(appAttempt, event);
        }
    }

    private static class ExpiredTransition
    extends FinalTransition {
        public ExpiredTransition() {
            super(RMAppAttemptState.FAILED);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.diagnostics.append((CharSequence)RMAppAttemptImpl.getAMExpiredDiagnostics(event));
            super.transition(appAttempt, event);
        }
    }

    private static class FinalTransition
    extends BaseFinalTransition {
        public FinalTransition(RMAppAttemptState finalAttemptState) {
            super(finalAttemptState);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.progress = 1.0f;
            super.transition(appAttempt, event);
            appAttempt.rmContext.getAMLivelinessMonitor().unregister(appAttempt.getAppAttemptId());
            appAttempt.rmContext.getAMFinishingMonitor().unregister(appAttempt.getAppAttemptId());
            if (!appAttempt.submissionContext.getUnmanagedAM()) {
                appAttempt.eventHandler.handle((Event)new AMLauncherEvent(AMLauncherEventType.CLEANUP, appAttempt));
            }
        }
    }

    private static final class AMContainerCrashedBeforeRunningTransition
    extends BaseFinalTransition {
        public AMContainerCrashedBeforeRunningTransition() {
            super(RMAppAttemptState.FAILED);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptContainerFinishedEvent finishEvent = (RMAppAttemptContainerFinishedEvent)event;
            appAttempt.rmContext.getAMLivelinessMonitor().unregister(appAttempt.getAppAttemptId());
            appAttempt.setAMContainerCrashedDiagnosticsAndExitStatus(finishEvent);
            super.transition(appAttempt, finishEvent);
        }
    }

    private static final class AMRegisteredTransition
    extends BaseTransition {
        private AMRegisteredTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            if (!RMAppAttemptState.LAUNCHED.equals((Object)appAttempt.getState())) {
                LAUNCHED_TRANSITION.transition(appAttempt, event);
            }
            long delay = System.currentTimeMillis() - appAttempt.launchAMEndTime;
            ClusterMetrics.getMetrics().addAMRegisterDelay(delay);
            RMAppAttemptRegistrationEvent registrationEvent = (RMAppAttemptRegistrationEvent)event;
            appAttempt.host = StringInterner.weakIntern((String)registrationEvent.getHost());
            appAttempt.rpcPort = registrationEvent.getRpcport();
            appAttempt.originalTrackingUrl = RMAppAttemptImpl.sanitizeTrackingUrl(registrationEvent.getTrackingurl());
            appAttempt.updateAMLaunchDiagnostics(null);
            appAttempt.eventHandler.handle((Event)new RMAppEvent(appAttempt.getAppAttemptId().getApplicationId(), RMAppEventType.ATTEMPT_REGISTERED));
            appAttempt.rmContext.getRMApplicationHistoryWriter().applicationAttemptStarted(appAttempt);
            appAttempt.rmContext.getSystemMetricsPublisher().appAttemptRegistered(appAttempt, System.currentTimeMillis());
        }
    }

    private static final class KillAllocatedAMTransition
    extends BaseFinalTransition {
        public KillAllocatedAMTransition() {
            super(RMAppAttemptState.KILLED);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            super.transition(appAttempt, event);
            appAttempt.eventHandler.handle((Event)new AMLauncherEvent(AMLauncherEventType.CLEANUP, appAttempt));
        }
    }

    private static final class LaunchFailedTransition
    extends BaseFinalTransition {
        public LaunchFailedTransition() {
            super(RMAppAttemptState.FAILED);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.diagnostics.append((CharSequence)event.getDiagnosticMsg());
            super.transition(appAttempt, event);
        }
    }

    private static final class UnmanagedAMAttemptSavedTransition
    extends AMLaunchedTransition {
        private UnmanagedAMAttemptSavedTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.amrmToken = appAttempt.rmContext.getAMRMTokenSecretManager().createAndGetAMRMToken(appAttempt.applicationAttemptId);
            appAttempt.registerClientToken();
            super.transition(appAttempt, event);
        }
    }

    private static class AMLaunchedTransition
    extends BaseTransition {
        private AMLaunchedTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            if (event.getType() == RMAppAttemptEventType.LAUNCHED || event.getType() == RMAppAttemptEventType.REGISTERED) {
                appAttempt.launchAMEndTime = System.currentTimeMillis();
                long delay = appAttempt.launchAMEndTime - appAttempt.launchAMStartTime;
                ClusterMetrics.getMetrics().addAMLaunchDelay(delay);
            }
            appAttempt.eventHandler.handle((Event)new RMAppEvent(appAttempt.getAppAttemptId().getApplicationId(), RMAppEventType.ATTEMPT_LAUNCHED, event.getTimestamp()));
            appAttempt.updateAMLaunchDiagnostics(SchedulerApplicationAttempt.AMState.LAUNCHED.getDiagnosticMessage());
            appAttempt.attemptLaunched();
        }
    }

    private static class AttemptFailedTransition
    extends BaseFinalTransition {
        public AttemptFailedTransition() {
            super(RMAppAttemptState.FAILED);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            if (event.getDiagnosticMsg() != null) {
                appAttempt.diagnostics.append((CharSequence)event.getDiagnosticMsg());
            }
            super.transition(appAttempt, event);
        }
    }

    private static class BaseFinalTransition
    extends BaseTransition {
        private final RMAppAttemptState finalAttemptState;

        public BaseFinalTransition(RMAppAttemptState finalAttemptState) {
            this.finalAttemptState = finalAttemptState;
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            ApplicationAttemptId appAttemptId = appAttempt.getAppAttemptId();
            appAttempt.masterService.unregisterAttempt(appAttemptId);
            ApplicationId applicationId = appAttemptId.getApplicationId();
            RMAppEvent appEvent = null;
            boolean keepContainersAcrossAppAttempts = false;
            switch (this.finalAttemptState) {
                case FINISHED: {
                    appEvent = new RMAppEvent(applicationId, RMAppEventType.ATTEMPT_FINISHED, appAttempt.getDiagnostics());
                    break;
                }
                case KILLED: {
                    appAttempt.invalidateAMHostAndPort();
                    appEvent = new RMAppFailedAttemptEvent(applicationId, RMAppEventType.ATTEMPT_KILLED, event.getDiagnosticMsg(), false);
                    break;
                }
                case FAILED: {
                    appAttempt.invalidateAMHostAndPort();
                    if (appAttempt.submissionContext.getKeepContainersAcrossApplicationAttempts() && !appAttempt.submissionContext.getUnmanagedAM()) {
                        int numberOfFailure = ((RMAppImpl)appAttempt.rmApp).getNumFailedAppAttempts();
                        if (appAttempt.rmApp.getMaxAppAttempts() > 1 && numberOfFailure < appAttempt.rmApp.getMaxAppAttempts()) {
                            keepContainersAcrossAppAttempts = true;
                        }
                    }
                    appEvent = new RMAppFailedAttemptEvent(applicationId, RMAppEventType.ATTEMPT_FAILED, appAttempt.getDiagnostics(), keepContainersAcrossAppAttempts);
                    break;
                }
                default: {
                    LOG.error("Cannot get this state!! Error!!");
                }
            }
            appAttempt.eventHandler.handle(appEvent);
            appAttempt.eventHandler.handle((Event)new AppAttemptRemovedSchedulerEvent(appAttemptId, this.finalAttemptState, keepContainersAcrossAppAttempts));
            appAttempt.removeCredentials(appAttempt);
            appAttempt.rmContext.getRMApplicationHistoryWriter().applicationAttemptFinished(appAttempt, this.finalAttemptState);
            appAttempt.rmContext.getSystemMetricsPublisher().appAttemptFinished(appAttempt, this.finalAttemptState, appAttempt.rmApp, System.currentTimeMillis());
        }
    }

    private static class FinalStateSavedTransition
    implements MultipleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent, RMAppAttemptState> {
        private FinalStateSavedTransition() {
        }

        public RMAppAttemptState transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptEvent causeEvent = appAttempt.eventCausingFinalSaving;
            if (appAttempt.transitionTodo instanceof SingleArcTransition) {
                ((SingleArcTransition)appAttempt.transitionTodo).transition((Object)appAttempt, (Object)causeEvent);
            } else if (appAttempt.transitionTodo instanceof MultipleArcTransition) {
                ((MultipleArcTransition)appAttempt.transitionTodo).transition((Object)appAttempt, (Object)causeEvent);
            }
            return appAttempt.targetedFinalState;
        }
    }

    private static class FinalSavingTransition
    extends BaseTransition {
        Object transitionToDo;
        RMAppAttemptState targetedFinalState;

        public FinalSavingTransition(Object transitionToDo, RMAppAttemptState targetedFinalState) {
            this.transitionToDo = transitionToDo;
            this.targetedFinalState = targetedFinalState;
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.rememberTargetTransitionsAndStoreState(event, this.transitionToDo, this.targetedFinalState, this.targetedFinalState);
        }
    }

    private static class AttemptRecoveredTransition
    implements MultipleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent, RMAppAttemptState> {
        private AttemptRecoveredTransition() {
        }

        public RMAppAttemptState transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMApp rmApp = appAttempt.rmApp;
            if (appAttempt.recoveredFinalState != null) {
                appAttempt.progress = 1.0f;
                if (appAttempt.submissionContext.getKeepContainersAcrossApplicationAttempts() && rmApp.getCurrentAppAttempt() != appAttempt) {
                    appAttempt.transferStateFromAttempt(rmApp.getCurrentAppAttempt());
                }
                if (rmApp.getCurrentAppAttempt() == appAttempt && !RMAppImpl.isAppInFinalState(rmApp)) {
                    appAttempt.scheduler.handle((Event)new AppAttemptAddedSchedulerEvent(appAttempt.getAppAttemptId(), false, true));
                    new BaseFinalTransition(appAttempt.recoveredFinalState).transition(appAttempt, event);
                }
                return appAttempt.recoveredFinalState;
            }
            if (RMAppImpl.isAppInFinalState(rmApp)) {
                RMAppState appState = ((RMAppImpl)rmApp).getRecoveredFinalState();
                LOG.warn(rmApp.getApplicationId() + " final state (" + (Object)((Object)appState) + ") was recorded, but " + appAttempt.applicationAttemptId + " final state (" + (Object)((Object)appAttempt.recoveredFinalState) + ") was not recorded.");
                switch (appState) {
                    case FINISHED: {
                        return RMAppAttemptState.FINISHED;
                    }
                    case FAILED: {
                        return RMAppAttemptState.FAILED;
                    }
                    case KILLED: {
                        return RMAppAttemptState.KILLED;
                    }
                }
                return RMAppAttemptState.FAILED;
            }
            if (appAttempt.rmContext.isWorkPreservingRecoveryEnabled()) {
                appAttempt.masterService.registerAppAttempt(appAttempt.applicationAttemptId);
                appAttempt.scheduler.handle((Event)new AppAttemptAddedSchedulerEvent(appAttempt.getAppAttemptId(), false, true));
            }
            LAUNCHED_TRANSITION.transition(appAttempt, event);
            return RMAppAttemptState.LAUNCHED;
        }
    }

    private static final class AttemptStoredTransition
    extends BaseTransition {
        private AttemptStoredTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.registerClientToken();
            appAttempt.launchAttempt();
        }
    }

    private static final class AMContainerAllocatedTransition
    implements MultipleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent, RMAppAttemptState> {
        private AMContainerAllocatedTransition() {
        }

        public RMAppAttemptState transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            Allocation amContainerAllocation = appAttempt.scheduler.allocate(appAttempt.applicationAttemptId, EMPTY_CONTAINER_REQUEST_LIST, null, EMPTY_CONTAINER_RELEASE_LIST, null, null, new ContainerUpdates());
            if (amContainerAllocation.getContainers().size() == 0) {
                appAttempt.retryFetchingAMContainer(appAttempt);
                return RMAppAttemptState.SCHEDULED;
            }
            Container amContainer = amContainerAllocation.getContainers().get(0);
            RMContainerImpl rmMasterContainer = (RMContainerImpl)appAttempt.scheduler.getRMContainer(amContainer.getId());
            if (rmMasterContainer == null) {
                return RMAppAttemptState.SCHEDULED;
            }
            appAttempt.setMasterContainer(amContainer);
            rmMasterContainer.setAMContainer(true);
            appAttempt.rmContext.getNMTokenSecretManager().clearNodeSetForAttempt(appAttempt.applicationAttemptId);
            appAttempt.getSubmissionContext().setResource(appAttempt.getMasterContainer().getResource());
            appAttempt.containerAllocatedTime = System.currentTimeMillis();
            long allocationDelay = appAttempt.containerAllocatedTime - appAttempt.scheduledTime;
            ClusterMetrics.getMetrics().addAMContainerAllocationDelay(allocationDelay);
            appAttempt.storeAttempt();
            return RMAppAttemptState.ALLOCATED_SAVING;
        }
    }

    @VisibleForTesting
    public static final class ScheduleTransition
    implements MultipleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent, RMAppAttemptState> {
        public RMAppAttemptState transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            ApplicationSubmissionContext subCtx = appAttempt.submissionContext;
            if (!subCtx.getUnmanagedAM()) {
                for (ResourceRequest amReq : appAttempt.amReqs) {
                    amReq.setNumContainers(1);
                    amReq.setPriority(AM_CONTAINER_PRIORITY);
                }
                int numNodes = RMServerUtils.getApplicableNodeCountForAM(appAttempt.rmContext, appAttempt.conf, appAttempt.amReqs);
                LOG.debug("Setting node count for blacklist to {}", (Object)numNodes);
                appAttempt.getAMBlacklistManager().refreshNodeHostCount(numNodes);
                ResourceBlacklistRequest amBlacklist = appAttempt.getAMBlacklistManager().getBlacklistUpdates();
                LOG.debug("Using blacklist for AM: additions({}) and removals({})", (Object)amBlacklist.getBlacklistAdditions(), (Object)amBlacklist.getBlacklistRemovals());
                QueueInfo queueInfo = null;
                for (ResourceRequest amReq : appAttempt.amReqs) {
                    if (amReq.getNodeLabelExpression() != null || !"*".equals(amReq.getResourceName())) continue;
                    String queue = appAttempt.rmApp.getQueue();
                    if (queueInfo == null) {
                        try {
                            queueInfo = appAttempt.scheduler.getQueueInfo(queue, false, false);
                        }
                        catch (IOException e) {
                            LOG.error("Could not find queue for application : ", (Throwable)e);
                            appAttempt.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(appAttempt.getAppAttemptId(), RMAppAttemptEventType.FAIL, "Could not find queue for application : " + appAttempt.rmApp.getQueue()));
                            appAttempt.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(appAttempt.rmApp.getApplicationId(), RMAppEventType.APP_REJECTED, "Could not find queue for application : " + appAttempt.rmApp.getQueue()));
                            return RMAppAttemptState.FAILED;
                        }
                    }
                    String labelExp = "";
                    if (queueInfo != null) {
                        LOG.debug("Setting default node label expression : {}", (Object)queueInfo.getDefaultNodeLabelExpression());
                        labelExp = queueInfo.getDefaultNodeLabelExpression();
                    }
                    amReq.setNodeLabelExpression(labelExp);
                }
                Allocation amContainerAllocation = appAttempt.scheduler.allocate(appAttempt.applicationAttemptId, appAttempt.amReqs, null, EMPTY_CONTAINER_RELEASE_LIST, amBlacklist.getBlacklistAdditions(), amBlacklist.getBlacklistRemovals(), new ContainerUpdates());
                if (amContainerAllocation != null && amContainerAllocation.getContainers() != null) assert (amContainerAllocation.getContainers().size() == 0);
                appAttempt.scheduledTime = System.currentTimeMillis();
                return RMAppAttemptState.SCHEDULED;
            }
            appAttempt.storeAttempt();
            return RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING;
        }
    }

    private static final class AttemptStartedTransition
    extends BaseTransition {
        private AttemptStartedTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            boolean transferStateFromPreviousAttempt = false;
            if (event instanceof RMAppStartAttemptEvent) {
                transferStateFromPreviousAttempt = ((RMAppStartAttemptEvent)event).getTransferStateFromPreviousAttempt();
            }
            appAttempt.startTime = System.currentTimeMillis();
            appAttempt.masterService.registerAppAttempt(appAttempt.applicationAttemptId);
            if (UserGroupInformation.isSecurityEnabled()) {
                appAttempt.clientTokenMasterKey = appAttempt.rmContext.getClientToAMTokenSecretManager().createMasterKey(appAttempt.applicationAttemptId);
            }
            appAttempt.eventHandler.handle((Event)new AppAttemptAddedSchedulerEvent(appAttempt.applicationAttemptId, transferStateFromPreviousAttempt));
        }
    }

    private static class BaseTransition
    implements SingleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent> {
        private BaseTransition() {
        }

        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
        }
    }
}

