/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueResourceQuotas;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractAutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueueConfig;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCreatedLeafQueue
extends AbstractAutoCreatedLeafQueue {
    private static final Logger LOG = LoggerFactory.getLogger(AutoCreatedLeafQueue.class);

    public AutoCreatedLeafQueue(CapacitySchedulerQueueContext queueContext, String queueName, ManagedParentQueue parent) throws IOException {
        super(queueContext, queueName, parent, null);
        parent.setLeafQueueConfigs(queueName);
        super.setupQueueConfigs(queueContext.getClusterResource());
        this.updateCapacitiesToZero();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reinitialize(CSQueue newlyParsedQueue, Resource clusterResource) throws IOException {
        this.writeLock.lock();
        try {
            this.validate(newlyParsedQueue);
            ManagedParentQueue managedParentQueue = (ManagedParentQueue)this.parent;
            managedParentQueue.setLeafQueueConfigs(newlyParsedQueue.getQueueShortName());
            super.reinitialize(newlyParsedQueue, clusterResource);
            this.updateCapacitiesToZero();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void reinitializeFromTemplate(AutoCreatedLeafQueueConfig leafQueueTemplate) {
        this.writeLock.lock();
        try {
            QueueCapacities capacities = leafQueueTemplate.getQueueCapacities();
            this.mergeCapacities(capacities, leafQueueTemplate.getResourceQuotas());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void mergeCapacities(QueueCapacities capacities, QueueResourceQuotas resourceQuotas) {
        for (String nodeLabel : capacities.getExistingNodeLabels()) {
            this.queueCapacities.setCapacity(nodeLabel, capacities.getCapacity(nodeLabel));
            this.queueCapacities.setAbsoluteCapacity(nodeLabel, capacities.getAbsoluteCapacity(nodeLabel));
            this.queueCapacities.setMaximumCapacity(nodeLabel, capacities.getMaximumCapacity(nodeLabel));
            this.queueCapacities.setAbsoluteMaximumCapacity(nodeLabel, capacities.getAbsoluteMaximumCapacity(nodeLabel));
            Resource resourceByLabel = this.labelManager.getResourceByLabel(nodeLabel, this.queueContext.getClusterResource());
            if (this.getCapacityConfigType().equals((Object)AbstractCSQueue.CapacityConfigType.ABSOLUTE_RESOURCE) && this.queueCapacities.getAbsoluteCapacity(nodeLabel) > 0.0f) {
                this.getQueueResourceQuotas().setEffectiveMinResource(nodeLabel, resourceQuotas.getConfiguredMinResource(nodeLabel));
            } else {
                this.getQueueResourceQuotas().setEffectiveMinResource(nodeLabel, Resources.multiply((Resource)resourceByLabel, (double)this.queueCapacities.getAbsoluteCapacity(nodeLabel)));
            }
            this.getQueueResourceQuotas().setEffectiveMaxResource(nodeLabel, Resources.multiply((Resource)resourceByLabel, (double)this.queueCapacities.getAbsoluteMaximumCapacity(nodeLabel)));
        }
    }

    public void validateConfigurations(AutoCreatedLeafQueueConfig template) throws SchedulerDynamicEditException {
        QueueCapacities capacities = template.getQueueCapacities();
        for (String label : capacities.getExistingNodeLabels()) {
            float capacity = capacities.getCapacity(label);
            if (!(capacity < 0.0f) && !(capacity > 1.0f)) continue;
            throw new SchedulerDynamicEditException("Capacity demand is not in the [0,1] range: " + capacity);
        }
    }

    @Override
    protected void setDynamicQueueProperties() {
        String parentTemplate = String.format("%s.%s", this.getParent().getQueuePath(), "leaf-queue-template");
        Set<String> parentNodeLabels = this.queueContext.getQueueManager().getConfiguredNodeLabelsForAllQueues().getLabelsByQueue(parentTemplate);
        if (parentNodeLabels != null && parentNodeLabels.size() > 1) {
            this.queueContext.getQueueManager().getConfiguredNodeLabelsForAllQueues().setLabelsByQueue(this.getQueuePath(), new HashSet<String>(parentNodeLabels));
        }
    }

    private void validate(CSQueue newlyParsedQueue) throws IOException {
        if (!(newlyParsedQueue instanceof AutoCreatedLeafQueue) || !newlyParsedQueue.getQueuePath().equals(this.getQueuePath())) {
            throw new IOException("Error trying to reinitialize " + this.getQueuePath() + " from " + newlyParsedQueue.getQueuePath());
        }
    }

    private void updateCapacitiesToZero() throws IOException {
        try {
            for (String nodeLabel : this.parent.getQueueCapacities().getExistingNodeLabels()) {
                this.setEntitlement(nodeLabel, new QueueEntitlement(0.0f, this.parent.getLeafQueueTemplate().getQueueCapacities().getMaximumCapacity(nodeLabel)));
            }
        }
        catch (SchedulerDynamicEditException e) {
            throw new IOException((Throwable)((Object)e));
        }
    }
}

