/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.queuemanagement;

import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.slf4j.Logger;

public class DeactivatedLeafQueuesByLabel {
    private String parentQueuePath;
    private String nodeLabel;
    private Map<String, QueueCapacities> deactivatedLeafQueues;
    private float sumOfChildQueueActivatedCapacity;
    private float parentAbsoluteCapacity;
    private float leafQueueTemplateAbsoluteCapacity;
    private float availableCapacity;
    private float totalDeactivatedCapacity;

    @VisibleForTesting
    public DeactivatedLeafQueuesByLabel() {
    }

    public DeactivatedLeafQueuesByLabel(Map<String, QueueCapacities> deactivatedLeafQueues, String parentQueuePath, String nodeLabel, float sumOfChildQueueActivatedCapacity, float parentAbsoluteCapacity, float leafQueueTemplateAbsoluteCapacity) {
        this.parentQueuePath = parentQueuePath;
        this.nodeLabel = nodeLabel;
        this.deactivatedLeafQueues = deactivatedLeafQueues;
        this.sumOfChildQueueActivatedCapacity = sumOfChildQueueActivatedCapacity;
        this.parentAbsoluteCapacity = parentAbsoluteCapacity;
        this.leafQueueTemplateAbsoluteCapacity = leafQueueTemplateAbsoluteCapacity;
        this.totalDeactivatedCapacity = this.getTotalDeactivatedCapacity();
        this.availableCapacity = parentAbsoluteCapacity - sumOfChildQueueActivatedCapacity + this.totalDeactivatedCapacity + 1.0E-4f;
    }

    float getTotalDeactivatedCapacity() {
        float deactivatedCapacity = 0.0f;
        for (Map.Entry<String, QueueCapacities> deactivatedQueueCapacity : this.deactivatedLeafQueues.entrySet()) {
            deactivatedCapacity += deactivatedQueueCapacity.getValue().getAbsoluteCapacity(this.nodeLabel);
        }
        return deactivatedCapacity;
    }

    public Set<String> getQueues() {
        return this.deactivatedLeafQueues.keySet();
    }

    public void printToDebug(Logger logger) {
        if (logger.isDebugEnabled()) {
            logger.debug("Parent queue = {}, nodeLabel = {}, absCapacity = {}, leafQueueAbsoluteCapacity = {}, deactivatedCapacity = {}, absChildActivatedCapacity = {}, availableCapacity = {}", new Object[]{this.parentQueuePath, this.nodeLabel, Float.valueOf(this.parentAbsoluteCapacity), Float.valueOf(this.leafQueueTemplateAbsoluteCapacity), Float.valueOf(this.getTotalDeactivatedCapacity()), Float.valueOf(this.sumOfChildQueueActivatedCapacity), Float.valueOf(this.availableCapacity)});
        }
    }

    @VisibleForTesting
    public int getMaxLeavesToBeActivated(int numPendingApps) {
        float childQueueAbsoluteCapacity = this.leafQueueTemplateAbsoluteCapacity;
        if (childQueueAbsoluteCapacity > 0.0f) {
            int numLeafQueuesNeeded = (int)Math.floor(this.availableCapacity / childQueueAbsoluteCapacity);
            return Math.min(numLeafQueuesNeeded, numPendingApps);
        }
        return 0;
    }

    public boolean canActivateLeafQueues() {
        return this.availableCapacity >= this.leafQueueTemplateAbsoluteCapacity;
    }

    @VisibleForTesting
    public void setAvailableCapacity(float availableCapacity) {
        this.availableCapacity = availableCapacity;
    }

    @VisibleForTesting
    public void setLeafQueueTemplateAbsoluteCapacity(float leafQueueTemplateAbsoluteCapacity) {
        this.leafQueueTemplateAbsoluteCapacity = leafQueueTemplateAbsoluteCapacity;
    }
}

