/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.helper;

import java.util.Map;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AutoQueueTemplatePropertiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.LeafQueueTemplateInfo;

public class CapacitySchedulerInfoHelper {
    private static final String PARENT_QUEUE = "parent";
    private static final String LEAF_QUEUE = "leaf";
    private static final String UNKNOWN_QUEUE = "unknown";
    private static final String STATIC_QUEUE = "static";
    private static final String LEGACY_DYNAMIC_QUEUE = "dynamicLegacy";
    private static final String FLEXIBLE_DYNAMIC_QUEUE = "dynamicFlexible";
    private static final String AUTO_CREATION_OFF = "off";
    private static final String AUTO_CREATION_LEGACY = "legacy";
    private static final String AUTO_CREATION_FLEXIBLE = "flexible";

    private CapacitySchedulerInfoHelper() {
    }

    public static String getMode(CSQueue queue) throws YarnRuntimeException {
        if (queue.getCapacityConfigType() == AbstractCSQueue.CapacityConfigType.ABSOLUTE_RESOURCE) {
            return "absolute";
        }
        if (queue.getCapacityConfigType() == AbstractCSQueue.CapacityConfigType.PERCENTAGE) {
            float weight = queue.getQueueCapacities().getWeight();
            if (weight == -1.0f) {
                return "percentage";
            }
            return "weight";
        }
        throw new YarnRuntimeException("Unknown mode for queue: " + queue.getQueuePath() + ". Queue details: " + queue);
    }

    public static String getQueueType(CSQueue queue) {
        if (queue instanceof AbstractLeafQueue) {
            return LEAF_QUEUE;
        }
        if (queue instanceof ParentQueue) {
            return PARENT_QUEUE;
        }
        return UNKNOWN_QUEUE;
    }

    public static String getCreationMethod(CSQueue queue) {
        if (queue instanceof AutoCreatedLeafQueue) {
            return LEGACY_DYNAMIC_QUEUE;
        }
        if (((AbstractCSQueue)queue).isDynamicQueue()) {
            return FLEXIBLE_DYNAMIC_QUEUE;
        }
        return STATIC_QUEUE;
    }

    public static String getAutoCreationEligibility(CSQueue queue) {
        if (queue instanceof ManagedParentQueue) {
            return AUTO_CREATION_LEGACY;
        }
        if (queue instanceof ParentQueue && ((ParentQueue)queue).isEligibleForAutoQueueCreation()) {
            return AUTO_CREATION_FLEXIBLE;
        }
        return AUTO_CREATION_OFF;
    }

    public static AutoQueueTemplatePropertiesInfo getAutoCreatedTemplate(Map<String, String> templateProperties) {
        AutoQueueTemplatePropertiesInfo propertiesInfo = new AutoQueueTemplatePropertiesInfo();
        for (Map.Entry<String, String> e : templateProperties.entrySet()) {
            propertiesInfo.add(new LeafQueueTemplateInfo.ConfItem(e.getKey(), e.getValue()));
        }
        return propertiesInfo;
    }
}

