/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.collector;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorManager;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestTimelineCollectorManager {
    @Test
    @Timeout(value=60000L)
    void testTimelineCollectorManagerWithInvalidTimelineWriter() {
        Assertions.assertThrows(YarnRuntimeException.class, () -> {
            YarnConfiguration conf = new YarnConfiguration();
            conf.set("yarn.timeline-service.writer.class", Object.class.getName());
            TestTimelineCollectorManager.runTimelineCollectorManagerWithConfig((Configuration)conf);
        });
    }

    @Test
    @Timeout(value=60000L)
    void testTimelineCollectorManagerWithNonexistentTimelineWriter() {
        Assertions.assertThrows(YarnRuntimeException.class, () -> {
            String nonexistentTimelineWriterClass = "org.apache.org.yarn.server.timelineservice.storage.XXXXXXXX";
            YarnConfiguration conf = new YarnConfiguration();
            conf.set("yarn.timeline-service.writer.class", nonexistentTimelineWriterClass);
            TestTimelineCollectorManager.runTimelineCollectorManagerWithConfig((Configuration)conf);
        });
    }

    @Test
    @Timeout(value=60000L)
    void testTimelineCollectorManagerWithFileSystemWriter() {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.timeline-service.writer.class", FileSystemTimelineWriterImpl.class, TimelineWriter.class);
        TestTimelineCollectorManager.runTimelineCollectorManagerWithConfig((Configuration)conf);
    }

    private static void runTimelineCollectorManagerWithConfig(Configuration conf) {
        TimelineCollectorManager collectorManager = new TimelineCollectorManager("testTimelineCollectorManager");
        try {
            collectorManager.init(conf);
            collectorManager.start();
        }
        finally {
            collectorManager.stop();
        }
    }
}

