/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.timelineservice.ApplicationAttemptEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.ContainerEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareOp;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineExistsFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterList;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineKeyValueFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineKeyValuesFilter;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineReaderImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestFileSystemTimelineReaderImpl {
    private static final String ROOT_DIR = new File("target", TestFileSystemTimelineReaderImpl.class.getSimpleName()).getAbsolutePath();
    private FileSystemTimelineReaderImpl reader;

    @BeforeAll
    public static void setup() throws Exception {
        TestFileSystemTimelineReaderImpl.initializeDataDirectory(ROOT_DIR);
    }

    public static void initializeDataDirectory(String rootDir) throws Exception {
        TestFileSystemTimelineReaderImpl.loadEntityData(rootDir);
        CSVFormat format = CSVFormat.Builder.create().setHeader(new String[]{"APP", "USER", "FLOW", "FLOWRUN"}).build();
        String appFlowMappingFile = rootDir + File.separator + "entities" + File.separator + "cluster1" + File.separator + "app_flow_mapping.csv";
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(appFlowMappingFile, true)));
             CSVPrinter printer = new CSVPrinter((Appendable)out, format);){
            printer.printRecord(new Object[]{"app1", "user1", "flow1", 1});
            printer.printRecord(new Object[]{"app2", "user1", "flow1,flow", 1});
            printer.close();
        }
        new File(rootDir).deleteOnExit();
    }

    @AfterAll
    public static void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)new File(ROOT_DIR));
    }

    @BeforeEach
    public void init() throws Exception {
        this.reader = new FileSystemTimelineReaderImpl();
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.timeline-service.fs-writer.root-dir", ROOT_DIR);
        this.reader.init((Configuration)conf);
    }

    private static void writeEntityFile(TimelineEntity entity, File dir) throws Exception {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Could not create directories for " + dir);
        }
        String fileName = dir.getAbsolutePath() + File.separator + entity.getId() + ".thist";
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName, true)));){
            out.println(TimelineUtils.dumpTimelineRecordtoJSON((Object)entity));
            out.write("\n");
            out.close();
        }
    }

    private static void loadEntityData(String rootDir) throws Exception {
        File appDir = TestFileSystemTimelineReaderImpl.getAppDir(rootDir, "cluster1", "user1", "flow1", "1", "app1", "app");
        TimelineEntity entity11 = new TimelineEntity();
        entity11.setId("id_1");
        entity11.setType("app");
        entity11.setCreatedTime(Long.valueOf(1425016502000L));
        HashMap<String, Object> info1 = new HashMap<String, Object>();
        info1.put("info1", "val1");
        info1.put("info2", "val5");
        entity11.addInfo(info1);
        TimelineEvent event = new TimelineEvent();
        event.setId("event_1");
        event.setTimestamp(1425016502003L);
        entity11.addEvent(event);
        HashSet<TimelineMetric> metrics = new HashSet<TimelineMetric>();
        TimelineMetric metric1 = new TimelineMetric();
        metric1.setId("metric1");
        metric1.setType(TimelineMetric.Type.SINGLE_VALUE);
        metric1.addValue(1425016502006L, (Number)113);
        metrics.add(metric1);
        TimelineMetric metric2 = new TimelineMetric();
        metric2.setId("metric2");
        metric2.setType(TimelineMetric.Type.TIME_SERIES);
        metric2.addValue(1425016502016L, (Number)34);
        metrics.add(metric2);
        entity11.setMetrics(metrics);
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("config_1", "127");
        entity11.setConfigs(configs);
        entity11.addRelatesToEntity("flow", "flow1");
        entity11.addIsRelatedToEntity("type1", "tid1_1");
        TestFileSystemTimelineReaderImpl.writeEntityFile(entity11, appDir);
        TimelineEntity entity12 = new TimelineEntity();
        entity12.setId("id_1");
        entity12.setType("app");
        configs.clear();
        configs.put("config_2", "23");
        configs.put("config_3", "abc");
        entity12.addConfigs(configs);
        metrics.clear();
        TimelineMetric metric12 = new TimelineMetric();
        metric12.setId("metric2");
        metric12.setType(TimelineMetric.Type.TIME_SERIES);
        metric12.addValue(1425016502032L, (Number)48);
        metric12.addValue(1425016502054L, (Number)51);
        metrics.add(metric12);
        TimelineMetric metric3 = new TimelineMetric();
        metric3.setId("metric3");
        metric3.setType(TimelineMetric.Type.SINGLE_VALUE);
        metric3.addValue(1425016502060L, (Number)23L);
        metrics.add(metric3);
        entity12.setMetrics(metrics);
        entity12.addIsRelatedToEntity("type1", "tid1_2");
        entity12.addIsRelatedToEntity("type2", "tid2_1`");
        TimelineEvent event15 = new TimelineEvent();
        event15.setId("event_5");
        event15.setTimestamp(1425016502017L);
        entity12.addEvent(event15);
        TestFileSystemTimelineReaderImpl.writeEntityFile(entity12, appDir);
        TimelineEntity entity2 = new TimelineEntity();
        entity2.setId("id_2");
        entity2.setType("app");
        entity2.setCreatedTime(Long.valueOf(1425016501050L));
        HashMap info2 = new HashMap();
        info1.put("info2", 4);
        entity2.addInfo(info2);
        HashMap<String, String> configs2 = new HashMap<String, String>();
        configs2.put("config_1", "129");
        configs2.put("config_3", "def");
        entity2.setConfigs(configs2);
        TimelineEvent event2 = new TimelineEvent();
        event2.setId("event_2");
        event2.setTimestamp(1425016501003L);
        entity2.addEvent(event2);
        HashSet<TimelineMetric> metrics2 = new HashSet<TimelineMetric>();
        TimelineMetric metric21 = new TimelineMetric();
        metric21.setId("metric1");
        metric21.setType(TimelineMetric.Type.SINGLE_VALUE);
        metric21.addValue(1425016501006L, (Number)300);
        metrics2.add(metric21);
        TimelineMetric metric22 = new TimelineMetric();
        metric22.setId("metric2");
        metric22.setType(TimelineMetric.Type.TIME_SERIES);
        metric22.addValue(1425016501056L, (Number)31);
        metric22.addValue(1425016501084L, (Number)70);
        metrics2.add(metric22);
        TimelineMetric metric23 = new TimelineMetric();
        metric23.setId("metric3");
        metric23.setType(TimelineMetric.Type.SINGLE_VALUE);
        metric23.addValue(1425016502060L, (Number)23L);
        metrics2.add(metric23);
        entity2.setMetrics(metrics2);
        entity2.addRelatesToEntity("flow", "flow2");
        TestFileSystemTimelineReaderImpl.writeEntityFile(entity2, appDir);
        TimelineEntity entity3 = new TimelineEntity();
        entity3.setId("id_3");
        entity3.setType("app");
        entity3.setCreatedTime(Long.valueOf(1425016501050L));
        HashMap<String, Number> info3 = new HashMap<String, Number>();
        info3.put("info2", 3.5);
        info3.put("info4", 20);
        entity3.addInfo(info3);
        HashMap<String, String> configs3 = new HashMap<String, String>();
        configs3.put("config_1", "123");
        configs3.put("config_3", "abc");
        entity3.setConfigs(configs3);
        TimelineEvent event3 = new TimelineEvent();
        event3.setId("event_2");
        event3.setTimestamp(1425016501003L);
        entity3.addEvent(event3);
        TimelineEvent event4 = new TimelineEvent();
        event4.setId("event_4");
        event4.setTimestamp(1425016502006L);
        entity3.addEvent(event4);
        HashSet<TimelineMetric> metrics3 = new HashSet<TimelineMetric>();
        TimelineMetric metric31 = new TimelineMetric();
        metric31.setId("metric1");
        metric31.setType(TimelineMetric.Type.SINGLE_VALUE);
        metric31.addValue(1425016501006L, (Number)124);
        metrics3.add(metric31);
        TimelineMetric metric32 = new TimelineMetric();
        metric32.setId("metric2");
        metric32.setType(TimelineMetric.Type.TIME_SERIES);
        metric32.addValue(1425016501056L, (Number)31);
        metric32.addValue(1425016501084L, (Number)74);
        metrics3.add(metric32);
        entity3.setMetrics(metrics3);
        entity3.addIsRelatedToEntity("type1", "tid1_2");
        TestFileSystemTimelineReaderImpl.writeEntityFile(entity3, appDir);
        TimelineEntity entity4 = new TimelineEntity();
        entity4.setId("id_4");
        entity4.setType("app");
        entity4.setCreatedTime(Long.valueOf(1425016502050L));
        TimelineEvent event44 = new TimelineEvent();
        event44.setId("event_4");
        event44.setTimestamp(1425016502003L);
        entity4.addEvent(event44);
        TestFileSystemTimelineReaderImpl.writeEntityFile(entity4, appDir);
        File attemptDir = TestFileSystemTimelineReaderImpl.getAppDir(rootDir, "cluster1", "user1", "flow1", "1", "app1", TimelineEntityType.YARN_APPLICATION_ATTEMPT.toString());
        ApplicationAttemptEntity attempt1 = new ApplicationAttemptEntity();
        attempt1.setId("app-attempt-1");
        attempt1.setCreatedTime(Long.valueOf(1425017502003L));
        TestFileSystemTimelineReaderImpl.writeEntityFile((TimelineEntity)attempt1, attemptDir);
        ApplicationAttemptEntity attempt2 = new ApplicationAttemptEntity();
        attempt2.setId("app-attempt-2");
        attempt2.setCreatedTime(Long.valueOf(1425017502004L));
        TestFileSystemTimelineReaderImpl.writeEntityFile((TimelineEntity)attempt2, attemptDir);
        File entityDir = TestFileSystemTimelineReaderImpl.getAppDir(rootDir, "cluster1", "user1", "flow1", "1", "app1", TimelineEntityType.YARN_CONTAINER.toString());
        ContainerEntity containerEntity1 = new ContainerEntity();
        containerEntity1.setId("container_1_1");
        containerEntity1.setParent(attempt1.getIdentifier());
        containerEntity1.setCreatedTime(Long.valueOf(1425017502003L));
        TestFileSystemTimelineReaderImpl.writeEntityFile((TimelineEntity)containerEntity1, entityDir);
        ContainerEntity containerEntity2 = new ContainerEntity();
        containerEntity2.setId("container_2_1");
        containerEntity2.setParent(attempt2.getIdentifier());
        containerEntity2.setCreatedTime(Long.valueOf(1425018502003L));
        TestFileSystemTimelineReaderImpl.writeEntityFile((TimelineEntity)containerEntity2, entityDir);
        ContainerEntity containerEntity3 = new ContainerEntity();
        containerEntity3.setId("container_2_2");
        containerEntity3.setParent(attempt2.getIdentifier());
        containerEntity3.setCreatedTime(Long.valueOf(1425018502003L));
        TestFileSystemTimelineReaderImpl.writeEntityFile((TimelineEntity)containerEntity3, entityDir);
        File appDir2 = TestFileSystemTimelineReaderImpl.getAppDir(rootDir, "cluster1", "user1", "flow1,flow", "1", "app2", "app");
        TimelineEntity entity5 = new TimelineEntity();
        entity5.setId("id_5");
        entity5.setType("app");
        entity5.setCreatedTime(Long.valueOf(1425016502050L));
        TestFileSystemTimelineReaderImpl.writeEntityFile(entity5, appDir2);
    }

    private static File getAppDir(String rootDir, String cluster, String user, String flowName, String flowRunId, String appId, String entityName) {
        return new File(rootDir + File.separator + "entities" + File.separator + cluster + File.separator + user + File.separator + flowName + File.separator + flowRunId + File.separator + appId + File.separator + entityName + File.separator);
    }

    @Test
    void testGetEntityDefaultView() throws Exception {
        TimelineEntity result = this.reader.getEntity(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", "id_1"), new TimelineDataToRetrieve(null, null, null, null, null, null));
        Assertions.assertEquals((Object)new TimelineEntity.Identifier("app", "id_1").toString(), (Object)result.getIdentifier().toString());
        Assertions.assertEquals((Long)1425016502000L, (Long)result.getCreatedTime());
        Assertions.assertEquals((int)0, (int)result.getConfigs().size());
        Assertions.assertEquals((int)0, (int)result.getMetrics().size());
    }

    @Test
    void testGetEntityByClusterAndApp() throws Exception {
        TimelineEntity result = this.reader.getEntity(new TimelineReaderContext("cluster1", null, null, null, "app1", "app", "id_1"), new TimelineDataToRetrieve(null, null, null, null, null, null));
        Assertions.assertEquals((Object)new TimelineEntity.Identifier("app", "id_1").toString(), (Object)result.getIdentifier().toString());
        Assertions.assertEquals((Long)1425016502000L, (Long)result.getCreatedTime());
        Assertions.assertEquals((int)0, (int)result.getConfigs().size());
        Assertions.assertEquals((int)0, (int)result.getMetrics().size());
    }

    @Test
    void testAppFlowMappingCsv() throws Exception {
        TimelineEntity result = this.reader.getEntity(new TimelineReaderContext("cluster1", null, null, null, "app2", "app", "id_5"), new TimelineDataToRetrieve(null, null, null, null, null, null));
        Assertions.assertEquals((Object)new TimelineEntity.Identifier("app", "id_5").toString(), (Object)result.getIdentifier().toString());
        Assertions.assertEquals((Long)1425016502050L, (Long)result.getCreatedTime());
    }

    @Test
    void testGetEntityCustomFields() throws Exception {
        TimelineEntity result = this.reader.getEntity(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", "id_1"), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.INFO, TimelineReader.Field.CONFIGS, TimelineReader.Field.METRICS), null, null, null));
        Assertions.assertEquals((Object)new TimelineEntity.Identifier("app", "id_1").toString(), (Object)result.getIdentifier().toString());
        Assertions.assertEquals((Long)1425016502000L, (Long)result.getCreatedTime());
        Assertions.assertEquals((int)3, (int)result.getConfigs().size());
        Assertions.assertEquals((int)3, (int)result.getMetrics().size());
        Assertions.assertEquals((int)2, (int)result.getInfo().size());
        Assertions.assertEquals((int)0, (int)result.getEvents().size());
    }

    @Test
    void testGetEntityAllFields() throws Exception {
        TimelineEntity result = this.reader.getEntity(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", "id_1"), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.ALL), null, null, null));
        Assertions.assertEquals((Object)new TimelineEntity.Identifier("app", "id_1").toString(), (Object)result.getIdentifier().toString());
        Assertions.assertEquals((Long)1425016502000L, (Long)result.getCreatedTime());
        Assertions.assertEquals((int)3, (int)result.getConfigs().size());
        Assertions.assertEquals((int)3, (int)result.getMetrics().size());
        Assertions.assertEquals((int)2, (int)result.getEvents().size());
    }

    @Test
    void testGetAllEntities() throws Exception {
        Set result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.ALL), null, null, null));
        Assertions.assertEquals((int)4, (int)result.size());
    }

    @Test
    void testGetEntitiesWithLimit() throws Exception {
        Set result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().entityLimit(Long.valueOf(2L)).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)2, (int)result.size());
        for (TimelineEntity entity : result) {
            if (entity.getId().equals("id_1") || entity.getId().equals("id_4")) continue;
            Assertions.fail((String)"Entity not sorted by created time");
        }
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().entityLimit(Long.valueOf(3L)).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)3, (int)result.size());
    }

    @Test
    void testGetEntitiesByTimeWindows() throws Exception {
        Set result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().createdTimeBegin(Long.valueOf(1425016502030L)).createTimeEnd(Long.valueOf(1425016502060L)).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)result.size());
        for (TimelineEntity entity : result) {
            if (entity.getId().equals("id_4")) continue;
            Assertions.fail((String)"Incorrect filtering based on created time range");
        }
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().createTimeEnd(Long.valueOf(1425016502010L)).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)3, (int)result.size());
        for (TimelineEntity entity : result) {
            if (!entity.getId().equals("id_4")) continue;
            Assertions.fail((String)"Incorrect filtering based on created time range");
        }
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().createdTimeBegin(Long.valueOf(1425016502010L)).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)result.size());
        for (TimelineEntity entity : result) {
            if (entity.getId().equals("id_4")) continue;
            Assertions.fail((String)"Incorrect filtering based on created time range");
        }
    }

    @Test
    void testGetFilteredEntities() throws Exception {
        TimelineFilterList infoFilterList = new TimelineFilterList();
        infoFilterList.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "info2", (Object)3.5));
        Set result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().infoFilters(infoFilterList).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)result.size());
        for (Object entity : result) {
            if (entity.getId().equals("id_3")) continue;
            Assertions.fail((String)"Incorrect filtering based on info filters");
        }
        TimelineFilterList confFilterList = new TimelineFilterList();
        confFilterList.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "config_1", (Object)"123"));
        confFilterList.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "config_3", (Object)"abc"));
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().configFilters(confFilterList).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)result.size());
        for (Object entity : result) {
            if (entity.getId().equals("id_3")) continue;
            Assertions.fail((String)"Incorrect filtering based on config filters");
        }
        TimelineFilterList eventFilters = new TimelineFilterList();
        eventFilters.addFilter((TimelineFilter)new TimelineExistsFilter(TimelineCompareOp.EQUAL, "event_2"));
        eventFilters.addFilter((TimelineFilter)new TimelineExistsFilter(TimelineCompareOp.EQUAL, "event_4"));
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().eventFilters(eventFilters).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)result.size());
        for (Object entity : result) {
            if (entity.getId().equals("id_3")) continue;
            Assertions.fail((String)"Incorrect filtering based on event filters");
        }
        TimelineFilterList metricFilterList = new TimelineFilterList();
        metricFilterList.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.GREATER_OR_EQUAL, "metric3", (Object)0L));
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)2, (int)result.size());
        for (TimelineEntity entity : result) {
            if (entity.getId().equals("id_1") || entity.getId().equals("id_2")) continue;
            Assertions.fail((String)"Incorrect filtering based on metric filters");
        }
        TimelineFilterList list1 = new TimelineFilterList();
        list1.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "config_1", (Object)"129"));
        list1.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "config_3", (Object)"def"));
        TimelineFilterList list2 = new TimelineFilterList();
        list2.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "config_2", (Object)"23"));
        list2.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "config_3", (Object)"abc"));
        TimelineFilterList confFilterList1 = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{list1, list2});
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().configFilters(confFilterList1).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)2, (int)result.size());
        for (TimelineEntity entity : result) {
            if (entity.getId().equals("id_1") || entity.getId().equals("id_2")) continue;
            Assertions.fail((String)"Incorrect filtering based on config filters");
        }
        TimelineFilterList list3 = new TimelineFilterList();
        list3.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "config_1", (Object)"123"));
        list3.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "config_3", (Object)"abc"));
        TimelineFilterList list4 = new TimelineFilterList();
        list4.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "config_2", (Object)"23"));
        TimelineFilterList confFilterList2 = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{list3, list4});
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().configFilters(confFilterList2).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)2, (int)result.size());
        for (Object entity : result) {
            if (entity.getId().equals("id_1") || entity.getId().equals("id_2")) continue;
            Assertions.fail((String)"Incorrect filtering based on config filters");
        }
        TimelineFilterList confFilterList3 = new TimelineFilterList();
        confFilterList3.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "config_1", (Object)"127"));
        confFilterList3.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "config_3", (Object)"abc"));
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().configFilters(confFilterList3).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)result.size());
        for (TimelineEntity entity : result) {
            if (entity.getId().equals("id_2")) continue;
            Assertions.fail((String)"Incorrect filtering based on config filters");
        }
        TimelineFilterList confFilterList4 = new TimelineFilterList();
        confFilterList4.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "config_dummy", (Object)"dummy"));
        confFilterList4.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "config_3", (Object)"def"));
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().configFilters(confFilterList4).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)0, (int)result.size());
        TimelineFilterList confFilterList5 = new TimelineFilterList(TimelineFilterList.Operator.OR);
        confFilterList5.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "config_dummy", (Object)"dummy"));
        confFilterList5.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "config_3", (Object)"def"));
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().configFilters(confFilterList5).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)result.size());
        for (TimelineEntity entity : result) {
            if (entity.getId().equals("id_2")) continue;
            Assertions.fail((String)"Incorrect filtering based on config filters");
        }
        TimelineFilterList list6 = new TimelineFilterList();
        list6.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.GREATER_THAN, "metric1", (Object)200));
        list6.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.EQUAL, "metric3", (Object)23));
        TimelineFilterList list7 = new TimelineFilterList();
        list7.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.GREATER_OR_EQUAL, "metric2", (Object)74));
        TimelineFilterList metricFilterList1 = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{list6, list7});
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList1).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)2, (int)result.size());
        for (Object entity : result) {
            if (entity.getId().equals("id_2") || entity.getId().equals("id_3")) continue;
            Assertions.fail((String)"Incorrect filtering based on metric filters");
        }
        TimelineFilterList metricFilterList2 = new TimelineFilterList();
        metricFilterList2.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, "metric2", (Object)70));
        metricFilterList2.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.LESS_OR_EQUAL, "metric3", (Object)23));
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList2).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)result.size());
        for (TimelineEntity entity : result) {
            if (entity.getId().equals("id_1")) continue;
            Assertions.fail((String)"Incorrect filtering based on metric filters");
        }
        TimelineFilterList metricFilterList3 = new TimelineFilterList();
        metricFilterList3.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, "dummy_metric", (Object)30));
        metricFilterList3.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.LESS_OR_EQUAL, "metric3", (Object)23));
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList3).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)0, (int)result.size());
        TimelineFilterList metricFilterList4 = new TimelineFilterList(TimelineFilterList.Operator.OR);
        metricFilterList4.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, "dummy_metric", (Object)30));
        metricFilterList4.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.LESS_OR_EQUAL, "metric3", (Object)23));
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList4).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)2, (int)result.size());
        for (Object entity : result) {
            if (entity.getId().equals("id_1") || entity.getId().equals("id_2")) continue;
            Assertions.fail((String)"Incorrect filtering based on metric filters");
        }
        TimelineFilterList metricFilterList5 = new TimelineFilterList(new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.NOT_EQUAL, "metric2", (Object)74)});
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList5).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)2, (int)result.size());
        for (TimelineEntity entity : result) {
            if (entity.getId().equals("id_1") || entity.getId().equals("id_2")) continue;
            Assertions.fail((String)"Incorrect filtering based on metric filters");
        }
        TimelineFilterList infoFilterList1 = new TimelineFilterList();
        infoFilterList1.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "info2", (Object)3.5));
        infoFilterList1.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "info4", (Object)20));
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().infoFilters(infoFilterList1).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)0, (int)result.size());
        TimelineFilterList infoFilterList2 = new TimelineFilterList(TimelineFilterList.Operator.OR);
        infoFilterList2.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "info2", (Object)3.5));
        infoFilterList2.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "info1", (Object)"val1"));
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().infoFilters(infoFilterList2).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)2, (int)result.size());
        for (TimelineEntity entity : result) {
            if (entity.getId().equals("id_1") || entity.getId().equals("id_3")) continue;
            Assertions.fail((String)"Incorrect filtering based on info filters");
        }
        TimelineFilterList infoFilterList3 = new TimelineFilterList();
        infoFilterList3.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "dummy_info", (Object)1));
        infoFilterList3.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "info2", (Object)"val5"));
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().infoFilters(infoFilterList3).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)0, (int)result.size());
        TimelineFilterList infoFilterList4 = new TimelineFilterList(TimelineFilterList.Operator.OR);
        infoFilterList4.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "dummy_info", (Object)1));
        infoFilterList4.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "info2", (Object)"val5"));
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().infoFilters(infoFilterList4).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)result.size());
        for (TimelineEntity entity : result) {
            if (entity.getId().equals("id_1")) continue;
            Assertions.fail((String)"Incorrect filtering based on info filters");
        }
    }

    @Test
    void testGetEntitiesByRelations() throws Exception {
        TimelineFilterList relatesTo = new TimelineFilterList(TimelineFilterList.Operator.OR);
        HashSet<Object> relatesToIds = new HashSet<Object>(Arrays.asList("flow1"));
        relatesTo.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "flow", relatesToIds));
        Set result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().relatesTo(relatesTo).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)result.size());
        for (TimelineEntity entity : result) {
            if (entity.getId().equals("id_1")) continue;
            Assertions.fail((String)"Incorrect filtering based on relatesTo");
        }
        TimelineFilterList isRelatedTo = new TimelineFilterList(TimelineFilterList.Operator.OR);
        HashSet<Object> isRelatedToIds = new HashSet<Object>(Arrays.asList("tid1_2"));
        isRelatedTo.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "type1", isRelatedToIds));
        result = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "flow1", Long.valueOf(1L), "app1", "app", null), new TimelineEntityFilters.Builder().isRelatedTo(isRelatedTo).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)2, (int)result.size());
        for (TimelineEntity entity : result) {
            if (entity.getId().equals("id_1") || entity.getId().equals("id_3")) continue;
            Assertions.fail((String)"Incorrect filtering based on isRelatedTo");
        }
    }
}

