/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationReportPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.webproxy.AppReportFetcher;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxy;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServer;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class TestWebAppProxyServlet {
    private static final Log LOG = LogFactory.getLog(TestWebAppProxyServlet.class);
    private static Server server;
    private static int originalPort;

    @BeforeClass
    public static void start() throws Exception {
        server = new Server(0);
        Context context = new Context();
        context.setContextPath("/foo");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder(TestServlet.class), "/bar");
        server.getConnectors()[0].setHost("localhost");
        server.start();
        originalPort = server.getConnectors()[0].getLocalPort();
        LOG.info((Object)("Running embedded servlet container at: http://localhost:" + originalPort));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testWebAppProxyServlet() throws Exception {
        Configuration configuration = new Configuration();
        configuration.set("yarn.web-proxy.address", "localhost:9090");
        configuration.setInt("hadoop.http.max.threads", 5);
        WebAppProxyServerForTest proxy = new WebAppProxyServerForTest();
        proxy.init(configuration);
        proxy.start();
        int proxyPort = ((WebAppProxyServerForTest)proxy).proxy.proxyServer.getConnectorAddress(0).getPort();
        AppReportFetcherForTest appReportFetcher = ((WebAppProxyServerForTest)proxy).proxy.appReportFetcher;
        try {
            URL wrongUrl = new URL("http://localhost:" + proxyPort + "/proxy/app");
            HttpURLConnection proxyConn = (HttpURLConnection)wrongUrl.openConnection();
            proxyConn.connect();
            Assert.assertEquals((long)500L, (long)proxyConn.getResponseCode());
            URL url = new URL("http://localhost:" + proxyPort + "/proxy/application_00_0");
            proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.setRequestProperty("Cookie", "checked_application_0_0000=true");
            proxyConn.connect();
            Assert.assertEquals((long)200L, (long)proxyConn.getResponseCode());
            Assert.assertTrue((boolean)this.isResponseCookiePresent(proxyConn, "checked_application_0_0000", "true"));
            appReportFetcher.answer = 1;
            proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.setRequestProperty("Cookie", "checked_application_0_0000=true");
            proxyConn.connect();
            Assert.assertEquals((long)404L, (long)proxyConn.getResponseCode());
            Assert.assertFalse((boolean)this.isResponseCookiePresent(proxyConn, "checked_application_0_0000", "true"));
            appReportFetcher.answer = 4;
            proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.setRequestProperty("Cookie", "checked_application_0_0000=true");
            proxyConn.connect();
            Assert.assertEquals((long)404L, (long)proxyConn.getResponseCode());
            Assert.assertFalse((boolean)this.isResponseCookiePresent(proxyConn, "checked_application_0_0000", "true"));
            appReportFetcher.answer = 2;
            proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.connect();
            Assert.assertEquals((long)200L, (long)proxyConn.getResponseCode());
            String s = this.readInputStream(proxyConn.getInputStream());
            Assert.assertTrue((boolean)s.contains("to continue to an Application Master web interface owned by"));
            Assert.assertTrue((boolean)s.contains("WARNING: The following page may not be safe!"));
            appReportFetcher.answer = 3;
            proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.setRequestProperty("Cookie", "checked_application_0_0000=true");
            proxyConn.connect();
            Assert.assertEquals((long)200L, (long)proxyConn.getResponseCode());
            appReportFetcher.answer = 5;
            URL clientUrl = new URL("http://localhost:" + proxyPort + "/proxy/application_00_0/test/tez?x=y&h=p");
            proxyConn = (HttpURLConnection)clientUrl.openConnection();
            proxyConn.connect();
            LOG.info((Object)("" + proxyConn.getURL()));
            LOG.info((Object)("ProxyConn.getHeaderField(): " + proxyConn.getHeaderField("Location")));
            Assert.assertEquals((Object)("http://localhost:" + originalPort + "/foo/bar/test/tez?a=b&x=y&h=p#main"), (Object)proxyConn.getURL().toString());
        }
        finally {
            proxy.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testWebAppProxyServerMainMethod() throws Exception {
        WebAppProxyServer mainServer = null;
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.web-proxy.address", "localhost:9099");
        try {
            mainServer = WebAppProxyServer.startServer((Configuration)conf);
            int counter = 20;
            URL wrongUrl = new URL("http://localhost:9099/proxy/app");
            HttpURLConnection proxyConn = null;
            while (counter > 0) {
                --counter;
                try {
                    proxyConn = (HttpURLConnection)wrongUrl.openConnection();
                    proxyConn.connect();
                    proxyConn.getResponseCode();
                    counter = 0;
                }
                catch (Exception e) {
                    Thread.sleep(100L);
                }
            }
            Assert.assertNotNull(proxyConn);
            Assert.assertEquals((long)500L, (long)proxyConn.getResponseCode());
        }
        finally {
            if (mainServer != null) {
                mainServer.stop();
            }
        }
    }

    private String readInputStream(InputStream input) throws Exception {
        int read;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        byte[] buffer = new byte[512];
        while ((read = input.read(buffer)) >= 0) {
            data.write(buffer, 0, read);
        }
        return new String(data.toByteArray(), "UTF-8");
    }

    private boolean isResponseCookiePresent(HttpURLConnection proxyConn, String expectedName, String expectedValue) {
        Map<String, List<String>> headerFields = proxyConn.getHeaderFields();
        List<String> cookiesHeader = headerFields.get("Set-Cookie");
        if (cookiesHeader != null) {
            for (String cookie : cookiesHeader) {
                HttpCookie c = HttpCookie.parse(cookie).get(0);
                if (!c.getName().equals(expectedName) || !c.getValue().equals(expectedValue)) continue;
                return true;
            }
        }
        return false;
    }

    @AfterClass
    public static void stop() throws Exception {
        try {
            server.stop();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            server.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        originalPort = 0;
    }

    private class AppReportFetcherForTest
    extends AppReportFetcher {
        int answer;

        public AppReportFetcherForTest(Configuration conf) {
            super(conf);
            this.answer = 0;
        }

        public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException {
            if (this.answer == 0) {
                return this.getDefaultApplicationReport(appId);
            }
            if (this.answer == 1) {
                return null;
            }
            if (this.answer == 2) {
                ApplicationReport result = this.getDefaultApplicationReport(appId);
                result.setUser("user");
                return result;
            }
            if (this.answer == 3) {
                ApplicationReport result = this.getDefaultApplicationReport(appId);
                result.setYarnApplicationState(YarnApplicationState.KILLED);
                return result;
            }
            if (this.answer == 4) {
                throw new ApplicationNotFoundException("Application is not found");
            }
            if (this.answer == 5) {
                ApplicationReport result = this.getDefaultApplicationReport(appId);
                result.setOriginalTrackingUrl("localhost:" + originalPort + "/foo/bar?a=b#main");
                result.setYarnApplicationState(YarnApplicationState.FINISHED);
                return result;
            }
            return null;
        }

        private ApplicationReport getDefaultApplicationReport(ApplicationId appId) {
            ApplicationReportPBImpl result = new ApplicationReportPBImpl();
            result.setApplicationId(appId);
            result.setOriginalTrackingUrl("localhost:" + originalPort + "/foo/bar");
            result.setYarnApplicationState(YarnApplicationState.RUNNING);
            result.setUser("dr.who");
            return result;
        }
    }

    private class WebAppProxyForTest
    extends WebAppProxy {
        HttpServer2 proxyServer;
        AppReportFetcherForTest appReportFetcher;

        private WebAppProxyForTest() {
        }

        public void start() {
            try {
                Configuration conf = this.getConfig();
                String bindAddress = conf.get("yarn.web-proxy.address");
                bindAddress = StringUtils.split((String)bindAddress, (char)':')[0];
                AccessControlList acl = new AccessControlList(conf.get("yarn.admin.acl", "*"));
                this.proxyServer = new HttpServer2.Builder().setName("proxy").addEndpoint(URI.create(WebAppUtils.getHttpSchemePrefix((Configuration)conf) + bindAddress + ":0")).setFindPort(true).setConf(conf).setACL(acl).build();
                this.proxyServer.addServlet("proxy", "/proxy/*", WebAppProxyServlet.class);
                this.appReportFetcher = new AppReportFetcherForTest(conf);
                this.proxyServer.setAttribute("AppUrlFetcher", (Object)this.appReportFetcher);
                this.proxyServer.setAttribute("IsSecurityEnabled", (Object)Boolean.TRUE);
                String proxy = WebAppUtils.getProxyHostAndPort((Configuration)conf);
                String[] proxyParts = proxy.split(":");
                String proxyHost = proxyParts[0];
                this.proxyServer.setAttribute("proxyHost", (Object)proxyHost);
                this.proxyServer.start();
                System.out.println("Proxy server is started at port " + this.proxyServer.getConnectorAddress(0).getPort());
            }
            catch (Exception e) {
                LOG.fatal((Object)"Could not start proxy web server", (Throwable)e);
                throw new YarnRuntimeException("Could not start proxy web server", (Throwable)e);
            }
        }
    }

    private class WebAppProxyServerForTest
    extends CompositeService {
        private WebAppProxyForTest proxy;

        public WebAppProxyServerForTest() {
            super(WebAppProxyServer.class.getName());
            this.proxy = null;
        }

        public synchronized void init(Configuration conf) {
            YarnConfiguration config = new YarnConfiguration(conf);
            this.proxy = new WebAppProxyForTest();
            this.addService((Service)this.proxy);
            super.init((Configuration)config);
        }
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            ServletInputStream is = req.getInputStream();
            ServletOutputStream os = resp.getOutputStream();
            int c = is.read();
            while (c > -1) {
                os.write(c);
                c = is.read();
            }
            is.close();
            os.close();
            resp.setStatus(200);
        }
    }
}

