/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ColumnPrefixFilter
extends FilterBase {
    protected byte[] prefix = null;

    public ColumnPrefixFilter(byte[] prefix) {
        this.prefix = prefix;
    }

    public byte[] getPrefix() {
        return this.prefix;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell kv) {
        if (this.prefix == null || kv.getQualifierArray() == null) {
            return Filter.ReturnCode.INCLUDE;
        }
        return this.filterColumn(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength());
    }

    public Filter.ReturnCode filterColumn(byte[] buffer, int qualifierOffset, int qualifierLength) {
        if (qualifierLength < this.prefix.length) {
            int cmp = Bytes.compareTo((byte[])buffer, (int)qualifierOffset, (int)qualifierLength, (byte[])this.prefix, (int)0, (int)qualifierLength);
            if (cmp <= 0) {
                return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
            }
            return Filter.ReturnCode.NEXT_ROW;
        }
        int cmp = Bytes.compareTo((byte[])buffer, (int)qualifierOffset, (int)this.prefix.length, (byte[])this.prefix, (int)0, (int)this.prefix.length);
        if (cmp < 0) {
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        if (cmp > 0) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 but got: %s", (Object[])new Object[]{filterArguments.size()});
        byte[] columnPrefix = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
        return new ColumnPrefixFilter(columnPrefix);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.ColumnPrefixFilter.Builder builder = FilterProtos.ColumnPrefixFilter.newBuilder();
        if (this.prefix != null) {
            builder.setPrefix(ByteString.copyFrom((byte[])this.prefix));
        }
        return builder.build().toByteArray();
    }

    public static ColumnPrefixFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.ColumnPrefixFilter proto;
        try {
            proto = FilterProtos.ColumnPrefixFilter.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new ColumnPrefixFilter(proto.getPrefix().toByteArray());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnPrefixFilter)) {
            return false;
        }
        ColumnPrefixFilter other = (ColumnPrefixFilter)o;
        return Bytes.equals((byte[])this.getPrefix(), (byte[])other.getPrefix());
    }

    @Override
    public Cell getNextCellHint(Cell kv) {
        return KeyValue.createFirstOnRow((byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])kv.getFamilyArray(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength(), (byte[])this.prefix, (int)0, (int)this.prefix.length);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + Bytes.toStringBinary((byte[])this.prefix);
    }
}

