/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.zookeeper.ZKTableReadOnly;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ZKTable {
    private static final Log LOG = LogFactory.getLog(ZKTable.class);
    private final ZooKeeperWatcher watcher;
    private final Map<TableName, ZooKeeperProtos.Table.State> cache = new HashMap<TableName, ZooKeeperProtos.Table.State>();

    public ZKTable(ZooKeeperWatcher zkw) throws KeeperException {
        this.watcher = zkw;
        this.populateTableStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateTableStates() throws KeeperException {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            List<String> children = ZKUtil.listChildrenNoWatch(this.watcher, this.watcher.tableZNode);
            if (children == null) {
                return;
            }
            for (String child : children) {
                TableName tableName = TableName.valueOf((String)child);
                ZooKeeperProtos.Table.State state = ZKTableReadOnly.getTableState(this.watcher, tableName);
                if (state == null) continue;
                this.cache.put(tableName, state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisabledTable(TableName tableName) throws KeeperException {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            if (!this.isDisablingOrDisabledTable(tableName)) {
                LOG.warn((Object)("Moving table " + tableName + " state to disabled but was " + "not first in disabling state: " + this.cache.get(tableName)));
            }
            this.setTableState(tableName, ZooKeeperProtos.Table.State.DISABLED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisablingTable(TableName tableName) throws KeeperException {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            if (!this.isEnabledOrDisablingTable(tableName)) {
                LOG.warn((Object)("Moving table " + tableName + " state to disabling but was " + "not first in enabled state: " + this.cache.get(tableName)));
            }
            this.setTableState(tableName, ZooKeeperProtos.Table.State.DISABLING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnablingTable(TableName tableName) throws KeeperException {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            if (!this.isDisabledOrEnablingTable(tableName)) {
                LOG.warn((Object)("Moving table " + tableName + " state to enabling but was " + "not first in disabled state: " + this.cache.get(tableName)));
            }
            this.setTableState(tableName, ZooKeeperProtos.Table.State.ENABLING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAndSetEnablingTable(TableName tableName) throws KeeperException {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            if (this.isEnablingTable(tableName)) {
                return false;
            }
            this.setTableState(tableName, ZooKeeperProtos.Table.State.ENABLING);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkDisabledAndSetEnablingTable(TableName tableName) throws KeeperException {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            if (!this.isDisabledTable(tableName)) {
                return false;
            }
            this.setTableState(tableName, ZooKeeperProtos.Table.State.ENABLING);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkEnabledAndSetDisablingTable(TableName tableName) throws KeeperException {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            if (this.cache.get(tableName) != null && !this.isEnabledTable(tableName)) {
                return false;
            }
            this.setTableState(tableName, ZooKeeperProtos.Table.State.DISABLING);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTableState(TableName tableName, ZooKeeperProtos.Table.State state) throws KeeperException {
        String znode = ZKUtil.joinZNode(this.watcher.tableZNode, tableName.getNameAsString());
        if (ZKUtil.checkExists(this.watcher, znode) == -1) {
            ZKUtil.createAndFailSilent(this.watcher, znode);
        }
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            ZooKeeperProtos.Table.Builder builder = ZooKeeperProtos.Table.newBuilder();
            builder.setState(state);
            byte[] data = ProtobufUtil.prependPBMagic(builder.build().toByteArray());
            ZKUtil.setData(this.watcher, znode, data);
            this.cache.put(tableName, state);
        }
    }

    public boolean isDisabledTable(TableName tableName) {
        return this.isTableState(tableName, ZooKeeperProtos.Table.State.DISABLED);
    }

    public boolean isDisablingTable(TableName tableName) {
        return this.isTableState(tableName, ZooKeeperProtos.Table.State.DISABLING);
    }

    public boolean isEnablingTable(TableName tableName) {
        return this.isTableState(tableName, ZooKeeperProtos.Table.State.ENABLING);
    }

    public boolean isEnabledTable(TableName tableName) {
        return this.isTableState(tableName, ZooKeeperProtos.Table.State.ENABLED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisablingOrDisabledTable(TableName tableName) {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            return this.isDisablingTable(tableName) || this.isDisabledTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabledOrDisablingTable(TableName tableName) {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            return this.isEnabledTable(tableName) || this.isDisablingTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisabledOrEnablingTable(TableName tableName) {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            return this.isDisabledTable(tableName) || this.isEnablingTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTableState(TableName tableName, ZooKeeperProtos.Table.State state) {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            ZooKeeperProtos.Table.State currentState = this.cache.get(tableName);
            return ZKTableReadOnly.isTableState(currentState, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeletedTable(TableName tableName) throws KeeperException {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            if (this.cache.remove(tableName) == null) {
                LOG.warn((Object)("Moving table " + tableName + " state to deleted but was " + "already deleted"));
            }
            ZKUtil.deleteNodeFailSilent(this.watcher, ZKUtil.joinZNode(this.watcher.tableZNode, tableName.getNameAsString()));
        }
    }

    public void setEnabledTable(TableName tableName) throws KeeperException {
        this.setTableState(tableName, ZooKeeperProtos.Table.State.ENABLED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTablePresent(TableName tableName) {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            ZooKeeperProtos.Table.State state = this.cache.get(tableName);
            return state != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TableName> getDisabledTables() {
        HashSet<TableName> disabledTables = new HashSet<TableName>();
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            Set<TableName> tables = this.cache.keySet();
            for (TableName table : tables) {
                if (!this.isDisabledTable(table)) continue;
                disabledTables.add(table);
            }
        }
        return disabledTables;
    }

    public static Set<TableName> getDisabledTables(ZooKeeperWatcher zkw) throws KeeperException {
        return ZKTable.getAllTables(zkw, ZooKeeperProtos.Table.State.DISABLED);
    }

    public static Set<TableName> getDisablingTables(ZooKeeperWatcher zkw) throws KeeperException {
        return ZKTable.getAllTables(zkw, ZooKeeperProtos.Table.State.DISABLING);
    }

    public static Set<TableName> getEnablingTables(ZooKeeperWatcher zkw) throws KeeperException {
        return ZKTable.getAllTables(zkw, ZooKeeperProtos.Table.State.ENABLING);
    }

    public static Set<TableName> getDisabledOrDisablingTables(ZooKeeperWatcher zkw) throws KeeperException {
        return ZKTable.getAllTables(zkw, ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEnablingTable(TableName tableName, boolean deleteZNode) throws KeeperException {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            if (this.isEnablingTable(tableName)) {
                this.cache.remove(tableName);
                if (deleteZNode) {
                    ZKUtil.deleteNodeFailSilent(this.watcher, ZKUtil.joinZNode(this.watcher.tableZNode, tableName.getNameAsString()));
                }
            }
        }
    }

    static Set<TableName> getAllTables(ZooKeeperWatcher zkw, ZooKeeperProtos.Table.State ... states) throws KeeperException {
        HashSet<TableName> allTables = new HashSet<TableName>();
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, zkw.tableZNode);
        if (children == null) {
            return allTables;
        }
        block0: for (String child : children) {
            TableName tableName = TableName.valueOf((String)child);
            ZooKeeperProtos.Table.State state = ZKTableReadOnly.getTableState(zkw, tableName);
            for (ZooKeeperProtos.Table.State expectedState : states) {
                if (state != expectedState) continue;
                allTables.add(tableName);
                continue block0;
            }
        }
        return allTables;
    }
}

