/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TestCellUtil;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestCellComparator {
    private CellComparator comparator = CellComparator.COMPARATOR;
    byte[] row1 = Bytes.toBytes((String)"row1");
    byte[] row2 = Bytes.toBytes((String)"row2");
    byte[] row_1_0 = Bytes.toBytes((String)"row10");
    byte[] fam1 = Bytes.toBytes((String)"fam1");
    byte[] fam2 = Bytes.toBytes((String)"fam2");
    byte[] fam_1_2 = Bytes.toBytes((String)"fam12");
    byte[] qual1 = Bytes.toBytes((String)"qual1");
    byte[] qual2 = Bytes.toBytes((String)"qual2");
    byte[] val = Bytes.toBytes((String)"val");

    @Test
    public void testCompareCells() {
        KeyValue kv1 = new KeyValue(this.row1, this.fam1, this.qual1, this.val);
        KeyValue kv2 = new KeyValue(this.row2, this.fam1, this.qual1, this.val);
        Assert.assertTrue((this.comparator.compare((Cell)kv1, (Cell)kv2) < 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam2, this.qual1, this.val);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, this.val);
        Assert.assertTrue((CellComparator.compareFamilies((Cell)kv1, (Cell)kv2) > 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, this.val);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 2L, this.val);
        Assert.assertTrue((this.comparator.compare((Cell)kv1, (Cell)kv2) > 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Maximum);
        Assert.assertTrue((this.comparator.compare((Cell)kv1, (Cell)kv2) > 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        Assert.assertTrue((boolean)CellUtil.equals((Cell)kv1, (Cell)kv2));
    }

    @Test
    public void testCompareCellWithKey() throws Exception {
        KeyValue kv1 = new KeyValue(this.row1, this.fam1, this.qual1, this.val);
        KeyValue kv2 = new KeyValue(this.row2, this.fam1, this.qual1, this.val);
        Assert.assertTrue((this.comparator.compare((Cell)kv1, kv2.getKey(), 0, kv2.getKey().length) < 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam2, this.qual1, this.val);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, this.val);
        Assert.assertTrue((this.comparator.compare((Cell)kv1, kv2.getKey(), 0, kv2.getKey().length) > 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, this.val);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 2L, this.val);
        Assert.assertTrue((this.comparator.compare((Cell)kv1, kv2.getKey(), 0, kv2.getKey().length) > 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Maximum);
        Assert.assertTrue((this.comparator.compare((Cell)kv1, kv2.getKey(), 0, kv2.getKey().length) > 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        Assert.assertTrue((this.comparator.compare((Cell)kv1, kv2.getKey(), 0, kv2.getKey().length) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareByteBufferedCell() {
        byte[] r1 = Bytes.toBytes((String)"row1");
        byte[] r2 = Bytes.toBytes((String)"row2");
        byte[] f1 = Bytes.toBytes((String)"cf1");
        byte[] q1 = Bytes.toBytes((String)"qual1");
        byte[] q2 = Bytes.toBytes((String)"qual2");
        byte[] v = Bytes.toBytes((String)"val1");
        KeyValue kv = new KeyValue(r1, f1, q1, v);
        ByteBuffer buffer = ByteBuffer.wrap(kv.getBuffer());
        TestCellUtil.ByteBufferedCellImpl bbCell1 = new TestCellUtil.ByteBufferedCellImpl(buffer, 0, buffer.remaining());
        kv = new KeyValue(r2, f1, q1, v);
        buffer = ByteBuffer.wrap(kv.getBuffer());
        TestCellUtil.ByteBufferedCellImpl bbCell2 = new TestCellUtil.ByteBufferedCellImpl(buffer, 0, buffer.remaining());
        Assert.assertEquals((long)0L, (long)CellComparator.compareColumns((Cell)bbCell1, (Cell)bbCell2));
        Assert.assertEquals((long)0L, (long)CellComparator.compareColumns((Cell)bbCell1, (Cell)kv));
        kv = new KeyValue(r2, f1, q2, v);
        buffer = ByteBuffer.wrap(kv.getBuffer());
        TestCellUtil.ByteBufferedCellImpl bbCell3 = new TestCellUtil.ByteBufferedCellImpl(buffer, 0, buffer.remaining());
        Assert.assertEquals((long)0L, (long)CellComparator.compareFamilies((Cell)bbCell2, (Cell)bbCell3));
        Assert.assertTrue((CellComparator.compareQualifiers((Cell)bbCell2, (Cell)bbCell3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparator.compareColumns((Cell)bbCell2, (Cell)bbCell3) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)CellComparator.COMPARATOR.compareRows((Cell)bbCell2, (Cell)bbCell3));
        Assert.assertTrue((CellComparator.COMPARATOR.compareRows((Cell)bbCell1, (Cell)bbCell2) < 0 ? 1 : 0) != 0);
    }
}

