/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.hadoop.hbase.io.BoundedByteBufferPool;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestBoundedByteBufferPool {
    final int maxByteBufferSizeToCache = 10;
    final int initialByteBufferSize = 1;
    final int maxToCache = 10;
    BoundedByteBufferPool reservoir;

    @Before
    public void before() {
        this.reservoir = new BoundedByteBufferPool(10, 1, 10);
    }

    @After
    public void after() {
        this.reservoir = null;
    }

    @Test
    public void testEquivalence() {
        ByteBuffer bb = ByteBuffer.allocate(1);
        this.reservoir.putBuffer(bb);
        this.reservoir.putBuffer(bb);
        this.reservoir.putBuffer(bb);
        Assert.assertEquals((long)3L, (long)this.reservoir.getQueueSize());
    }

    @Test
    public void testGetPut() {
        ByteBuffer bb = this.reservoir.getBuffer();
        Assert.assertEquals((long)1L, (long)bb.capacity());
        Assert.assertEquals((long)0L, (long)this.reservoir.getQueueSize());
        this.reservoir.putBuffer(bb);
        Assert.assertEquals((long)1L, (long)this.reservoir.getQueueSize());
        this.reservoir.getBuffer();
        Assert.assertEquals((long)0L, (long)this.reservoir.getQueueSize());
        int newCapacity = 2;
        this.reservoir.putBuffer(ByteBuffer.allocate(2));
        Assert.assertEquals((long)1L, (long)this.reservoir.getQueueSize());
        this.reservoir.getBuffer();
        Assert.assertEquals((long)0L, (long)this.reservoir.getQueueSize());
        bb = this.reservoir.getBuffer();
        Assert.assertEquals((long)2L, (long)bb.capacity());
        Assert.assertEquals((long)0L, (long)this.reservoir.getQueueSize());
        this.reservoir.putBuffer(ByteBuffer.allocate(20));
        Assert.assertEquals((long)0L, (long)this.reservoir.getQueueSize());
        for (int i = 0; i < 10; ++i) {
            this.reservoir.putBuffer(ByteBuffer.allocate(1));
        }
        Assert.assertEquals((long)10L, (long)this.reservoir.getQueueSize());
    }

    @Test
    public void testBufferSizeGrowWithMultiThread() throws Exception {
        int i;
        final ConcurrentLinkedDeque bufferQueue = new ConcurrentLinkedDeque();
        int takeBufferThreadsCount = 30;
        int putBufferThreadsCount = 1;
        Thread[] takeBufferThreads = new Thread[takeBufferThreadsCount];
        for (int i2 = 0; i2 < takeBufferThreadsCount; ++i2) {
            takeBufferThreads[i2] = new Thread(new Runnable(){

                @Override
                public void run() {
                    do {
                        ByteBuffer buffer = TestBoundedByteBufferPool.this.reservoir.getBuffer();
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                        bufferQueue.offer(buffer);
                    } while (!Thread.currentThread().isInterrupted());
                }
            });
        }
        Thread[] putBufferThread = new Thread[putBufferThreadsCount];
        for (i = 0; i < putBufferThreadsCount; ++i) {
            putBufferThread[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    do {
                        ByteBuffer buffer;
                        if ((buffer = (ByteBuffer)bufferQueue.poll()) == null) continue;
                        TestBoundedByteBufferPool.this.reservoir.putBuffer(buffer);
                    } while (!Thread.currentThread().isInterrupted());
                }
            });
        }
        for (i = 0; i < takeBufferThreadsCount; ++i) {
            takeBufferThreads[i].start();
        }
        for (i = 0; i < putBufferThreadsCount; ++i) {
            putBufferThread[i].start();
        }
        Thread.sleep(2000L);
        for (i = 0; i < takeBufferThreadsCount; ++i) {
            takeBufferThreads[i].interrupt();
            takeBufferThreads[i].join();
        }
        for (i = 0; i < putBufferThreadsCount; ++i) {
            putBufferThread[i].interrupt();
            putBufferThread[i].join();
        }
        Assert.assertEquals((long)1L, (long)this.reservoir.getRunningAverage());
    }

    @Test
    public void testStateConversionMethods() {
        int countOfBuffers = 123;
        int totalCapacity = 456;
        long state = BoundedByteBufferPool.toState((int)countOfBuffers, (int)totalCapacity);
        Assert.assertEquals((long)countOfBuffers, (long)BoundedByteBufferPool.toCountOfBuffers((long)state));
        Assert.assertEquals((long)totalCapacity, (long)BoundedByteBufferPool.toTotalCapacity((long)state));
        long state2 = BoundedByteBufferPool.subtractOneBufferFromState((long)state, (int)7);
        Assert.assertEquals((long)(countOfBuffers - 1), (long)BoundedByteBufferPool.toCountOfBuffers((long)state2));
        Assert.assertEquals((long)(totalCapacity - 7), (long)BoundedByteBufferPool.toTotalCapacity((long)state2));
    }
}

