/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.BoundedArrayQueue;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestBoundedArrayQueue {
    private int qMaxElements = 5;
    private BoundedArrayQueue<Integer> queue = new BoundedArrayQueue(this.qMaxElements);

    @Test
    public void testBoundedArrayQueueOperations() throws Exception {
        int i;
        Assert.assertEquals((long)0L, (long)this.queue.size());
        Assert.assertNull((Object)this.queue.poll());
        Assert.assertNull((Object)this.queue.peek());
        for (i = 0; i < this.qMaxElements; ++i) {
            Assert.assertTrue((boolean)this.queue.offer((Object)i));
        }
        Assert.assertEquals((long)this.qMaxElements, (long)this.queue.size());
        Assert.assertFalse((boolean)this.queue.offer((Object)0));
        Assert.assertEquals((long)0L, (long)((Integer)this.queue.peek()).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)this.queue.peek()).intValue());
        for (i = 0; i < this.qMaxElements; ++i) {
            Assert.assertEquals((long)i, (long)((Integer)this.queue.poll()).intValue());
        }
        Assert.assertEquals((long)0L, (long)this.queue.size());
        Assert.assertNull((Object)this.queue.poll());
        Assert.assertTrue((boolean)this.queue.offer((Object)100));
        Assert.assertTrue((boolean)this.queue.offer((Object)1000));
        Assert.assertEquals((long)100L, (long)((Integer)this.queue.peek()).intValue());
        Assert.assertEquals((long)100L, (long)((Integer)this.queue.poll()).intValue());
        Assert.assertEquals((long)1000L, (long)((Integer)this.queue.poll()).intValue());
    }
}

