/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestReplicationAdmin {
    private static final Log LOG = LogFactory.getLog(TestReplicationAdmin.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final String ID_ONE = "1";
    private final String KEY_ONE = "127.0.0.1:2181:/hbase";
    private final String ID_SECOND = "2";
    private final String KEY_SECOND = "127.0.0.1:2181:/hbase2";
    private static ReplicationAdmin admin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.replication", true);
        admin = new ReplicationAdmin(conf);
    }

    @Test
    public void testAddRemovePeer() throws Exception {
        admin.addPeer("1", "127.0.0.1:2181:/hbase");
        try {
            admin.addPeer("1", "127.0.0.1:2181:/hbase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        try {
            admin.removePeer("2");
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        try {
            admin.addPeer("2", "127.0.0.1:2181:/hbase2");
        }
        catch (IllegalStateException iae) {
            Assert.fail();
        }
        Assert.assertEquals((long)2L, (long)admin.getPeersCount());
        admin.removePeer("1");
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        admin.removePeer("2");
        Assert.assertEquals((long)0L, (long)admin.getPeersCount());
    }

    @Test
    public void testEnableDisable() throws Exception {
        admin.addPeer("1", "127.0.0.1:2181:/hbase");
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        Assert.assertTrue((boolean)admin.getPeerState("1"));
        admin.disablePeer("1");
        Assert.assertFalse((boolean)admin.getPeerState("1"));
        try {
            admin.getPeerState("2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        admin.removePeer("1");
    }
}

