/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.DefaultScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.EnforcingScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityController;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestEnforcingScanLabelGenerator {
    public static final String CONFIDENTIAL = "confidential";
    private static final String SECRET = "secret";
    public static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] ROW_1 = Bytes.toBytes((String)"row1");
    private static final byte[] CF = Bytes.toBytes((String)"f");
    private static final byte[] Q1 = Bytes.toBytes((String)"q1");
    private static final byte[] Q2 = Bytes.toBytes((String)"q2");
    private static final byte[] Q3 = Bytes.toBytes((String)"q3");
    private static final byte[] value = Bytes.toBytes((String)"value");
    public static Configuration conf;
    @Rule
    public final TestName TEST_NAME = new TestName();
    public static User SUPERUSER;
    public static User TESTUSER;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("hfile.format.version", 3);
        conf.set("hbase.coprocessor.master.classes", VisibilityController.class.getName());
        conf.set("hbase.coprocessor.region.classes", VisibilityController.class.getName());
        String classes = DefaultScanLabelGenerator.class.getCanonicalName() + " , " + EnforcingScanLabelGenerator.class.getCanonicalName();
        conf.setStrings("hbase.regionserver.scan.visibility.label.generator.class", new String[]{classes});
        conf.set("hbase.superuser", "admin");
        TEST_UTIL.startMiniCluster(1);
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        TESTUSER = User.createUserForTesting((Configuration)conf, (String)"test", (String[])new String[0]);
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        SUPERUSER.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    VisibilityClient.addLabels((Configuration)conf, (String[])new String[]{TestEnforcingScanLabelGenerator.SECRET, TestEnforcingScanLabelGenerator.CONFIDENTIAL});
                    VisibilityClient.setAuths((Configuration)conf, (String[])new String[]{TestEnforcingScanLabelGenerator.CONFIDENTIAL}, (String)TESTUSER.getShortName());
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
                return null;
            }
        });
    }

    @Test
    public void testEnforcingScanLabelGenerator() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        SUPERUSER.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable table = TEST_UTIL.createTable(tableName, CF);
                try {
                    Put put = new Put(ROW_1);
                    put.add(CF, Q1, Long.MAX_VALUE, value);
                    put.setCellVisibility(new CellVisibility(TestEnforcingScanLabelGenerator.SECRET));
                    table.put(put);
                    put = new Put(ROW_1);
                    put.add(CF, Q2, Long.MAX_VALUE, value);
                    put.setCellVisibility(new CellVisibility(TestEnforcingScanLabelGenerator.CONFIDENTIAL));
                    table.put(put);
                    put = new Put(ROW_1);
                    put.add(CF, Q3, Long.MAX_VALUE, value);
                    table.put(put);
                    Void void_ = null;
                    return void_;
                }
                finally {
                    table.close();
                }
            }
        });
        TESTUSER.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable table = new HTable(conf, tableName);
                try {
                    Get get = new Get(ROW_1);
                    get.setAuthorizations(new Authorizations(new String[]{TestEnforcingScanLabelGenerator.SECRET, TestEnforcingScanLabelGenerator.CONFIDENTIAL}));
                    Result result = table.get(get);
                    Assert.assertFalse((String)"Inappropriate authorization", (boolean)result.containsColumn(CF, Q1));
                    Assert.assertTrue((String)"Missing authorization", (boolean)result.containsColumn(CF, Q2));
                    Assert.assertTrue((String)"Inappropriate filtering", (boolean)result.containsColumn(CF, Q3));
                    get = new Get(ROW_1);
                    result = table.get(get);
                    Assert.assertFalse((String)"Inappropriate authorization", (boolean)result.containsColumn(CF, Q1));
                    Assert.assertTrue((String)"Missing authorization", (boolean)result.containsColumn(CF, Q2));
                    Assert.assertTrue((String)"Inappropriate filtering", (boolean)result.containsColumn(CF, Q3));
                    Void void_ = null;
                    return void_;
                }
                finally {
                    table.close();
                }
            }
        });
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }
}

