/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DaemonThreadFactory;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.RpcScheduler;

public class FifoRpcScheduler
implements RpcScheduler {
    private final int handlerCount;
    private final int maxQueueLength;
    private ThreadPoolExecutor executor;

    public FifoRpcScheduler(Configuration conf, int handlerCount) {
        this.handlerCount = handlerCount;
        this.maxQueueLength = conf.getInt("ipc.server.max.callqueue.length", handlerCount * 10);
    }

    @Override
    public void init(RpcScheduler.Context context) {
    }

    @Override
    public void start() {
        this.executor = new ThreadPoolExecutor(this.handlerCount, this.handlerCount, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.maxQueueLength), new DaemonThreadFactory("FifoRpcScheduler.handler"), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Override
    public void stop() {
        this.executor.shutdown();
    }

    @Override
    public void dispatch(final CallRunner task) throws IOException, InterruptedException {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                task.run();
            }
        });
    }

    @Override
    public int getGeneralQueueLength() {
        return this.executor.getQueue().size();
    }

    @Override
    public int getPriorityQueueLength() {
        return 0;
    }

    @Override
    public int getReplicationQueueLength() {
        return 0;
    }

    @Override
    public int getActiveRpcHandlerCount() {
        return this.executor.getActiveCount();
    }
}

