/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.TestHRegionServerBulkLoad;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestReplicaWithCluster {
    private static final Log LOG = LogFactory.getLog(TestReplicaWithCluster.class);
    private static final int NB_SERVERS = 2;
    private static final byte[] row = TestReplicaWithCluster.class.getName().getBytes();
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    private static HBaseTestingUtility HTU2;
    private static final byte[] f;
    private static final int REFRESH_PERIOD = 1000;

    @BeforeClass
    public static void beforeClass() throws Exception {
        HTU.getConfiguration().setInt("hbase.regionserver.storefile.refresh.period", 1000);
        HTU.getConfiguration().setFloat("hbase.regionserver.logroll.multiplier", 1.0E-4f);
        HTU.getConfiguration().setInt("replication.source.size.capacity", 10240);
        HTU.getConfiguration().setLong("replication.source.sleepforretries", 100L);
        HTU.getConfiguration().setInt("hbase.regionserver.maxlogs", 2);
        HTU.getConfiguration().setLong("hbase.master.logcleaner.ttl", 10L);
        HTU.getConfiguration().setInt("zookeeper.recovery.retry", 1);
        HTU.getConfiguration().setInt("zookeeper.recovery.retry.intervalmill", 10);
        HTU.startMiniCluster(2);
        HTU.getHBaseCluster().startMaster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        HTU2.shutdownMiniCluster();
        HTU.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testCreateDeleteTable() throws IOException {
        HTableDescriptor hdt = HTU.createTableDescriptor("testCreateDeleteTable");
        hdt.setRegionReplication(2);
        hdt.addCoprocessor(SlowMeCopro.class.getName());
        HTable table = HTU.createTable(hdt, (byte[][])new byte[][]{f}, HTU.getConfiguration());
        Put p = new Put(row);
        p.add(f, row, row);
        table.put(p);
        Get g = new Get(row);
        Result r = table.get(g);
        Assert.assertFalse((boolean)r.isStale());
        try {
            SlowMeCopro.cdl.set(new CountDownLatch(1));
            g = new Get(row);
            g.setConsistency(Consistency.TIMELINE);
            r = table.get(g);
            Assert.assertTrue((boolean)r.isStale());
            SlowMeCopro.cdl.get().countDown();
        }
        finally {
            SlowMeCopro.cdl.get().countDown();
            SlowMeCopro.sleepTime.set(0L);
        }
        HTU.getHBaseAdmin().disableTable(hdt.getTableName());
        HTU.deleteTable(hdt.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testChangeTable() throws Exception {
        HTableDescriptor hdt = HTU.createTableDescriptor("testChangeTable");
        hdt.setRegionReplication(2);
        hdt.addCoprocessor(SlowMeCopro.class.getName());
        HTable table = HTU.createTable(hdt, (byte[][])new byte[][]{f}, HTU.getConfiguration());
        Put p = new Put(row);
        p.add(f, row, row);
        table.put(p);
        Get g = new Get(row);
        Result r = table.get(g);
        Assert.assertFalse((boolean)r.isStale());
        HTableDescriptor bHdt = HTU.getHBaseAdmin().getTableDescriptor(hdt.getTableName());
        HColumnDescriptor hcd = new HColumnDescriptor(row);
        hdt.addFamily(hcd);
        HTU.getHBaseAdmin().disableTable(hdt.getTableName());
        HTU.getHBaseAdmin().modifyTable(hdt.getTableName(), hdt);
        HTU.getHBaseAdmin().enableTable(hdt.getTableName());
        HTableDescriptor nHdt = HTU.getHBaseAdmin().getTableDescriptor(hdt.getTableName());
        Assert.assertEquals((String)("fams=" + Arrays.toString(nHdt.getColumnFamilies())), (long)(bHdt.getColumnFamilies().length + 1), (long)nHdt.getColumnFamilies().length);
        p = new Put(row);
        p.add(row, row, row);
        table.put(p);
        g = new Get(row);
        r = table.get(g);
        Assert.assertFalse((boolean)r.isStale());
        try {
            SlowMeCopro.cdl.set(new CountDownLatch(1));
            g = new Get(row);
            g.setConsistency(Consistency.TIMELINE);
            r = table.get(g);
            Assert.assertTrue((boolean)r.isStale());
        }
        finally {
            SlowMeCopro.cdl.get().countDown();
            SlowMeCopro.sleepTime.set(0L);
        }
        HTU.getHBaseCluster().stopMaster(0);
        HBaseAdmin admin = new HBaseAdmin(HTU.getConfiguration());
        nHdt = admin.getTableDescriptor(hdt.getTableName());
        Assert.assertEquals((String)("fams=" + Arrays.toString(nHdt.getColumnFamilies())), (long)(bHdt.getColumnFamilies().length + 1), (long)nHdt.getColumnFamilies().length);
        admin.disableTable(hdt.getTableName());
        admin.deleteTable(hdt.getTableName());
        HTU.getHBaseCluster().startMaster();
        admin.close();
    }

    @Test(timeout=300000L)
    public void testReplicaAndReplication() throws Exception {
        HTableDescriptor hdt = HTU.createTableDescriptor("testReplicaAndReplication");
        hdt.setRegionReplication(2);
        HColumnDescriptor fam = new HColumnDescriptor(row);
        fam.setScope(1);
        hdt.addFamily(fam);
        hdt.addCoprocessor(SlowMeCopro.class.getName());
        HTU.getHBaseAdmin().createTable(hdt, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        Configuration conf2 = HBaseConfiguration.create((Configuration)HTU.getConfiguration());
        conf2.set("hbase.client.instance.id", String.valueOf(-1));
        conf2.set("zookeeper.znode.parent", "/2");
        MiniZooKeeperCluster miniZK = HTU.getZkCluster();
        HTU2 = new HBaseTestingUtility(conf2);
        HTU2.setZkCluster(miniZK);
        HTU2.startMiniCluster(2);
        LOG.info((Object)"Setup second Zk");
        HTU2.getHBaseAdmin().createTable(hdt, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        ReplicationAdmin admin = new ReplicationAdmin(HTU.getConfiguration());
        admin.addPeer("2", HTU2.getClusterKey());
        admin.close();
        Put p = new Put(row);
        p.add(row, row, row);
        HTable table = new HTable(HTU.getConfiguration(), hdt.getTableName());
        table.put(p);
        HTU.getHBaseAdmin().flush(table.getName());
        LOG.info((Object)"Put & flush done on the first cluster. Now doing a get on the same cluster.");
        Waiter.waitFor((Configuration)HTU.getConfiguration(), (long)1000L, (Waiter.Predicate)new Waiter.Predicate<Exception>((Table)table){
            final /* synthetic */ Table val$table;
            {
                this.val$table = table;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean evaluate() throws Exception {
                try {
                    SlowMeCopro.cdl.set(new CountDownLatch(1));
                    Get g = new Get(row);
                    g.setConsistency(Consistency.TIMELINE);
                    Result r = this.val$table.get(g);
                    Assert.assertTrue((boolean)r.isStale());
                    boolean bl = !r.isEmpty();
                    return bl;
                }
                finally {
                    SlowMeCopro.cdl.get().countDown();
                    SlowMeCopro.sleepTime.set(0L);
                }
            }
        });
        table.close();
        LOG.info((Object)"stale get on the first cluster done. Now for the second.");
        HTable table2 = new HTable(HTU.getConfiguration(), hdt.getTableName());
        Waiter.waitFor((Configuration)HTU.getConfiguration(), (long)1000L, (Waiter.Predicate)new Waiter.Predicate<Exception>((Table)table2){
            final /* synthetic */ Table val$table2;
            {
                this.val$table2 = table;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean evaluate() throws Exception {
                try {
                    SlowMeCopro.cdl.set(new CountDownLatch(1));
                    Get g = new Get(row);
                    g.setConsistency(Consistency.TIMELINE);
                    Result r = this.val$table2.get(g);
                    Assert.assertTrue((boolean)r.isStale());
                    boolean bl = !r.isEmpty();
                    return bl;
                }
                finally {
                    SlowMeCopro.cdl.get().countDown();
                    SlowMeCopro.sleepTime.set(0L);
                }
            }
        });
        table2.close();
        HTU.getHBaseAdmin().disableTable(hdt.getTableName());
        HTU.deleteTable(hdt.getTableName());
        HTU2.getHBaseAdmin().disableTable(hdt.getTableName());
        HTU2.deleteTable(hdt.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testBulkLoad() throws IOException {
        Result r;
        Get g;
        byte[] row;
        int i;
        LOG.debug((Object)"Creating test table");
        HTableDescriptor hdt = HTU.createTableDescriptor("testBulkLoad");
        hdt.setRegionReplication(2);
        hdt.addCoprocessor(SlowMeCopro.class.getName());
        HTable table = HTU.createTable(hdt, (byte[][])new byte[][]{f}, HTU.getConfiguration());
        LOG.debug((Object)"Creating test data");
        Path dir = HTU.getDataTestDirOnTestFS("testBulkLoad");
        int numRows = 10;
        byte[] qual = Bytes.toBytes((String)"qual");
        byte[] val = Bytes.toBytes((String)"val");
        final ArrayList<Pair> famPaths = new ArrayList<Pair>();
        for (HColumnDescriptor col : hdt.getColumnFamilies()) {
            Path hfile = new Path(dir, col.getNameAsString());
            TestHRegionServerBulkLoad.createHFile(HTU.getTestFileSystem(), hfile, col.getName(), qual, val, 10);
            famPaths.add(new Pair((Object)col.getName(), (Object)hfile.toString()));
        }
        LOG.debug((Object)"Loading test data");
        HConnection conn = HTU.getHBaseAdmin().getConnection();
        RegionServerCallable<Void> callable = new RegionServerCallable<Void>(conn, hdt.getTableName(), TestHRegionServerBulkLoad.rowkey(0)){

            public Void call(int timeout) throws Exception {
                LOG.debug((Object)("Going to connect to server " + this.getLocation() + " for row " + Bytes.toStringBinary((byte[])this.getRow())));
                byte[] regionName = this.getLocation().getRegionInfo().getRegionName();
                ClientProtos.BulkLoadHFileRequest request = RequestConverter.buildBulkLoadHFileRequest((List)famPaths, (byte[])regionName, (boolean)true);
                this.getStub().bulkLoadHFile(null, request);
                return null;
            }
        };
        RpcRetryingCallerFactory factory = new RpcRetryingCallerFactory(HTU.getConfiguration());
        RpcRetryingCaller caller = factory.newCaller();
        caller.callWithRetries((RetryingCallable)callable, 10000);
        LOG.debug((Object)"Verifying data load");
        for (i = 0; i < 10; ++i) {
            row = TestHRegionServerBulkLoad.rowkey(i);
            g = new Get(row);
            r = table.get(g);
            Assert.assertFalse((boolean)r.isStale());
        }
        LOG.debug((Object)"Verifying replica queries");
        try {
            SlowMeCopro.cdl.set(new CountDownLatch(1));
            for (i = 0; i < 10; ++i) {
                row = TestHRegionServerBulkLoad.rowkey(i);
                g = new Get(row);
                g.setConsistency(Consistency.TIMELINE);
                r = table.get(g);
                Assert.assertTrue((boolean)r.isStale());
            }
            SlowMeCopro.cdl.get().countDown();
        }
        finally {
            SlowMeCopro.cdl.get().countDown();
            SlowMeCopro.sleepTime.set(0L);
        }
        HTU.getHBaseAdmin().disableTable(hdt.getTableName());
        HTU.deleteTable(hdt.getTableName());
    }

    static {
        f = HConstants.CATALOG_FAMILY;
    }

    public static class SlowMeCopro
    extends BaseRegionObserver {
        static final AtomicLong sleepTime = new AtomicLong(0L);
        static final AtomicReference<CountDownLatch> cdl = new AtomicReference<CountDownLatch>(new CountDownLatch(0));

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            if (((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().getRegionInfo().getReplicaId() == 0) {
                CountDownLatch latch = cdl.get();
                try {
                    if (sleepTime.get() > 0L) {
                        LOG.info((Object)("Sleeping for " + sleepTime.get() + " ms"));
                        Thread.sleep(sleepTime.get());
                    } else if (latch.getCount() > 0L) {
                        LOG.info((Object)"Waiting for the counterCountDownLatch");
                        latch.await(2L, TimeUnit.MINUTES);
                        if (latch.getCount() > 0L) {
                            throw new RuntimeException("Can't wait more");
                        }
                    }
                }
                catch (InterruptedException e1) {
                    LOG.error((Object)e1);
                }
            } else {
                LOG.info((Object)"We're not the primary replicas.");
            }
        }
    }
}

