/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMasterObserver {
    private static final Log LOG = LogFactory.getLog(TestMasterObserver.class);
    public static CountDownLatch tableCreationLatch = new CountDownLatch(1);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static byte[] TEST_SNAPSHOT = Bytes.toBytes((String)"observed_snapshot");
    private static TableName TEST_TABLE = TableName.valueOf((String)"observed_table");
    private static TableName TEST_CLONE = TableName.valueOf((String)"observed_clone");
    private static byte[] TEST_FAMILY = Bytes.toBytes((String)"fam1");
    private static byte[] TEST_FAMILY2 = Bytes.toBytes((String)"fam2");
    private static byte[] TEST_FAMILY3 = Bytes.toBytes((String)"fam3");

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.coprocessor.master.classes", CPMasterObserver.class.getName());
        conf.set("hbase.master.hfilecleaner.plugins", "org.apache.hadoop.hbase.master.cleaner.HFileLinkCleaner,org.apache.hadoop.hbase.master.snapshot.SnapshotHFileCleaner");
        conf.set("hbase.master.logcleaner.plugins", "org.apache.hadoop.hbase.master.snapshot.SnapshotLogCleaner");
        UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testStarted() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        Assert.assertTrue((String)"Master should be active", (boolean)master.isActiveMaster());
        MasterCoprocessorHost host = master.getMasterCoprocessorHost();
        Assert.assertNotNull((String)"CoprocessorHost should not be null", (Object)host);
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class.getName());
        Assert.assertNotNull((String)"CPMasterObserver coprocessor not found or not installed!", (Object)cp);
        Assert.assertTrue((String)"MasterObserver should have been started", (boolean)cp.wasStarted());
        Assert.assertTrue((String)"preMasterInitialization() hook should have been called", (boolean)cp.wasMasterInitializationCalled());
        Assert.assertTrue((String)"postStartMaster() hook should have been called", (boolean)cp.wasStartMasterCalled());
    }

    @Test
    public void testTableOperations() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        MasterCoprocessorHost host = master.getMasterCoprocessorHost();
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class.getName());
        cp.enableBypass(true);
        cp.resetStates();
        Assert.assertFalse((String)"No table created yet", (boolean)cp.wasCreateTableCalled());
        HTableDescriptor htd = new HTableDescriptor(TEST_TABLE);
        htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        tableCreationLatch = new CountDownLatch(1);
        admin.createTable(htd);
        Assert.assertTrue((String)"Test table should be created", (boolean)cp.wasCreateTableCalled());
        tableCreationLatch.await();
        Assert.assertTrue((String)"Table pre create handler called.", (boolean)cp.wasPreCreateTableHandlerCalled());
        Assert.assertTrue((String)"Table create handler should be called.", (boolean)cp.wasCreateTableHandlerCalled());
        tableCreationLatch = new CountDownLatch(1);
        admin.disableTable(TEST_TABLE);
        Assert.assertTrue((boolean)admin.isTableDisabled(TEST_TABLE));
        Assert.assertTrue((String)"Coprocessor should have been called on table disable", (boolean)cp.wasDisableTableCalled());
        Assert.assertTrue((String)"Disable table handler should be called.", (boolean)cp.wasDisableTableHandlerCalled());
        Assert.assertFalse((boolean)cp.wasEnableTableCalled());
        admin.enableTable(TEST_TABLE);
        Assert.assertTrue((boolean)admin.isTableEnabled(TEST_TABLE));
        Assert.assertTrue((String)"Coprocessor should have been called on table enable", (boolean)cp.wasEnableTableCalled());
        Assert.assertTrue((String)"Enable table handler should be called.", (boolean)cp.wasEnableTableHandlerCalled());
        admin.disableTable(TEST_TABLE);
        Assert.assertTrue((boolean)admin.isTableDisabled(TEST_TABLE));
        htd.setMaxFileSize(0x20000000L);
        this.modifyTableSync((Admin)admin, TEST_TABLE, htd);
        Assert.assertTrue((String)"Test table should have been modified", (boolean)cp.wasModifyTableCalled());
        admin.addColumn(TEST_TABLE, new HColumnDescriptor(TEST_FAMILY2));
        Assert.assertTrue((String)"New column family shouldn't have been added to test table", (boolean)cp.preAddColumnCalledOnly());
        HColumnDescriptor hcd1 = new HColumnDescriptor(TEST_FAMILY2);
        hcd1.setMaxVersions(25);
        admin.modifyColumn(TEST_TABLE, hcd1);
        Assert.assertTrue((String)"Second column family should be modified", (boolean)cp.preModifyColumnCalledOnly());
        admin.truncateTable(TEST_TABLE, false);
        admin.disableTable(TEST_TABLE);
        Assert.assertTrue((boolean)admin.isTableDisabled(TEST_TABLE));
        admin.deleteTable(TEST_TABLE);
        Assert.assertFalse((String)"Test table should have been deleted", (boolean)admin.tableExists(TEST_TABLE));
        Assert.assertTrue((String)"Coprocessor should have been called on table delete", (boolean)cp.wasDeleteTableCalled());
        Assert.assertTrue((String)"Delete table handler should be called.", (boolean)cp.wasDeleteTableHandlerCalled());
        cp.enableBypass(false);
        cp.resetStates();
        admin.createTable(htd);
        Assert.assertTrue((String)"Test table should be created", (boolean)cp.wasCreateTableCalled());
        tableCreationLatch.await();
        Assert.assertTrue((String)"Table pre create handler called.", (boolean)cp.wasPreCreateTableHandlerCalled());
        Assert.assertTrue((String)"Table create handler should be called.", (boolean)cp.wasCreateTableHandlerCalled());
        Assert.assertFalse((boolean)cp.wasDisableTableCalled());
        Assert.assertFalse((boolean)cp.wasDisableTableHandlerCalled());
        admin.disableTable(TEST_TABLE);
        Assert.assertTrue((boolean)admin.isTableDisabled(TEST_TABLE));
        Assert.assertTrue((String)"Coprocessor should have been called on table disable", (boolean)cp.wasDisableTableCalled());
        Assert.assertTrue((String)"Disable table handler should be called.", (boolean)cp.wasDisableTableHandlerCalled());
        htd.setMaxFileSize(0x20000000L);
        this.modifyTableSync((Admin)admin, TEST_TABLE, htd);
        Assert.assertTrue((String)"Test table should have been modified", (boolean)cp.wasModifyTableCalled());
        admin.addColumn(TEST_TABLE, new HColumnDescriptor(TEST_FAMILY2));
        Assert.assertTrue((String)"New column family should have been added to test table", (boolean)cp.wasAddColumnCalled());
        Assert.assertTrue((String)"Add column handler should be called.", (boolean)cp.wasAddColumnHandlerCalled());
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY2);
        hcd.setMaxVersions(25);
        admin.modifyColumn(TEST_TABLE, hcd);
        Assert.assertTrue((String)"Second column family should be modified", (boolean)cp.wasModifyColumnCalled());
        Assert.assertTrue((String)"Modify table handler should be called.", (boolean)cp.wasModifyColumnHandlerCalled());
        Assert.assertFalse((boolean)cp.wasEnableTableCalled());
        Assert.assertFalse((boolean)cp.wasEnableTableHandlerCalled());
        admin.enableTable(TEST_TABLE);
        Assert.assertTrue((boolean)admin.isTableEnabled(TEST_TABLE));
        Assert.assertTrue((String)"Coprocessor should have been called on table enable", (boolean)cp.wasEnableTableCalled());
        Assert.assertTrue((String)"Enable table handler should be called.", (boolean)cp.wasEnableTableHandlerCalled());
        admin.disableTable(TEST_TABLE);
        Assert.assertTrue((boolean)admin.isTableDisabled(TEST_TABLE));
        Assert.assertFalse((String)"No column family deleted yet", (boolean)cp.wasDeleteColumnCalled());
        Assert.assertFalse((String)"Delete table column handler should not be called.", (boolean)cp.wasDeleteColumnHandlerCalled());
        admin.deleteColumn(TEST_TABLE, TEST_FAMILY2);
        HTableDescriptor tableDesc = admin.getTableDescriptor(TEST_TABLE);
        Assert.assertNull((String)("'" + Bytes.toString((byte[])TEST_FAMILY2) + "' should have been removed"), (Object)tableDesc.getFamily(TEST_FAMILY2));
        Assert.assertTrue((String)"Coprocessor should have been called on column delete", (boolean)cp.wasDeleteColumnCalled());
        Assert.assertTrue((String)"Delete table column handler should be called.", (boolean)cp.wasDeleteColumnHandlerCalled());
        Assert.assertFalse((String)"No table deleted yet", (boolean)cp.wasDeleteTableCalled());
        Assert.assertFalse((String)"Delete table handler should not be called.", (boolean)cp.wasDeleteTableHandlerCalled());
        admin.deleteTable(TEST_TABLE);
        Assert.assertFalse((String)"Test table should have been deleted", (boolean)admin.tableExists(TEST_TABLE));
        Assert.assertTrue((String)"Coprocessor should have been called on table delete", (boolean)cp.wasDeleteTableCalled());
        Assert.assertTrue((String)"Delete table handler should be called.", (boolean)cp.wasDeleteTableHandlerCalled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotOperations() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        MasterCoprocessorHost host = master.getMasterCoprocessorHost();
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class.getName());
        cp.resetStates();
        HTableDescriptor htd = new HTableDescriptor(TEST_TABLE);
        htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        tableCreationLatch = new CountDownLatch(1);
        admin.createTable(htd);
        tableCreationLatch.await();
        tableCreationLatch = new CountDownLatch(1);
        admin.disableTable(TEST_TABLE);
        Assert.assertTrue((boolean)admin.isTableDisabled(TEST_TABLE));
        try {
            Assert.assertFalse((String)"Coprocessor should not have been called yet", (boolean)cp.wasSnapshotCalled());
            admin.snapshot(TEST_SNAPSHOT, TEST_TABLE);
            Assert.assertTrue((String)"Coprocessor should have been called on snapshot", (boolean)cp.wasSnapshotCalled());
            admin.cloneSnapshot(TEST_SNAPSHOT, TEST_CLONE);
            Assert.assertTrue((String)"Coprocessor should have been called on snapshot clone", (boolean)cp.wasCloneSnapshotCalled());
            Assert.assertFalse((String)"Coprocessor restore should not have been called on snapshot clone", (boolean)cp.wasRestoreSnapshotCalled());
            admin.disableTable(TEST_CLONE);
            Assert.assertTrue((boolean)admin.isTableDisabled(TEST_TABLE));
            admin.deleteTable(TEST_CLONE);
            cp.resetStates();
            admin.restoreSnapshot(TEST_SNAPSHOT);
            Assert.assertTrue((String)"Coprocessor should have been called on snapshot restore", (boolean)cp.wasRestoreSnapshotCalled());
            Assert.assertFalse((String)"Coprocessor clone should not have been called on snapshot restore", (boolean)cp.wasCloneSnapshotCalled());
            admin.deleteSnapshot(TEST_SNAPSHOT);
            Assert.assertTrue((String)"Coprocessor should have been called on snapshot delete", (boolean)cp.wasDeleteSnapshotCalled());
        }
        finally {
            admin.deleteTable(TEST_TABLE);
        }
    }

    @Test
    public void testNamespaceOperations() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        String testNamespace = "observed_ns";
        HMaster master = cluster.getMaster();
        MasterCoprocessorHost host = master.getMasterCoprocessorHost();
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class.getName());
        cp.enableBypass(false);
        cp.resetStates();
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        admin.createNamespace(NamespaceDescriptor.create((String)testNamespace).build());
        Assert.assertTrue((String)"Test namespace should be created", (boolean)cp.wasCreateNamespaceCalled());
        Assert.assertNotNull((Object)admin.getNamespaceDescriptor(testNamespace));
        Assert.assertTrue((String)"Test namespace descriptor should have been called", (boolean)cp.wasGetNamespaceDescriptorCalled());
        cp.enableBypass(true);
        cp.resetStates();
        admin.modifyNamespace(NamespaceDescriptor.create((String)testNamespace).build());
        Assert.assertTrue((String)"Test namespace should not have been modified", (boolean)cp.preModifyNamespaceCalledOnly());
        Assert.assertNotNull((Object)admin.getNamespaceDescriptor(testNamespace));
        Assert.assertTrue((String)"Test namespace descriptor should have been called", (boolean)cp.wasGetNamespaceDescriptorCalled());
        admin.deleteNamespace(testNamespace);
        Assert.assertTrue((String)"Test namespace should not have been deleted", (boolean)cp.preDeleteNamespaceCalledOnly());
        Assert.assertNotNull((Object)admin.getNamespaceDescriptor(testNamespace));
        Assert.assertTrue((String)"Test namespace descriptor should have been called", (boolean)cp.wasGetNamespaceDescriptorCalled());
        cp.enableBypass(false);
        cp.resetStates();
        admin.modifyNamespace(NamespaceDescriptor.create((String)testNamespace).build());
        Assert.assertTrue((String)"Test namespace should have been modified", (boolean)cp.wasModifyNamespaceCalled());
        admin.deleteNamespace(testNamespace);
        Assert.assertTrue((String)"Test namespace should have been deleted", (boolean)cp.wasDeleteNamespaceCalled());
        cp.enableBypass(true);
        cp.resetStates();
        admin.createNamespace(NamespaceDescriptor.create((String)testNamespace).build());
        Assert.assertTrue((String)"Test namespace should not be created", (boolean)cp.preCreateNamespaceCalledOnly());
        cp.enableBypass(true);
        cp.resetStates();
        admin.listNamespaceDescriptors();
        Assert.assertTrue((String)"post listNamespace should not have been called", (boolean)cp.preListNamespaceDescriptorsCalledOnly());
        cp.enableBypass(false);
        cp.resetStates();
        admin.listNamespaceDescriptors();
        Assert.assertTrue((String)"post listNamespace should have been called", (boolean)cp.wasListNamespaceDescriptorsCalled());
    }

    private void modifyTableSync(Admin admin, TableName tableName, HTableDescriptor htd) throws IOException {
        HTableDescriptor td;
        admin.modifyTable(tableName, htd);
        for (int t = 0; t < 100 && !(td = admin.getTableDescriptor(htd.getTableName())).equals((Object)htd); ++t) {
            Threads.sleep((long)100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionTransitionOperations() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        MasterCoprocessorHost host = master.getMasterCoprocessorHost();
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class.getName());
        cp.enableBypass(false);
        cp.resetStates();
        HTable table = UTIL.createTable(TEST_TABLE, TEST_FAMILY);
        try {
            UTIL.createMultiRegions(table, TEST_FAMILY);
            UTIL.waitUntilAllRegionsAssigned(TEST_TABLE);
            NavigableMap regions = table.getRegionLocations();
            Map.Entry firstGoodPair = null;
            for (Map.Entry e : regions.entrySet()) {
                if (e.getValue() == null) continue;
                firstGoodPair = e;
                break;
            }
            Assert.assertNotNull((String)"Found a non-null entry", firstGoodPair);
            LOG.info((Object)("Found " + firstGoodPair.toString()));
            Collection servers = master.getClusterStatus().getServers();
            String destName = null;
            String serverNameForFirstRegion = ((ServerName)firstGoodPair.getValue()).toString();
            LOG.info((Object)("serverNameForFirstRegion=" + serverNameForFirstRegion));
            ServerName masterServerName = master.getServerName();
            boolean found = false;
            for (ServerName info : servers) {
                LOG.info((Object)("ServerName=" + info));
                if (serverNameForFirstRegion.equals(info.getServerName()) || masterServerName.equals((Object)info)) continue;
                destName = info.toString();
                found = true;
                break;
            }
            Assert.assertTrue((String)"Found server", (boolean)found);
            LOG.info((Object)("Found " + destName));
            master.getMasterRpcServices().moveRegion(null, RequestConverter.buildMoveRegionRequest((byte[])((HRegionInfo)firstGoodPair.getKey()).getEncodedNameAsBytes(), (byte[])Bytes.toBytes(destName)));
            Assert.assertTrue((String)"Coprocessor should have been called on region move", (boolean)cp.wasMoveCalled());
            master.balanceSwitch(true);
            Assert.assertTrue((String)"Coprocessor should have been called on balance switch", (boolean)cp.wasBalanceSwitchCalled());
            master.balanceSwitch(false);
            AssignmentManager mgr = master.getAssignmentManager();
            Collection transRegions = mgr.getRegionStates().getRegionsInTransition().values();
            for (RegionState state : transRegions) {
                mgr.getRegionStates().waitOnRegionToClearRegionsInTransition(state.getRegion());
            }
            HRegionServer rs = cluster.getRegionServer(0);
            byte[] destRS = Bytes.toBytes((String)cluster.getRegionServer(1).getServerName().toString());
            this.waitForRITtoBeZero(master);
            List openRegions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices());
            int moveCnt = openRegions.size() / 2;
            for (int i = 0; i < moveCnt; ++i) {
                HRegionInfo info = (HRegionInfo)openRegions.get(i);
                if (info.isMetaTable()) continue;
                master.getMasterRpcServices().moveRegion(null, RequestConverter.buildMoveRegionRequest((byte[])((HRegionInfo)openRegions.get(i)).getEncodedNameAsBytes(), (byte[])destRS));
            }
            this.waitForRITtoBeZero(master);
            master.balanceSwitch(true);
            boolean balanceRun = master.balance();
            Assert.assertTrue((String)"Coprocessor should be called on region rebalancing", (boolean)cp.wasBalanceCalled());
        }
        finally {
            UTIL.deleteTable(TEST_TABLE);
        }
    }

    private void waitForRITtoBeZero(HMaster master) throws Exception {
        AssignmentManager mgr = master.getAssignmentManager();
        Collection transRegions = mgr.getRegionStates().getRegionsInTransition().values();
        for (RegionState state : transRegions) {
            mgr.getRegionStates().waitOnRegionToClearRegionsInTransition(state.getRegion());
        }
    }

    @Test
    public void testTableDescriptorsEnumeration() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        MasterCoprocessorHost host = master.getMasterCoprocessorHost();
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class.getName());
        cp.resetStates();
        MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest((List)null);
        master.getMasterRpcServices().getTableDescriptors(null, req);
        Assert.assertTrue((String)"Coprocessor should be called on table descriptors request", (boolean)cp.wasGetTableDescriptorsCalled());
    }

    @Test
    public void testTableNamesEnumeration() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        MasterCoprocessorHost host = master.getMasterCoprocessorHost();
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class.getName());
        cp.resetStates();
        master.getMasterRpcServices().getTableNames(null, MasterProtos.GetTableNamesRequest.newBuilder().build());
        Assert.assertTrue((String)"Coprocessor should be called on table names request", (boolean)cp.wasGetTableNamesCalled());
    }

    public static class CPMasterObserver
    implements MasterObserver {
        private boolean bypass = false;
        private boolean preCreateTableCalled;
        private boolean postCreateTableCalled;
        private boolean preDeleteTableCalled;
        private boolean postDeleteTableCalled;
        private boolean preTruncateTableCalled;
        private boolean postTruncateTableCalled;
        private boolean preModifyTableCalled;
        private boolean postModifyTableCalled;
        private boolean preCreateNamespaceCalled;
        private boolean postCreateNamespaceCalled;
        private boolean preDeleteNamespaceCalled;
        private boolean postDeleteNamespaceCalled;
        private boolean preModifyNamespaceCalled;
        private boolean postModifyNamespaceCalled;
        private boolean preGetNamespaceDescriptorCalled;
        private boolean postGetNamespaceDescriptorCalled;
        private boolean preListNamespaceDescriptorsCalled;
        private boolean postListNamespaceDescriptorsCalled;
        private boolean preAddColumnCalled;
        private boolean postAddColumnCalled;
        private boolean preModifyColumnCalled;
        private boolean postModifyColumnCalled;
        private boolean preDeleteColumnCalled;
        private boolean postDeleteColumnCalled;
        private boolean preEnableTableCalled;
        private boolean postEnableTableCalled;
        private boolean preDisableTableCalled;
        private boolean postDisableTableCalled;
        private boolean preMoveCalled;
        private boolean postMoveCalled;
        private boolean preAssignCalled;
        private boolean postAssignCalled;
        private boolean preUnassignCalled;
        private boolean postUnassignCalled;
        private boolean preRegionOfflineCalled;
        private boolean postRegionOfflineCalled;
        private boolean preBalanceCalled;
        private boolean postBalanceCalled;
        private boolean preBalanceSwitchCalled;
        private boolean postBalanceSwitchCalled;
        private boolean preShutdownCalled;
        private boolean preStopMasterCalled;
        private boolean preMasterInitializationCalled;
        private boolean postStartMasterCalled;
        private boolean startCalled;
        private boolean stopCalled;
        private boolean preSnapshotCalled;
        private boolean postSnapshotCalled;
        private boolean preCloneSnapshotCalled;
        private boolean postCloneSnapshotCalled;
        private boolean preRestoreSnapshotCalled;
        private boolean postRestoreSnapshotCalled;
        private boolean preDeleteSnapshotCalled;
        private boolean postDeleteSnapshotCalled;
        private boolean preCreateTableHandlerCalled;
        private boolean postCreateTableHandlerCalled;
        private boolean preDeleteTableHandlerCalled;
        private boolean postDeleteTableHandlerCalled;
        private boolean preTruncateTableHandlerCalled;
        private boolean postTruncateTableHandlerCalled;
        private boolean preAddColumnHandlerCalled;
        private boolean postAddColumnHandlerCalled;
        private boolean preModifyColumnHandlerCalled;
        private boolean postModifyColumnHandlerCalled;
        private boolean preDeleteColumnHandlerCalled;
        private boolean postDeleteColumnHandlerCalled;
        private boolean preEnableTableHandlerCalled;
        private boolean postEnableTableHandlerCalled;
        private boolean preDisableTableHandlerCalled;
        private boolean postDisableTableHandlerCalled;
        private boolean preModifyTableHandlerCalled;
        private boolean postModifyTableHandlerCalled;
        private boolean preGetTableDescriptorsCalled;
        private boolean postGetTableDescriptorsCalled;
        private boolean postGetTableNamesCalled;
        private boolean preGetTableNamesCalled;

        public void enableBypass(boolean bypass) {
            this.bypass = bypass;
        }

        public void resetStates() {
            this.preCreateTableCalled = false;
            this.postCreateTableCalled = false;
            this.preDeleteTableCalled = false;
            this.postDeleteTableCalled = false;
            this.preTruncateTableCalled = false;
            this.postTruncateTableCalled = false;
            this.preModifyTableCalled = false;
            this.postModifyTableCalled = false;
            this.preCreateNamespaceCalled = false;
            this.postCreateNamespaceCalled = false;
            this.preDeleteNamespaceCalled = false;
            this.postDeleteNamespaceCalled = false;
            this.preModifyNamespaceCalled = false;
            this.postModifyNamespaceCalled = false;
            this.preGetNamespaceDescriptorCalled = false;
            this.postGetNamespaceDescriptorCalled = false;
            this.preListNamespaceDescriptorsCalled = false;
            this.postListNamespaceDescriptorsCalled = false;
            this.preAddColumnCalled = false;
            this.postAddColumnCalled = false;
            this.preModifyColumnCalled = false;
            this.postModifyColumnCalled = false;
            this.preDeleteColumnCalled = false;
            this.postDeleteColumnCalled = false;
            this.preEnableTableCalled = false;
            this.postEnableTableCalled = false;
            this.preDisableTableCalled = false;
            this.postDisableTableCalled = false;
            this.preMoveCalled = false;
            this.postMoveCalled = false;
            this.preAssignCalled = false;
            this.postAssignCalled = false;
            this.preUnassignCalled = false;
            this.postUnassignCalled = false;
            this.preRegionOfflineCalled = false;
            this.postRegionOfflineCalled = false;
            this.preBalanceCalled = false;
            this.postBalanceCalled = false;
            this.preBalanceSwitchCalled = false;
            this.postBalanceSwitchCalled = false;
            this.preSnapshotCalled = false;
            this.postSnapshotCalled = false;
            this.preCloneSnapshotCalled = false;
            this.postCloneSnapshotCalled = false;
            this.preRestoreSnapshotCalled = false;
            this.postRestoreSnapshotCalled = false;
            this.preDeleteSnapshotCalled = false;
            this.postDeleteSnapshotCalled = false;
            this.preCreateTableHandlerCalled = false;
            this.postCreateTableHandlerCalled = false;
            this.preDeleteTableHandlerCalled = false;
            this.postDeleteTableHandlerCalled = false;
            this.preTruncateTableHandlerCalled = false;
            this.postTruncateTableHandlerCalled = false;
            this.preModifyTableHandlerCalled = false;
            this.postModifyTableHandlerCalled = false;
            this.preAddColumnHandlerCalled = false;
            this.postAddColumnHandlerCalled = false;
            this.preModifyColumnHandlerCalled = false;
            this.postModifyColumnHandlerCalled = false;
            this.preDeleteColumnHandlerCalled = false;
            this.postDeleteColumnHandlerCalled = false;
            this.preEnableTableHandlerCalled = false;
            this.postEnableTableHandlerCalled = false;
            this.preDisableTableHandlerCalled = false;
            this.postDisableTableHandlerCalled = false;
            this.preModifyTableHandlerCalled = false;
            this.postModifyTableHandlerCalled = false;
            this.preGetTableDescriptorsCalled = false;
            this.postGetTableDescriptorsCalled = false;
            this.postGetTableNamesCalled = false;
            this.preGetTableNamesCalled = false;
        }

        public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> env, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preCreateTableCalled = true;
        }

        public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> env, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
            this.postCreateTableCalled = true;
        }

        public boolean wasCreateTableCalled() {
            return this.preCreateTableCalled && this.postCreateTableCalled;
        }

        public boolean preCreateTableCalledOnly() {
            return this.preCreateTableCalled && !this.postCreateTableCalled;
        }

        public void preDeleteTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preDeleteTableCalled = true;
        }

        public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            this.postDeleteTableCalled = true;
        }

        public boolean wasDeleteTableCalled() {
            return this.preDeleteTableCalled && this.postDeleteTableCalled;
        }

        public boolean preDeleteTableCalledOnly() {
            return this.preDeleteTableCalled && !this.postDeleteTableCalled;
        }

        public void preTruncateTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preTruncateTableCalled = true;
        }

        public void postTruncateTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            this.postTruncateTableCalled = true;
        }

        public boolean wasTruncateTableCalled() {
            return this.preTruncateTableCalled && this.postTruncateTableCalled;
        }

        public boolean preTruncateTableCalledOnly() {
            return this.preTruncateTableCalled && !this.postTruncateTableCalled;
        }

        public void preModifyTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName, HTableDescriptor htd) throws IOException {
            if (this.bypass) {
                env.bypass();
            } else {
                env.shouldBypass();
            }
            this.preModifyTableCalled = true;
        }

        public void postModifyTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName, HTableDescriptor htd) throws IOException {
            this.postModifyTableCalled = true;
        }

        public boolean wasModifyTableCalled() {
            return this.preModifyTableCalled && this.postModifyTableCalled;
        }

        public boolean preModifyTableCalledOnly() {
            return this.preModifyTableCalled && !this.postModifyTableCalled;
        }

        public void preCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> env, NamespaceDescriptor ns) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preCreateNamespaceCalled = true;
        }

        public void postCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> env, NamespaceDescriptor ns) throws IOException {
            this.postCreateNamespaceCalled = true;
        }

        public boolean wasCreateNamespaceCalled() {
            return this.preCreateNamespaceCalled && this.postCreateNamespaceCalled;
        }

        public boolean preCreateNamespaceCalledOnly() {
            return this.preCreateNamespaceCalled && !this.postCreateNamespaceCalled;
        }

        public void preDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> env, String name) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preDeleteNamespaceCalled = true;
        }

        public void postDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> env, String name) throws IOException {
            this.postDeleteNamespaceCalled = true;
        }

        public boolean wasDeleteNamespaceCalled() {
            return this.preDeleteNamespaceCalled && this.postDeleteNamespaceCalled;
        }

        public boolean preDeleteNamespaceCalledOnly() {
            return this.preDeleteNamespaceCalled && !this.postDeleteNamespaceCalled;
        }

        public void preModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> env, NamespaceDescriptor ns) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preModifyNamespaceCalled = true;
        }

        public void postModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> env, NamespaceDescriptor ns) throws IOException {
            this.postModifyNamespaceCalled = true;
        }

        public boolean wasModifyNamespaceCalled() {
            return this.preModifyNamespaceCalled && this.postModifyNamespaceCalled;
        }

        public boolean preModifyNamespaceCalledOnly() {
            return this.preModifyNamespaceCalled && !this.postModifyNamespaceCalled;
        }

        public void preGetNamespaceDescriptor(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
            this.preGetNamespaceDescriptorCalled = true;
        }

        public void postGetNamespaceDescriptor(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
            this.postGetNamespaceDescriptorCalled = true;
        }

        public boolean wasGetNamespaceDescriptorCalled() {
            return this.preGetNamespaceDescriptorCalled && this.postGetNamespaceDescriptorCalled;
        }

        public void preListNamespaceDescriptors(ObserverContext<MasterCoprocessorEnvironment> env, List<NamespaceDescriptor> descriptors) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preListNamespaceDescriptorsCalled = true;
        }

        public void postListNamespaceDescriptors(ObserverContext<MasterCoprocessorEnvironment> env, List<NamespaceDescriptor> descriptors) throws IOException {
            this.postListNamespaceDescriptorsCalled = true;
        }

        public boolean wasListNamespaceDescriptorsCalled() {
            return this.preListNamespaceDescriptorsCalled && this.postListNamespaceDescriptorsCalled;
        }

        public boolean preListNamespaceDescriptorsCalledOnly() {
            return this.preListNamespaceDescriptorsCalled && !this.postListNamespaceDescriptorsCalled;
        }

        public void preAddColumn(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName, HColumnDescriptor column) throws IOException {
            if (this.bypass) {
                env.bypass();
            } else {
                env.shouldBypass();
            }
            this.preAddColumnCalled = true;
        }

        public void postAddColumn(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName, HColumnDescriptor column) throws IOException {
            this.postAddColumnCalled = true;
        }

        public boolean wasAddColumnCalled() {
            return this.preAddColumnCalled && this.postAddColumnCalled;
        }

        public boolean preAddColumnCalledOnly() {
            return this.preAddColumnCalled && !this.postAddColumnCalled;
        }

        public void preModifyColumn(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName, HColumnDescriptor descriptor) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preModifyColumnCalled = true;
        }

        public void postModifyColumn(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName, HColumnDescriptor descriptor) throws IOException {
            this.postModifyColumnCalled = true;
        }

        public boolean wasModifyColumnCalled() {
            return this.preModifyColumnCalled && this.postModifyColumnCalled;
        }

        public boolean preModifyColumnCalledOnly() {
            return this.preModifyColumnCalled && !this.postModifyColumnCalled;
        }

        public void preDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName, byte[] c) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preDeleteColumnCalled = true;
        }

        public void postDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName, byte[] c) throws IOException {
            this.postDeleteColumnCalled = true;
        }

        public boolean wasDeleteColumnCalled() {
            return this.preDeleteColumnCalled && this.postDeleteColumnCalled;
        }

        public boolean preDeleteColumnCalledOnly() {
            return this.preDeleteColumnCalled && !this.postDeleteColumnCalled;
        }

        public void preEnableTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preEnableTableCalled = true;
        }

        public void postEnableTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            this.postEnableTableCalled = true;
        }

        public boolean wasEnableTableCalled() {
            return this.preEnableTableCalled && this.postEnableTableCalled;
        }

        public boolean preEnableTableCalledOnly() {
            return this.preEnableTableCalled && !this.postEnableTableCalled;
        }

        public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preDisableTableCalled = true;
        }

        public void postDisableTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            this.postDisableTableCalled = true;
        }

        public boolean wasDisableTableCalled() {
            return this.preDisableTableCalled && this.postDisableTableCalled;
        }

        public boolean preDisableTableCalledOnly() {
            return this.preDisableTableCalled && !this.postDisableTableCalled;
        }

        public void preMove(ObserverContext<MasterCoprocessorEnvironment> env, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preMoveCalled = true;
        }

        public void postMove(ObserverContext<MasterCoprocessorEnvironment> env, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
            this.postMoveCalled = true;
        }

        public boolean wasMoveCalled() {
            return this.preMoveCalled && this.postMoveCalled;
        }

        public boolean preMoveCalledOnly() {
            return this.preMoveCalled && !this.postMoveCalled;
        }

        public void preAssign(ObserverContext<MasterCoprocessorEnvironment> env, HRegionInfo regionInfo) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preAssignCalled = true;
        }

        public void postAssign(ObserverContext<MasterCoprocessorEnvironment> env, HRegionInfo regionInfo) throws IOException {
            this.postAssignCalled = true;
        }

        public boolean wasAssignCalled() {
            return this.preAssignCalled && this.postAssignCalled;
        }

        public boolean preAssignCalledOnly() {
            return this.preAssignCalled && !this.postAssignCalled;
        }

        public void preUnassign(ObserverContext<MasterCoprocessorEnvironment> env, HRegionInfo regionInfo, boolean force) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preUnassignCalled = true;
        }

        public void postUnassign(ObserverContext<MasterCoprocessorEnvironment> env, HRegionInfo regionInfo, boolean force) throws IOException {
            this.postUnassignCalled = true;
        }

        public boolean wasUnassignCalled() {
            return this.preUnassignCalled && this.postUnassignCalled;
        }

        public boolean preUnassignCalledOnly() {
            return this.preUnassignCalled && !this.postUnassignCalled;
        }

        public void preRegionOffline(ObserverContext<MasterCoprocessorEnvironment> env, HRegionInfo regionInfo) throws IOException {
            this.preRegionOfflineCalled = true;
        }

        public void postRegionOffline(ObserverContext<MasterCoprocessorEnvironment> env, HRegionInfo regionInfo) throws IOException {
            this.postRegionOfflineCalled = true;
        }

        public boolean wasRegionOfflineCalled() {
            return this.preRegionOfflineCalled && this.postRegionOfflineCalled;
        }

        public boolean preRegionOfflineCalledOnly() {
            return this.preRegionOfflineCalled && !this.postRegionOfflineCalled;
        }

        public void preBalance(ObserverContext<MasterCoprocessorEnvironment> env) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preBalanceCalled = true;
        }

        public void postBalance(ObserverContext<MasterCoprocessorEnvironment> env, List<RegionPlan> plans) throws IOException {
            this.postBalanceCalled = true;
        }

        public boolean wasBalanceCalled() {
            return this.preBalanceCalled && this.postBalanceCalled;
        }

        public boolean preBalanceCalledOnly() {
            return this.preBalanceCalled && !this.postBalanceCalled;
        }

        public boolean preBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> env, boolean b) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preBalanceSwitchCalled = true;
            return b;
        }

        public void postBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> env, boolean oldValue, boolean newValue) throws IOException {
            this.postBalanceSwitchCalled = true;
        }

        public boolean wasBalanceSwitchCalled() {
            return this.preBalanceSwitchCalled && this.postBalanceSwitchCalled;
        }

        public boolean preBalanceSwitchCalledOnly() {
            return this.preBalanceSwitchCalled && !this.postBalanceSwitchCalled;
        }

        public void preShutdown(ObserverContext<MasterCoprocessorEnvironment> env) throws IOException {
            this.preShutdownCalled = true;
        }

        public void preStopMaster(ObserverContext<MasterCoprocessorEnvironment> env) throws IOException {
            this.preStopMasterCalled = true;
        }

        public void preMasterInitialization(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
            this.preMasterInitializationCalled = true;
        }

        public boolean wasMasterInitializationCalled() {
            return this.preMasterInitializationCalled;
        }

        public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
            this.postStartMasterCalled = true;
        }

        public boolean wasStartMasterCalled() {
            return this.postStartMasterCalled;
        }

        public void start(CoprocessorEnvironment env) throws IOException {
            this.startCalled = true;
        }

        public void stop(CoprocessorEnvironment env) throws IOException {
            this.stopCalled = true;
        }

        public boolean wasStarted() {
            return this.startCalled;
        }

        public boolean wasStopped() {
            return this.stopCalled;
        }

        public void preSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
            this.preSnapshotCalled = true;
        }

        public void postSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
            this.postSnapshotCalled = true;
        }

        public boolean wasSnapshotCalled() {
            return this.preSnapshotCalled && this.postSnapshotCalled;
        }

        public void preCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
            this.preCloneSnapshotCalled = true;
        }

        public void postCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
            this.postCloneSnapshotCalled = true;
        }

        public boolean wasCloneSnapshotCalled() {
            return this.preCloneSnapshotCalled && this.postCloneSnapshotCalled;
        }

        public void preRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
            this.preRestoreSnapshotCalled = true;
        }

        public void postRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
            this.postRestoreSnapshotCalled = true;
        }

        public boolean wasRestoreSnapshotCalled() {
            return this.preRestoreSnapshotCalled && this.postRestoreSnapshotCalled;
        }

        public void preDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
            this.preDeleteSnapshotCalled = true;
        }

        public void postDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
            this.postDeleteSnapshotCalled = true;
        }

        public boolean wasDeleteSnapshotCalled() {
            return this.preDeleteSnapshotCalled && this.postDeleteSnapshotCalled;
        }

        public void preCreateTableHandler(ObserverContext<MasterCoprocessorEnvironment> env, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preCreateTableHandlerCalled = true;
        }

        public void postCreateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
            this.postCreateTableHandlerCalled = true;
            tableCreationLatch.countDown();
        }

        public boolean wasPreCreateTableHandlerCalled() {
            return this.preCreateTableHandlerCalled;
        }

        public boolean wasCreateTableHandlerCalled() {
            return this.preCreateTableHandlerCalled && this.postCreateTableHandlerCalled;
        }

        public boolean wasCreateTableHandlerCalledOnly() {
            return this.preCreateTableHandlerCalled && !this.postCreateTableHandlerCalled;
        }

        public void preDeleteTableHandler(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preDeleteTableHandlerCalled = true;
        }

        public void postDeleteTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
            this.postDeleteTableHandlerCalled = true;
        }

        public boolean wasDeleteTableHandlerCalled() {
            return this.preDeleteTableHandlerCalled && this.postDeleteTableHandlerCalled;
        }

        public boolean wasDeleteTableHandlerCalledOnly() {
            return this.preDeleteTableHandlerCalled && !this.postDeleteTableHandlerCalled;
        }

        public void preTruncateTableHandler(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preTruncateTableHandlerCalled = true;
        }

        public void postTruncateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
            this.postTruncateTableHandlerCalled = true;
        }

        public boolean wasTruncateTableHandlerCalled() {
            return this.preTruncateTableHandlerCalled && this.postTruncateTableHandlerCalled;
        }

        public boolean wasTruncateTableHandlerCalledOnly() {
            return this.preTruncateTableHandlerCalled && !this.postTruncateTableHandlerCalled;
        }

        public void preModifyTableHandler(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName, HTableDescriptor htd) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preModifyTableHandlerCalled = true;
        }

        public void postModifyTableHandler(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName, HTableDescriptor htd) throws IOException {
            this.postModifyTableHandlerCalled = true;
        }

        public boolean wasModifyTableHandlerCalled() {
            return this.preModifyColumnHandlerCalled && this.postModifyColumnHandlerCalled;
        }

        public boolean wasModifyTableHandlerCalledOnly() {
            return this.preModifyColumnHandlerCalled && !this.postModifyColumnHandlerCalled;
        }

        public void preAddColumnHandler(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName, HColumnDescriptor column) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preAddColumnHandlerCalled = true;
        }

        public void postAddColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor column) throws IOException {
            this.postAddColumnHandlerCalled = true;
        }

        public boolean wasAddColumnHandlerCalled() {
            return this.preAddColumnHandlerCalled && this.postAddColumnHandlerCalled;
        }

        public boolean preAddColumnHandlerCalledOnly() {
            return this.preAddColumnHandlerCalled && !this.postAddColumnHandlerCalled;
        }

        public void preModifyColumnHandler(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName, HColumnDescriptor descriptor) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preModifyColumnHandlerCalled = true;
        }

        public void postModifyColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor descriptor) throws IOException {
            this.postModifyColumnHandlerCalled = true;
        }

        public boolean wasModifyColumnHandlerCalled() {
            return this.preModifyColumnHandlerCalled && this.postModifyColumnHandlerCalled;
        }

        public boolean preModifyColumnHandlerCalledOnly() {
            return this.preModifyColumnHandlerCalled && !this.postModifyColumnHandlerCalled;
        }

        public void preDeleteColumnHandler(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName, byte[] c) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preDeleteColumnHandlerCalled = true;
        }

        public void postDeleteColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, byte[] c) throws IOException {
            this.postDeleteColumnHandlerCalled = true;
        }

        public boolean wasDeleteColumnHandlerCalled() {
            return this.preDeleteColumnHandlerCalled && this.postDeleteColumnHandlerCalled;
        }

        public boolean preDeleteColumnHandlerCalledOnly() {
            return this.preDeleteColumnHandlerCalled && !this.postDeleteColumnHandlerCalled;
        }

        public void preEnableTableHandler(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preEnableTableHandlerCalled = true;
        }

        public void postEnableTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
            this.postEnableTableHandlerCalled = true;
        }

        public boolean wasEnableTableHandlerCalled() {
            return this.preEnableTableHandlerCalled && this.postEnableTableHandlerCalled;
        }

        public boolean preEnableTableHandlerCalledOnly() {
            return this.preEnableTableHandlerCalled && !this.postEnableTableHandlerCalled;
        }

        public void preDisableTableHandler(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preDisableTableHandlerCalled = true;
        }

        public void postDisableTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
            this.postDisableTableHandlerCalled = true;
        }

        public boolean wasDisableTableHandlerCalled() {
            return this.preDisableTableHandlerCalled && this.postDisableTableHandlerCalled;
        }

        public boolean preDisableTableHandlerCalledOnly() {
            return this.preDisableTableHandlerCalled && !this.postDisableTableHandlerCalled;
        }

        public void preGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<HTableDescriptor> descriptors) throws IOException {
        }

        public void postGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<HTableDescriptor> descriptors) throws IOException {
        }

        public void preGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<HTableDescriptor> descriptors, String regex) throws IOException {
            this.preGetTableDescriptorsCalled = true;
        }

        public void postGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<HTableDescriptor> descriptors, String regex) throws IOException {
            this.postGetTableDescriptorsCalled = true;
        }

        public boolean wasGetTableDescriptorsCalled() {
            return this.preGetTableDescriptorsCalled && this.postGetTableDescriptorsCalled;
        }

        public void preGetTableNames(ObserverContext<MasterCoprocessorEnvironment> ctx, List<HTableDescriptor> descriptors, String regex) throws IOException {
            this.preGetTableNamesCalled = true;
        }

        public void postGetTableNames(ObserverContext<MasterCoprocessorEnvironment> ctx, List<HTableDescriptor> descriptors, String regex) throws IOException {
            this.postGetTableNamesCalled = true;
        }

        public boolean wasGetTableNamesCalled() {
            return this.preGetTableNamesCalled && this.postGetTableNamesCalled;
        }

        public void preTableFlush(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        }

        public void postTableFlush(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        }
    }
}

