/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.SampleRegionWALObserver;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.TestWALReplay;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKey;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestFSHLog {
    protected static final Log LOG = LogFactory.getLog(TestFSHLog.class);
    protected static Configuration conf;
    protected static FileSystem fs;
    protected static Path dir;
    protected static final HBaseTestingUtility TEST_UTIL;
    @Rule
    public final TestName currentTest = new TestName();

    @Before
    public void setUp() throws Exception {
        FileStatus[] entries;
        for (FileStatus dir : entries = fs.listStatus(new Path("/"))) {
            fs.delete(dir.getPath(), true);
        }
        Path hbaseDir = TEST_UTIL.createRootDir();
        dir = new Path(hbaseDir, this.currentTest.getMethodName());
    }

    @After
    public void tearDown() throws Exception {
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("dfs.blocksize", 0x100000);
        TEST_UTIL.getConfiguration().setInt("dfs.namenode.heartbeat.recheck-interval", 5000);
        TEST_UTIL.getConfiguration().setInt("dfs.heartbeat.interval", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.socket-timeout", 5000);
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.client.connect.max.retries", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.block.recovery.retries", 1);
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.client.connection.maxidletime", 500);
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.wal.classes", SampleRegionWALObserver.class.getName());
        TEST_UTIL.startMiniDFSCluster(3);
        conf = TEST_UTIL.getConfiguration();
        fs = TEST_UTIL.getDFSCluster().getFileSystem();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWALCoprocessorLoaded() throws Exception {
        try (FSHLog log = null;){
            log = new FSHLog(fs, FSUtils.getRootDir((Configuration)conf), dir.toString(), "oldWALs", conf, null, true, null, null);
            WALCoprocessorHost host = log.getCoprocessorHost();
            Coprocessor c = host.findCoprocessor(SampleRegionWALObserver.class.getName());
            Assert.assertNotNull((Object)c);
        }
    }

    protected void addEdits(WAL log, HRegionInfo hri, TableName tableName, int times, AtomicLong sequenceId) throws IOException {
        HTableDescriptor htd = new HTableDescriptor();
        htd.addFamily(new HColumnDescriptor("row"));
        byte[] row = Bytes.toBytes((String)"row");
        for (int i = 0; i < times; ++i) {
            long timestamp = System.currentTimeMillis();
            WALEdit cols = new WALEdit();
            cols.add((Cell)new KeyValue(row, row, row, timestamp, row));
            log.append(htd, hri, new WALKey(hri.getEncodedNameAsBytes(), tableName, timestamp), cols, sequenceId, true, null);
        }
        log.sync();
    }

    protected void flushRegion(WAL wal, byte[] regionEncodedName) {
        wal.startCacheFlush(regionEncodedName);
        wal.completeCacheFlush(regionEncodedName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWALComparator() throws Exception {
        FSHLog wal1 = null;
        FSHLog walMeta = null;
        try {
            wal1 = new FSHLog(fs, FSUtils.getRootDir((Configuration)conf), dir.toString(), "oldWALs", conf, null, true, null, null);
            LOG.debug((Object)("Log obtained is: " + wal1));
            Comparator comp = wal1.LOG_NAME_COMPARATOR;
            Path p1 = wal1.computeFilename(11L);
            Path p2 = wal1.computeFilename(12L);
            Assert.assertTrue((comp.compare(p1, p1) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((comp.compare(p1, p2) < 0 ? 1 : 0) != 0);
            walMeta = new FSHLog(fs, FSUtils.getRootDir((Configuration)conf), dir.toString(), "oldWALs", conf, null, true, null, ".meta");
            Comparator compMeta = walMeta.LOG_NAME_COMPARATOR;
            Path p1WithMeta = walMeta.computeFilename(11L);
            Path p2WithMeta = walMeta.computeFilename(12L);
            Assert.assertTrue((compMeta.compare(p1WithMeta, p1WithMeta) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((compMeta.compare(p1WithMeta, p2WithMeta) < 0 ? 1 : 0) != 0);
            boolean ex = false;
            try {
                comp.compare(p1WithMeta, p2);
            }
            catch (IllegalArgumentException e) {
                ex = true;
            }
            Assert.assertTrue((String)"Comparator doesn't complain while checking meta log files", (boolean)ex);
            boolean exMeta = false;
            try {
                compMeta.compare(p1WithMeta, p2);
            }
            catch (IllegalArgumentException e) {
                exMeta = true;
            }
            Assert.assertTrue((String)"Meta comparator doesn't complain while checking log files", (boolean)exMeta);
        }
        finally {
            if (wal1 != null) {
                wal1.close();
            }
            if (walMeta != null) {
                walMeta.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindMemStoresEligibleForFlush() throws Exception {
        LOG.debug((Object)"testFindMemStoresEligibleForFlush");
        Configuration conf1 = HBaseConfiguration.create((Configuration)conf);
        conf1.setInt("hbase.regionserver.maxlogs", 1);
        FSHLog wal = new FSHLog(fs, FSUtils.getRootDir((Configuration)conf1), dir.toString(), "oldWALs", conf1, null, true, null, null);
        TableName t1 = TableName.valueOf((String)"t1");
        TableName t2 = TableName.valueOf((String)"t2");
        HRegionInfo hri1 = new HRegionInfo(t1, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        HRegionInfo hri2 = new HRegionInfo(t2, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        AtomicLong sequenceId1 = new AtomicLong(1L);
        AtomicLong sequenceId2 = new AtomicLong(1L);
        try {
            this.addEdits((WAL)wal, hri1, t1, 2, sequenceId1);
            wal.rollWriter();
            this.addEdits((WAL)wal, hri1, t1, 2, sequenceId1);
            wal.rollWriter();
            Assert.assertTrue((wal.getNumRolledLogFiles() == 2 ? 1 : 0) != 0);
            byte[][] regionsToFlush = wal.findRegionsToForceFlush();
            Assert.assertEquals((long)1L, (long)regionsToFlush.length);
            Assert.assertEquals((Object)hri1.getEncodedNameAsBytes(), (Object)regionsToFlush[0]);
            this.addEdits((WAL)wal, hri2, t2, 2, sequenceId2);
            regionsToFlush = wal.findRegionsToForceFlush();
            Assert.assertEquals((long)regionsToFlush.length, (long)1L);
            Assert.assertEquals((Object)hri1.getEncodedNameAsBytes(), (Object)regionsToFlush[0]);
            this.flushRegion((WAL)wal, hri1.getEncodedNameAsBytes());
            wal.rollWriter();
            Assert.assertEquals((long)1L, (long)wal.getNumRolledLogFiles());
            this.flushRegion((WAL)wal, hri2.getEncodedNameAsBytes());
            wal.rollWriter(true);
            Assert.assertEquals((long)0L, (long)wal.getNumRolledLogFiles());
            this.addEdits((WAL)wal, hri1, t1, 2, sequenceId1);
            this.addEdits((WAL)wal, hri2, t2, 2, sequenceId2);
            wal.rollWriter();
            Assert.assertEquals((long)1L, (long)wal.getNumRolledLogFiles());
            this.addEdits((WAL)wal, hri1, t1, 2, sequenceId1);
            wal.rollWriter();
            regionsToFlush = wal.findRegionsToForceFlush();
            Assert.assertEquals((long)2L, (long)regionsToFlush.length);
            this.flushRegion((WAL)wal, hri1.getEncodedNameAsBytes());
            this.flushRegion((WAL)wal, hri2.getEncodedNameAsBytes());
            wal.rollWriter(true);
            Assert.assertEquals((long)0L, (long)wal.getNumRolledLogFiles());
            this.addEdits((WAL)wal, hri1, t1, 2, sequenceId1);
            wal.startCacheFlush(hri1.getEncodedNameAsBytes());
            wal.rollWriter();
            wal.completeCacheFlush(hri1.getEncodedNameAsBytes());
            Assert.assertEquals((long)1L, (long)wal.getNumRolledLogFiles());
        }
        finally {
            if (wal != null) {
                wal.close();
            }
        }
    }

    @Test
    public void testAllRegionsFlushed() {
        LOG.debug((Object)"testAllRegionsFlushed");
        HashMap<byte[], Long> oldestFlushingSeqNo = new HashMap<byte[], Long>();
        HashMap<byte[], Long> oldestUnFlushedSeqNo = new HashMap<byte[], Long>();
        HashMap<byte[], Long> seqNo = new HashMap<byte[], Long>();
        TableName t1 = TableName.valueOf((String)"t1");
        HRegionInfo hri1 = new HRegionInfo(t1, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        AtomicLong sequenceId1 = new AtomicLong(1L);
        Assert.assertTrue((boolean)FSHLog.areAllRegionsFlushed(seqNo, oldestFlushingSeqNo, oldestUnFlushedSeqNo));
        seqNo.put(hri1.getEncodedNameAsBytes(), sequenceId1.incrementAndGet());
        oldestUnFlushedSeqNo.put(hri1.getEncodedNameAsBytes(), sequenceId1.get());
        Assert.assertFalse((boolean)FSHLog.areAllRegionsFlushed(seqNo, oldestFlushingSeqNo, oldestUnFlushedSeqNo));
        oldestUnFlushedSeqNo.clear();
        oldestFlushingSeqNo.put(hri1.getEncodedNameAsBytes(), sequenceId1.get());
        Assert.assertFalse((boolean)FSHLog.areAllRegionsFlushed(seqNo, oldestFlushingSeqNo, oldestUnFlushedSeqNo));
        oldestFlushingSeqNo.clear();
        oldestUnFlushedSeqNo.clear();
        Assert.assertTrue((boolean)FSHLog.areAllRegionsFlushed(seqNo, oldestFlushingSeqNo, oldestUnFlushedSeqNo));
        oldestUnFlushedSeqNo.put(hri1.getEncodedNameAsBytes(), 1000L);
        seqNo.put(hri1.getEncodedNameAsBytes(), 1500L);
        Assert.assertFalse((boolean)FSHLog.areAllRegionsFlushed(seqNo, oldestFlushingSeqNo, oldestUnFlushedSeqNo));
        oldestFlushingSeqNo.put(hri1.getEncodedNameAsBytes(), 1200L);
        oldestUnFlushedSeqNo.clear();
        seqNo.put(hri1.getEncodedNameAsBytes(), 1199L);
        Assert.assertTrue((boolean)FSHLog.areAllRegionsFlushed(seqNo, oldestFlushingSeqNo, oldestUnFlushedSeqNo));
    }

    @Test(expected=IOException.class)
    public void testFailedToCreateWALIfParentRenamed() throws IOException {
        String name = "testFailedToCreateWALIfParentRenamed";
        FSHLog log = new FSHLog(fs, FSUtils.getRootDir((Configuration)conf), "testFailedToCreateWALIfParentRenamed", "oldWALs", conf, null, true, null, null);
        long filenum = System.currentTimeMillis();
        Path path = log.computeFilename(filenum);
        log.createWriterInstance(path);
        Path parent = path.getParent();
        path = log.computeFilename(filenum + 1L);
        Path newPath = new Path(parent.getParent(), parent.getName() + "-splitting");
        fs.rename(parent, newPath);
        log.createWriterInstance(path);
        Assert.fail((String)"It should fail to create the new WAL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushSequenceIdIsGreaterThanAllEditsInHFile() throws IOException {
        String testName = "testFlushSequenceIdIsGreaterThanAllEditsInHFile";
        TableName tableName = TableName.valueOf((String)testName);
        HRegionInfo hri = new HRegionInfo(tableName);
        byte[] rowName = tableName.getName();
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor("f"));
        HRegion r = HRegion.createHRegion((HRegionInfo)hri, (Path)TEST_UTIL.getDefaultRootDirPath(), (Configuration)TEST_UTIL.getConfiguration(), (HTableDescriptor)htd);
        HRegion.closeHRegion((HRegion)r);
        int countPerFamily = 10;
        final MutableBoolean goslow = new MutableBoolean(false);
        FSHLog wal = new FSHLog(FileSystem.get((Configuration)conf), TEST_UTIL.getDefaultRootDirPath(), testName, conf){

            void atHeadOfRingBufferEventHandlerAppend() {
                if (goslow.isTrue()) {
                    Threads.sleep((long)100L);
                    LOG.debug((Object)"Sleeping before appending 100ms");
                }
                super.atHeadOfRingBufferEventHandlerAppend();
            }
        };
        HRegion region = HRegion.openHRegion((Configuration)TEST_UTIL.getConfiguration(), (FileSystem)TEST_UTIL.getTestFileSystem(), (Path)TEST_UTIL.getDefaultRootDirPath(), (HRegionInfo)hri, (HTableDescriptor)htd, (WAL)wal);
        EnvironmentEdge ee = EnvironmentEdgeManager.getDelegate();
        try {
            List<Put> puts = null;
            for (HColumnDescriptor hcd : htd.getFamilies()) {
                puts = TestWALReplay.addRegionEdits(rowName, hcd.getName(), 10, ee, region, "x");
            }
            Get g = new Get(rowName);
            Result result = region.get(g);
            Assert.assertEquals((long)(10 * htd.getFamilies().size()), (long)result.size());
            WALEdit edits = new WALEdit();
            for (Put p : puts) {
                CellScanner cs = p.cellScanner();
                while (cs.advance()) {
                    edits.add(cs.current());
                }
            }
            ArrayList<UUID> clusterIds = new ArrayList<UUID>();
            clusterIds.add(UUID.randomUUID());
            goslow.setValue(true);
            for (int i = 0; i < 10; ++i) {
                HRegionInfo info = region.getRegionInfo();
                WALKey logkey = new WALKey(info.getEncodedNameAsBytes(), tableName, System.currentTimeMillis(), clusterIds, -1L, -1L);
                wal.append(htd, info, logkey, edits, region.getSequenceId(), true, null);
            }
            region.flushcache();
            long currentSequenceId = region.getSequenceId().get();
            goslow.setValue(false);
            MutableBoolean mutableBoolean = goslow;
            synchronized (mutableBoolean) {
                goslow.notifyAll();
            }
            Assert.assertTrue((currentSequenceId >= region.getSequenceId().get() ? 1 : 0) != 0);
        }
        finally {
            region.close(true);
            wal.close();
        }
    }

    static {
        TEST_UTIL = new HBaseTestingUtility();
    }
}

