/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagRewriteCell;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.codec.KeyValueCodecWithTags;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.DefaultVisibilityLabelServiceImpl;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.SimpleScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityController;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelService;
import org.apache.hadoop.hbase.security.visibility.VisibilityReplicationEndpoint;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestVisibilityLabelsReplication {
    private static final Log LOG = LogFactory.getLog(TestVisibilityLabelsReplication.class);
    protected static final int NON_VIS_TAG_TYPE = 100;
    protected static final String TEMP = "temp";
    protected static Configuration conf;
    protected static Configuration conf1;
    protected static String TABLE_NAME;
    protected static byte[] TABLE_NAME_BYTES;
    protected static ReplicationAdmin replicationAdmin;
    public static final String TOPSECRET = "topsecret";
    public static final String PUBLIC = "public";
    public static final String PRIVATE = "private";
    public static final String CONFIDENTIAL = "confidential";
    public static final String COPYRIGHT = "\u00a9ABC";
    public static final String ACCENT = "\u0941";
    public static final String SECRET = "secret";
    public static final String UNICODE_VIS_TAG = "\u00a9ABC\"\u0941\\secret\"'&\\";
    public static HBaseTestingUtility TEST_UTIL;
    public static HBaseTestingUtility TEST_UTIL1;
    public static final byte[] row1;
    public static final byte[] row2;
    public static final byte[] row3;
    public static final byte[] row4;
    public static final byte[] fam;
    public static final byte[] qual;
    public static final byte[] value;
    protected static ZooKeeperWatcher zkw1;
    protected static ZooKeeperWatcher zkw2;
    protected static int[] expected;
    private static final String NON_VISIBILITY = "non-visibility";
    protected static String[] expectedVisString;
    @Rule
    public final TestName TEST_NAME = new TestName();
    public static User SUPERUSER;
    public static User USER1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setup() throws Exception {
        conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.master.distributed.log.replay", false);
        conf.setBoolean("hbase.online.schema.update.enable", true);
        conf.setInt("hfile.format.version", 3);
        conf.set("zookeeper.znode.parent", "/1");
        conf.setInt("replication.source.size.capacity", 10240);
        conf.setLong("replication.source.sleepforretries", 100L);
        conf.setInt("hbase.regionserver.maxlogs", 10);
        conf.setLong("hbase.master.logcleaner.ttl", 10L);
        conf.setInt("zookeeper.recovery.retry", 1);
        conf.setInt("zookeeper.recovery.retry.intervalmill", 10);
        conf.setBoolean("dfs.support.append", true);
        conf.setLong("hbase.server.thread.wakefrequency", 100L);
        conf.setInt("replication.stats.thread.period.seconds", 5);
        conf.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        TestVisibilityLabelsReplication.setVisibilityLabelServiceImpl(conf);
        conf.setBoolean("hbase.replication", true);
        conf.setStrings("hbase.replication.rpc.codec", new String[]{KeyValueCodecWithTags.class.getName()});
        VisibilityTestUtil.enableVisiblityLabels(conf);
        conf.set("hbase.coprocessor.regionserver.classes", VisibilityController.VisibilityReplication.class.getName());
        conf.setStrings("hbase.coprocessor.user.region.classes", new String[]{SimpleCP.class.getName()});
        conf.setClass("hbase.regionserver.scan.visibility.label.generator.class", SimpleScanLabelGenerator.class, ScanLabelGenerator.class);
        conf.set("hbase.superuser", User.getCurrent().getShortName());
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)User.getCurrent().getShortName(), (String[])new String[]{"supergroup"});
        USER1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        TEST_UTIL = new HBaseTestingUtility(conf);
        TEST_UTIL.startMiniZKCluster();
        MiniZooKeeperCluster miniZK = TEST_UTIL.getZkCluster();
        zkw1 = new ZooKeeperWatcher(conf, "cluster1", null, true);
        replicationAdmin = new ReplicationAdmin(conf);
        conf1 = HBaseConfiguration.create((Configuration)conf);
        conf1.setInt("hfile.format.version", 3);
        conf1.set("zookeeper.znode.parent", "/2");
        conf1.setInt("hbase.client.retries.number", 6);
        conf1.setBoolean("dfs.support.append", true);
        conf1.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        conf.setBoolean("hbase.replication", true);
        conf1.setStrings("hbase.replication.rpc.codec", new String[]{KeyValueCodecWithTags.class.getName()});
        conf1.setStrings("hbase.coprocessor.user.region.classes", new String[]{TestCoprocessorForTagsAtSink.class.getName()});
        USER1 = User.createUserForTesting((Configuration)conf1, (String)"user1", (String[])new String[0]);
        TEST_UTIL1 = new HBaseTestingUtility(conf1);
        TEST_UTIL1.setZkCluster(miniZK);
        zkw2 = new ZooKeeperWatcher(conf1, "cluster2", null, true);
        replicationAdmin.addPeer("2", TEST_UTIL1.getClusterKey());
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        TEST_UTIL1.startMiniCluster(1);
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor table = new HTableDescriptor(TableName.valueOf((String)TABLE_NAME));
        HColumnDescriptor desc = new HColumnDescriptor(fam);
        desc.setScope(1);
        table.addFamily(desc);
        try {
            hBaseAdmin.createTable(table);
        }
        finally {
            if (hBaseAdmin != null) {
                hBaseAdmin.close();
            }
        }
        try (HBaseAdmin hBaseAdmin1 = TEST_UTIL1.getHBaseAdmin();){
            hBaseAdmin1.createTable(table);
        }
        TestVisibilityLabelsReplication.addLabels();
        TestVisibilityLabelsReplication.setAuths(conf);
        TestVisibilityLabelsReplication.setAuths(conf1);
    }

    protected static void setVisibilityLabelServiceImpl(Configuration conf) {
        conf.setClass("hbase.regionserver.visibility.label.service.class", DefaultVisibilityLabelServiceImpl.class, VisibilityLabelService.class);
    }

    @Test
    public void testVisibilityReplication() throws Exception {
        try (Table table = TestVisibilityLabelsReplication.writeData(TableName.valueOf((String)TABLE_NAME), "(secret&public)|(confidential)&(topsecret)", "(private|confidential)&(public|topsecret)", "(secret|confidential)&!topsecret", CellVisibility.quote((String)UNICODE_VIS_TAG) + "&" + SECRET);){
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET, CONFIDENTIAL, PRIVATE, TOPSECRET, UNICODE_VIS_TAG}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(4);
            Assert.assertTrue((next.length == 4 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            cellScanner = next[2].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row3, (int)0, (int)row3.length));
            cellScanner = next[3].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row4, (int)0, (int)row4.length));
            try (Table table2 = TEST_UTIL1.getConnection().getTable(TableName.valueOf((String)TABLE_NAME));){
                s = new Scan();
                scanner = table2.getScanner(s);
                next = scanner.next(4);
                for (int retry = 0; next.length == 0 && retry <= 10; ++retry) {
                    scanner = table2.getScanner(s);
                    next = scanner.next(4);
                    Thread.sleep(2000L);
                }
                Assert.assertTrue((next.length == 4 ? 1 : 0) != 0);
                this.verifyGet(row1, expectedVisString[0], expected[0], false, TOPSECRET, CONFIDENTIAL);
                TestCoprocessorForTagsAtSink.tags.clear();
                this.verifyGet(row2, expectedVisString[1], expected[1], false, CONFIDENTIAL, PUBLIC);
                TestCoprocessorForTagsAtSink.tags.clear();
                this.verifyGet(row3, expectedVisString[2], expected[2], false, PRIVATE, SECRET);
                this.verifyGet(row3, "", expected[3], true, TOPSECRET, SECRET);
                this.verifyGet(row4, expectedVisString[3], expected[4], false, UNICODE_VIS_TAG, SECRET);
            }
        }
    }

    protected static void doAssert(byte[] row, String visTag) throws Exception {
        if (VisibilityReplicationEndPointForTest.lastEntries == null) {
            return;
        }
        Assert.assertEquals((long)1L, (long)VisibilityReplicationEndPointForTest.lastEntries.size());
        ArrayList cells = VisibilityReplicationEndPointForTest.lastEntries.get(0).getEdit().getCells();
        Assert.assertEquals((long)4L, (long)cells.size());
        boolean tagFound = false;
        block0: for (Cell cell : cells) {
            if (!Bytes.equals((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength(), (byte[])row, (int)0, (int)row.length)) continue;
            List tags = Tag.asList((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLength());
            for (Tag tag : tags) {
                if (tag.getType() != 7) continue;
                Assert.assertEquals((Object)visTag, (Object)Bytes.toString((byte[])tag.getValue()));
                tagFound = true;
                continue block0;
            }
        }
        Assert.assertTrue((boolean)tagFound);
    }

    protected void verifyGet(final byte[] row, final String visString, final int expected, final boolean nullExpected, final String ... auths) throws IOException, InterruptedException {
        PrivilegedExceptionAction<Void> scanAction = new PrivilegedExceptionAction<Void>(){

            /*
             * Exception decompiling
             */
            @Override
            public Void run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        USER1.runAs((PrivilegedExceptionAction)scanAction);
    }

    public static void addLabels() throws Exception {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                String[] labels = new String[]{TestVisibilityLabelsReplication.SECRET, TestVisibilityLabelsReplication.TOPSECRET, TestVisibilityLabelsReplication.CONFIDENTIAL, TestVisibilityLabelsReplication.PUBLIC, TestVisibilityLabelsReplication.PRIVATE, TestVisibilityLabelsReplication.UNICODE_VIS_TAG};
                try {
                    VisibilityClient.addLabels((Configuration)conf, (String[])labels);
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
                return null;
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
    }

    public static void setAuths(final Configuration conf) throws Exception {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try {
                    return VisibilityClient.setAuths((Configuration)conf, (String[])new String[]{TestVisibilityLabelsReplication.SECRET, TestVisibilityLabelsReplication.CONFIDENTIAL, TestVisibilityLabelsReplication.PRIVATE, TestVisibilityLabelsReplication.TOPSECRET, TestVisibilityLabelsReplication.UNICODE_VIS_TAG}, (String)"user1");
                }
                catch (Throwable e) {
                    throw new Exception(e);
                }
            }
        };
        VisibilityLabelsProtos.VisibilityLabelsResponse response = (VisibilityLabelsProtos.VisibilityLabelsResponse)SUPERUSER.runAs((PrivilegedExceptionAction)action);
    }

    static Table writeData(TableName tableName, String ... labelExps) throws Exception {
        Table table = TEST_UTIL.getConnection().getTable(TableName.valueOf((String)TABLE_NAME));
        int i = 1;
        ArrayList<Put> puts = new ArrayList<Put>();
        for (String labelExp : labelExps) {
            Put put = new Put(Bytes.toBytes((String)("row" + i)));
            put.add(fam, qual, Long.MAX_VALUE, value);
            put.setCellVisibility(new CellVisibility(labelExp));
            put.setAttribute(NON_VISIBILITY, Bytes.toBytes((String)TEMP));
            puts.add(put);
            ++i;
        }
        table.put(puts);
        return table;
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static {
        TABLE_NAME = "TABLE_NAME";
        TABLE_NAME_BYTES = Bytes.toBytes((String)TABLE_NAME);
        row1 = Bytes.toBytes((String)"row1");
        row2 = Bytes.toBytes((String)"row2");
        row3 = Bytes.toBytes((String)"row3");
        row4 = Bytes.toBytes((String)"row4");
        fam = Bytes.toBytes((String)"info");
        qual = Bytes.toBytes((String)"qual");
        value = Bytes.toBytes((String)"value");
        expected = new int[]{4, 6, 4, 0, 3};
        expectedVisString = new String[]{"(\"secret\"&\"topsecret\"&\"public\")|(\"topsecret\"&\"confidential\")", "(\"public\"&\"private\")|(\"topsecret\"&\"private\")|(\"confidential\"&\"public\")|(\"topsecret\"&\"confidential\")", "(!\"topsecret\"&\"secret\")|(!\"topsecret\"&\"confidential\")", "(\"secret\"&\"\u00a9ABC\\\"\u0941\\\\secret\\\"'&\\\\\")"};
    }

    public static class VisibilityReplicationEndPointForTest
    extends VisibilityReplicationEndpoint {
        static AtomicInteger replicateCount = new AtomicInteger();
        static volatile List<WAL.Entry> lastEntries = null;

        public VisibilityReplicationEndPointForTest(ReplicationEndpoint endpoint, VisibilityLabelService visibilityLabelsService) {
            super(endpoint, visibilityLabelsService);
        }

        public boolean replicate(ReplicationEndpoint.ReplicateContext replicateContext) {
            boolean ret = super.replicate(replicateContext);
            lastEntries = replicateContext.getEntries();
            replicateCount.incrementAndGet();
            return ret;
        }
    }

    public static class TestCoprocessorForTagsAtSink
    extends BaseRegionObserver {
        public static List<Tag> tags = null;

        public void postGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            if (results.size() > 0 && !results.isEmpty()) {
                Cell cell = results.get(0);
                tags = Tag.asList((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLength());
            }
        }
    }

    public static class SimpleCP
    extends BaseRegionObserver {
        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put m, WALEdit edit, Durability durability) throws IOException {
            byte[] attribute = m.getAttribute(TestVisibilityLabelsReplication.NON_VISIBILITY);
            byte[] cf = null;
            ArrayList<TagRewriteCell> updatedCells = new ArrayList<TagRewriteCell>();
            if (attribute != null) {
                for (List edits : m.getFamilyCellMap().values()) {
                    for (Cell cell : edits) {
                        KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                        if (cf == null) {
                            cf = kv.getFamily();
                        }
                        Tag tag = new Tag(100, attribute);
                        ArrayList<Tag> tagList = new ArrayList<Tag>();
                        tagList.add(tag);
                        tagList.addAll(kv.getTags());
                        byte[] fromList = Tag.fromList(tagList);
                        TagRewriteCell newcell = new TagRewriteCell((Cell)kv, fromList);
                        KeyValue newKV = new KeyValue(kv.getRow(), 0, (int)kv.getRowLength(), kv.getFamily(), 0, (int)kv.getFamilyLength(), kv.getQualifier(), 0, kv.getQualifierLength(), kv.getTimestamp(), KeyValue.Type.codeToType((byte)kv.getType()), kv.getValue(), 0, kv.getValueLength(), tagList);
                        updatedCells.add(newcell);
                    }
                }
                m.getFamilyCellMap().remove(cf);
                m.getFamilyCellMap().put(cf, updatedCells);
            }
        }
    }
}

