/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.coprocessor.SampleRegionWALObserver;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.SequenceFileLogReader;
import org.apache.hadoop.hbase.regionserver.wal.SequenceFileLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestWALFactory {
    protected static final Log LOG = LogFactory.getLog(TestWALFactory.class);
    protected static Configuration conf;
    private static MiniDFSCluster cluster;
    protected static final HBaseTestingUtility TEST_UTIL;
    protected static Path hbaseDir;
    protected FileSystem fs;
    protected Path dir;
    protected WALFactory wals;
    @Rule
    public final TestName currentTest = new TestName();
    private static final byte[] UNSPECIFIED_REGION;

    @Before
    public void setUp() throws Exception {
        this.fs = cluster.getFileSystem();
        this.dir = new Path(hbaseDir, this.currentTest.getMethodName());
        this.wals = new WALFactory(conf, null, this.currentTest.getMethodName());
    }

    @After
    public void tearDown() throws Exception {
        FileStatus[] entries;
        try {
            this.wals.close();
        }
        catch (IOException exception) {
            LOG.warn((Object)("Encountered exception while closing wal factory. If you have other errors, this may be the cause. Message: " + exception));
            LOG.debug((Object)"Exception details for failure to close wal factory.", (Throwable)exception);
        }
        for (FileStatus dir : entries = this.fs.listStatus(new Path("/"))) {
            this.fs.delete(dir.getPath(), true);
        }
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("dfs.blocksize", 0x100000);
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.broken.append", true);
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.append", true);
        TEST_UTIL.getConfiguration().setInt("dfs.namenode.heartbeat.recheck-interval", 5000);
        TEST_UTIL.getConfiguration().setInt("dfs.heartbeat.interval", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.socket-timeout", 5000);
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.client.connect.max.retries", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.block.recovery.retries", 1);
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.client.connection.maxidletime", 500);
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.wal.classes", SampleRegionWALObserver.class.getName());
        TEST_UTIL.startMiniDFSCluster(3);
        conf = TEST_UTIL.getConfiguration();
        cluster = TEST_UTIL.getDFSCluster();
        hbaseDir = TEST_UTIL.createRootDir();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void canCloseSingleton() throws IOException {
        WALFactory.getInstance((Configuration)conf).close();
    }

    @Test
    public void testSplit() throws IOException {
        TableName tableName = TableName.valueOf((String)this.currentTest.getMethodName());
        byte[] rowName = tableName.getName();
        Path logdir = new Path(hbaseDir, DefaultWALProvider.getWALDirectoryName((String)this.currentTest.getMethodName()));
        Path oldLogDir = new Path(hbaseDir, "oldWALs");
        int howmany = 3;
        HRegionInfo[] infos = new HRegionInfo[3];
        Path tabledir = FSUtils.getTableDir((Path)hbaseDir, (TableName)tableName);
        this.fs.mkdirs(tabledir);
        for (int i = 0; i < 3; ++i) {
            infos[i] = new HRegionInfo(tableName, Bytes.toBytes((String)("" + i)), Bytes.toBytes((String)("" + (i + 1))), false);
            this.fs.mkdirs(new Path(tabledir, infos[i].getEncodedName()));
            LOG.info((Object)("allo " + new Path(tabledir, infos[i].getEncodedName()).toString()));
        }
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor("column"));
        AtomicLong sequenceId = new AtomicLong(1L);
        for (int ii = 0; ii < 3; ++ii) {
            for (int i = 0; i < 3; ++i) {
                WAL log = this.wals.getWAL(infos[i].getEncodedNameAsBytes());
                for (int j = 0; j < 3; ++j) {
                    WALEdit edit = new WALEdit();
                    byte[] family = Bytes.toBytes((String)"column");
                    byte[] qualifier = Bytes.toBytes((String)Integer.toString(j));
                    byte[] column = Bytes.toBytes((String)("column:" + Integer.toString(j)));
                    edit.add((Cell)new KeyValue(rowName, family, qualifier, System.currentTimeMillis(), column));
                    LOG.info((Object)("Region " + i + ": " + edit));
                    log.append(htd, infos[i], new WALKey(infos[i].getEncodedNameAsBytes(), tableName, System.currentTimeMillis()), edit, sequenceId, true, null);
                }
                log.sync();
                log.rollWriter();
            }
        }
        this.wals.shutdown();
        List splits = WALSplitter.split((Path)hbaseDir, (Path)logdir, (Path)oldLogDir, (FileSystem)this.fs, (Configuration)conf, (WALFactory)this.wals);
        this.verifySplits(splits, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void Broken_testSync() throws Exception {
        TableName tableName = TableName.valueOf((String)this.currentTest.getMethodName());
        Path p = new Path(this.dir, this.currentTest.getMethodName() + ".fsdos");
        FSDataOutputStream out = this.fs.create(p);
        out.write(tableName.getName());
        Method syncMethod = null;
        try {
            syncMethod = out.getClass().getMethod("hflush", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                syncMethod = out.getClass().getMethod("sync", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                Assert.fail((String)"This version of Hadoop supports neither Syncable.sync() nor Syncable.hflush().");
            }
        }
        syncMethod.invoke((Object)out, new Object[0]);
        FSDataInputStream in = this.fs.open(p);
        Assert.assertTrue((in.available() > 0 ? 1 : 0) != 0);
        byte[] buffer = new byte[1024];
        int read = in.read(buffer);
        Assert.assertEquals((long)tableName.getName().length, (long)read);
        out.close();
        in.close();
        AtomicLong sequenceId = new AtomicLong(1L);
        int total = 20;
        try (WAL.Reader reader = null;){
            HRegionInfo info = new HRegionInfo(tableName, null, null, false);
            HTableDescriptor htd = new HTableDescriptor();
            htd.addFamily(new HColumnDescriptor(tableName.getName()));
            WAL wal = this.wals.getWAL(info.getEncodedNameAsBytes());
            for (int i = 0; i < 20; ++i) {
                WALEdit kvs = new WALEdit();
                kvs.add((Cell)new KeyValue(Bytes.toBytes((int)i), tableName.getName(), tableName.getName()));
                wal.append(htd, info, new WALKey(info.getEncodedNameAsBytes(), tableName, System.currentTimeMillis()), kvs, sequenceId, true, null);
            }
            wal.sync();
            Path walPath = DefaultWALProvider.getCurrentFileName((WAL)wal);
            reader = this.wals.createReader(this.fs, walPath);
            int count = 0;
            WAL.Entry entry = new WAL.Entry();
            while ((entry = reader.next(entry)) != null) {
                ++count;
            }
            Assert.assertEquals((long)20L, (long)count);
            reader.close();
            for (int i = 0; i < 20; ++i) {
                WALEdit kvs = new WALEdit();
                kvs.add((Cell)new KeyValue(Bytes.toBytes((int)i), tableName.getName(), tableName.getName()));
                wal.append(htd, info, new WALKey(info.getEncodedNameAsBytes(), tableName, System.currentTimeMillis()), kvs, sequenceId, true, null);
            }
            wal.sync();
            reader = this.wals.createReader(this.fs, walPath);
            count = 0;
            while ((entry = reader.next(entry)) != null) {
                ++count;
            }
            Assert.assertTrue((count >= 20 ? 1 : 0) != 0);
            reader.close();
            wal.sync();
            reader = this.wals.createReader(this.fs, walPath);
            count = 0;
            while ((entry = reader.next(entry)) != null) {
                ++count;
            }
            Assert.assertEquals((long)40L, (long)count);
            reader.close();
            byte[] value = new byte[0x100400];
            for (int i = 0; i < 20; ++i) {
                WALEdit kvs = new WALEdit();
                kvs.add((Cell)new KeyValue(Bytes.toBytes((int)i), tableName.getName(), value));
                wal.append(htd, info, new WALKey(info.getEncodedNameAsBytes(), tableName, System.currentTimeMillis()), kvs, sequenceId, true, null);
            }
            wal.sync();
            reader = this.wals.createReader(this.fs, walPath);
            count = 0;
            while ((entry = reader.next(entry)) != null) {
                ++count;
            }
            Assert.assertEquals((long)60L, (long)count);
            reader.close();
            wal.shutdown();
            reader = this.wals.createReader(this.fs, walPath);
            count = 0;
            while ((entry = reader.next(entry)) != null) {
                ++count;
            }
            Assert.assertEquals((long)60L, (long)count);
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySplits(List<Path> splits, int howmany) throws IOException {
        Assert.assertEquals((long)(howmany * howmany), (long)splits.size());
        for (int i = 0; i < splits.size(); ++i) {
            LOG.info((Object)("Verifying=" + splits.get(i)));
            try (WAL.Reader reader = this.wals.createReader(this.fs, splits.get(i));){
                int count = 0;
                String previousRegion = null;
                long seqno = -1L;
                WAL.Entry entry = new WAL.Entry();
                while ((entry = reader.next(entry)) != null) {
                    WALKey key = entry.getKey();
                    String region = Bytes.toString((byte[])key.getEncodedRegionName());
                    if (previousRegion != null) {
                        Assert.assertEquals(previousRegion, (Object)region);
                    }
                    LOG.info((Object)("oldseqno=" + seqno + ", newseqno=" + key.getLogSeqNum()));
                    Assert.assertTrue((seqno < key.getLogSeqNum() ? 1 : 0) != 0);
                    seqno = key.getLogSeqNum();
                    previousRegion = region;
                    ++count;
                }
                Assert.assertEquals((long)howmany, (long)count);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testAppendClose() throws Exception {
        TableName tableName = TableName.valueOf((String)this.currentTest.getMethodName());
        HRegionInfo regioninfo = new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false);
        WAL wal = this.wals.getWAL(regioninfo.getEncodedNameAsBytes());
        AtomicLong sequenceId = new AtomicLong(1L);
        int total = 20;
        HTableDescriptor htd = new HTableDescriptor();
        htd.addFamily(new HColumnDescriptor(tableName.getName()));
        for (int i = 0; i < 20; ++i) {
            WALEdit kvs = new WALEdit();
            kvs.add((Cell)new KeyValue(Bytes.toBytes((int)i), tableName.getName(), tableName.getName()));
            wal.append(htd, regioninfo, new WALKey(regioninfo.getEncodedNameAsBytes(), tableName, System.currentTimeMillis()), kvs, sequenceId, true, null);
        }
        wal.sync();
        int namenodePort = cluster.getNameNodePort();
        final Path walPath = DefaultWALProvider.getCurrentFileName((WAL)wal);
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            TEST_UTIL.shutdownMiniDFSCluster();
            try {
                wal.shutdown();
            }
            catch (IOException e) {
                LOG.info((Object)e);
            }
            this.fs.close();
            LOG.info((Object)"STOPPED first instance of the cluster");
        }
        finally {
            while (cluster.isClusterUp()) {
                LOG.error((Object)"Waiting for cluster to go down");
                Thread.sleep(1000L);
            }
            Assert.assertFalse((boolean)cluster.isClusterUp());
            cluster = null;
            for (int i = 0; i < 100; ++i) {
                try {
                    cluster = TEST_UTIL.startMiniDFSClusterForTestWAL(namenodePort);
                    break;
                }
                catch (BindException e) {
                    LOG.info((Object)"Sleeping.  BindException bringing up new cluster");
                    Threads.sleep((long)1000L);
                    continue;
                }
            }
            cluster.waitActive();
            this.fs = cluster.getFileSystem();
            LOG.info((Object)"STARTED second instance.");
        }
        Method setLeasePeriod = cluster.getClass().getDeclaredMethod("setLeasePeriod", Long.TYPE, Long.TYPE);
        setLeasePeriod.setAccessible(true);
        setLeasePeriod.invoke((Object)cluster, 1000L, 1000L);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            LOG.info((Object)e);
        }
        final FileSystem recoveredFs = this.fs;
        final Configuration rlConf = conf;
        class RecoverLogThread
        extends Thread {
            public Exception exception = null;

            RecoverLogThread() {
            }

            @Override
            public void run() {
                try {
                    FSUtils.getInstance((FileSystem)TestWALFactory.this.fs, (Configuration)rlConf).recoverFileLease(recoveredFs, walPath, rlConf, null);
                }
                catch (IOException e) {
                    this.exception = e;
                }
            }
        }
        RecoverLogThread t = new RecoverLogThread();
        t.start();
        t.join(60000L);
        if (t.isAlive()) {
            t.interrupt();
            throw new Exception("Timed out waiting for WAL.recoverLog()");
        }
        if (t.exception != null) {
            throw t.exception;
        }
        WAL.Reader reader = this.wals.createReader(this.fs, walPath);
        int count = 0;
        WAL.Entry entry = new WAL.Entry();
        while (reader.next(entry) != null) {
            ++count;
            Assert.assertTrue((String)"Should be one KeyValue per WALEdit", (entry.getEdit().getCells().size() == 1 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)20L, (long)count);
        reader.close();
        setLeasePeriod.invoke((Object)cluster, new Long(60000L), new Long(3600000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEditAdd() throws IOException {
        int COL_COUNT = 10;
        TableName tableName = TableName.valueOf((String)"tablename");
        byte[] row = Bytes.toBytes((String)"row");
        try (WAL.Reader reader = null;){
            AtomicLong sequenceId = new AtomicLong(1L);
            long timestamp = System.currentTimeMillis();
            WALEdit cols = new WALEdit();
            for (int i = 0; i < 10; ++i) {
                cols.add((Cell)new KeyValue(row, Bytes.toBytes((String)"column"), Bytes.toBytes((String)Integer.toString(i)), timestamp, new byte[]{(byte)(i + 48)}));
            }
            HRegionInfo info = new HRegionInfo(tableName, row, Bytes.toBytes((String)(Bytes.toString((byte[])row) + "1")), false);
            HTableDescriptor htd = new HTableDescriptor();
            htd.addFamily(new HColumnDescriptor("column"));
            WAL log = this.wals.getWAL(info.getEncodedNameAsBytes());
            long txid = log.append(htd, info, new WALKey(info.getEncodedNameAsBytes(), tableName, System.currentTimeMillis()), cols, sequenceId, true, null);
            log.sync(txid);
            log.startCacheFlush(info.getEncodedNameAsBytes());
            log.completeCacheFlush(info.getEncodedNameAsBytes());
            log.shutdown();
            Path filename = DefaultWALProvider.getCurrentFileName((WAL)log);
            reader = this.wals.createReader(this.fs, filename);
            for (int i = 0; i < 1; ++i) {
                WAL.Entry entry = reader.next(null);
                if (entry == null) {
                    break;
                }
                WALKey key = entry.getKey();
                WALEdit val = entry.getEdit();
                Assert.assertTrue((boolean)Bytes.equals((byte[])info.getEncodedNameAsBytes(), (byte[])key.getEncodedRegionName()));
                Assert.assertTrue((boolean)tableName.equals((Object)key.getTablename()));
                Cell cell = (Cell)val.getCells().get(0);
                Assert.assertTrue((boolean)Bytes.equals((byte[])row, (byte[])cell.getRow()));
                Assert.assertEquals((long)((byte)(i + 48)), (long)cell.getValue()[0]);
                System.out.println(key + " " + val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppend() throws IOException {
        int COL_COUNT = 10;
        TableName tableName = TableName.valueOf((String)"tablename");
        byte[] row = Bytes.toBytes((String)"row");
        AtomicLong sequenceId = new AtomicLong(1L);
        try (WAL.Reader reader = null;){
            long timestamp = System.currentTimeMillis();
            WALEdit cols = new WALEdit();
            for (int i = 0; i < 10; ++i) {
                cols.add((Cell)new KeyValue(row, Bytes.toBytes((String)"column"), Bytes.toBytes((String)Integer.toString(i)), timestamp, new byte[]{(byte)(i + 48)}));
            }
            HRegionInfo hri = new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            HTableDescriptor htd = new HTableDescriptor();
            htd.addFamily(new HColumnDescriptor("column"));
            WAL log = this.wals.getWAL(hri.getEncodedNameAsBytes());
            long txid = log.append(htd, hri, new WALKey(hri.getEncodedNameAsBytes(), tableName, System.currentTimeMillis()), cols, sequenceId, true, null);
            log.sync(txid);
            log.startCacheFlush(hri.getEncodedNameAsBytes());
            log.completeCacheFlush(hri.getEncodedNameAsBytes());
            log.shutdown();
            Path filename = DefaultWALProvider.getCurrentFileName((WAL)log);
            reader = this.wals.createReader(this.fs, filename);
            WAL.Entry entry = reader.next();
            Assert.assertEquals((long)10L, (long)entry.getEdit().size());
            int idx = 0;
            for (Cell val : entry.getEdit().getCells()) {
                Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEncodedNameAsBytes(), (byte[])entry.getKey().getEncodedRegionName()));
                Assert.assertTrue((boolean)tableName.equals((Object)entry.getKey().getTablename()));
                Assert.assertTrue((boolean)Bytes.equals((byte[])row, (byte[])val.getRow()));
                Assert.assertEquals((long)((byte)(idx + 48)), (long)val.getValue()[0]);
                System.out.println(entry.getKey() + " " + val);
                ++idx;
            }
        }
    }

    @Test
    public void testVisitors() throws Exception {
        int COL_COUNT = 10;
        TableName tableName = TableName.valueOf((String)"tablename");
        byte[] row = Bytes.toBytes((String)"row");
        DumbWALActionsListener visitor = new DumbWALActionsListener();
        AtomicLong sequenceId = new AtomicLong(1L);
        long timestamp = System.currentTimeMillis();
        HTableDescriptor htd = new HTableDescriptor();
        htd.addFamily(new HColumnDescriptor("column"));
        HRegionInfo hri = new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        WAL log = this.wals.getWAL(hri.getEncodedNameAsBytes());
        log.registerWALActionsListener((WALActionsListener)visitor);
        for (int i = 0; i < 10; ++i) {
            WALEdit cols = new WALEdit();
            cols.add((Cell)new KeyValue(row, Bytes.toBytes((String)"column"), Bytes.toBytes((String)Integer.toString(i)), timestamp, new byte[]{(byte)(i + 48)}));
            log.append(htd, hri, new WALKey(hri.getEncodedNameAsBytes(), tableName, System.currentTimeMillis()), cols, sequenceId, true, null);
        }
        log.sync();
        Assert.assertEquals((long)10L, (long)visitor.increments);
        log.unregisterWALActionsListener((WALActionsListener)visitor);
        WALEdit cols = new WALEdit();
        cols.add((Cell)new KeyValue(row, Bytes.toBytes((String)"column"), Bytes.toBytes((String)Integer.toString(11)), timestamp, new byte[]{59}));
        log.append(htd, hri, new WALKey(hri.getEncodedNameAsBytes(), tableName, System.currentTimeMillis()), cols, sequenceId, true, null);
        log.sync();
        Assert.assertEquals((long)10L, (long)visitor.increments);
    }

    @Test
    public void testWALCoprocessorLoaded() throws Exception {
        WALCoprocessorHost host = this.wals.getWAL(UNSPECIFIED_REGION).getCoprocessorHost();
        Coprocessor c = host.findCoprocessor(SampleRegionWALObserver.class.getName());
        Assert.assertNotNull((Object)c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadLegacyLog() throws IOException {
        int columnCount = 5;
        int recordCount = 5;
        TableName tableName = TableName.valueOf((String)"tablename");
        byte[] row = Bytes.toBytes((String)"row");
        long timestamp = System.currentTimeMillis();
        Path path = new Path(this.dir, "tempwal");
        SequenceFileLogWriter sflw = null;
        WAL.Reader reader = null;
        try {
            int i;
            HRegionInfo hri = new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            HTableDescriptor htd = new HTableDescriptor(tableName);
            this.fs.mkdirs(this.dir);
            sflw = new SequenceFileLogWriter();
            sflw.init(this.fs, path, conf, false);
            for (i = 0; i < 5; ++i) {
                HLogKey key = new HLogKey(hri.getEncodedNameAsBytes(), tableName, (long)i, timestamp, HConstants.DEFAULT_CLUSTER_ID);
                WALEdit edit = new WALEdit();
                for (int j = 0; j < 5; ++j) {
                    if (i == 0) {
                        htd.addFamily(new HColumnDescriptor("column" + j));
                    }
                    String value = i + "" + j;
                    edit.add((Cell)new KeyValue(row, row, row, timestamp, Bytes.toBytes((String)value)));
                }
                sflw.append(new WAL.Entry((WALKey)key, edit));
            }
            sflw.sync();
            sflw.close();
            reader = this.wals.createReader(this.fs, path);
            Assert.assertTrue((boolean)(reader instanceof SequenceFileLogReader));
            for (i = 0; i < 5; ++i) {
                WAL.Entry entry = reader.next();
                Assert.assertNotNull((Object)entry);
                Assert.assertEquals((long)5L, (long)entry.getEdit().size());
                Assert.assertArrayEquals((byte[])hri.getEncodedNameAsBytes(), (byte[])entry.getKey().getEncodedRegionName());
                Assert.assertEquals((Object)tableName, (Object)entry.getKey().getTablename());
                int idx = 0;
                for (Cell val : entry.getEdit().getCells()) {
                    Assert.assertTrue((boolean)Bytes.equals((byte[])row, (byte[])val.getRow()));
                    String value = i + "" + idx;
                    Assert.assertArrayEquals((byte[])Bytes.toBytes((String)value), (byte[])val.getValue());
                    ++idx;
                }
            }
            WAL.Entry entry = reader.next();
            Assert.assertNull((Object)entry);
        }
        finally {
            if (sflw != null) {
                sflw.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    static {
        TEST_UTIL = new HBaseTestingUtility();
        UNSPECIFIED_REGION = new byte[0];
    }

    static class DumbWALActionsListener
    extends WALActionsListener.Base {
        int increments = 0;

        DumbWALActionsListener() {
        }

        public void visitLogEntryBeforeWrite(HRegionInfo info, WALKey logKey, WALEdit logEdit) {
            ++this.increments;
        }

        public void visitLogEntryBeforeWrite(HTableDescriptor htd, WALKey logKey, WALEdit logEdit) {
            ++this.increments;
        }
    }
}

