/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.BloomType;

@InterfaceAudience.Private
public class TableDescriptor {
    private HTableDescriptor hTableDescriptor;

    @VisibleForTesting
    public TableDescriptor(HTableDescriptor hTableDescriptor) {
        this.hTableDescriptor = hTableDescriptor;
    }

    public HTableDescriptor getHTableDescriptor() {
        return this.hTableDescriptor;
    }

    public void setHTableDescriptor(HTableDescriptor hTableDescriptor) {
        this.hTableDescriptor = hTableDescriptor;
    }

    public HBaseProtos.TableDescriptor convert() {
        HBaseProtos.TableDescriptor.Builder builder = HBaseProtos.TableDescriptor.newBuilder().setSchema(this.hTableDescriptor.convert());
        return builder.build();
    }

    public static TableDescriptor convert(HBaseProtos.TableDescriptor proto) {
        return new TableDescriptor(HTableDescriptor.convert((HBaseProtos.TableSchema)proto.getSchema()));
    }

    public byte[] toByteArray() {
        return ProtobufUtil.prependPBMagic((byte[])this.convert().toByteArray());
    }

    public static TableDescriptor parseFrom(byte[] bytes) throws DeserializationException, IOException {
        HBaseProtos.TableDescriptor ts;
        if (!ProtobufUtil.isPBMagicPrefix((byte[])bytes)) {
            throw new DeserializationException("Expected PB encoded TableDescriptor");
        }
        int pblen = ProtobufUtil.lengthOfPBMagic();
        HBaseProtos.TableDescriptor.Builder builder = HBaseProtos.TableDescriptor.newBuilder();
        try {
            ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])bytes, (int)pblen, (int)(bytes.length - pblen));
            ts = builder.build();
        }
        catch (IOException e) {
            throw new DeserializationException((Throwable)e);
        }
        return TableDescriptor.convert(ts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableDescriptor that = (TableDescriptor)o;
        return !(this.hTableDescriptor != null ? !this.hTableDescriptor.equals((Object)that.hTableDescriptor) : that.hTableDescriptor != null);
    }

    public int hashCode() {
        return this.hTableDescriptor != null ? this.hTableDescriptor.hashCode() : 0;
    }

    public String toString() {
        return "TableDescriptor{hTableDescriptor=" + this.hTableDescriptor + '}';
    }

    public static HTableDescriptor metaTableDescriptor(Configuration conf) throws IOException {
        HTableDescriptor metaDescriptor = new HTableDescriptor(TableName.META_TABLE_NAME, new HColumnDescriptor[]{new HColumnDescriptor(HConstants.CATALOG_FAMILY).setMaxVersions(conf.getInt("hbase.meta.versions", 3)).setInMemory(true).setBlocksize(conf.getInt("hbase.meta.blocksize", 8192)).setScope(0).setBloomFilterType(BloomType.NONE).setCacheDataInL1(true), new HColumnDescriptor(HConstants.TABLE_FAMILY).setMaxVersions(10).setInMemory(true).setBlocksize(8192).setScope(0).setBloomFilterType(BloomType.NONE).setCacheDataInL1(true)}){};
        metaDescriptor.addCoprocessor("org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint", null, 0x1FFFFFFF, null);
        return metaDescriptor;
    }
}

