/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.SettableSequenceId;
import org.apache.hadoop.hbase.SettableTimestamp;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.util.ClassSize;

@InterfaceAudience.Private
public class TagRewriteCell
implements Cell,
SettableSequenceId,
SettableTimestamp,
HeapSize {
    private Cell cell;
    private byte[] tags;

    public TagRewriteCell(Cell cell, byte[] tags) {
        assert (cell instanceof SettableSequenceId);
        assert (cell instanceof SettableTimestamp);
        assert (tags != null);
        this.cell = cell;
        this.tags = tags;
        if (this.cell instanceof TagRewriteCell) {
            ((TagRewriteCell)this.cell).tags = null;
        }
    }

    public byte[] getRowArray() {
        return this.cell.getRowArray();
    }

    public int getRowOffset() {
        return this.cell.getRowOffset();
    }

    public short getRowLength() {
        return this.cell.getRowLength();
    }

    public byte[] getFamilyArray() {
        return this.cell.getFamilyArray();
    }

    public int getFamilyOffset() {
        return this.cell.getFamilyOffset();
    }

    public byte getFamilyLength() {
        return this.cell.getFamilyLength();
    }

    public byte[] getQualifierArray() {
        return this.cell.getQualifierArray();
    }

    public int getQualifierOffset() {
        return this.cell.getQualifierOffset();
    }

    public int getQualifierLength() {
        return this.cell.getQualifierLength();
    }

    public long getTimestamp() {
        return this.cell.getTimestamp();
    }

    public byte getTypeByte() {
        return this.cell.getTypeByte();
    }

    public long getSequenceId() {
        return this.cell.getSequenceId();
    }

    public byte[] getValueArray() {
        return this.cell.getValueArray();
    }

    public int getValueOffset() {
        return this.cell.getValueOffset();
    }

    public int getValueLength() {
        return this.cell.getValueLength();
    }

    public byte[] getTagsArray() {
        return this.tags;
    }

    public int getTagsOffset() {
        return 0;
    }

    public int getTagsLength() {
        if (null == this.tags) {
            return 0;
        }
        return this.tags.length;
    }

    public long heapSize() {
        long sum = CellUtil.estimatedHeapSizeOf((Cell)this.cell) - (long)this.cell.getTagsLength();
        sum += (long)ClassSize.OBJECT;
        sum += (long)(2 * ClassSize.REFERENCE);
        if (this.tags != null) {
            sum += (long)ClassSize.align((int)ClassSize.ARRAY);
            sum += (long)this.tags.length;
        }
        return sum;
    }

    public void setTimestamp(long ts) throws IOException {
        CellUtil.setTimestamp((Cell)this.cell, (long)ts);
    }

    public void setTimestamp(byte[] ts, int tsOffset) throws IOException {
        CellUtil.setTimestamp((Cell)this.cell, (byte[])ts, (int)tsOffset);
    }

    public void setSequenceId(long seqId) throws IOException {
        CellUtil.setSequenceId((Cell)this.cell, (long)seqId);
    }
}

