/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.security.UserProvider;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CoprocessorHConnection
extends ConnectionImplementation {
    private static final NonceGenerator NO_NONCE_GEN = new ConnectionImplementation.NoNonceGenerator();
    private final ServerName serverName;
    private final HRegionServer server;

    public static ClusterConnection getConnectionForEnvironment(CoprocessorEnvironment env) throws IOException {
        RegionCoprocessorEnvironment e;
        RegionServerServices services;
        if (env instanceof RegionCoprocessorEnvironment && (services = (e = (RegionCoprocessorEnvironment)env).getRegionServerServices()) instanceof HRegionServer) {
            return new CoprocessorHConnection((HRegionServer)services);
        }
        return (ClusterConnection)ConnectionFactory.createConnection((Configuration)env.getConfiguration());
    }

    public CoprocessorHConnection(HRegionServer server) throws IOException {
        this(server.getConfiguration(), server);
    }

    public CoprocessorHConnection(Configuration conf, HRegionServer server) throws IOException {
        super(conf, null, UserProvider.instantiate((Configuration)conf).getCurrent());
        this.server = server;
        this.serverName = server.getServerName();
    }

    public ClientProtos.ClientService.BlockingInterface getClient(ServerName serverName) throws IOException {
        if (!this.serverName.equals((Object)serverName)) {
            return super.getClient(serverName);
        }
        return this.server.getRSRpcServices();
    }

    public NonceGenerator getNonceGenerator() {
        return NO_NONCE_GEN;
    }
}

