/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coordination;

import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.coordination.BaseCoordinatedStateManager;
import org.apache.hadoop.hbase.coordination.SplitLogManagerCoordination;
import org.apache.hadoop.hbase.coordination.SplitLogWorkerCoordination;
import org.apache.hadoop.hbase.coordination.ZKSplitLogManagerCoordination;
import org.apache.hadoop.hbase.coordination.ZkSplitLogWorkerCoordination;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class ZkCoordinatedStateManager
extends BaseCoordinatedStateManager {
    protected Server server;
    protected ZooKeeperWatcher watcher;
    protected SplitLogWorkerCoordination splitLogWorkerCoordination;
    protected SplitLogManagerCoordination splitLogManagerCoordination;

    @Override
    public void initialize(Server server) {
        this.server = server;
        this.watcher = server.getZooKeeper();
        this.splitLogWorkerCoordination = new ZkSplitLogWorkerCoordination(this, this.watcher);
        this.splitLogManagerCoordination = new ZKSplitLogManagerCoordination(this, this.watcher);
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public SplitLogWorkerCoordination getSplitLogWorkerCoordination() {
        return this.splitLogWorkerCoordination;
    }

    @Override
    public SplitLogManagerCoordination getSplitLogManagerCoordination() {
        return this.splitLogManagerCoordination;
    }
}

